/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.phonecontact;

import androidx.paging.PagingSource;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.sdk.model.contact.PhoneContact;
import io.streamlayer.sdk.model.pagination.PhoneContactPaginationParams;
import io.streamlayer.sdk.repository.phonecontact.PhoneContactRepo;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u00020\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lio/streamlayer/sdk/repository/phonecontact/PhoneContactRepoImpl;", "Lio/streamlayer/sdk/repository/phonecontact/PhoneContactRepo;", "Lio/streamlayer/sdk/model/pagination/PhoneContactPaginationParams;", "params", "Landroidx/paging/PagingSource;", "", "Lio/streamlayer/sdk/model/contact/PhoneContact;", "getPhoneContacts", "(Lio/streamlayer/sdk/model/pagination/PhoneContactPaginationParams;)Landroidx/paging/PagingSource;", "", "items", "", "savePhoneContacts", "(Ljava/util/List;)V", "deletePhoneContacts", "Lio/streamlayer/common/data/database/AppDatabase;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "<init>", "(Lio/streamlayer/common/data/database/AppDatabase;)V", "sdk_originalRelease"})
public final class PhoneContactRepoImpl
implements PhoneContactRepo {
    private final AppDatabase database;

    @Inject
    public PhoneContactRepoImpl(@NotNull AppDatabase appDatabase) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"database");
        this.database = appDatabase;
    }

    @Override
    @NotNull
    public PagingSource<Integer, PhoneContact> getPhoneContacts(@NotNull PhoneContactPaginationParams phoneContactPaginationParams) {
        Intrinsics.checkParameterIsNotNull((Object)phoneContactPaginationParams, (String)"params");
        PhoneContactPaginationParams phoneContactPaginationParams2 = phoneContactPaginationParams;
        String string2 = phoneContactPaginationParams2.getQuery();
        return ((PhoneContactRepoImpl)((Object)string2)).database.phoneContactDao().getPhoneContacts(string2, phoneContactPaginationParams2.getOnlyNonTinodeContacts());
    }

    @Override
    public void savePhoneContacts(@NotNull List<PhoneContact> list) {
        PhoneContactRepoImpl phoneContactRepoImpl = this;
        Intrinsics.checkParameterIsNotNull(list, (String)"items");
        phoneContactRepoImpl.database.phoneContactDao().deletePhoneContacts();
        phoneContactRepoImpl.database.phoneContactDao().savePhoneContacts(list);
    }

    @Override
    public void deletePhoneContacts(@NotNull List<PhoneContact> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"items");
        this.database.phoneContactDao().deletePhoneContacts(list);
    }
}

