/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.SoundPool;
import io.streamlayer.common.data.notifications.InAppNotificationsService$WhenMappings;
import io.streamlayer.common.data.notifications.NotificationUtil;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.messaging.MessagingExtensionsKt;
import io.streamlayer.sdk.model.analytics.AnalyticsDataKt;
import io.streamlayer.sdk.model.analytics.CommonKind;
import io.streamlayer.sdk.model.analytics.NotificationType;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.WaveMessage;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.sdksettings.ClientSettings;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010?\u001a\u00020>\u0012\u0006\u0010(\u001a\u00020'\u0012\u0006\u0010;\u001a\u00020:\u0012\u0006\u0010+\u001a\u00020*\u00a2\u0006\u0004\bH\u0010IJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u001f\u0010\u000eJ\r\u0010 \u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010!J\u001d\u0010%\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\n2\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&R\u0016\u0010(\u001a\u00020'8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0018\u0010/\u001a\u0004\u0018\u00010#8B@\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0016\u00101\u001a\u0002008\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0018\u00106\u001a\u0004\u0018\u0001038B@\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020#078\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0016\u0010;\u001a\u00020:8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0016\u0010=\u001a\u0002008\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u00102R\u0016\u0010?\u001a\u00020>8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u0016\u0010B\u001a\u00020A8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u001e\u0010F\u001a\n E*\u0004\u0018\u00010D0D8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010G\u00a8\u0006J"}, d2={"Lio/streamlayer/common/data/notifications/InAppNotificationsService;", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "", "showNotification", "(Lio/streamlayer/sdk/model/notifications/Notification;)V", "showInAppNotification", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "type", "", "isSoundEnabled", "(Lio/streamlayer/sdk/model/notifications/NotificationType;)Z", "playNotificationSound", "(Lio/streamlayer/sdk/model/notifications/NotificationType;)V", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "chatMessage", "notifyChatMessage", "(Lio/streamlayer/sdk/model/messaging/ChatMessage;)V", "Lio/streamlayer/sdk/model/calls/WatchParty;", "watchParty", "notifyWatchParty", "(Lio/streamlayer/sdk/model/calls/WatchParty;)V", "Lio/streamlayer/sdk/model/social/Tweet;", "tweet", "notifyTweet", "(Lio/streamlayer/sdk/model/social/Tweet;)V", "Lio/streamlayer/sdk/model/messaging/WaveMessage;", "waveMessage", "notifyWaveMessage", "(Lio/streamlayer/sdk/model/messaging/WaveMessage;)V", "playSound", "disconnect", "()V", "pause", "", "chatId", "pauseNotifications", "(ZLjava/lang/String;)V", "Lio/streamlayer/common/session/SessionPrefImpl;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "analyticsRepo", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "getTinodeUserId", "()Ljava/lang/String;", "tinodeUserId", "", "generalSound", "I", "Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "getSettings", "()Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "settings", "", "pausedTopicsNotifications", "Ljava/util/List;", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "notificationsRepo", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "messageSound", "Landroid/content/Context;", "context", "Landroid/content/Context;", "", "lastTimestampSoundPlayed", "J", "Landroid/media/SoundPool;", "kotlin.jvm.PlatformType", "soundPool", "Landroid/media/SoundPool;", "<init>", "(Landroid/content/Context;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/sdk/repository/notifications/NotificationRepo;Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;)V", "sdk_originalRelease"})
public final class InAppNotificationsService {
    private final List<String> pausedTopicsNotifications;
    private long lastTimestampSoundPlayed;
    private final SoundPool soundPool;
    private final int generalSound;
    private final int messageSound;
    private final Context context;
    private final SessionPrefImpl session;
    private final NotificationRepo notificationsRepo;
    private final AnalyticsRepo analyticsRepo;

    private final String getTinodeUserId() {
        return this.session.getTinodeUserId();
    }

    private final ClientSettings getSettings() {
        return this.session.getClientSettings();
    }

    private final void showNotification(Notification notification) {
        NotificationUtil notificationUtil = NotificationUtil.INSTANCE;
        if (notificationUtil.isNotificationEnabled$sdk_originalRelease(this.session, notification) && notificationUtil.isAppInForeground()) {
            this.showInAppNotification(notification);
        }
    }

    private final void showInAppNotification(Notification notification) {
        if (ArraysKt.contains((Object[])new io.streamlayer.sdk.model.notifications.NotificationType[]{io.streamlayer.sdk.model.notifications.NotificationType.WatchParty, io.streamlayer.sdk.model.notifications.NotificationType.WaveReply}, (Object)((Object)notification.getType()))) {
            this.notificationsRepo.upsertNotificationBySourceId(notification);
        } else {
            this.notificationsRepo.saveNotification(notification);
        }
        InAppNotificationsService inAppNotificationsService = this;
        inAppNotificationsService.playSound(notification.getType());
        AnalyticsRepo.DefaultImpls.triggerNotificationEvent$default(inAppNotificationsService.analyticsRepo, NotificationType.IN_APP, AnalyticsDataKt.toKind(notification.getType()), CommonKind.NOTIFICATION_RECEIVED, null, 8, null);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isSoundEnabled(io.streamlayer.sdk.model.notifications.NotificationType var1_1) {
        switch (InAppNotificationsService$WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()]) lbl-1000:
        // 4 sources

        {
            default: {
                v0 = true;
                break;
            }
lbl5:
            // 4 sources

            case 4: {
                v0 = false;
                break;
            }
            case 3: {
                if ((this = this.getSettings()) == null || !this.getFriendsSound()) ** GOTO lbl5
                ** GOTO lbl-1000
            }
            case 2: {
                if ((this = this.getSettings()) == null || !this.getCallsSound()) ** GOTO lbl5
                ** GOTO lbl-1000
            }
            case 1: {
                if ((this = this.getSettings()) == null || !this.getMessagesSound()) ** GOTO lbl5
                ** GOTO lbl-1000
            }
        }
        return v0;
    }

    private final void playNotificationSound(io.streamlayer.sdk.model.notifications.NotificationType notificationType) {
        long l = System.currentTimeMillis();
        if (l > this.lastTimestampSoundPlayed + (long)1200) {
            this.lastTimestampSoundPlayed = l;
            int n = InAppNotificationsService$WhenMappings.$EnumSwitchMapping$1[notificationType.ordinal()] != 1 ? this.generalSound : this.messageSound;
            this.soundPool.play(n, 1.0f, 1.0f, 0, 0, 1.0f);
        }
    }

    @Inject
    public InAppNotificationsService(@NotNull Context context, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull NotificationRepo notificationRepo, @NotNull AnalyticsRepo analyticsRepo) {
        InAppNotificationsService inAppNotificationsService = this;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)notificationRepo, (String)"notificationsRepo");
        Intrinsics.checkParameterIsNotNull((Object)analyticsRepo, (String)"analyticsRepo");
        this.context = context;
        this.session = sessionPrefImpl;
        this.notificationsRepo = notificationRepo;
        inAppNotificationsService.analyticsRepo = analyticsRepo;
        inAppNotificationsService.pausedTopicsNotifications = new ArrayList<String>();
        sessionPrefImpl = new SoundPool.Builder().setMaxStreams(2).setAudioAttributes(new AudioAttributes.Builder().setUsage(5).setContentType(4).build()).build();
        this.soundPool = sessionPrefImpl;
        this.generalSound = sessionPrefImpl.load(context, R.raw.slr_general_notification, 1);
        inAppNotificationsService.messageSound = sessionPrefImpl.load(context, R.raw.slr_message_notification, 1);
    }

    public final void notifyChatMessage(@NotNull ChatMessage object) {
        ChatMessage chatMessage = object;
        Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"chatMessage");
        if (!Intrinsics.areEqual((Object)chatMessage.getSenderUserId(), (Object)this.getTinodeUserId()) && !StringsKt.isBlank((CharSequence)((ChatMessage)object).getText())) {
            ChatMessage chatMessage2 = object;
            object = chatMessage2.getTopicId();
            Notification notification = NotificationUtilKt.toNotification$default(chatMessage2, null, 1, null);
            if (!this.pausedTopicsNotifications.contains(object)) {
                this.session.incrementTotalUnreadMessagesCount();
                this.showNotification(notification);
            }
            return;
        }
    }

    public final void notifyWatchParty(@NotNull WatchParty object) {
        Notification notification;
        Object object2;
        Date date;
        WatchParty watchParty = object;
        Intrinsics.checkParameterIsNotNull((Object)watchParty, (String)"watchParty");
        object = watchParty.getData();
        Object object3 = watchParty.getStatus();
        Object object4 = watchParty.getOwner();
        String cfr_ignored_0 = "notifyCall: " + object + ' ' + object3;
        object3 = ((Chat)object).getChatId();
        MessagingExtensionsKt.participantsWithoutUser((Chat)object, this.session.getTinodeUserId());
        Long l = null;
        Object object5 = this.context;
        int n = R.string.slr_s_is_having_a_watch_party;
        Object object6 = new Object[1];
        int n2 = 0;
        String string2 = object4 != null ? ((TinodeContact)object4).getChatName() : null;
        object6[n2] = string2;
        object5 = object5.getString(n, object6);
        String string3 = ((Chat)object).getName();
        object6 = io.streamlayer.sdk.model.notifications.NotificationType.WatchParty.name();
        Date date2 = date;
        date = new Date();
        string2 = "topic_" + ((Chat)object).getChatId();
        if (object4 != null) {
            TinodeContact tinodeContact = object4;
            object4 = NotificationIcon.Companion;
            object2 = tinodeContact.getPhotoData();
            String string4 = tinodeContact.getChatName();
            if (string4 == null) {
                string4 = "";
            }
            object4 = ((NotificationIcon.Companion)object4).buildAvatarIcon((String)object2, string4);
        } else {
            object4 = null;
        }
        object2 = notification;
        notification = new Notification(l, (String)object5, string3, (String)object6, date2, string2, object, (NotificationIcon)object4);
        if (!this.pausedTopicsNotifications.contains(object3)) {
            this.showNotification((Notification)object2);
        }
    }

    public final void notifyTweet(@NotNull Tweet tweet) {
        Tweet tweet2 = tweet;
        Intrinsics.checkParameterIsNotNull((Object)tweet2, (String)"tweet");
        this.showNotification(NotificationUtilKt.toNotification(tweet2));
    }

    public final void notifyWaveMessage(@NotNull WaveMessage waveMessage) {
        Intrinsics.checkParameterIsNotNull((Object)waveMessage, (String)"waveMessage");
        String string2 = this.context.getString(R.string.slr_wave_reply_message, new Object[]{waveMessage.getUserName()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.stri\u2026ge, waveMessage.userName)");
        this.showNotification(NotificationUtilKt.toNotification(waveMessage, string2));
    }

    public final void playSound(@NotNull io.streamlayer.sdk.model.notifications.NotificationType notificationType) {
        io.streamlayer.sdk.model.notifications.NotificationType notificationType2 = notificationType;
        Intrinsics.checkParameterIsNotNull((Object)((Object)notificationType2), (String)"type");
        if (!this.isSoundEnabled(notificationType2)) {
            return;
        }
        this.playNotificationSound(notificationType);
    }

    public final void disconnect() {
        this.notificationsRepo.deleteAllNotifications();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void pauseNotifications(boolean bl, @NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        if (bl) {
            this.pausedTopicsNotifications.add(string2);
            return;
        }
        try {
            Result.constructor-impl((Object)this.pausedTopicsNotifications.remove(string2));
            return;
        }
        catch (Throwable throwable) {
            Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return;
        }
    }
}

