/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.lite;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import io.streamlayer.common.eventbus.SLREventBus;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.routes.OverlayRoutesProvider;
import io.streamlayer.common.session.Session;
import io.streamlayer.sdk.StreamLayerEvents;
import io.streamlayer.sdk.lite.StreamLayerLiteOverlayState;
import io.streamlayer.sdk.model.advertising.AdvertisingData;
import io.streamlayer.sdk.model.advertising.AdvertisingImage;
import io.streamlayer.sdk.model.analytics.CommonCategory;
import io.streamlayer.sdk.model.analytics.CommonKind;
import io.streamlayer.sdk.model.analytics.InteractionActionType;
import io.streamlayer.sdk.model.analytics.InvitationCategory;
import io.streamlayer.sdk.model.analytics.NotificationKind;
import io.streamlayer.sdk.model.analytics.NotificationType;
import io.streamlayer.sdk.model.analytics.PermissionType;
import io.streamlayer.sdk.model.analytics.WaveCategory;
import io.streamlayer.sdk.repository.advertising.AdvertisingRepo;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.usecases.NetworkConnectionUseCase;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B9\b\u0007\u0012\u0006\u0010&\u001a\u00020%\u0012\u0006\u0010(\u001a\u00020\u0002\u0012\u0006\u0010+\u001a\u00020*\u0012\u0006\u0010.\u001a\u00020-\u0012\u0006\u00101\u001a\u000200\u0012\u0006\u0010A\u001a\u00020@\u00a2\u0006\u0004\bB\u0010CJ\b\u0010\u0004\u001a\u00020\u0003H\u0002J\u0011\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0096\u0001J8\u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\fH\u0096\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ8\u0010\u0010\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\fH\u0096\u0001\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u001f\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u00112\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\fH\u0096\u0001J)\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0015H\u0096\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u0096\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u0096\u0001J9\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0096\u0001J\u0019\u0010 \u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u0005H\u0096\u0001J%\u0010!\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00052\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\fH\u0096\u0001J\u0013\u0010\"\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0096\u0001J%\u0010$\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010#H\u0096\u0001R\u0016\u0010&\u001a\u00020%8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0016\u0010(\u001a\u00020\u00028\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0016\u0010.\u001a\u00020-8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0019\u00101\u001a\u0002008\u0006@\u0006\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R\u001f\u00107\u001a\b\u0012\u0004\u0012\u000206058\u0006@\u0006\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\u0019\u0010<\u001a\u00020;8\u0006@\u0006\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?\u00a8\u0006D"}, d2={"Lio/streamlayer/sdk/lite/StreamLayerLiteViewModel;", "Landroidx/lifecycle/ViewModel;", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "", "loadAdvertisingData", "Lio/streamlayer/sdk/model/analytics/CommonKind;", "kind", "triggerAuthenticationEvent", "", "topicId", "", "participantsCount", "Lio/streamlayer/sdk/model/analytics/CommonCategory;", "category", "triggerCallEvent", "(Ljava/lang/String;Lio/streamlayer/sdk/model/analytics/CommonKind;Ljava/lang/Integer;Lio/streamlayer/sdk/model/analytics/CommonCategory;)V", "triggerConversationEvent", "Lio/streamlayer/sdk/model/analytics/InteractionActionType;", "actionType", "triggerInteractionEvent", "eventId", "Lio/streamlayer/sdk/model/analytics/InvitationCategory;", "triggerInvitationEvent", "triggerLaunchButtonInitEvent", "triggerLaunchButtonTappedEvent", "Lio/streamlayer/sdk/model/analytics/NotificationType;", "type", "Lio/streamlayer/sdk/model/analytics/NotificationKind;", "commonKind", "triggerNotificationEvent", "Lio/streamlayer/sdk/model/analytics/PermissionType;", "permission", "triggerPermissionEvent", "triggerPollEvent", "triggerSessionHeartbeat", "Lio/streamlayer/sdk/model/analytics/WaveCategory;", "triggerWaveEvent", "Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;", "advertisingRepo", "Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;", "analyticsRepo", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "Lio/streamlayer/common/session/Session;", "session", "Lio/streamlayer/common/session/Session;", "Lio/streamlayer/sdk/usecases/NetworkConnectionUseCase;", "networkConnectionUseCase", "Lio/streamlayer/sdk/usecases/NetworkConnectionUseCase;", "Lio/streamlayer/common/routes/OverlayRoutesProvider;", "overlayRoutesProvider", "Lio/streamlayer/common/routes/OverlayRoutesProvider;", "getOverlayRoutesProvider", "()Lio/streamlayer/common/routes/OverlayRoutesProvider;", "Lkotlinx/coroutines/flow/Flow;", "", "networkConnection", "Lkotlinx/coroutines/flow/Flow;", "getNetworkConnection", "()Lkotlinx/coroutines/flow/Flow;", "Lio/streamlayer/sdk/lite/StreamLayerLiteOverlayState;", "overlayState", "Lio/streamlayer/sdk/lite/StreamLayerLiteOverlayState;", "getOverlayState", "()Lio/streamlayer/sdk/lite/StreamLayerLiteOverlayState;", "Lio/streamlayer/common/eventbus/SLREventBus;", "eventBus", "<init>", "(Lio/streamlayer/sdk/repository/advertising/AdvertisingRepo;Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;Lio/streamlayer/common/session/Session;Lio/streamlayer/sdk/usecases/NetworkConnectionUseCase;Lio/streamlayer/common/routes/OverlayRoutesProvider;Lio/streamlayer/common/eventbus/SLREventBus;)V", "sdk_originalRelease"})
public final class StreamLayerLiteViewModel
extends ViewModel
implements AnalyticsRepo {
    @NotNull
    private final AdvertisingRepo advertisingRepo;
    @NotNull
    private final AnalyticsRepo analyticsRepo;
    @NotNull
    private final Session session;
    @NotNull
    private final NetworkConnectionUseCase networkConnectionUseCase;
    @NotNull
    private final OverlayRoutesProvider overlayRoutesProvider;
    @NotNull
    private final Flow<Boolean> networkConnection;
    @NotNull
    private final StreamLayerLiteOverlayState overlayState;

    @Inject
    public StreamLayerLiteViewModel(@NotNull AdvertisingRepo advertisingRepo, @NotNull AnalyticsRepo analyticsRepo, @NotNull Session session, @NotNull NetworkConnectionUseCase networkConnectionUseCase, @NotNull OverlayRoutesProvider overlayRoutesProvider, @NotNull SLREventBus sLREventBus) {
        StreamLayerLiteViewModel streamLayerLiteViewModel = this;
        Intrinsics.checkNotNullParameter((Object)advertisingRepo, (String)"advertisingRepo");
        Intrinsics.checkNotNullParameter((Object)analyticsRepo, (String)"analyticsRepo");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)networkConnectionUseCase, (String)"networkConnectionUseCase");
        Intrinsics.checkNotNullParameter((Object)overlayRoutesProvider, (String)"overlayRoutesProvider");
        Intrinsics.checkNotNullParameter((Object)sLREventBus, (String)"eventBus");
        this.advertisingRepo = advertisingRepo;
        this.analyticsRepo = analyticsRepo;
        this.session = session;
        this.networkConnectionUseCase = networkConnectionUseCase;
        this.overlayRoutesProvider = overlayRoutesProvider;
        streamLayerLiteViewModel.networkConnection = networkConnectionUseCase.getState();
        streamLayerLiteViewModel.overlayState = new StreamLayerLiteOverlayState(false, 0L, 3, null);
        if (!session.isLoggedIn()) {
            sLREventBus.produceEvent(StreamLayerEvents.LoginRequiredLiteOverlay.INSTANCE);
        }
        this.loadAdvertisingData();
    }

    private final void loadAdvertisingData() {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ StreamLayerLiteViewModel this$0;
            {
                this.this$0 = streamLayerLiteViewModel;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object2);
                } else {
                    ResultKt.throwOnFailure((Object)object2);
                    this.label = 1;
                    object2 = FlowKt.firstOrNull(StreamLayerLiteViewModel.access$getAdvertisingRepo$p(this.this$0).fetchAdvertisingData(), (Continuation)this);
                    if (object2 == object3) {
                        return object3;
                    }
                }
                object2 = (ResourceState)object2;
                if (object2 == null || (object2 = (List)((ResourceState)object2).getData()) == null) return Unit.INSTANCE;
                StreamLayerLiteViewModel streamLayerLiteViewModel = this.this$0;
                if ((object2 = (AdvertisingData)CollectionsKt.firstOrNull((List)object2)) == null || (object2 = (AdvertisingImage)CollectionsKt.randomOrNull(((AdvertisingData)object2).getImages(), (Random)Random.Default)) == null || (object2 = ((AdvertisingImage)object2).getFileUrl()) == null) return Unit.INSTANCE;
                StreamLayerLiteViewModel.access$getSession$p(streamLayerLiteViewModel).setCurrentSponsorAdUrl((String)object2);
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)function22, (int)3, null);
    }

    public static final /* synthetic */ AdvertisingRepo access$getAdvertisingRepo$p(StreamLayerLiteViewModel streamLayerLiteViewModel) {
        return streamLayerLiteViewModel.advertisingRepo;
    }

    public static final /* synthetic */ Session access$getSession$p(StreamLayerLiteViewModel streamLayerLiteViewModel) {
        return streamLayerLiteViewModel.session;
    }

    @NotNull
    public final OverlayRoutesProvider getOverlayRoutesProvider() {
        return this.overlayRoutesProvider;
    }

    @Override
    public void triggerAuthenticationEvent(@NotNull CommonKind commonKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerAuthenticationEvent(commonKind);
    }

    @Override
    public void triggerCallEvent(@NotNull String string2, @NotNull CommonKind commonKind, @Nullable Integer n, @Nullable CommonCategory commonCategory) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerCallEvent(string2, commonKind, n, commonCategory);
    }

    @Override
    public void triggerConversationEvent(@NotNull String string2, @NotNull CommonKind commonKind, @Nullable Integer n, @Nullable CommonCategory commonCategory) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerConversationEvent(string2, commonKind, n, commonCategory);
    }

    @Override
    public void triggerInteractionEvent(@NotNull InteractionActionType interactionActionType, @Nullable CommonCategory commonCategory) {
        Intrinsics.checkNotNullParameter((Object)((Object)interactionActionType), (String)"actionType");
        this.analyticsRepo.triggerInteractionEvent(interactionActionType, commonCategory);
    }

    @Override
    public void triggerInvitationEvent(@NotNull CommonKind commonKind, @Nullable String string2, @Nullable InvitationCategory invitationCategory) {
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerInvitationEvent(commonKind, string2, invitationCategory);
    }

    @Override
    public void triggerLaunchButtonInitEvent() {
        this.analyticsRepo.triggerLaunchButtonInitEvent();
    }

    @Override
    public void triggerLaunchButtonTappedEvent() {
        this.analyticsRepo.triggerLaunchButtonTappedEvent();
    }

    @Override
    public void triggerNotificationEvent(@NotNull NotificationType notificationType, @NotNull NotificationKind notificationKind, @NotNull CommonKind commonKind, @Nullable CommonCategory commonCategory, @Nullable String string2) {
        Intrinsics.checkNotNullParameter((Object)((Object)notificationType), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)notificationKind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"commonKind");
        this.analyticsRepo.triggerNotificationEvent(notificationType, notificationKind, commonKind, commonCategory, string2);
    }

    @Override
    public void triggerPermissionEvent(@NotNull PermissionType permissionType, @NotNull CommonKind commonKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)permissionType), (String)"permission");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerPermissionEvent(permissionType, commonKind);
    }

    @Override
    public void triggerPollEvent(@NotNull String string2, @NotNull CommonKind commonKind, @Nullable CommonCategory commonCategory) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"commonKind");
        this.analyticsRepo.triggerPollEvent(string2, commonKind, commonCategory);
    }

    @Override
    public void triggerSessionHeartbeat(@Nullable String string2) {
        this.analyticsRepo.triggerSessionHeartbeat(string2);
    }

    @Override
    public void triggerWaveEvent(@NotNull CommonKind commonKind, @NotNull String string2, @Nullable WaveCategory waveCategory) {
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"eventId");
        this.analyticsRepo.triggerWaveEvent(commonKind, string2, waveCategory);
    }

    @NotNull
    public final Flow<Boolean> getNetworkConnection() {
        return this.networkConnection;
    }

    @NotNull
    public final StreamLayerLiteOverlayState getOverlayState() {
        return this.overlayState;
    }
}

