/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.notifications;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.LayerDrawable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import io.streamlayer.common.extensions.CoilExtensionsKt;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemNotificationBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationCustomBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationPredictionsBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationWatchPartyBinding;
import io.streamlayer.sdk.main.notifications.NotificationViewsProvider;
import io.streamlayer.sdk.main.notifications.NotificationsLayout;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationBuilder;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.predictions.view.ExtensionsKt;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.Iterator;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001:\u0005\u001b\u001c\u001d\u001e\u001fB\u000f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002R\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\"\u0010\u0013\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "", "Landroid/view/ViewGroup;", "parent", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "getNotificationView", "view", "", "addToPool", "clearPool", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;", "listener", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;", "Ljava/util/LinkedList;", "notificationViewsPool", "Ljava/util/LinkedList;", "", "overlayHeight", "I", "getOverlayHeight", "()I", "setOverlayHeight", "(I)V", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;)V", "NotificationCustomViewHolder", "NotificationPredictionsView", "NotificationTouchListener", "NotificationView", "NotificationWatchPartyView", "sdk_originalRelease"})
public final class NotificationViewsProvider {
    @NotNull
    private final NotificationsLayout.NotificationViewAction listener;
    @NotNull
    private final LinkedList<NotificationsLayout.BaseNotificationView> notificationViewsPool;
    private int overlayHeight;

    public NotificationViewsProvider(@NotNull NotificationsLayout.NotificationViewAction notificationViewAction2) {
        LinkedList linkedList;
        Intrinsics.checkNotNullParameter((Object)notificationViewAction2, (String)"listener");
        ((NotificationViewsProvider)((Object)linkedList2)).listener = notificationViewAction2;
        LinkedList linkedList2 = linkedList;
        linkedList = new LinkedList();
        v1.notificationViewsPool = linkedList2;
    }

    public final int getOverlayHeight() {
        return this.overlayHeight;
    }

    public final void setOverlayHeight(int n) {
        this.overlayHeight = n;
    }

    @NotNull
    public final NotificationsLayout.BaseNotificationView getNotificationView(@NotNull ViewGroup object, @NotNull Notification notification) {
        NotificationsLayout.BaseNotificationView baseNotificationView;
        Notification notification2 = notification;
        Intrinsics.checkNotNullParameter((Object)object, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        notification = LayoutInflater.from((Context)object.getContext());
        int n = WhenMappings.$EnumSwitchMapping$0[notification2.getType().ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (this.notificationViewsPool.isEmpty()) {
                        NotificationView notificationView;
                        baseNotificationView = notificationView;
                        object = SlrItemNotificationBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationView = new NotificationView((SlrItemNotificationBinding)object);
                    } else {
                        baseNotificationView = this.notificationViewsPool.removeFirst();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)baseNotificationView, (String)"{\n                if (notificationViewsPool.isEmpty())\n                    NotificationView(SlrItemNotificationBinding.inflate(inflater, parent, false))\n                else notificationViewsPool.removeFirst()\n            }");
                } else {
                    NotificationCustomViewHolder notificationCustomViewHolder;
                    baseNotificationView = notificationCustomViewHolder;
                    object = SlrItemNotificationCustomBinding.inflate((LayoutInflater)notification, object, false);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(\n                    inflater,\n                    parent,\n                    false\n                )");
                    notificationCustomViewHolder = new NotificationCustomViewHolder((SlrItemNotificationCustomBinding)object);
                }
            } else {
                NotificationPredictionsView notificationPredictionsView;
                baseNotificationView = notificationPredictionsView;
                object = SlrItemNotificationPredictionsBinding.inflate((LayoutInflater)notification, object, false);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                notificationPredictionsView = new NotificationPredictionsView((SlrItemNotificationPredictionsBinding)object);
            }
        } else {
            NotificationWatchPartyView notificationWatchPartyView;
            baseNotificationView = notificationWatchPartyView;
            object = SlrItemNotificationWatchPartyBinding.inflate((LayoutInflater)notification, object, false);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
            notificationWatchPartyView = new NotificationWatchPartyView((SlrItemNotificationWatchPartyBinding)object);
        }
        return baseNotificationView;
    }

    public final void addToPool(@NotNull NotificationsLayout.BaseNotificationView baseNotificationView) {
        Intrinsics.checkNotNullParameter((Object)baseNotificationView, (String)"view");
        if (!this.notificationViewsPool.contains(baseNotificationView)) {
            this.notificationViewsPool.addLast(baseNotificationView);
        }
    }

    public final void clearPool(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        Iterator iterator = this.notificationViewsPool.iterator();
        while (iterator.hasNext()) {
            viewGroup.removeView(((NotificationsLayout.BaseNotificationView)iterator.next()).getBinding().getRoot());
        }
        this.notificationViewsPool.clear();
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016R\u0019\u0010\t\u001a\u00020\b8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u000fR\u0016\u0010\u0012\u001a\u00020\r8\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationTouchListener;", "Landroid/view/View$OnTouchListener;", "Landroid/view/View;", "view", "Landroid/view/MotionEvent;", "motionEvent", "", "onTouch", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "getNotification", "()Lio/streamlayer/sdk/model/notifications/Notification;", "", "dY", "F", "y1", "y2", "swipeThreshold", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/model/notifications/Notification;)V", "sdk_originalRelease"})
    public final class NotificationTouchListener
    implements View.OnTouchListener {
        @NotNull
        private final Notification notification;
        private float dY;
        private float y1;
        private float y2;
        private final float swipeThreshold;

        public NotificationTouchListener(Notification notification) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            this.notification = notification;
            this.swipeThreshold = 50.0f;
        }

        @NotNull
        public final Notification getNotification() {
            return this.notification;
        }

        public boolean onTouch(@NotNull View view2, @NotNull MotionEvent motionEvent) {
            MotionEvent motionEvent2 = motionEvent;
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
            Intrinsics.checkNotNullParameter((Object)motionEvent2, (String)"motionEvent");
            int n = motionEvent2.getAction();
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        view2.setY(motionEvent.getRawY() + this.dY);
                    }
                } else {
                    NotificationTouchListener notificationTouchListener;
                    this.y2 = view2.getY();
                    if (Math.abs(Math.abs(notificationTouchListener.y1) - Math.abs(this.y2)) < this.swipeThreshold) {
                        NotificationViewsProvider.this.listener.onExpand(this.notification, view2);
                    } else {
                        float f;
                        float f2 = this.y2;
                        if (f < this.y1 && Math.abs(Math.abs(f2) - Math.abs(this.y1)) > this.swipeThreshold) {
                            NotificationViewsProvider.this.listener.onHide(this.notification, view2);
                        } else {
                            float f3;
                            float f4 = this.y1;
                            if (f3 < this.y2 && Math.abs(Math.abs(f4) - Math.abs(this.y2)) > this.swipeThreshold) {
                                NotificationViewsProvider.this.listener.hideAll();
                            }
                        }
                    }
                }
            } else {
                this.dY = view2.getY() - motionEvent.getRawY();
                this.y1 = view2.getY();
            }
            return true;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u001c\u0010\u0007\u001a\u00020\u00068\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationWatchPartyView;", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;)V", "sdk_originalRelease"})
    public final class NotificationWatchPartyView
    implements NotificationsLayout.BaseNotificationView {
        @NotNull
        private final SlrItemNotificationWatchPartyBinding binding;

        public NotificationWatchPartyView(SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationWatchPartyBinding, (String)"binding");
            this.binding = slrItemNotificationWatchPartyBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationWatchPartyBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            NotificationWatchPartyView notificationWatchPartyView = this;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding = notificationWatchPartyView.getBinding();
            NotificationViewsProvider notificationViewsProvider = notificationWatchPartyView.NotificationViewsProvider.this;
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding2 = slrItemNotificationWatchPartyBinding;
            slrItemNotificationWatchPartyBinding2.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            slrItemNotificationWatchPartyBinding2.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            if (WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()] == 1) {
                slrItemNotificationWatchPartyBinding = slrItemNotificationWatchPartyBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationWatchPartyBinding, (String)"slNotifIconIV");
                Object object = notification.getNotificationIcon();
                object = object == null ? null : ((NotificationIcon)object).getAvatarUrl();
                Object object2 = notification.getNotificationIcon();
                object2 = object2 == null ? null : ((NotificationIcon)object2).getAvatarName();
                ProfileExtensionsKt.loadUserAvatar$default((ImageView)slrItemNotificationWatchPartyBinding, (String)object, (String)object2, null, 4, null);
            } else {
                AppCompatImageView appCompatImageView = slrItemNotificationWatchPartyBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                CoilExtensionsKt.clear((ImageView)appCompatImageView, bind.1.1.INSTANCE);
            }
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
        }

        @Override
        public void clear() {
            NotificationsLayout.BaseNotificationView.DefaultImpls.clear(this);
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                nArray[NotificationType.WatchParty.ordinal()] = 1;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0014\u0010\u0006\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0003H\u0003J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0003H\u0003J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016R\u001c\u0010\u000f\u001a\u00020\u000e8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "Landroid/view/View;", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "type", "", "setPadding", "", "getIcon", "getColor", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "bind", "clear", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;)V", "sdk_originalRelease"})
    public final class NotificationView
    implements NotificationsLayout.BaseNotificationView {
        @NotNull
        private final SlrItemNotificationBinding binding;

        public NotificationView(SlrItemNotificationBinding slrItemNotificationBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationBinding, (String)"binding");
            this.binding = slrItemNotificationBinding;
        }

        private final void setPadding(View view2, NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    n = 0;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n = ViewExtensionsKt.getDp(4.0f);
                }
            }
            int n2 = n;
            view2.setPadding(n2, n2, n2, n2);
        }

        @DrawableRes
        private final int getIcon(NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 9: 
                case 11: {
                    n = 0;
                    break;
                }
                case 8: 
                case 10: {
                    n = R.drawable.slr_ic_watch_party_centered;
                    break;
                }
                case 6: 
                case 7: {
                    n = R.drawable.slr_ic_profile;
                    break;
                }
                case 5: {
                    n = R.drawable.slr_ic_betting;
                    break;
                }
                case 3: {
                    n = R.drawable.slr_ic_twitter;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n = R.drawable.slr_ic_chat;
                }
            }
            return n;
        }

        @ColorRes
        private final int getColor(NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 11: {
                    n = 0;
                    break;
                }
                case 9: 
                case 10: {
                    n = 17170445;
                    break;
                }
                case 8: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 6: 
                case 7: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 5: {
                    n = R.color.slr_orange;
                    break;
                }
                case 4: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 3: {
                    n = R.color.slr_twitter;
                    break;
                }
                case 2: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 1: {
                    n = R.color.slr_primaryBlue;
                }
            }
            return n;
        }

        public static final /* synthetic */ void access$setPadding(NotificationView notificationView, View view2, NotificationType notificationType) {
            notificationView.setPadding(view2, notificationType);
        }

        public static final /* synthetic */ int access$getIcon(NotificationView notificationView, NotificationType notificationType) {
            return notificationView.getIcon(notificationType);
        }

        @Override
        @NotNull
        public SlrItemNotificationBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Unit unit;
            ConstraintSet constraintSet;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationBinding slrItemNotificationBinding = this.getBinding();
            NotificationViewsProvider notificationViewsProvider = NotificationViewsProvider.this;
            slrItemNotificationBinding.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            Object object = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"slNotifTitleTV");
            String string2 = notification.getTitle();
            boolean bl = string2 == null || string2.length() == 0;
            ViewExtensionsKt.visibleIf((View)object, bl ^ true);
            slrItemNotificationBinding.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            object = constraintSet;
            object();
            constraintSet.clone(slrItemNotificationBinding.slNotification);
            String string3 = notification.getDescription();
            boolean bl2 = string3 == null || string3.length() == 0;
            if (bl2) {
                object.connect(slrItemNotificationBinding.slNotifTitleTV.getId(), 3, slrItemNotificationBinding.slNotifIconIV.getId(), 3);
                object.connect(slrItemNotificationBinding.slNotifTitleTV.getId(), 4, slrItemNotificationBinding.slNotifIconIV.getId(), 4);
            } else {
                int n = ViewExtensionsKt.getDp(4.0f);
                object.connect(slrItemNotificationBinding.slNotifTitleTV.getId(), 3, 0, 3, n);
            }
            object.applyTo(slrItemNotificationBinding.slNotification);
            object = slrItemNotificationBinding.slNotifDescriptionTV;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"slNotifDescriptionTV");
            String string4 = notification.getDescription();
            boolean bl3 = string4 == null || string4.length() == 0;
            ViewExtensionsKt.visibleIf((View)object, bl3 ^ true);
            object = notification.getNotificationIcon();
            if (object == null) {
                unit = null;
            } else {
                if (object.getAvatarName() != null) {
                    AppCompatImageView appCompatImageView = slrItemNotificationBinding.slNotifIconIV;
                    AppCompatTextView appCompatTextView = object;
                    Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                    object = appCompatTextView.getAvatarUrl();
                    ProfileExtensionsKt.loadUserAvatar$default((ImageView)appCompatImageView, (String)object, appCompatTextView.getAvatarName(), null, 4, null);
                } else if (object.getAvatarUrl() != null) {
                    Function1<Boolean, Unit> function1;
                    AppCompatImageView appCompatImageView = slrItemNotificationBinding.slNotifIconIV;
                    Object object2 = appCompatImageView;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifIconIV");
                    object = object.getAvatarUrl();
                    Intrinsics.checkNotNull((Object)object);
                    object2 = this.getIcon(notification.getType());
                    AppCompatTextView appCompatTextView = object;
                    object = function1;
                    function1 = new Function1<Boolean, Unit>(this, slrItemNotificationBinding, notification){
                        final /* synthetic */ NotificationView this$0;
                        final /* synthetic */ SlrItemNotificationBinding $this_with;
                        final /* synthetic */ Notification $data;
                        {
                            this.this$0 = notificationView;
                            this.$this_with = slrItemNotificationBinding;
                            this.$data = notification;
                            super(1);
                        }

                        public final void invoke(boolean bl) {
                            if (!bl) {
                                AppCompatImageView appCompatImageView = this.$this_with.slNotifIconIV;
                                Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                                NotificationView.access$setPadding(this.this$0, (View)appCompatImageView, this.$data.getType());
                            }
                        }
                    };
                    ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)appCompatTextView, false, (Integer)object2, (Function1)object, 2, null);
                }
                slrItemNotificationBinding.slNotifIconIV.setBackgroundTintList(null);
                unit = Unit.INSTANCE;
            }
            if (unit == null) {
                SlrItemNotificationBinding slrItemNotificationBinding2 = slrItemNotificationBinding = slrItemNotificationBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationBinding2, (String)"");
                CoilExtensionsKt.clear((ImageView)slrItemNotificationBinding2, (Function1<? super ImageView, Unit>)new Function1<ImageView, Unit>(this, notification){
                    final /* synthetic */ NotificationView this$0;
                    final /* synthetic */ Notification $data;
                    {
                        this.this$0 = notificationView;
                        this.$data = notification;
                        super(1);
                    }

                    public final void invoke(@NotNull ImageView imageView) {
                        Intrinsics.checkNotNullParameter((Object)imageView, (String)"$this$clear");
                        imageView.setImageResource(NotificationView.access$getIcon(this.this$0, this.$data.getType()));
                    }
                });
                this.setPadding((View)slrItemNotificationBinding, notification.getType());
                slrItemNotificationBinding.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)slrItemNotificationBinding.getContext(), (int)this.getColor(notification.getType()))));
                Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationBinding, (String)"run {\n                    slNotifIconIV.apply {\n                        clear { setImageResource(getIcon(data.type)) }\n                        setPadding(data.type)\n                        backgroundTintList =\n                            ColorStateList.valueOf(ContextCompat.getColor(context, getColor(data.type)))\n                    }\n                }");
            }
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
        }

        @Override
        public void clear() {
            SlrItemNotificationBinding slrItemNotificationBinding = this.getBinding();
            slrItemNotificationBinding.slNotifTitleTV.setText(null);
            AppCompatTextView appCompatTextView = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slNotifTitleTV");
            ViewExtensionsKt.gone((View)appCompatTextView);
            slrItemNotificationBinding.slNotifDescriptionTV.setText(null);
            AppCompatTextView appCompatTextView2 = slrItemNotificationBinding.slNotifDescriptionTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView2, (String)"slNotifDescriptionTV");
            ViewExtensionsKt.gone((View)appCompatTextView2);
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                nArray[NotificationType.Universal.ordinal()] = 1;
                nArray[NotificationType.Chat.ordinal()] = 2;
                nArray[NotificationType.Twitter.ordinal()] = 3;
                nArray[NotificationType.Alert.ordinal()] = 4;
                nArray[NotificationType.Inplay.ordinal()] = 5;
                nArray[NotificationType.ArrivingFriend.ordinal()] = 6;
                nArray[NotificationType.WaveReply.ordinal()] = 7;
                nArray[NotificationType.CreateNewWatchParty.ordinal()] = 8;
                nArray[NotificationType.Prediction.ordinal()] = 9;
                nArray[NotificationType.WatchParty.ordinal()] = 10;
                nArray[NotificationType.Custom.ordinal()] = 11;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u001c\u0010\u000b\u001a\u00020\n8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationPredictionsView;", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "", "visible", "", "setNotificationVisible", "showAnimate", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "bind", "Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;)V", "sdk_originalRelease"})
    public final class NotificationPredictionsView
    implements NotificationsLayout.BaseNotificationView {
        @NotNull
        private final SlrItemNotificationPredictionsBinding binding;

        public NotificationPredictionsView(SlrItemNotificationPredictionsBinding slrItemNotificationPredictionsBinding) {
            block4: {
                block5: {
                    block6: {
                        block3: {
                            block2: {
                                Intrinsics.checkNotNullParameter((Object)notificationPredictionsView2.NotificationViewsProvider.this, (String)"this$0");
                                Intrinsics.checkNotNullParameter((Object)slrItemNotificationPredictionsBinding, (String)"binding");
                                notificationPredictionsView2.binding = slrItemNotificationPredictionsBinding;
                                Context context = notificationPredictionsView2.getBinding().getRoot().getContext();
                                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                                if (!OtherExtensionsKt.isScreenPortrait(context)) break block2;
                                notificationPredictionsView2.setNotificationVisible(true);
                                break block3;
                            }
                            notificationPredictionsView2.NotificationViewsProvider.this = notificationPredictionsView2.getBinding().getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)notificationPredictionsView2.NotificationViewsProvider.this, (String)"binding.root");
                            slrItemNotificationPredictionsBinding = notificationPredictionsView2.NotificationViewsProvider.this.getLayoutParams();
                            if (slrItemNotificationPredictionsBinding == null) break block4;
                            ((ViewGroup.LayoutParams)slrItemNotificationPredictionsBinding).width = notificationPredictionsView2.getBinding().getRoot().getContext().getResources().getDimensionPixelSize(R.dimen.slr_predictions_notification_landscape_width);
                            notificationPredictionsView2.NotificationViewsProvider.this.setLayoutParams((ViewGroup.LayoutParams)slrItemNotificationPredictionsBinding);
                            notificationPredictionsView2.NotificationViewsProvider.this = notificationPredictionsView2.getBinding().slNotification;
                            Intrinsics.checkNotNullExpressionValue((Object)notificationPredictionsView2.NotificationViewsProvider.this, (String)"binding.slNotification");
                            slrItemNotificationPredictionsBinding = notificationPredictionsView2.NotificationViewsProvider.this.getLayoutParams();
                            if (slrItemNotificationPredictionsBinding == null) break block5;
                            ((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding).topToTop = -1;
                            ((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding).bottomToBottom = 0;
                            notificationPredictionsView2.NotificationViewsProvider.this.setLayoutParams((ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding));
                            notificationPredictionsView2.NotificationViewsProvider.this = notificationPredictionsView2.getBinding().slrNotificationIcon;
                            Intrinsics.checkNotNullExpressionValue((Object)notificationPredictionsView2.NotificationViewsProvider.this, (String)"binding.slrNotificationIcon");
                            slrItemNotificationPredictionsBinding = notificationPredictionsView2.NotificationViewsProvider.this.getLayoutParams();
                            if (slrItemNotificationPredictionsBinding == null) break block6;
                            NotificationPredictionsView notificationPredictionsView = notificationPredictionsView2;
                            NotificationPredictionsView notificationPredictionsView2 = (ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding;
                            ((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding).topToTop = -1;
                            ((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding).bottomToBottom = 0;
                            notificationPredictionsView2.NotificationViewsProvider.this.setLayoutParams((ViewGroup.LayoutParams)notificationPredictionsView2);
                            notificationPredictionsView.setNotificationVisible(true);
                        }
                        return;
                    }
                    throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                }
                throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        private final void setNotificationVisible(boolean bl) {
            SlrItemNotificationPredictionsBinding slrItemNotificationPredictionsBinding = this.getBinding();
            ConstraintLayout constraintLayout = slrItemNotificationPredictionsBinding.slNotification;
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"slNotification");
            ViewExtensionsKt.visibleIf((View)constraintLayout, bl);
            ImageView imageView = slrItemNotificationPredictionsBinding.slrLeftSide;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slrLeftSide");
            ViewExtensionsKt.visibleIf((View)imageView, bl);
            ImageView imageView2 = slrItemNotificationPredictionsBinding.slrNotificationIcon;
            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"slrNotificationIcon");
            ViewExtensionsKt.visibleIf((View)imageView2, bl);
            ImageView imageView3 = slrItemNotificationPredictionsBinding.slrNotificationsSmallIcon;
            Intrinsics.checkNotNullExpressionValue((Object)imageView3, (String)"slrNotificationsSmallIcon");
            ViewExtensionsKt.visibleIf((View)imageView3, bl);
        }

        private final void showAnimate() {
            NotificationPredictionsView notificationPredictionsView = this;
            this.getBinding().getRoot().post(() -> NotificationPredictionsView.showAnimate$lambda-12(notificationPredictionsView, notificationPredictionsView.NotificationViewsProvider.this));
        }

        private static final void showAnimate$lambda-12$lambda-9$lambda-8(ValueAnimator object, NotificationPredictionsView notificationPredictionsView, ValueAnimator valueAnimator) {
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsView, (String)"this$0");
            object = object.getAnimatedValue();
            if (object != null) {
                int n = (Integer)object;
                valueAnimator = notificationPredictionsView.getBinding().slrNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"binding.slrNotificationIcon");
                boolean bl = n > ViewExtensionsKt.getDp(73.0f);
                ViewExtensionsKt.visibleIf((View)valueAnimator, bl);
                notificationPredictionsView = notificationPredictionsView.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)notificationPredictionsView, (String)"binding.root");
                valueAnimator = notificationPredictionsView.getLayoutParams();
                if (valueAnimator != null) {
                    valueAnimator.width = n;
                    notificationPredictionsView.setLayoutParams((ViewGroup.LayoutParams)valueAnimator);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }

        private static final void showAnimate$lambda-12$lambda-11(NotificationPredictionsView notificationPredictionsView) {
            NotificationPredictionsView notificationPredictionsView2 = notificationPredictionsView;
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsView2, (String)"this$0");
            ConstraintLayout constraintLayout = notificationPredictionsView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            ViewExtensionsKt.visible((View)constraintLayout);
        }

        private static final void showAnimate$lambda-12(NotificationPredictionsView notificationPredictionsView, NotificationViewsProvider notificationViewsProvider) {
            block4: {
                block3: {
                    boolean bl;
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)notificationPredictionsView, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)notificationViewsProvider, (String)"this$1");
                        Context context = notificationPredictionsView.getBinding().getRoot().getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                        bl = OtherExtensionsKt.isScreenPortrait(context);
                        if (bl) break block2;
                        NotificationPredictionsView notificationPredictionsView2 = notificationPredictionsView;
                        ConstraintLayout constraintLayout = notificationPredictionsView2.getBinding().slNotification;
                        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.slNotification");
                        ViewExtensionsKt.invisible((View)constraintLayout);
                        ImageView imageView = notificationPredictionsView2.getBinding().slrNotificationIcon;
                        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slrNotificationIcon");
                        ViewExtensionsKt.invisible((View)imageView);
                        ImageView imageView2 = notificationPredictionsView2.getBinding().slrLeftSide;
                        Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.slrLeftSide");
                        ViewExtensionsKt.invisible((View)imageView2);
                        int n = (int)notificationPredictionsView2.getBinding().getRoot().getContext().getResources().getDimension(R.dimen.slr_notification_landscape_width);
                        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, n});
                        valueAnimator.setDuration(300L);
                        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(notificationPredictionsView){
                            final /* synthetic */ NotificationPredictionsView this$0;
                            {
                                this.this$0 = notificationPredictionsView;
                            }

                            public void onAnimationStart(@NotNull Animator animator) {
                                showAnimate.1.1.1 v0 = this;
                                Intrinsics.checkNotNullParameter((Object)animator, (String)"var1");
                                ConstraintLayout constraintLayout = v0.this$0.getBinding().slNotification;
                                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.slNotification");
                                ViewExtensionsKt.visible((View)constraintLayout);
                                ImageView imageView = v0.this$0.getBinding().slrLeftSide;
                                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slrLeftSide");
                                ViewExtensionsKt.visible((View)imageView);
                            }
                        });
                        valueAnimator.addUpdateListener(arg_0 -> NotificationPredictionsView.showAnimate$lambda-12$lambda-9$lambda-8(valueAnimator, notificationPredictionsView, arg_0));
                        valueAnimator.start();
                        break block3;
                    }
                    ConstraintLayout constraintLayout = notificationPredictionsView.getBinding().getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                    ViewGroup.LayoutParams layoutParams = constraintLayout.getLayoutParams();
                    if (layoutParams == null) break block4;
                    NotificationPredictionsView notificationPredictionsView3 = notificationPredictionsView;
                    ((ViewGroup.MarginLayoutParams)layoutParams).height = -2;
                    constraintLayout.setLayoutParams((ViewGroup.LayoutParams)((ViewGroup.MarginLayoutParams)layoutParams));
                    notificationPredictionsView3.getBinding().getRoot().setAlpha(0.0f);
                    notificationPredictionsView = notificationPredictionsView3.getBinding().getRoot().animate().withStartAction(() -> NotificationPredictionsView.showAnimate$lambda-12$lambda-11(notificationPredictionsView));
                    long l = bl ? 500L : 300L;
                    notificationPredictionsView.setDuration(l).alpha(1.0f).translationY(-((float)notificationViewsProvider.getOverlayHeight() - (float)ViewExtensionsKt.getDp(150.0f))).start();
                    int cfr_ignored_0 = Resources.getSystem().getDisplayMetrics().heightPixels;
                }
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }

        @Override
        @NotNull
        public SlrItemNotificationPredictionsBinding getBinding() {
            return this.binding;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void bind(@NotNull Notification var1_1) {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            v0 = this;
                            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"data");
                            var2_2 = v0.getBinding();
                            var3_3 = v0.NotificationViewsProvider.this;
                            var2_2.slrQuestionText.setText((CharSequence)var1_1.getTitle());
                            var4_4 = var1_1.getNotificationIcon();
                            if (var4_4 == null) {
                                while (true) {
                                    var4_4 = null;
                                    break;
                                }
                            } else {
                                if ((var4_4 = var4_4.getMeta()) == null) ** continue;
                                var4_4 = (String)var4_4.get("icon");
                            }
                            var5_6 = var1_1.getNotificationIcon();
                            if (var5_6 == null) {
                                while (true) {
                                    var5_6 = null;
                                    break;
                                }
                            } else {
                                if ((var5_6 = var5_6.getMeta()) == null) ** continue;
                                var5_6 = (String)var5_6.get("smallIcon");
                            }
                            if (var4_4 != null) {
                                v1 = var2_2.slrNotificationIcon;
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"slrNotificationIcon");
                                ExtensionsKt.load(v1, (String)var4_4);
                            } else {
                                var2_2.slrNotificationIcon.setImageResource(0);
                            }
                            if (var5_6 != null) {
                                v2 = var2_2.slrNotificationsSmallIcon;
                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"slrNotificationsSmallIcon");
                                ExtensionsKt.load(v2, (String)var5_6);
                            } else {
                                var2_2.slrNotificationsSmallIcon.setImageResource(0);
                            }
                            v3 = var1_1;
                            var4_4 = v3.getDataJson();
                            if (var4_4 != null) break block19;
                            var4_4 = null;
                            break block20;
                        }
                        var4_4 = StringsKt.replace$default((String)var4_4, (String)"\"", (String)"", (boolean)false, (int)4, null);
                    }
                    try {
                        var4_4 = Result.constructor-impl((Object)Color.parseColor((String)var4_4));
                    }
                    catch (Throwable v4) {
                        var4_4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)v4));
                    }
                    if (Result.isFailure-impl((Object)var4_4)) {
                        var4_4 = null;
                    }
                    if ((var4_4 = (Integer)var4_4) == null) break block21;
                    var4_5 = var4_4.intValue();
                    var5_6 = var2_2.slrLeftSide.getBackground();
                    if (var5_6 == null) break block22;
                    ((LayerDrawable)var5_6).getDrawable(0).setTint(var4_5);
                }
                var2_2.getRoot().setOnTouchListener((View.OnTouchListener)var3_3.new NotificationTouchListener(var1_1));
                this.showAnimate();
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
        }

        @Override
        public void clear() {
            NotificationsLayout.BaseNotificationView.DefaultImpls.clear(this);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u001c\u0010\u0007\u001a\u00020\u00068\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationCustomViewHolder;", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;)V", "sdk_originalRelease"})
    public final class NotificationCustomViewHolder
    implements NotificationsLayout.BaseNotificationView {
        @NotNull
        private final SlrItemNotificationCustomBinding binding;

        public NotificationCustomViewHolder(SlrItemNotificationCustomBinding slrItemNotificationCustomBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationCustomBinding, (String)"binding");
            this.binding = slrItemNotificationCustomBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationCustomBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
                    Object object = notificationCustomViewHolder.getBinding().getRoot().getContext();
                    NotificationBuilder notificationBuilder = notification.getCustomBuilder();
                    if (notificationBuilder == null) break block7;
                    NotificationViewsProvider notificationViewsProvider = notificationCustomViewHolder.NotificationViewsProvider.this;
                    Object object2 = LayoutInflater.from((Context)object);
                    if (notificationBuilder.getLayoutId() != null) {
                        Integer n = notificationBuilder.getLayoutId();
                        Intrinsics.checkNotNull((Object)n);
                        object = object2.inflate(n.intValue(), (ViewGroup)notificationCustomViewHolder.getBinding().getRoot(), false);
                    } else {
                        object2 = SlrItemNotificationBinding.inflate(object2, (ViewGroup)notificationCustomViewHolder.getBinding().getRoot(), false);
                        object2.slNotifTitleTV.setText((CharSequence)notificationBuilder.getTitle());
                        object2.slNotifDescriptionTV.setText((CharSequence)notificationBuilder.getDescription());
                        Integer n = notificationBuilder.getIconBackgroundColor();
                        if (n != null) {
                            int n2 = n;
                            object2.slNotifIconIV.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)object, (int)n2)));
                        }
                        object = notificationBuilder.getIconUrl();
                        if (object != null) {
                            AppCompatImageView appCompatImageView = object2.slNotifIconIV;
                            Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                            ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)object, false, null, null, 14, null);
                        }
                        object = notificationCustomViewHolder.getBinding().getRoot();
                    }
                    Context context = object;
                    notificationCustomViewHolder.getBinding().getRoot().addView((View)object);
                    context.setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
                    NotificationCustomViewHolder notificationCustomViewHolder = context.getLayoutParams();
                    if (notificationCustomViewHolder == null) break block8;
                    Object object3 = object;
                    notificationCustomViewHolder = (FrameLayout.LayoutParams)notificationCustomViewHolder;
                    v4.gravity = 80;
                    object3.setLayoutParams((ViewGroup.LayoutParams)notificationCustomViewHolder);
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"view");
                    notificationBuilder.bindView((View)object);
                }
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        }

        @Override
        public void clear() {
            NotificationsLayout.BaseNotificationView.DefaultImpls.clear(this);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            nArray[NotificationType.WatchParty.ordinal()] = 1;
            nArray[NotificationType.Prediction.ordinal()] = 2;
            nArray[NotificationType.Custom.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

