/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.messaging;

import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0081\b\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u0012\u0006\u0010\u0013\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0014\u001a\u00020\b\u0012\b\b\u0002\u0010\u0015\u001a\u00020\b\u0012\b\b\u0002\u0010\u0016\u001a\u00020\b\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u0019\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\bJ\u0010KJ\u0013\u0010\u0004\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\t\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0007\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\t\u001a\u00020\bH\u00c6\u0003J\t\u0010\n\u001a\u00020\bH\u00c6\u0003J\t\u0010\u000b\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003Ji\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\b2\b\b\u0002\u0010\u0015\u001a\u00020\b2\b\b\u0002\u0010\u0016\u001a\u00020\b2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0019\u001a\u00020\u00032\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u00c6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001R\u001c\u0010\u0012\u001a\u00020\u00058\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0019\u0010\u0013\u001a\u00020\u00058\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u001e\u001a\u0004\b!\u0010 R\"\u0010\u0014\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0019\u0010\u0015\u001a\u00020\b8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\"\u001a\u0004\b'\u0010$R\u0019\u0010\u0016\u001a\u00020\b8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\"\u001a\u0004\b(\u0010$R\u001b\u0010\u0017\u001a\u0004\u0018\u00010\f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010)\u001a\u0004\b*\u0010+R\u001b\u0010\u0018\u001a\u0004\u0018\u00010\f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010)\u001a\u0004\b,\u0010+R\u0019\u0010\u0019\u001a\u00020\u00038\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010-\u001a\u0004\b\u0019\u0010.R\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u00108\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010/\u001a\u0004\b0\u00101R$\u00102\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u0010\u001e\u001a\u0004\b3\u0010 \"\u0004\b4\u00105R(\u00108\u001a\b\u0012\u0004\u0012\u000207068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R$\u0010?\u001a\u0004\u0018\u00010>8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0013\u0010H\u001a\u00020E8F@\u0006\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u0013\u0010I\u001a\u00020\u00038F@\u0006\u00a2\u0006\u0006\u001a\u0004\bI\u0010.\u00a8\u0006L"}, d2={"Lio/streamlayer/sdk/model/messaging/Topic;", "", "other", "", "equals", "", "component1", "component2", "", "component3", "component4", "component5", "Ljava/util/Date;", "component6", "component7", "component8", "Lio/streamlayer/sdk/model/messaging/Access;", "component9", "chatId", "name", "seq", "readSeq", "recvSeq", "updatedAt", "touchedAt", "isWPTopic", "access", "copy", "toString", "hashCode", "Ljava/lang/String;", "getChatId", "()Ljava/lang/String;", "getName", "I", "getSeq", "()I", "setSeq", "(I)V", "getReadSeq", "getRecvSeq", "Ljava/util/Date;", "getUpdatedAt", "()Ljava/util/Date;", "getTouchedAt", "Z", "()Z", "Lio/streamlayer/sdk/model/messaging/Access;", "getAccess", "()Lio/streamlayer/sdk/model/messaging/Access;", "watchPartyStreamId", "getWatchPartyStreamId", "setWatchPartyStreamId", "(Ljava/lang/String;)V", "", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "participants", "Ljava/util/List;", "getParticipants", "()Ljava/util/List;", "setParticipants", "(Ljava/util/List;)V", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "lastMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "getLastMessage", "()Lio/streamlayer/sdk/model/messaging/ChatMessage;", "setLastMessage", "(Lio/streamlayer/sdk/model/messaging/ChatMessage;)V", "Lio/streamlayer/sdk/model/messaging/ChatType;", "getChatType", "()Lio/streamlayer/sdk/model/messaging/ChatType;", "chatType", "isOwner", "<init>", "(Ljava/lang/String;Ljava/lang/String;IIILjava/util/Date;Ljava/util/Date;ZLio/streamlayer/sdk/model/messaging/Access;)V", "sdk_originalRelease"})
@Entity
public final class Topic {
    @PrimaryKey
    @NotNull
    private final String chatId;
    @NotNull
    private final String name;
    private int seq;
    private final int readSeq;
    private final int recvSeq;
    @Nullable
    private final Date updatedAt;
    @Nullable
    private final Date touchedAt;
    private final boolean isWPTopic;
    @Embedded
    @Nullable
    private final Access access;
    @Nullable
    private String watchPartyStreamId;
    @Ignore
    @NotNull
    private List<TinodeContact> participants;
    @Ignore
    @Nullable
    private ChatMessage lastMessage;

    public Topic(@NotNull String string2, @NotNull String string3, int n, int n2, int n3, @Nullable Date date, @Nullable Date date2, boolean bl, @Nullable Access access) {
        Topic topic2 = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"name");
        this.chatId = string2;
        this.name = string3;
        this.seq = n;
        this.readSeq = n2;
        this.recvSeq = n3;
        this.updatedAt = date;
        this.touchedAt = date2;
        this.isWPTopic = bl;
        topic2.access = access;
        topic2.participants = CollectionsKt.emptyList();
    }

    public /* synthetic */ Topic(String string2, String string3, int n, int n2, int n3, Date date, Date date2, boolean bl, Access access, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x20) != 0) {
            date = null;
        }
        if ((n4 & 0x40) != 0) {
            date2 = null;
        }
        if ((n4 & 0x100) != 0) {
            access = null;
        }
        this(string2, string3, n, n2, n3, date, date2, bl, access);
    }

    public static /* synthetic */ Topic copy$default(Topic topic2, String string2, String string3, int n, int n2, int n3, Date date, Date date2, boolean bl, Access access, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string2 = topic2.chatId;
        }
        if ((n4 & 2) != 0) {
            string3 = topic2.name;
        }
        if ((n4 & 4) != 0) {
            n = topic2.seq;
        }
        if ((n4 & 8) != 0) {
            n2 = topic2.readSeq;
        }
        if ((n4 & 0x10) != 0) {
            n3 = topic2.recvSeq;
        }
        if ((n4 & 0x20) != 0) {
            date = topic2.updatedAt;
        }
        if ((n4 & 0x40) != 0) {
            date2 = topic2.touchedAt;
        }
        if ((n4 & 0x80) != 0) {
            bl = topic2.isWPTopic;
        }
        if ((n4 & 0x100) != 0) {
            access = topic2.access;
        }
        return topic2.copy(string2, string3, n, n2, n3, date, date2, bl, access);
    }

    @NotNull
    public final String getChatId() {
        return this.chatId;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getSeq() {
        return this.seq;
    }

    public final void setSeq(int n) {
        this.seq = n;
    }

    public final int getReadSeq() {
        return this.readSeq;
    }

    public final int getRecvSeq() {
        return this.recvSeq;
    }

    @Nullable
    public final Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public final Date getTouchedAt() {
        return this.touchedAt;
    }

    public final boolean isWPTopic() {
        return this.isWPTopic;
    }

    @Nullable
    public final Access getAccess() {
        return this.access;
    }

    @Nullable
    public final String getWatchPartyStreamId() {
        return this.watchPartyStreamId;
    }

    public final void setWatchPartyStreamId(@Nullable String string2) {
        this.watchPartyStreamId = string2;
    }

    @NotNull
    public final ChatType getChatType() {
        return StringsKt.startsWith$default((String)this.chatId, (String)"usr", (boolean)false, (int)2, null) ? ChatType.P2P : (StringsKt.startsWith$default((String)this.chatId, (String)"grp", (boolean)false, (int)2, null) ? ChatType.Group : ChatType.Unknown);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOwner() {
        Access access = ((Topic)((Object)access)).access;
        if (access == null) {
            return false;
        }
        if (!StringsKt.contains$default((CharSequence)access.getGiven(), (CharSequence)"O", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @NotNull
    public final List<TinodeContact> getParticipants() {
        return this.participants;
    }

    public final void setParticipants(@NotNull List<TinodeContact> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.participants = list;
    }

    @Nullable
    public final ChatMessage getLastMessage() {
        return this.lastMessage;
    }

    public final void setLastMessage(@Nullable ChatMessage chatMessage) {
        this.lastMessage = chatMessage;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        void var3_17;
        void var2_9;
        void var3_13;
        void var2_5;
        if (!(object instanceof Topic)) return false;
        object = (Topic)object;
        if (!Intrinsics.areEqual((Object)this.name, (Object)((Topic)object).name)) return false;
        if (!Intrinsics.areEqual((Object)this.chatId, (Object)((Topic)object).chatId)) return false;
        if (this.seq != ((Topic)object).seq) return false;
        if (this.readSeq != ((Topic)object).readSeq) return false;
        if (this.recvSeq != ((Topic)object).recvSeq) return false;
        ChatMessage chatMessage = this.lastMessage;
        if (chatMessage == null) {
            Object var2_3 = null;
        } else {
            Integer n = chatMessage.getSeqId();
        }
        ChatMessage chatMessage2 = ((Topic)object).lastMessage;
        if (chatMessage2 == null) {
            Object var3_11 = null;
        } else {
            Integer n = chatMessage2.getSeqId();
        }
        if (!Intrinsics.areEqual((Object)var2_5, (Object)var3_13)) return false;
        ChatMessage chatMessage3 = this.lastMessage;
        if (chatMessage3 == null) {
            Object var2_7 = null;
        } else {
            ChatMessageStatus chatMessageStatus = chatMessage3.getStatus();
        }
        ChatMessage chatMessage4 = ((Topic)object).lastMessage;
        if (chatMessage4 == null) {
            Object var3_15 = null;
        } else {
            ChatMessageStatus chatMessageStatus = chatMessage4.getStatus();
        }
        if (var2_9 != var3_17) return false;
        if (!Intrinsics.areEqual(this.participants, ((Topic)object).participants)) return false;
        return true;
    }

    @NotNull
    public final String component1() {
        return this.chatId;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    public final int component3() {
        return this.seq;
    }

    public final int component4() {
        return this.readSeq;
    }

    public final int component5() {
        return this.recvSeq;
    }

    @Nullable
    public final Date component6() {
        return this.updatedAt;
    }

    @Nullable
    public final Date component7() {
        return this.touchedAt;
    }

    public final boolean component8() {
        return this.isWPTopic;
    }

    @Nullable
    public final Access component9() {
        return this.access;
    }

    @NotNull
    public final Topic copy(@NotNull String string2, @NotNull String string3, int n, int n2, int n3, @Nullable Date date, @Nullable Date date2, boolean bl, @Nullable Access access) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"name");
        return new Topic(string2, string3, n, n2, n3, date, date2, bl, access);
    }

    @NotNull
    public String toString() {
        return "Topic(chatId=" + this.chatId + ", name=" + this.name + ", seq=" + this.seq + ", readSeq=" + this.readSeq + ", recvSeq=" + this.recvSeq + ", updatedAt=" + this.updatedAt + ", touchedAt=" + this.touchedAt + ", isWPTopic=" + this.isWPTopic + ", access=" + this.access + ')';
    }

    public int hashCode() {
        Topic topic2 = this;
        int n = ((((topic2.chatId.hashCode() * 31 + this.name.hashCode()) * 31 + Integer.hashCode(this.seq)) * 31 + Integer.hashCode(this.readSeq)) * 31 + Integer.hashCode(this.recvSeq)) * 31;
        Date date = topic2.updatedAt;
        int n2 = date == null ? 0 : date.hashCode();
        n = (n + n2) * 31;
        Date date2 = this.touchedAt;
        int n3 = date2 == null ? 0 : date2.hashCode();
        n = (n + n3) * 31;
        boolean bl = this.isWPTopic;
        n3 = bl ? 1 : 0;
        if (bl) {
            n3 = 1;
        }
        int n4 = (n + n3) * 31;
        Access access = this.access;
        int n5 = access == null ? 0 : access.hashCode();
        return n4 + n5;
    }
}

