/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.messaging;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.collection.ArrayMap;
import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageRelation;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageUpdate;
import io.streamlayer.sdk.model.messaging.ChatOwnerCrossRef;
import io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef;
import io.streamlayer.sdk.model.messaging.ChatRelation;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.messaging.WaveMessage;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.messaging.MessagingDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class MessagingDao_Impl
implements MessagingDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage;
    private final Converters __converters;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage_1;
    private final EntityInsertionAdapter<ChatOwnerCrossRef> __insertionAdapterOfChatOwnerCrossRef;
    private final EntityInsertionAdapter<Topic> __insertionAdapterOfTopic;
    private final EntityInsertionAdapter<ChatParticipantCrossRef> __insertionAdapterOfChatParticipantCrossRef;
    private final EntityInsertionAdapter<WaveMessage> __insertionAdapterOfWaveMessage;
    private final EntityDeletionOrUpdateAdapter<ChatMessage> __deletionAdapterOfChatMessage;
    private final EntityDeletionOrUpdateAdapter<WaveMessage> __deletionAdapterOfWaveMessage;
    private final EntityDeletionOrUpdateAdapter<ChatMessageUpdate> __updateAdapterOfChatMessageUpdateAsChatMessage;
    private final SharedSQLiteStatement __preparedStmtOfUpdateChatMessagedByLocalSeq;
    private final SharedSQLiteStatement __preparedStmtOfUpdateChatMessageSeq;
    private final SharedSQLiteStatement __preparedStmtOfUpdateChatMessageRecvSeq;
    private final SharedSQLiteStatement __preparedStmtOfUpdateChatMessageRecvSeqAndDate;
    private final SharedSQLiteStatement __preparedStmtOfDeleteMessages;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChats;
    private final SharedSQLiteStatement __preparedStmtOfDeleteWaveEvents;

    public MessagingDao_Impl(RoomDatabase roomDatabase) {
        SharedSQLiteStatement sharedSQLiteStatement;
        SharedSQLiteStatement sharedSQLiteStatement2;
        SharedSQLiteStatement sharedSQLiteStatement3;
        SharedSQLiteStatement sharedSQLiteStatement4;
        SharedSQLiteStatement sharedSQLiteStatement5;
        SharedSQLiteStatement sharedSQLiteStatement6;
        SharedSQLiteStatement sharedSQLiteStatement7;
        EntityDeletionOrUpdateAdapter<ChatMessageUpdate> entityDeletionOrUpdateAdapter;
        EntityDeletionOrUpdateAdapter<WaveMessage> entityDeletionOrUpdateAdapter2;
        EntityDeletionOrUpdateAdapter<ChatMessage> entityDeletionOrUpdateAdapter3;
        EntityInsertionAdapter<WaveMessage> entityInsertionAdapter;
        EntityInsertionAdapter<ChatParticipantCrossRef> entityInsertionAdapter2;
        EntityInsertionAdapter<Topic> entityInsertionAdapter3;
        EntityInsertionAdapter<ChatOwnerCrossRef> entityInsertionAdapter4;
        EntityInsertionAdapter<ChatMessage> entityInsertionAdapter5;
        EntityInsertionAdapter<ChatMessage> entityInsertionAdapter6;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter6;
        entityInsertionAdapter6 = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `ChatMessage` (`chatMessageTopicId`,`senderUserId`,`remoteSeqId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`,`uuid`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatMessage.getSenderUserId());
                }
                long l = chatMessage.getSeqId();
                supportSQLiteStatement.bindLong(3, l);
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(4, l3);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, (String)object);
                }
                if (chatMessage.getId() == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, chatMessage.getId());
                }
            }
        };
        this.__insertionAdapterOfChatMessage = converters2;
        converters2 = entityInsertionAdapter5;
        entityInsertionAdapter5 = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatMessage` (`chatMessageTopicId`,`senderUserId`,`remoteSeqId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`,`uuid`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatMessage.getSenderUserId());
                }
                long l = chatMessage.getSeqId();
                supportSQLiteStatement.bindLong(3, l);
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(4, l3);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, (String)object);
                }
                if (chatMessage.getId() == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, chatMessage.getId());
                }
            }
        };
        this.__insertionAdapterOfChatMessage_1 = converters2;
        converters2 = entityInsertionAdapter4;
        entityInsertionAdapter4 = new EntityInsertionAdapter<ChatOwnerCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatOwnerCrossRef` (`chatId`,`chatUserId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatOwnerCrossRef chatOwnerCrossRef) {
                if (chatOwnerCrossRef.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatOwnerCrossRef.getChatId());
                }
                if (chatOwnerCrossRef.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatOwnerCrossRef.getChatUserId());
                }
            }
        };
        this.__insertionAdapterOfChatOwnerCrossRef = converters2;
        converters2 = entityInsertionAdapter3;
        entityInsertionAdapter3 = new EntityInsertionAdapter<Topic>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Topic` (`chatId`,`name`,`seq`,`readSeq`,`recvSeq`,`updatedAt`,`touchedAt`,`isWPTopic`,`watchPartyStreamId`,`want`,`given`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Topic topic2) {
                if (topic2.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, topic2.getChatId());
                }
                if (topic2.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, topic2.getName());
                }
                long l = topic2.getSeq();
                supportSQLiteStatement.bindLong(3, l);
                l = topic2.getReadSeq();
                supportSQLiteStatement.bindLong(4, l);
                l = topic2.getRecvSeq();
                supportSQLiteStatement.bindLong(5, l);
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(topic2.getUpdatedAt());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(6, l3);
                }
                Object object = object.MessagingDao_Impl.this.__converters.dateToString(topic2.getTouchedAt());
                if (object == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    long l4 = (Long)object;
                    supportSQLiteStatement.bindLong(7, l4);
                }
                long l5 = (long)topic2.isWPTopic();
                supportSQLiteStatement.bindLong(8, l5);
                if (topic2.getWatchPartyStreamId() == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, topic2.getWatchPartyStreamId());
                }
                object = topic2.getAccess();
                if (object != null) {
                    if (((Access)object).getWant() == null) {
                        supportSQLiteStatement.bindNull(10);
                    } else {
                        supportSQLiteStatement.bindString(10, ((Access)object).getWant());
                    }
                    if (((Access)object).getGiven() == null) {
                        supportSQLiteStatement.bindNull(11);
                    } else {
                        supportSQLiteStatement.bindString(11, ((Access)object).getGiven());
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(10);
                    supportSQLiteStatement2.bindNull(11);
                }
            }
        };
        this.__insertionAdapterOfTopic = converters2;
        converters2 = entityInsertionAdapter2;
        entityInsertionAdapter2 = new EntityInsertionAdapter<ChatParticipantCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatParticipantCrossRef` (`chatId`,`chatUserId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatParticipantCrossRef chatParticipantCrossRef) {
                if (chatParticipantCrossRef.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatParticipantCrossRef.getChatId());
                }
                if (chatParticipantCrossRef.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatParticipantCrossRef.getChatUserId());
                }
            }
        };
        this.__insertionAdapterOfChatParticipantCrossRef = converters2;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<WaveMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `WaveMessage` (`chatUserId`,`chatId`,`userName`,`userAvatar`,`sentAt`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WaveMessage waveMessage) {
                if (waveMessage.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, waveMessage.getChatUserId());
                }
                if (waveMessage.getChatId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, waveMessage.getChatId());
                }
                if (waveMessage.getUserName() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, waveMessage.getUserName());
                }
                if (waveMessage.getUserAvatar() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, waveMessage.getUserAvatar());
                }
                Long l = l.MessagingDao_Impl.this.__converters.dateToString(waveMessage.getSentAt());
                if (l == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    long l2 = l;
                    supportSQLiteStatement.bindLong(5, l2);
                }
            }
        };
        this.__insertionAdapterOfWaveMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter3;
        entityDeletionOrUpdateAdapter3 = new EntityDeletionOrUpdateAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `ChatMessage` WHERE `chatMessageTopicId` = ? AND `uuid` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                if (chatMessage.getId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatMessage.getId());
                }
            }
        };
        this.__deletionAdapterOfChatMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter2;
        entityDeletionOrUpdateAdapter2 = new EntityDeletionOrUpdateAdapter<WaveMessage>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `WaveMessage` WHERE `chatUserId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WaveMessage waveMessage) {
                if (waveMessage.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, waveMessage.getChatUserId());
                }
            }
        };
        this.__deletionAdapterOfWaveMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter;
        entityDeletionOrUpdateAdapter = new EntityDeletionOrUpdateAdapter<ChatMessageUpdate>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `ChatMessage` SET `chatMessageTopicId` = ?,`uuid` = ?,`status` = ? WHERE `chatMessageTopicId` = ? AND `uuid` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessageUpdate chatMessageUpdate) {
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessageUpdate.getTopicId());
                }
                if (chatMessageUpdate.getId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatMessageUpdate.getId());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessageUpdate.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, chatMessageUpdate.getTopicId());
                }
                if (chatMessageUpdate.getId() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessageUpdate.getId());
                }
            }
        };
        this.__updateAdapterOfChatMessageUpdateAsChatMessage = converters2;
        converters2 = sharedSQLiteStatement7;
        sharedSQLiteStatement7 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE ChatMessage SET remoteSeqId=?, status=? WHERE ChatMessage.chatMessageTopicId=? AND ChatMessage.uuid=?";
            }
        };
        this.__preparedStmtOfUpdateChatMessagedByLocalSeq = converters2;
        converters2 = sharedSQLiteStatement6;
        sharedSQLiteStatement6 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE Topic SET readSeq=?,seq=?,recvSeq=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfUpdateChatMessageSeq = converters2;
        converters2 = sharedSQLiteStatement5;
        sharedSQLiteStatement5 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE Topic SET seq=?,recvSeq=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfUpdateChatMessageRecvSeq = converters2;
        converters2 = sharedSQLiteStatement4;
        sharedSQLiteStatement4 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE Topic SET seq=?,recvSeq=?,updatedAt=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfUpdateChatMessageRecvSeqAndDate = converters2;
        converters2 = sharedSQLiteStatement3;
        sharedSQLiteStatement3 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatMessage WHERE chatMessageTopicId = ? AND status = ?";
            }
        };
        this.__preparedStmtOfDeleteMessages = converters2;
        converters2 = sharedSQLiteStatement2;
        sharedSQLiteStatement2 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Topic";
            }
        };
        this.__preparedStmtOfDeleteChats = converters2;
        converters2 = sharedSQLiteStatement;
        sharedSQLiteStatement = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM WaveMessage WHERE sentAt <= ?";
            }
        };
        this.__preparedStmtOfDeleteWaveEvents = converters2;
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact(ArrayMap<String, TinodeContact> arrayMap) {
        int n;
        int n2;
        int n3;
        block32: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n4 = 0;
                int n5 = arrayMap.size();
                for (int i = 0; i < n5; ++i) {
                    ArrayMap arrayMap3;
                    set.put((String)arrayMap.keyAt(i), null);
                    if (++n4 != 999) continue;
                    messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set);
                    arrayMap.putAll((Map)((Object)set));
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n4 = 0;
                }
                if (n4 > 0) {
                    messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set);
                    arrayMap.putAll((Map)((Object)set));
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatUserId`,`externalId`,`chatName`,`online`,`photoData`,`privateData` FROM `TinodeContact` WHERE `chatUserId` IN (");
            int n6 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n6);
            stringBuilder.append(")");
            RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n6 + 0));
            n3 = 1;
            for (String string2 : set) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n3);
                } else {
                    roomSQLiteQuery.bindString(n3, string2);
                }
                ++n3;
            }
            MessagingDao_Impl messagingDao_Impl = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)messagingDao_Impl, (String)"chatUserId");
            if (n2 != -1) break block32;
            messagingDao_Impl.close();
            return;
        }
        MessagingDao_Impl messagingDao_Impl = messagingDao_Impl;
        MessagingDao_Impl messagingDao_Impl2 = messagingDao_Impl;
        MessagingDao_Impl messagingDao_Impl3 = messagingDao_Impl;
        MessagingDao_Impl messagingDao_Impl4 = messagingDao_Impl;
        MessagingDao_Impl messagingDao_Impl5 = messagingDao_Impl;
        MessagingDao_Impl messagingDao_Impl6 = messagingDao_Impl;
        n3 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"chatUserId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl4, (String)"externalId");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl5, (String)"chatName");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl6, (String)"online");
        int n10 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl2, (String)"photoData");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl3, (String)"privateData");
        }
        catch (Throwable throwable) {
            messagingDao_Impl.close();
            throw throwable;
        }
        while (true) {
            TinodeContact tinodeContact;
            String string3;
            String string4;
            boolean bl;
            String string5;
            String string6;
            String string7;
            Object object;
            block42: {
                block41: {
                    block40: {
                        block39: {
                            block38: {
                                block37: {
                                    block36: {
                                        block35: {
                                            block34: {
                                                block33: {
                                                    if (!messagingDao_Impl.moveToNext()) break;
                                                    ArrayMap<String, TinodeContact> arrayMap4 = arrayMap;
                                                    object = messagingDao_Impl.getString(n2);
                                                    if (!arrayMap4.containsKey(object)) continue;
                                                    if (!messagingDao_Impl.isNull(n3)) break block33;
                                                    string7 = null;
                                                    break block34;
                                                }
                                                string7 = messagingDao_Impl.getString(n3);
                                            }
                                            if (!messagingDao_Impl.isNull(n7)) break block35;
                                            string6 = null;
                                            break block36;
                                        }
                                        string6 = messagingDao_Impl.getString(n7);
                                    }
                                    if (!messagingDao_Impl.isNull(n8)) break block37;
                                    string5 = null;
                                    break block38;
                                }
                                string5 = messagingDao_Impl.getString(n8);
                            }
                            bl = messagingDao_Impl.getInt(n9) != 0;
                            if (!messagingDao_Impl.isNull(n10)) break block39;
                            string4 = null;
                            break block40;
                        }
                        string4 = messagingDao_Impl.getString(n10);
                    }
                    if (!messagingDao_Impl.isNull(n)) break block41;
                    string3 = null;
                    break block42;
                }
                string3 = messagingDao_Impl.getString(n);
            }
            ArrayMap<String, TinodeContact> arrayMap5 = arrayMap;
            String string8 = object;
            object = tinodeContact;
            tinodeContact = new TinodeContact(string7, string6, string5, bl, string4, string3);
            arrayMap5.put((Object)string8, object);
        }
        messagingDao_Impl.close();
        return;
    }

    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1(ArrayMap<String, ArrayList<TinodeContact>> arrayMap) {
        int n;
        Set set = arrayMap.keySet();
        if (set.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n2 = 0;
            int n3 = arrayMap.size();
            for (int i = 0; i < n3; ++i) {
                ArrayMap arrayMap3;
                String string2 = (String)arrayMap.keyAt(i);
                set.put(string2, (ArrayList)arrayMap.valueAt(i));
                if (++n2 != 999) continue;
                messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set);
                set = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n2 = 0;
            }
            if (n2 > 0) {
                messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,_junction.`chatId` FROM `ChatParticipantCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        int n4 = set.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
        int n5 = 1;
        for (String string3 : set) {
            if (string3 == null) {
                roomSQLiteQuery.bindNull(n5);
            } else {
                roomSQLiteQuery.bindString(n5, string3);
            }
            ++n5;
        }
        MessagingDao_Impl messagingDao_Impl = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"chatUserId");
        n5 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"externalId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"chatName");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"online");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"photoData");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)messagingDao_Impl, (String)"privateData");
        }
        catch (Throwable throwable) {
            messagingDao_Impl.close();
            throw throwable;
        }
        while (true) {
            String string4;
            String string5;
            boolean bl;
            String string6;
            String string7;
            String string8;
            ArrayList arrayList;
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        block31: {
                                            block30: {
                                                block29: {
                                                    if (!messagingDao_Impl.moveToNext()) break;
                                                    arrayList = (ArrayList)arrayMap.get((Object)messagingDao_Impl.getString(6));
                                                    if (arrayList == null) continue;
                                                    if (!messagingDao_Impl.isNull(n6)) break block29;
                                                    string8 = null;
                                                    break block30;
                                                }
                                                string8 = messagingDao_Impl.getString(n6);
                                            }
                                            if (!messagingDao_Impl.isNull(n5)) break block31;
                                            string7 = null;
                                            break block32;
                                        }
                                        string7 = messagingDao_Impl.getString(n5);
                                    }
                                    if (!messagingDao_Impl.isNull(n7)) break block33;
                                    string6 = null;
                                    break block34;
                                }
                                string6 = messagingDao_Impl.getString(n7);
                            }
                            bl = messagingDao_Impl.getInt(n8) != 0;
                            if (!messagingDao_Impl.isNull(n9)) break block35;
                            string5 = null;
                            break block36;
                        }
                        string5 = messagingDao_Impl.getString(n9);
                    }
                    if (!messagingDao_Impl.isNull(n)) break block37;
                    string4 = null;
                    break block38;
                }
                string4 = messagingDao_Impl.getString(n);
            }
            arrayList.add(new TinodeContact(string8, string7, string6, bl, string5, string4));
        }
        messagingDao_Impl.close();
        return;
    }

    private void __fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage(ArrayMap<String, ArrayList<ChatMessage>> arrayMap) {
        int n;
        int n2;
        RoomSQLiteQuery roomSQLiteQuery;
        block45: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n3 = 0;
                int n4 = arrayMap.size();
                for (int i = 0; i < n4; ++i) {
                    ArrayMap arrayMap3;
                    String string2 = (String)arrayMap.keyAt(i);
                    set.put(string2, (ArrayList)arrayMap.valueAt(i));
                    if (++n3 != 999) continue;
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatMessageTopicId`,`senderUserId`,`remoteSeqId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`,`uuid` FROM `ChatMessage` WHERE `chatMessageTopicId` IN (");
            int n5 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
            n2 = 1;
            for (String string3 : set) {
                if (string3 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string3);
                }
                ++n2;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatMessageTopicId");
            if (n2 != -1) break block45;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery7 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery8 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery9 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery10 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery11 = roomSQLiteQuery2;
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery2, (String)"chatMessageTopicId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery9, (String)"senderUserId");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery10, (String)"remoteSeqId");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery11, (String)"date");
        int n10 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery7, (String)"text");
        int n11 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery8, (String)"type");
        int n12 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery5, (String)"subtype");
        int n13 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery6, (String)"replyTo");
        int n14 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery3, (String)"status");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery4, (String)"uuid");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            ChatMessage chatMessage;
            String string4;
            ArrayList arrayList;
            block63: {
                block62: {
                    ChatMessage chatMessage2;
                    Object object;
                    String string5;
                    String string6;
                    String string7;
                    String string8;
                    Comparable<Long> comparable;
                    int n15;
                    String string9;
                    block61: {
                        block60: {
                            block59: {
                                block58: {
                                    block57: {
                                        block56: {
                                            block55: {
                                                block54: {
                                                    block53: {
                                                        block52: {
                                                            block51: {
                                                                block50: {
                                                                    block49: {
                                                                        block48: {
                                                                            block47: {
                                                                                block46: {
                                                                                    if (!roomSQLiteQuery.moveToNext()) break;
                                                                                    arrayList = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(n2));
                                                                                    if (arrayList == null) continue;
                                                                                    if (!roomSQLiteQuery.isNull(n6)) break block46;
                                                                                    string4 = null;
                                                                                    break block47;
                                                                                }
                                                                                string4 = roomSQLiteQuery.getString(n6);
                                                                            }
                                                                            if (!roomSQLiteQuery.isNull(n7)) break block48;
                                                                            string9 = null;
                                                                            break block49;
                                                                        }
                                                                        string9 = roomSQLiteQuery.getString(n7);
                                                                    }
                                                                    RoomSQLiteQuery roomSQLiteQuery12 = roomSQLiteQuery;
                                                                    int n16 = n9;
                                                                    n15 = roomSQLiteQuery.getInt(n8);
                                                                    if (!roomSQLiteQuery12.isNull(n16)) break block50;
                                                                    comparable = null;
                                                                    break block51;
                                                                }
                                                                comparable = roomSQLiteQuery.getLong(n9);
                                                            }
                                                            RoomSQLiteQuery roomSQLiteQuery13 = roomSQLiteQuery;
                                                            int n17 = n10;
                                                            comparable = this.__converters.timestampToDate((Long)comparable);
                                                            if (!roomSQLiteQuery13.isNull(n17)) break block52;
                                                            string8 = null;
                                                            break block53;
                                                        }
                                                        string8 = roomSQLiteQuery.getString(n10);
                                                    }
                                                    if (!roomSQLiteQuery.isNull(n11)) break block54;
                                                    string7 = null;
                                                    break block55;
                                                }
                                                string7 = roomSQLiteQuery.getString(n11);
                                            }
                                            if (!roomSQLiteQuery.isNull(n12)) break block56;
                                            string6 = null;
                                            break block57;
                                        }
                                        string6 = roomSQLiteQuery.getString(n12);
                                    }
                                    if (!roomSQLiteQuery.isNull(n13)) break block58;
                                    string5 = null;
                                    break block59;
                                }
                                string5 = roomSQLiteQuery.getString(n13);
                            }
                            if (!roomSQLiteQuery.isNull(n14)) break block60;
                            object = null;
                            break block61;
                        }
                        object = roomSQLiteQuery.getString(n14);
                    }
                    RoomSQLiteQuery roomSQLiteQuery14 = roomSQLiteQuery;
                    int n18 = n;
                    object = this.__converters.stringToChatStatus((String)object);
                    chatMessage = chatMessage2;
                    chatMessage2 = new ChatMessage(string4, string9, n15, (Date)comparable, string8, string7, string6, string5, (ChatMessageStatus)((Object)object));
                    if (!roomSQLiteQuery14.isNull(n18)) break block62;
                    string4 = null;
                    break block63;
                }
                string4 = roomSQLiteQuery.getString(n);
            }
            ChatMessage chatMessage3 = chatMessage;
            chatMessage3.setId(string4);
            arrayList.add(chatMessage3);
        }
        roomSQLiteQuery.close();
        return;
    }

    static /* synthetic */ void access$1100(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)arrayMap);
    }

    static /* synthetic */ void access$1200(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)arrayMap);
    }

    @Override
    public long saveChatMessage(ChatMessage chatMessage) {
        long l;
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            l = messagingDao_Impl.__insertionAdapterOfChatMessage.insertAndReturnId((Object)chatMessage);
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.setTransactionSuccessful();
            messagingDao_Impl2.__db.endTransaction();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        return l;
    }

    @Override
    public void saveChatMessages(List<ChatMessage> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatMessage_1.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatOwner(ChatOwnerCrossRef chatOwnerCrossRef) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatOwnerCrossRef.insert((Object)chatOwnerCrossRef);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveChats(List<Topic> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfTopic.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public Object saveTopic(final Topic topic2, Continuation<? super Long> continuation) {
        Callable<Long> callable;
        Callable<Long> callable2 = callable;
        callable = new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                Long l;
                17 v0 = this;
                v0.MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    long l2 = v0.MessagingDao_Impl.this.__insertionAdapterOfTopic.insertAndReturnId((Object)topic2);
                    MessagingDao_Impl.this.__db.setTransactionSuccessful();
                    l = l2;
                }
                catch (Throwable throwable) {
                    MessagingDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.endTransaction();
                return l;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public void saveChatParticipantCrossRefs(List<ChatParticipantCrossRef> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatParticipantCrossRef.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public Object saveWaveMessage(final WaveMessage waveMessage, Continuation<? super Long> continuation) {
        Callable<Long> callable;
        Callable<Long> callable2 = callable;
        callable = new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                Long l;
                18 v0 = this;
                v0.MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    long l2 = v0.MessagingDao_Impl.this.__insertionAdapterOfWaveMessage.insertAndReturnId((Object)waveMessage);
                    MessagingDao_Impl.this.__db.setTransactionSuccessful();
                    l = l2;
                }
                catch (Throwable throwable) {
                    MessagingDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.endTransaction();
                return l;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public void deleteChatMessage(ChatMessage chatMessage) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__deletionAdapterOfChatMessage.handle((Object)chatMessage);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public Object deleteWaveMessage(final WaveMessage waveMessage, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                19 v0 = this;
                v0.MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    v0.MessagingDao_Impl.this.__deletionAdapterOfWaveMessage.handle((Object)waveMessage);
                }
                catch (Throwable throwable) {
                    MessagingDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                v0.MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                MessagingDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public void updateChatMessage(ChatMessageUpdate chatMessageUpdate) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__updateAdapterOfChatMessageUpdateAsChatMessage.handle((Object)chatMessageUpdate);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChats(List<Topic> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__db.beginTransaction();
        try {
            MessagingDao.DefaultImpls.saveChats(messagingDao_Impl, list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatParticipants(String string2, List<TinodeContact> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__db.beginTransaction();
        try {
            MessagingDao.DefaultImpls.saveChatParticipants(messagingDao_Impl, string2, list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public Object updateChatMessagedByLocalSeq(final String string2, final String string3, final int n, final ChatMessageStatus chatMessageStatus, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                20 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessagedByLocalSeq.acquire();
                long l = n;
                supportSQLiteStatement.bindLong(1, l);
                int n2 = 2;
                String string22 = v0.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessageStatus);
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                n2 = 3;
                string22 = string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                n2 = 4;
                string22 = string3;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    20 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessagedByLocalSeq.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                20 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessagedByLocalSeq.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object updateChatMessageSeq(final String string2, final int n, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                21 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageSeq.acquire();
                long l = n;
                supportSQLiteStatement.bindLong(1, l);
                l = n;
                supportSQLiteStatement.bindLong(2, l);
                l = n;
                supportSQLiteStatement.bindLong(3, l);
                int n2 = 4;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    21 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageSeq.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                21 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageSeq.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object updateChatMessageRecvSeq(final String string2, final int n, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                22 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeq.acquire();
                long l = n;
                supportSQLiteStatement.bindLong(1, l);
                l = n;
                supportSQLiteStatement.bindLong(2, l);
                int n2 = 3;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    22 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeq.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                22 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeq.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object updateChatMessageRecvSeqAndDate(final String string2, final int n, final Date date, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                23 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeqAndDate.acquire();
                long l = n;
                supportSQLiteStatement.bindLong(1, l);
                l = n;
                supportSQLiteStatement.bindLong(2, l);
                int n2 = 3;
                Object object = v0.MessagingDao_Impl.this.__converters.dateToString(date);
                if (object == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindLong(n2, ((Long)object).longValue());
                }
                n2 = 4;
                object = string2;
                if (object == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, (String)object);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    23 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeqAndDate.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                23 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeqAndDate.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public void deleteMessages(String string2, ChatMessageStatus object) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteMessages.acquire();
        int n = 1;
        if (string2 == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, string2);
        }
        int n2 = 2;
        object = this.__converters.chatStatusToString((ChatMessageStatus)((Object)object));
        if (object == null) {
            supportSQLiteStatement.bindNull(n2);
        } else {
            supportSQLiteStatement.bindString(n2, (String)object);
        }
        MessagingDao_Impl messagingDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl3 = this;
            messagingDao_Impl3.__db.endTransaction();
            messagingDao_Impl3.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl2.__db.setTransactionSuccessful();
        messagingDao_Impl2.__db.endTransaction();
        messagingDao_Impl2.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
    }

    @Override
    public void deleteChats() {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteChats.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.endTransaction();
            messagingDao_Impl2.__preparedStmtOfDeleteChats.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
        messagingDao_Impl.__preparedStmtOfDeleteChats.release(supportSQLiteStatement);
    }

    @Override
    public Object deleteWaveEvents(final Date date, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                24 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfDeleteWaveEvents.acquire();
                int n = 1;
                Long l = v0.MessagingDao_Impl.this.__converters.dateToString(date);
                if (l == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindLong(n, l.longValue());
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    24 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfDeleteWaveEvents.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                24 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfDeleteWaveEvents.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasRemoteSeq(String string2, String string3, String string4) {
        void var1_6;
        MessagingDao_Impl messagingDao_Impl2;
        RoomSQLiteQuery roomSQLiteQuery;
        block10: {
            block9: {
                void var2_7;
                void var3_8;
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT EXISTS(SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId=? AND ChatMessage.uuid=? AND ChatMessage.senderUserId=?)", (int)3);
                int n = 1;
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n);
                } else {
                    roomSQLiteQuery.bindString(n, string2);
                }
                int bl = 2;
                if (var3_8 == null) {
                    roomSQLiteQuery.bindNull(bl);
                } else {
                    roomSQLiteQuery.bindString(bl, (String)var3_8);
                }
                int n2 = 3;
                if (var2_7 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, (String)var2_7);
                }
                MessagingDao_Impl messagingDao_Impl = messagingDao_Impl2;
                messagingDao_Impl.__db.assertNotSuspendingTransaction();
                messagingDao_Impl2 = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    if (!messagingDao_Impl2.moveToFirst()) break block9;
                }
                catch (Throwable throwable) {
                    messagingDao_Impl2.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                if (messagingDao_Impl2.getInt(0) == 0) break block9;
                boolean bl2 = true;
                break block10;
            }
            boolean bl = false;
        }
        messagingDao_Impl2.close();
        roomSQLiteQuery.release();
        return (boolean)var1_6;
    }

    @Override
    public boolean hasLocalSeq(String string2, int n) {
        boolean bl;
        Cursor cursor;
        RoomSQLiteQuery roomSQLiteQuery;
        block6: {
            block5: {
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT EXISTS(SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId=? AND ChatMessage.remoteSeqId=?)", (int)2);
                int n2 = 1;
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                MessagingDao_Impl messagingDao_Impl = this;
                long l = n;
                roomSQLiteQuery.bindLong(2, l);
                messagingDao_Impl.__db.assertNotSuspendingTransaction();
                cursor = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    if (!cursor.moveToFirst()) break block5;
                }
                catch (Throwable throwable) {
                    cursor.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                if (cursor.getInt(0) == 0) break block5;
                bl = true;
                break block6;
            }
            bl = false;
        }
        cursor.close();
        roomSQLiteQuery.release();
        return bl;
    }

    @Override
    public Integer getLastRemoteSeqId(String object) {
        RoomSQLiteQuery roomSQLiteQuery;
        block7: {
            block6: {
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT ChatMessage.remoteSeqId FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? ORDER BY ChatMessage.remoteSeqId DESC LIMIT 1", (int)1);
                int n = 1;
                if (object == null) {
                    roomSQLiteQuery.bindNull(n);
                } else {
                    roomSQLiteQuery.bindString(n, (String)object);
                }
                MessagingDao_Impl messagingDao_Impl = messagingDao_Impl2;
                messagingDao_Impl.__db.assertNotSuspendingTransaction();
                MessagingDao_Impl messagingDao_Impl2 = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    if (!messagingDao_Impl2.moveToFirst()) break block6;
                }
                catch (Throwable throwable) {
                    messagingDao_Impl2.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                if (messagingDao_Impl2.isNull(0)) break block6;
                object = messagingDao_Impl2.getInt(0);
                break block7;
            }
            object = null;
        }
        messagingDao_Impl2.close();
        roomSQLiteQuery.release();
        return object;
    }

    @Override
    public PagingSource<Integer, ChatMessageRelation> getChatMessagesRelationSource(String string2, List<? extends ChatMessageStatus> object) {
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ");
        stringBuilder.append("?");
        stringBuilder.append(" AND status IN(");
        int n = object.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n);
        stringBuilder.append(") ORDER BY ChatMessage.remoteSeqId DESC");
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n + 1));
        int n2 = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, string2);
        }
        int n3 = 2;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (ChatMessageStatus)((Object)object.next());
            if ((object2 = this.__converters.chatStatusToString((ChatMessageStatus)((Object)object2))) == null) {
                roomSQLiteQuery.bindNull(n3);
            } else {
                roomSQLiteQuery.bindString(n3, (String)object2);
            }
            ++n3;
        }
        return (PagingSource)new DataSource.Factory<Integer, ChatMessageRelation>(){

            public LimitOffsetDataSource<ChatMessageRelation> create() {
                25 v0 = this_;
                25 this_ = v0.MessagingDao_Impl.this.__db;
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                stringArray[0] = "TinodeContact";
                stringArray[1] = "ChatMessage";
                return new LimitOffsetDataSource<ChatMessageRelation>((RoomDatabase)this_, v0.roomSQLiteQuery, true, false, stringArray2){

                    protected List<ChatMessageRelation> convertRows(Cursor cursor) {
                        ArrayList<ChatMessageRelation> arrayList;
                        ArrayMap arrayMap;
                        Cursor cursor2 = cursor;
                        int n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"chatMessageTopicId");
                        int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"senderUserId");
                        int n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"remoteSeqId");
                        int n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"date");
                        int n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"text");
                        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"type");
                        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"subtype");
                        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"replyTo");
                        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"status");
                        int n10 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"uuid");
                        ArrayMap arrayMap2 = arrayMap;
                        arrayMap = new ArrayMap();
                        while (cursor.moveToNext()) {
                            arrayMap2.put((Object)cursor.getString(n2), null);
                        }
                        cursor.moveToPosition(-1);
                        MessagingDao_Impl.this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)arrayMap2);
                        ArrayList<ChatMessageRelation> arrayList2 = arrayList;
                        arrayList = new ArrayList<ChatMessageRelation>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Object object;
                            Object object2;
                            if (cursor.isNull(n) && cursor.isNull(n2) && cursor.isNull(n3) && cursor.isNull(n4) && cursor.isNull(n5) && cursor.isNull(n6) && cursor.isNull(n7) && cursor.isNull(n8) && cursor.isNull(n9) && cursor.isNull(n10)) {
                                object2 = null;
                            } else {
                                ChatMessage chatMessage;
                                object2 = cursor.isNull(n) ? null : cursor.getString(n);
                                object = cursor.isNull(n2) ? null : cursor.getString(n2);
                                int n11 = cursor.getInt(n3);
                                Comparable<Long> comparable = cursor.isNull(n4) ? null : Long.valueOf(cursor.getLong(n4));
                                comparable = MessagingDao_Impl.this.__converters.timestampToDate((Long)comparable);
                                String string2 = cursor.isNull(n5) ? null : cursor.getString(n5);
                                String string3 = cursor.isNull(n6) ? null : cursor.getString(n6);
                                String string4 = cursor.isNull(n7) ? null : cursor.getString(n7);
                                String string5 = cursor.isNull(n8) ? null : cursor.getString(n8);
                                Object object3 = cursor.isNull(n9) ? null : cursor.getString(n9);
                                object3 = MessagingDao_Impl.this.__converters.stringToChatStatus((String)object3);
                                ChatMessage chatMessage2 = chatMessage;
                                chatMessage = new ChatMessage((String)object2, (String)object, n11, (Date)comparable, string2, string3, string4, string5, (ChatMessageStatus)((Object)object3));
                                object2 = cursor.isNull(n10) ? null : cursor.getString(n10);
                                chatMessage2.setId((String)object2);
                                object2 = chatMessage2;
                            }
                            object = (TinodeContact)arrayMap2.get((Object)cursor.getString(n2));
                            arrayList2.add(new ChatMessageRelation((ChatMessage)object2, (TinodeContact)object));
                        }
                        return arrayList2;
                    }
                };
            }
        }.asPagingSourceFactory().invoke();
    }

    @Override
    public Flow<List<ChatRelation>> getChatsRelation() {
        Callable<List<ChatRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE chatId LIKE 'grp%' AND isWPTopic = 0 ORDER BY Topic.updatedAt DESC", (int)0);
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = "ChatParticipantCrossRef";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "ChatMessage";
        stringArray[3] = "Topic";
        Callable<List<ChatRelation>> callable2 = callable;
        callable = new Callable<List<ChatRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<ChatRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                var4_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                var5_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                var6_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                var7_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                var8_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                var9_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"isWPTopic");
                var10_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                var11_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                var12_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                var13_14 = v1;
                v1 = new ArrayMap();
                var14_15 = v2;
                v2 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block76: {
                        v3 = var13_14;
                        var15_16 = var1_1.getString(var2_2);
                        if ((ArrayList)v3.get(var15_16) != null) break block76;
                        v4 = var13_14;
                        v5 = var15_16;
                        var15_16 = v6;
                        v6 = new ArrayList<E>();
                        v4.put((Object)v5, var15_16);
                    }
                    v7 = var14_15;
                    var15_16 = var1_1.getString(var2_2);
                    if ((ArrayList)v7.get(var15_16) != null) continue;
                    v8 = var14_15;
                    v9 = var15_16;
                    var15_16 = v10;
                    v10 = new ArrayList<E>();
                    v8.put(v9, var15_16);
                    continue;
                }
lbl63:
                // 2 sources

                v11 = this;
                v12 = v11;
                v13 = v11;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$1100(v12.MessagingDao_Impl.this, var13_14);
                MessagingDao_Impl.access$1200(v13.MessagingDao_Impl.this, var14_15);
                var15_16 = v14;
                v14 = new ArrayList<E>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block78: {
                        block94: {
                            block93: {
                                block88: {
                                    block92: {
                                        block91: {
                                            block90: {
                                                block89: {
                                                    block87: {
                                                        block86: {
                                                            block85: {
                                                                block84: {
                                                                    block83: {
                                                                        block82: {
                                                                            block81: {
                                                                                block80: {
                                                                                    block79: {
                                                                                        block77: {
                                                                                            if (!var1_1.isNull(var2_2)) break block77;
                                                                                            if (!var1_1.isNull(var3_4)) break block77;
                                                                                            if (!var1_1.isNull(var4_5)) break block77;
                                                                                            if (!var1_1.isNull(var5_6)) break block77;
                                                                                            if (!var1_1.isNull(var6_7)) break block77;
                                                                                            if (!var1_1.isNull(var7_8)) break block77;
                                                                                            if (!var1_1.isNull(var8_9)) break block77;
                                                                                            if (!var1_1.isNull(var9_10)) break block77;
                                                                                            if (!var1_1.isNull(var10_11)) break block77;
                                                                                            if (!var1_1.isNull(var11_12)) break block77;
                                                                                            if (!var1_1.isNull(var12_13)) break block77;
                                                                                            var16_17 = null;
                                                                                            break block78;
                                                                                        }
                                                                                        if (!var1_1.isNull(var2_2)) break block79;
                                                                                        var16_17 = null;
                                                                                        break block80;
                                                                                    }
                                                                                    var16_17 = var1_1.getString(var2_2);
                                                                                }
                                                                                if (!var1_1.isNull(var3_4)) break block81;
                                                                                var17_18 = null;
                                                                                break block82;
                                                                            }
                                                                            var17_18 = var1_1.getString(var3_4);
                                                                        }
                                                                        v15 = var1_1;
                                                                        v16 = var7_8;
                                                                        v17 = var1_1;
                                                                        v18 = var6_7;
                                                                        v19 = var1_1;
                                                                        v20 = var5_6;
                                                                        var18_20 = var1_1.getInt(var4_5);
                                                                        var19_22 = v19.getInt(v20);
                                                                        var20_23 = v17.getInt(v18);
                                                                        if (!v15.isNull(v16)) break block83;
                                                                        var21_24 /* !! */  = null;
                                                                        break block84;
                                                                    }
                                                                    var21_24 /* !! */  = var1_1.getLong(var7_8);
                                                                }
                                                                v21 = var1_1;
                                                                v22 = var8_9;
                                                                var21_24 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var21_24 /* !! */ );
                                                                if (!v21.isNull(v22)) break block85;
                                                                var22_25 /* !! */  = null;
                                                                break block86;
                                                            }
                                                            var22_25 /* !! */  = var1_1.getLong(var8_9);
                                                        }
                                                        v23 = var1_1;
                                                        v24 = var9_10;
                                                        var22_25 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var22_25 /* !! */ );
                                                        var23_26 = v23.getInt(v24) != 0;
                                                        if (!var1_1.isNull(var11_12)) break block87;
                                                        if (!var1_1.isNull(var12_13)) break block87;
                                                        var24_27 = null;
                                                        break block88;
                                                    }
                                                    if (!var1_1.isNull(var11_12)) break block89;
                                                    var24_27 = null;
                                                    break block90;
                                                }
                                                var24_27 = var1_1.getString(var11_12);
                                            }
                                            if (!var1_1.isNull(var12_13)) break block91;
                                            var25_28 = null;
                                            break block92;
                                        }
                                        var25_28 = var1_1.getString(var12_13);
                                    }
                                    var26_29 = v25;
                                    v25 = new Access((String)var24_27, (String)var25_28);
                                    var24_27 = var26_29;
                                }
                                v26 = var1_1;
                                v27 = var10_11;
                                var25_28 = v28;
                                v28 = new Topic((String)var16_17, (String)var17_18, var18_20, var19_22, var20_23, (Date)var21_24 /* !! */ , (Date)var22_25 /* !! */ , var23_26, (Access)var24_27);
                                if (!v26.isNull(v27)) break block93;
                                var16_17 = null;
                                break block94;
                            }
                            var16_17 = var1_1.getString(var10_11);
                        }
                        var25_28.setWatchPartyStreamId((String)var16_17);
                        var16_17 = var25_28;
                    }
                    var17_18 = (ArrayList)var13_14.get((Object)var1_1.getString(var2_2));
                    if (var17_18 != null) ** GOTO lbl205
                    var17_18 = v29;
                    v29 = new ArrayList<E>();
lbl205:
                    // 2 sources

                    if ((var18_19 = (ArrayList)var14_15.get((Object)var1_1.getString(var2_2))) != null) ** GOTO lbl209
                    var18_19 = v30;
                    v30 = new ArrayList<E>();
lbl209:
                    // 2 sources

                    v31 = var15_16;
                    var19_21 = v32;
                    v32 = new ChatRelation((Topic)var16_17, (List<TinodeContact>)var17_18, var18_19);
                    v31.add(var19_21);
                    continue;
                }
lbl217:
                // 2 sources

                v33 = var15_16;
                v34 = this;
                v35 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v35.close();
                {
                    catch (Throwable v36) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v36;
                    }
                }
                MessagingDao_Impl.access$100(v34.MessagingDao_Impl.this).endTransaction();
                return v33;
                catch (Throwable var2_3) {
                    var1_1.close();
                    throw var2_3;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<ChatRelation> getChatRelation(String stringArray) {
        Callable<ChatRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[4];
        stringArray = stringArray2;
        stringArray2[0] = "ChatParticipantCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "ChatMessage";
        stringArray2[3] = "Topic";
        Callable<ChatRelation> callable2 = callable;
        callable = new Callable<ChatRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public ChatRelation call() throws Exception {
                block95: {
                    block75: {
                        block94: {
                            block77: {
                                block93: {
                                    block92: {
                                        block87: {
                                            block91: {
                                                block90: {
                                                    block89: {
                                                        block88: {
                                                            block86: {
                                                                block85: {
                                                                    block84: {
                                                                        block83: {
                                                                            block82: {
                                                                                block81: {
                                                                                    block80: {
                                                                                        block79: {
                                                                                            block78: {
                                                                                                block76: {
                                                                                                    v0 = this;
                                                                                                    MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                                                                                                    var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                                                    var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                                                    var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                                                    var4_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                                                    var5_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                                                    var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                                                    var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                                                    var8_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                                                    var9_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"isWPTopic");
                                                                                                    var10_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                                                    var11_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                                                    var12_20 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                                                    var13_23 = v1;
                                                                                                    v1 = new ArrayMap();
                                                                                                    var14_24 = v2;
                                                                                                    v2 = new ArrayMap();
                                                                                                    ** while (var1_1.moveToNext())
lbl-1000:
                                                                                                    // 1 sources

                                                                                                    {
                                                                                                        block74: {
                                                                                                            v3 = var13_23;
                                                                                                            var15_25 = var1_1.getString(var2_2);
                                                                                                            if ((ArrayList)v3.get(var15_25) != null) break block74;
                                                                                                            v4 = var13_23;
                                                                                                            v5 = var15_25;
                                                                                                            var15_25 = v6;
                                                                                                            v6 = new ArrayList<E>();
                                                                                                            v4.put((Object)v5, var15_25);
                                                                                                        }
                                                                                                        v7 = var14_24;
                                                                                                        var15_25 = var1_1.getString(var2_2);
                                                                                                        if ((ArrayList)v7.get(var15_25) != null) continue;
                                                                                                        v8 = var14_24;
                                                                                                        v9 = var15_25;
                                                                                                        var15_25 = v10;
                                                                                                        v10 = new ArrayList<E>();
                                                                                                        v8.put(v9, var15_25);
                                                                                                        continue;
                                                                                                    }
lbl63:
                                                                                                    // 2 sources

                                                                                                    v11 = var1_1;
                                                                                                    v12 = this;
                                                                                                    v13 = v12;
                                                                                                    v14 = v12;
                                                                                                    var1_1.moveToPosition(-1);
                                                                                                    MessagingDao_Impl.access$1100(v13.MessagingDao_Impl.this, var13_23);
                                                                                                    MessagingDao_Impl.access$1200(v14.MessagingDao_Impl.this, var14_24);
                                                                                                    if (!v11.moveToFirst()) break block75;
                                                                                                    if (!var1_1.isNull(var2_2)) break block76;
                                                                                                    if (!var1_1.isNull(var3_5)) break block76;
                                                                                                    if (!var1_1.isNull(var4_7)) break block76;
                                                                                                    if (!var1_1.isNull(var5_9)) break block76;
                                                                                                    if (!var1_1.isNull(var6_11)) break block76;
                                                                                                    if (!var1_1.isNull(var7_12)) break block76;
                                                                                                    if (!var1_1.isNull(var8_14)) break block76;
                                                                                                    if (!var1_1.isNull((int)var9_16)) break block76;
                                                                                                    if (!var1_1.isNull(var10_17)) break block76;
                                                                                                    if (!var1_1.isNull(var11_18)) break block76;
                                                                                                    if (!var1_1.isNull(var12_20)) break block76;
                                                                                                    var3_6 = null;
                                                                                                    break block77;
                                                                                                }
                                                                                                if (!var1_1.isNull(var2_2)) break block78;
                                                                                                var15_25 = null;
                                                                                                break block79;
                                                                                            }
                                                                                            var15_25 = var1_1.getString(var2_2);
                                                                                        }
                                                                                        if (!var1_1.isNull(var3_5)) break block80;
                                                                                        var3_6 = null;
                                                                                        break block81;
                                                                                    }
                                                                                    var3_6 = var1_1.getString(var3_5);
                                                                                }
                                                                                v15 = var1_1;
                                                                                v16 = var7_12;
                                                                                v17 = var1_1;
                                                                                v18 = var6_11;
                                                                                v19 = var1_1;
                                                                                v20 = var5_9;
                                                                                var4_7 = var1_1.getInt(var4_7);
                                                                                var5_9 = v19.getInt(v20);
                                                                                var6_11 = v17.getInt(v18);
                                                                                if (!v15.isNull(v16)) break block82;
                                                                                var7_13 /* !! */  = null;
                                                                                break block83;
                                                                            }
                                                                            var7_13 /* !! */  = var1_1.getLong(var7_12);
                                                                        }
                                                                        v21 = var1_1;
                                                                        v22 = var8_14;
                                                                        var7_13 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var7_13 /* !! */ );
                                                                        if (!v21.isNull(v22)) break block84;
                                                                        var8_15 /* !! */  = null;
                                                                        break block85;
                                                                    }
                                                                    var8_15 /* !! */  = var1_1.getLong(var8_14);
                                                                }
                                                                v23 = var1_1;
                                                                v24 = var9_16;
                                                                var8_15 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var8_15 /* !! */ );
                                                                var9_16 = v23.getInt((int)v24) != 0;
                                                                if (!var1_1.isNull(var11_18)) break block86;
                                                                if (!var1_1.isNull(var12_20)) break block86;
                                                                var11_19 = null;
                                                                break block87;
                                                            }
                                                            if (!var1_1.isNull(var11_18)) break block88;
                                                            var11_19 = null;
                                                            break block89;
                                                        }
                                                        var11_19 = var1_1.getString(var11_18);
                                                    }
                                                    if (!var1_1.isNull(var12_20)) break block90;
                                                    var12_21 = null;
                                                    break block91;
                                                }
                                                var12_21 = var1_1.getString(var12_20);
                                            }
                                            var16_26 = v25;
                                            v25 = new Access((String)var11_19, var12_21);
                                            var11_19 = var16_26;
                                        }
                                        v26 = var1_1;
                                        v27 = var10_17;
                                        var12_22 = v28;
                                        v28 = new Topic((String)var15_25, (String)var3_6, var4_7, var5_9, var6_11, (Date)var7_13 /* !! */ , (Date)var8_15 /* !! */ , var9_16, (Access)var11_19);
                                        if (!v26.isNull(v27)) break block92;
                                        var3_6 = null;
                                        break block93;
                                    }
                                    var3_6 = var1_1.getString(var10_17);
                                }
                                var12_22.setWatchPartyStreamId((String)var3_6);
                                var3_6 = var12_22;
                            }
                            var4_8 = (ArrayList)var13_23.get((Object)var1_1.getString(var2_2));
                            if (var4_8 != null) ** GOTO lbl203
                            var4_8 = v29;
                            v29 = new ArrayList<E>();
lbl203:
                            // 2 sources

                            if ((var2_3 = (ArrayList)var14_24.get((Object)var1_1.getString(var2_2))) != null) break block94;
                            var2_3 = v30;
                            v30 = new ArrayList<E>();
                        }
                        var5_10 = v31;
                        v31 = new ChatRelation((Topic)var3_6, var4_8, var2_3);
                        break block95;
                    }
                    var5_10 = null;
                }
                v32 = var5_10;
                v33 = this;
                v34 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v34.close();
                {
                    catch (Throwable v35) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v35;
                    }
                }
                MessagingDao_Impl.access$100(v33.MessagingDao_Impl.this).endTransaction();
                return v32;
                catch (Throwable var2_4) {
                    var1_1.close();
                    throw var2_4;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Object getTopic(String string2, Continuation<? super Topic> continuation) {
        Callable<Topic> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<Topic> callable2 = callable;
        callable = new Callable<Topic>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Topic call() throws Exception {
                Topic topic2;
                Cursor cursor;
                block58: {
                    block40: {
                        String string2;
                        block57: {
                            int n;
                            block56: {
                                void var9_16;
                                Topic topic3;
                                Object object;
                                Comparable<Long> comparable;
                                Comparable<Long> comparable2;
                                String string3;
                                int n2;
                                int n3;
                                int n4;
                                block51: {
                                    Access access;
                                    String string4;
                                    block55: {
                                        int n5;
                                        block54: {
                                            block53: {
                                                int n6;
                                                block52: {
                                                    block50: {
                                                        block49: {
                                                            int bl;
                                                            block48: {
                                                                int n7;
                                                                block47: {
                                                                    block46: {
                                                                        int n8;
                                                                        block45: {
                                                                            block44: {
                                                                                int n9;
                                                                                block43: {
                                                                                    block42: {
                                                                                        int n10;
                                                                                        block41: {
                                                                                            cursor = DBUtil.query((RoomDatabase)MessagingDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                                                            try {
                                                                                                n10 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatId");
                                                                                            }
                                                                                            catch (Throwable throwable) {
                                                                                                cursor.close();
                                                                                                roomSQLiteQuery.release();
                                                                                                throw throwable;
                                                                                            }
                                                                                            n9 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"name");
                                                                                            n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"seq");
                                                                                            n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"readSeq");
                                                                                            n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"recvSeq");
                                                                                            n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                                                                                            n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"touchedAt");
                                                                                            bl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isWPTopic");
                                                                                            n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"watchPartyStreamId");
                                                                                            n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"want");
                                                                                            n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"given");
                                                                                            if (!cursor.moveToFirst()) break block40;
                                                                                            if (!cursor.isNull(n10)) break block41;
                                                                                            string2 = null;
                                                                                            break block42;
                                                                                        }
                                                                                        string2 = cursor.getString(n10);
                                                                                    }
                                                                                    if (!cursor.isNull(n9)) break block43;
                                                                                    string3 = null;
                                                                                    break block44;
                                                                                }
                                                                                string3 = cursor.getString(n9);
                                                                            }
                                                                            Cursor cursor2 = cursor;
                                                                            int n9 = n8;
                                                                            Cursor cursor3 = cursor;
                                                                            int n10 = n2;
                                                                            Cursor cursor4 = cursor;
                                                                            int n11 = n3;
                                                                            n4 = cursor.getInt(n4);
                                                                            n3 = cursor4.getInt(n11);
                                                                            n2 = cursor3.getInt(n10);
                                                                            if (!cursor2.isNull(n9)) break block45;
                                                                            comparable2 = null;
                                                                            break block46;
                                                                        }
                                                                        comparable2 = cursor.getLong(n8);
                                                                    }
                                                                    Cursor cursor5 = cursor;
                                                                    int n12 = n7;
                                                                    comparable2 = MessagingDao_Impl.this.__converters.timestampToDate((Long)comparable2);
                                                                    if (!cursor5.isNull(n12)) break block47;
                                                                    comparable = null;
                                                                    break block48;
                                                                }
                                                                comparable = cursor.getLong(n7);
                                                            }
                                                            Cursor cursor6 = cursor;
                                                            int n13 = bl;
                                                            comparable = MessagingDao_Impl.this.__converters.timestampToDate((Long)comparable);
                                                            if (cursor6.getInt(n13) != 0) {
                                                                boolean bl2 = true;
                                                                break block49;
                                                            }
                                                            boolean bl3 = false;
                                                        }
                                                        if (!cursor.isNull(n6)) break block50;
                                                        if (!cursor.isNull(n5)) break block50;
                                                        object = null;
                                                        break block51;
                                                    }
                                                    if (!cursor.isNull(n6)) break block52;
                                                    object = null;
                                                    break block53;
                                                }
                                                object = cursor.getString(n6);
                                            }
                                            if (!cursor.isNull(n5)) break block54;
                                            string4 = null;
                                            break block55;
                                        }
                                        string4 = cursor.getString(n5);
                                    }
                                    Access access2 = access;
                                    access = new Access((String)object, string4);
                                    object = access2;
                                }
                                Cursor cursor7 = cursor;
                                int n14 = n;
                                topic2 = topic3;
                                topic3 = new Topic(string2, string3, n4, n3, n2, (Date)comparable2, (Date)comparable, (boolean)var9_16, (Access)object);
                                if (!cursor7.isNull(n14)) break block56;
                                string2 = null;
                                break block57;
                            }
                            string2 = cursor.getString(n);
                        }
                        topic2.setWatchPartyStreamId(string2);
                        break block58;
                    }
                    topic2 = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return topic2;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object isChatExist(String string2, Continuation<? super Boolean> continuation) {
        Callable<Boolean> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT EXISTS(SELECT * FROM Topic WHERE Topic.chatId = ?)", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<Boolean> callable2 = callable;
        callable = new Callable<Boolean>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Boolean call() throws Exception {
                void var2_10;
                Cursor cursor;
                block12: {
                    block8: {
                        void var2_4;
                        block10: {
                            block9: {
                                cursor = DBUtil.query((RoomDatabase)MessagingDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                try {
                                    if (!cursor.moveToFirst()) break block8;
                                }
                                catch (Throwable throwable) {
                                    cursor.close();
                                    roomSQLiteQuery.release();
                                    throw throwable;
                                }
                                if (!cursor.isNull(0)) break block9;
                                Object var2_2 = null;
                                break block10;
                            }
                            Integer n = cursor.getInt(0);
                        }
                        if (var2_4 != null) {
                            void var2_7;
                            block11: {
                                if (var2_4.intValue() != 0) {
                                    boolean bl = true;
                                    break block11;
                                }
                                boolean bl = false;
                            }
                            Boolean bl = (boolean)var2_7;
                            break block12;
                        }
                    }
                    Object var2_9 = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return var2_10;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object getWaveByIdAndDate(String string2, Date object, Continuation<? super WaveMessage> continuation) {
        Callable<WaveMessage> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WaveMessage WHERE chatUserId = ? AND sentAt >= ?", (int)2);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        int n2 = 2;
        object = this.__converters.dateToString((Date)object);
        if (object == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            long l = (Long)object;
            roomSQLiteQuery.bindLong(n2, l);
        }
        CancellationSignal cancellationSignal = DBUtil.createCancellationSignal();
        object = callable;
        callable = new Callable<WaveMessage>(){

            @Override
            public WaveMessage call() throws Exception {
                WaveMessage waveMessage;
                Cursor cursor;
                block31: {
                    block20: {
                        WaveMessage waveMessage2;
                        Comparable<Long> comparable;
                        String string2;
                        String string3;
                        String string4;
                        String string5;
                        block30: {
                            int n;
                            block29: {
                                block28: {
                                    int n2;
                                    block27: {
                                        block26: {
                                            int n3;
                                            block25: {
                                                block24: {
                                                    int n4;
                                                    block23: {
                                                        block22: {
                                                            int n5;
                                                            block21: {
                                                                cursor = DBUtil.query((RoomDatabase)MessagingDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                                try {
                                                                    n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatUserId");
                                                                }
                                                                catch (Throwable throwable) {
                                                                    cursor.close();
                                                                    roomSQLiteQuery.release();
                                                                    throw throwable;
                                                                }
                                                                n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatId");
                                                                n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userName");
                                                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userAvatar");
                                                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sentAt");
                                                                if (!cursor.moveToFirst()) break block20;
                                                                if (!cursor.isNull(n5)) break block21;
                                                                string5 = null;
                                                                break block22;
                                                            }
                                                            string5 = cursor.getString(n5);
                                                        }
                                                        if (!cursor.isNull(n4)) break block23;
                                                        string4 = null;
                                                        break block24;
                                                    }
                                                    string4 = cursor.getString(n4);
                                                }
                                                if (!cursor.isNull(n3)) break block25;
                                                string3 = null;
                                                break block26;
                                            }
                                            string3 = cursor.getString(n3);
                                        }
                                        if (!cursor.isNull(n2)) break block27;
                                        string2 = null;
                                        break block28;
                                    }
                                    string2 = cursor.getString(n2);
                                }
                                if (!cursor.isNull(n)) break block29;
                                comparable = null;
                                break block30;
                            }
                            comparable = cursor.getLong(n);
                        }
                        comparable = MessagingDao_Impl.this.__converters.timestampToDate((Long)comparable);
                        waveMessage = waveMessage2;
                        waveMessage2 = new WaveMessage(string5, string4, string3, string2, (Date)comparable);
                        break block31;
                    }
                    waveMessage = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return waveMessage;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)cancellationSignal, (Callable)object, continuation);
    }

    @Override
    public void saveOrUpdateChatMessage(ChatMessage chatMessage) {
        MessagingDao.DefaultImpls.saveOrUpdateChatMessage(this, chatMessage);
    }

    @Override
    public PagingSource<Integer, ChatMessageRelation> getChatMessagesSource(String string2, List<? extends ChatMessageStatus> list) {
        return MessagingDao.DefaultImpls.getChatMessagesSource(this, string2, list);
    }

    @Override
    public Flow<List<Topic>> getChats() {
        return MessagingDao.DefaultImpls.getChats(this);
    }

    @Override
    public Flow<Topic> getChat(String string2) {
        return MessagingDao.DefaultImpls.getChat(this, string2);
    }
}

