/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.soccer.models;

import androidx.collection.ArrayMap;
import com.streamlayer.sports.common.EventSummary;
import com.streamlayer.sports.common.EventTeam;
import com.streamlayer.sports.common.EventTime;
import com.streamlayer.sports.events.LineupResponse;
import com.streamlayer.sports.events.StandingsResponse;
import com.streamlayer.sports.events.SummaryResponse;
import com.streamlayer.sports.soccer.PlayByPlay;
import com.streamlayer.sports.soccer.SoccerMatchActivityType;
import com.streamlayer.sports.soccer.SoccerMatchFormationMatrix;
import com.streamlayer.sports.soccer.SoccerMatchFormationMatrixPlayer;
import com.streamlayer.sports.soccer.SoccerMatchLineup;
import com.streamlayer.sports.soccer.SoccerMatchPlayer;
import com.streamlayer.sports.soccer.SoccerPerformers;
import com.streamlayer.sports.soccer.TeamStanding;
import io.streamlayer.sdk.model.sports.EventsKt;
import io.streamlayer.sdk.model.sports.TeamStandings;
import io.streamlayer.sdk.statistics.common.model.PlayByPlayStatistics;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGame;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameEvent;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameEventType;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGamePlayerStats;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameStats;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameStatsGroup;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameSummary;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameTopPlayerStats;
import io.streamlayer.sdk.statistics.soccer.models.SoccerPlayByPlayStatistics;
import io.streamlayer.sdk.statistics.soccer.models.SoccerTeam;
import io.streamlayer.sdk.statistics.soccer.models.SoccerTeamMember;
import io.streamlayer.sdk.statistics.soccer.models.SoccerTeamStandings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0000H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0002*\u00020\u0004H\u0000\u001a\u0012\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\u00020\u0006H\u0000\u001a$\u0010\n\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00010\b*\u00020\u0006H\u0000\u001a\f\u0010\f\u001a\u00020\t*\u00020\u000bH\u0000\u001a\f\u0010\u0005\u001a\u00020\u000e*\u00020\rH\u0000\u001a\f\u0010\u0005\u001a\u00020\u0007*\u00020\u000bH\u0000\u001a\f\u0010\u0005\u001a\u00020\u0010*\u00020\u000fH\u0000\u001a:\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00160\u0014*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0001H\u0002\u001a\u0018\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\b*\u00020\u0018H\u0000\u001a\f\u0010\u0003\u001a\u00020\u001c*\u00020\u001bH\u0000\u00a8\u0006\u001d"}, d2={"Lcom/streamlayer/sports/events/StandingsResponse$ResponseData$StandingsResponseAttributes;", "", "Lio/streamlayer/sdk/model/sports/TeamStandings;", "toDomainSoccer", "Lcom/streamlayer/sports/soccer/TeamStanding;", "toDomain", "Lcom/streamlayer/sports/soccer/PlayByPlay;", "Lio/streamlayer/sdk/statistics/common/model/PlayByPlayStatistics;", "Lkotlin/Pair;", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerGameEvent;", "toDomainSoccerGameEvents", "Lcom/streamlayer/sports/soccer/SoccerPlayByPlayStatistics;", "toDomainSoccerGameEvent", "Lcom/streamlayer/sports/soccer/SoccerMatchActivityType;", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerGameEventType;", "Lcom/streamlayer/sports/soccer/SoccerMatchPlayer;", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerTeamMember;", "Lcom/streamlayer/sports/soccer/SoccerMatchLineup;", "mainTeam", "subTeam", "Landroidx/collection/ArrayMap;", "", "", "soccerTeamFieldPositions", "Lcom/streamlayer/sports/events/LineupResponse$ResponseData;", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerTeam;", "toDomainSoccerLineUp", "Lcom/streamlayer/sports/events/SummaryResponse$ResponseData;", "Lio/streamlayer/sdk/statistics/soccer/models/SoccerGameSummary;", "sdk_originalRelease"})
public final class ModelsKt {
    @NotNull
    public static final List<TeamStandings> toDomainSoccer(@NotNull StandingsResponse.ResponseData.StandingsResponseAttributes object) {
        ArrayList<TeamStandings> arrayList;
        StandingsResponse.ResponseData.StandingsResponseAttributes standingsResponseAttributes = object;
        Intrinsics.checkNotNullParameter((Object)standingsResponseAttributes, (String)"<this>");
        object = standingsResponseAttributes.getSoccer().getStandingsList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"soccer.standingsList");
        ArrayList<TeamStandings> arrayList2 = arrayList;
        arrayList = new ArrayList<TeamStandings>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            TeamStanding teamStanding = (TeamStanding)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)teamStanding, (String)"it");
            arrayList2.add(ModelsKt.toDomain(teamStanding));
        }
        return arrayList2;
    }

    @NotNull
    public static final TeamStandings toDomain(@NotNull TeamStanding object) {
        TeamStanding teamStanding = object;
        Intrinsics.checkNotNullParameter((Object)teamStanding, (String)"<this>");
        long l = teamStanding.getId();
        object = teamStanding.getName();
        String string2 = teamStanding.getLogo();
        int n = teamStanding.getWins();
        int n2 = teamStanding.getLosses();
        int n3 = teamStanding.getGamesBehind();
        List list = teamStanding.getColorsList();
        int n4 = teamStanding.getTotalGoals();
        int n5 = teamStanding.getTotalGoalsReceived();
        int n6 = teamStanding.getPosition();
        String string3 = teamStanding.getAlias();
        int n7 = teamStanding.getDraws();
        String string4 = teamStanding.getDivision();
        int n8 = teamStanding.getPoints();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"logo");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"colorsList");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"division");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"alias");
        return new SoccerTeamStandings(l, (String)object, string2, n, n2, 0.0, n3, list, n4, n5, n6, string4, n7, string3, n8);
    }

    @NotNull
    public static final List<PlayByPlayStatistics> toDomain(@NotNull PlayByPlay object) {
        ArrayList<PlayByPlayStatistics> arrayList;
        PlayByPlay playByPlay2 = object;
        Intrinsics.checkNotNullParameter((Object)playByPlay2, (String)"<this>");
        object = playByPlay2.getStatisticsList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"statisticsList");
        ArrayList<PlayByPlayStatistics> arrayList2 = arrayList;
        arrayList = new ArrayList<PlayByPlayStatistics>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics, (String)"it");
            arrayList2.add(ModelsKt.toDomain(soccerPlayByPlayStatistics));
        }
        return CollectionsKt.sortedWith(arrayList2, new Comparator<T>(){

            public final int compare(T t, T t2) {
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(Integer.parseInt((String)StringsKt.split$default((CharSequence)((PlayByPlayStatistics)t).getEventTime().getClock(), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(0))), (Comparable)Integer.valueOf(Integer.parseInt((String)StringsKt.split$default((CharSequence)((PlayByPlayStatistics)t2).getEventTime().getClock(), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(0))));
            }
        });
    }

    @NotNull
    public static final Pair<List<SoccerGameEvent>, List<SoccerGameEvent>> toDomainSoccerGameEvents(@NotNull PlayByPlay object) {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayList arrayList4;
        PlayByPlay playByPlay2 = object;
        Intrinsics.checkNotNullParameter((Object)playByPlay2, (String)"<this>");
        List list = playByPlay2.getStatisticsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"statisticsList");
        Object object2 = arrayList4;
        arrayList4 = new ArrayList();
        for (Object t : list) {
            if (!(((com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t).getEventTime().getPeriod() == 1)) continue;
            object2.add(t);
        }
        object2 = CollectionsKt.sortedWith(object2, new Comparator<T>(){

            public final int compare(T t, T t2) {
                String string2 = ((com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t2).getEventTime().getClock();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.eventTime.clock");
                Integer n = Integer.parseInt((String)StringsKt.split$default((CharSequence)string2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(0));
                String string3 = ((com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t).getEventTime().getClock();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.eventTime.clock");
                return ComparisonsKt.compareValues((Comparable)n, (Comparable)Integer.valueOf(Integer.parseInt((String)StringsKt.split$default((CharSequence)string3, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(0))));
            }
        });
        ArrayList arrayList5 = arrayList3;
        arrayList3 = new ArrayList(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)object2.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics, (String)"it");
            arrayList5.add(ModelsKt.toDomainSoccerGameEvent(soccerPlayByPlayStatistics));
        }
        List list2 = object.getStatisticsList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"statisticsList");
        object = arrayList2;
        arrayList2 = new ArrayList();
        for (Object t : list2) {
            if (!(((com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t).getEventTime().getPeriod() == 2)) continue;
            object.add(t);
        }
        object = CollectionsKt.sortedWith((Iterable)object, new Comparator<T>(){

            public final int compare(T t, T t2) {
                String string2 = ((com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t2).getEventTime().getClock();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.eventTime.clock");
                Integer n = Integer.parseInt((String)StringsKt.split$default((CharSequence)string2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(0));
                String string3 = ((com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)t).getEventTime().getClock();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.eventTime.clock");
                return ComparisonsKt.compareValues((Comparable)n, (Comparable)Integer.valueOf(Integer.parseInt((String)StringsKt.split$default((CharSequence)string3, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(0))));
            }
        });
        object2 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = (com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerPlayByPlayStatistics, (String)"it");
            object2.add(ModelsKt.toDomainSoccerGameEvent(soccerPlayByPlayStatistics));
        }
        return new Pair((Object)arrayList5, object2);
    }

    @NotNull
    public static final SoccerGameEvent toDomainSoccerGameEvent(@NotNull com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = object;
        object = soccerPlayByPlayStatistics.getEventTime().getClock();
        String string2 = soccerPlayByPlayStatistics.getTeam().getLogo();
        SoccerMatchActivityType soccerMatchActivityType = soccerPlayByPlayStatistics.getType();
        Intrinsics.checkNotNullExpressionValue((Object)soccerMatchActivityType, (String)"type");
        SoccerGameEventType soccerGameEventType = ModelsKt.toDomain(soccerMatchActivityType);
        String string3 = soccerPlayByPlayStatistics.getPlayText();
        return new SoccerGameEvent((String)object, string2, soccerGameEventType, string3);
    }

    @NotNull
    public static final SoccerGameEventType toDomain(@NotNull SoccerMatchActivityType soccerMatchActivityType) {
        SoccerGameEventType soccerGameEventType;
        Intrinsics.checkNotNullParameter((Object)soccerMatchActivityType, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[soccerMatchActivityType.ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 7: 
            case 8: {
                soccerGameEventType = SoccerGameEventType.NONE;
                break;
            }
            case 6: {
                soccerGameEventType = SoccerGameEventType.FULL_TIME;
                break;
            }
            case 5: {
                soccerGameEventType = SoccerGameEventType.HALF_TIME;
                break;
            }
            case 4: {
                soccerGameEventType = SoccerGameEventType.SUBSTITUTION;
                break;
            }
            case 3: {
                soccerGameEventType = SoccerGameEventType.RED_CARD;
                break;
            }
            case 2: {
                soccerGameEventType = SoccerGameEventType.YELLOW_CARD;
                break;
            }
            case 1: {
                soccerGameEventType = SoccerGameEventType.GOAL;
            }
        }
        return soccerGameEventType;
    }

    @NotNull
    public static final PlayByPlayStatistics toDomain(@NotNull com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.soccer.SoccerPlayByPlayStatistics soccerPlayByPlayStatistics = object;
        EventTeam eventTeam = soccerPlayByPlayStatistics.getTeam();
        Intrinsics.checkNotNullExpressionValue((Object)eventTeam, (String)"team");
        object = EventsKt.toDomain(eventTeam);
        EventTime eventTime = soccerPlayByPlayStatistics.getEventTime();
        Intrinsics.checkNotNullExpressionValue((Object)eventTime, (String)"eventTime");
        io.streamlayer.sdk.model.sports.EventTime eventTime2 = EventsKt.toDomain(eventTime);
        int n = soccerPlayByPlayStatistics.getScoreHome();
        int n2 = soccerPlayByPlayStatistics.getScoreAway();
        String string2 = soccerPlayByPlayStatistics.getPlayText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"playText");
        boolean bl = soccerPlayByPlayStatistics.getScoring();
        return new SoccerPlayByPlayStatistics((io.streamlayer.sdk.model.sports.EventTeam)object, eventTime2, n, n2, string2, bl);
    }

    @NotNull
    public static final SoccerTeamMember toDomain(@NotNull SoccerMatchPlayer object) {
        SoccerMatchPlayer soccerMatchPlayer = object;
        Intrinsics.checkNotNullParameter((Object)soccerMatchPlayer, (String)"<this>");
        object = soccerMatchPlayer.getLastName();
        String string2 = soccerMatchPlayer.getFirstName();
        int n = soccerMatchPlayer.getJersey();
        String string3 = soccerMatchPlayer.getPhoto();
        String string4 = soccerMatchPlayer.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"firstName");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lastName");
        return new SoccerTeamMember(string2, (String)object, n, string4, string3);
    }

    private static final ArrayMap<Integer, Set<SoccerTeamMember>> soccerTeamFieldPositions(SoccerMatchLineup soccerMatchLineup, List<SoccerTeamMember> list, List<SoccerTeamMember> list2) {
        ArrayMap arrayMap;
        SoccerMatchLineup soccerMatchLineup2 = soccerMatchLineup;
        soccerMatchLineup = arrayMap;
        arrayMap = new ArrayMap();
        List list3 = soccerMatchLineup2.getFormationMatrixList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"formationMatrixList");
        int n = 0;
        for (Object object : list3) {
            LinkedHashSet linkedHashSet;
            int n2 = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SoccerMatchFormationMatrix soccerMatchFormationMatrix = (SoccerMatchFormationMatrix)object;
            object = linkedHashSet;
            linkedHashSet = new LinkedHashSet();
            List list4 = soccerMatchFormationMatrix.getRowPlayersList();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"soccerMatchFormationMatrix.rowPlayersList");
            for (Object object2 : list4) {
                SoccerTeamMember soccerTeamMember;
                Object object3;
                Object var10_10;
                block10: {
                    block9: {
                        for (Object t : list) {
                            var10_10 = t;
                            if (!(((SoccerTeamMember)t).getNumber() == object2.getJerseyNumber())) continue;
                            break block9;
                        }
                        var10_10 = null;
                    }
                    object3 = var10_10;
                    if (object3 == null) {
                        object3 = null;
                    } else {
                        object.add((Object)object3);
                    }
                    if (object3 != null) continue;
                    for (Object t : list2) {
                        var10_10 = t;
                        if (!(((SoccerTeamMember)t).getNumber() == object2.getJerseyNumber())) continue;
                        break block10;
                    }
                    var10_10 = null;
                }
                object3 = var10_10;
                if (object3 == null) {
                    object3 = null;
                } else {
                    object.add(object3);
                }
                if (object3 != null) continue;
                SoccerMatchFormationMatrixPlayer soccerMatchFormationMatrixPlayer = object2;
                object2 = soccerMatchFormationMatrixPlayer.getPlayerName();
                object3 = soccerMatchFormationMatrixPlayer.getPlayerName();
                int n3 = soccerMatchFormationMatrixPlayer.getJerseyNumber();
                String string2 = soccerMatchFormationMatrixPlayer.getPhoto();
                SoccerTeamMember soccerTeamMember2 = soccerTeamMember;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"playerName");
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"playerName");
                soccerTeamMember = new SoccerTeamMember((String)object3, (String)object2, n3, null, string2, 8, null);
                object.add(soccerTeamMember2);
            }
            soccerMatchLineup.put(n, object);
            n = n2;
        }
        return soccerMatchLineup;
    }

    @NotNull
    public static final Pair<SoccerTeam, SoccerTeam> toDomainSoccerLineUp(@NotNull LineupResponse.ResponseData object) {
        SoccerTeam soccerTeam;
        SoccerTeam soccerTeam2;
        Object object22;
        ArrayList<SoccerTeamMember> arrayList;
        ArrayList<SoccerTeamMember> arrayList2;
        ArrayList<SoccerTeamMember> arrayList3;
        ArrayList<SoccerTeamMember> arrayList4;
        LineupResponse.ResponseData responseData = object;
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"<this>");
        Object object3 = responseData.getAttributes().getSoccer().getHomeTeam();
        Object object4 = object.getAttributes().getSoccer().getAwayTeam();
        Iterator iterator = object3.getStartPlayersList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"homeTeam.startPlayersList");
        Object object5 = arrayList4;
        arrayList4 = new ArrayList<SoccerTeamMember>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerMatchPlayer soccerMatchPlayer = (SoccerMatchPlayer)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchPlayer, (String)"it");
            object5.add(ModelsKt.toDomain(soccerMatchPlayer));
        }
        iterator = object3.getSubstitutesList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"homeTeam.substitutesList");
        ArrayList<SoccerTeamMember> arrayList5 = arrayList3;
        arrayList3 = new ArrayList<SoccerTeamMember>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerMatchPlayer soccerMatchPlayer = (SoccerMatchPlayer)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchPlayer, (String)"it");
            arrayList5.add(ModelsKt.toDomain(soccerMatchPlayer));
        }
        iterator = object4.getStartPlayersList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"awayTeam.startPlayersList");
        ArrayList<SoccerTeamMember> arrayList6 = arrayList2;
        arrayList2 = new ArrayList<SoccerTeamMember>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerMatchPlayer soccerMatchPlayer = (SoccerMatchPlayer)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchPlayer, (String)"it");
            arrayList6.add(ModelsKt.toDomain(soccerMatchPlayer));
        }
        iterator = object4.getSubstitutesList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"awayTeam.substitutesList");
        ArrayList<SoccerTeamMember> arrayList7 = arrayList;
        arrayList = new ArrayList<SoccerTeamMember>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SoccerMatchPlayer soccerMatchPlayer = (SoccerMatchPlayer)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)soccerMatchPlayer, (String)"it");
            arrayList7.add(ModelsKt.toDomain(soccerMatchPlayer));
        }
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"awayTeam");
        iterator = ModelsKt.soccerTeamFieldPositions(object4, arrayList6, arrayList7);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"homeTeam");
        ArrayMap<Integer, Set<SoccerTeamMember>> arrayMap = ModelsKt.soccerTeamFieldPositions(object3, object5, arrayList5);
        Object object6 = null;
        Object object7 = null;
        if (object.getAttributes().getSummary().getHomeTeam().getColorsList() != null && object.getAttributes().getSummary().getAwayTeam().getColorsList() != null) {
            block8: {
                block7: {
                    List list = object.getAttributes().getSummary().getHomeTeam().getColorsList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"attributes.summary.homeTeam.colorsList");
                    for (Object t : list) {
                        object7 = t;
                        object22 = (String)t;
                        if (!(object.getAttributes().getSummary().getAwayTeam().getColorsList().contains(object22) ^ true)) continue;
                        break block7;
                    }
                    object7 = null;
                }
                object6 = (String)object7;
                List list = object.getAttributes().getSummary().getAwayTeam().getColorsList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"attributes.summary.awayTeam.colorsList");
                for (Object object22 : list) {
                    String string2 = (String)object22;
                    if (!(object.getAttributes().getSummary().getHomeTeam().getColorsList().contains(string2) ^ true)) continue;
                    break block8;
                }
                object22 = null;
            }
            object7 = (String)object22;
        }
        LineupResponse.ResponseData responseData2 = object;
        SoccerMatchLineup soccerMatchLineup = object4;
        LineupResponse.ResponseData responseData3 = object;
        object = object.getAttributes().getSummary().getHomeTeam().getLogo();
        object3 = object3.getFormationString();
        object4 = responseData3.getAttributes().getSummary().getHomeTeam().getColorsList();
        object22 = soccerTeam2;
        soccerTeam2 = new SoccerTeam((String)object, (String)object3, arrayMap, (List<SoccerTeamMember>)object5, (List<SoccerTeamMember>)arrayList5, (List<String>)object4, (String)object6);
        object = responseData3.getAttributes().getSummary().getAwayTeam().getLogo();
        object3 = soccerMatchLineup.getFormationString();
        object4 = responseData2.getAttributes().getSummary().getAwayTeam().getColorsList();
        object5 = soccerTeam;
        soccerTeam = new SoccerTeam((String)object, (String)object3, (ArrayMap<Integer, Set<SoccerTeamMember>>)iterator, (List<SoccerTeamMember>)arrayList6, (List<SoccerTeamMember>)arrayList7, (List<String>)object4, (String)object7);
        return new Pair(object22, object5);
    }

    @NotNull
    public static final SoccerGameSummary toDomainSoccer(@NotNull SummaryResponse.ResponseData object) {
        ArrayList arrayList;
        SoccerGameStats soccerGameStats;
        SoccerGameStats soccerGameStats2;
        SoccerGameStats soccerGameStats3;
        SoccerGameStats soccerGameStats4;
        SoccerGameStats soccerGameStats5;
        SoccerGameStats soccerGameStats6;
        SoccerGameStats soccerGameStats7;
        SoccerGameStats soccerGameStats8;
        SoccerGameStats soccerGameStats9;
        SoccerGameStats soccerGameStats10;
        SoccerGameStats soccerGameStats11;
        SoccerGameStats soccerGameStats12;
        SoccerGameStats soccerGameStats13;
        SoccerGameStats soccerGameStats14;
        SoccerGameStats soccerGameStats15;
        SoccerGameStats soccerGameStats16;
        SoccerGameStats soccerGameStats17;
        SoccerGameStats soccerGameStats18;
        ArrayList arrayList2;
        SoccerGame soccerGame;
        SummaryResponse.ResponseData responseData = object;
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"<this>");
        EventSummary eventSummary2 = responseData.getAttributes().getSummary();
        object = eventSummary2.getHomeTeam().getAlias();
        ArrayList arrayList3 = eventSummary2.getHomeTeam().getLogo();
        Object object2 = eventSummary2.getAwayTeam().getAlias();
        Object object3 = eventSummary2.getAwayTeam().getLogo();
        int n = eventSummary2.getScoreHome();
        int n2 = eventSummary2.getScoreAway();
        String string2 = eventSummary2.getEventTime().getClock();
        Object object4 = eventSummary2.getAwayTeam().getColorsList();
        Object object5 = eventSummary2.getHomeTeam().getColorsList();
        SoccerGame soccerGame2 = soccerGame;
        soccerGame = new SoccerGame((String)((Object)arrayList3), (String)object3, (String)object, (String)object2, n, n2, string2, (List<String>)object5, (List<String>)object4);
        object = responseData.getAttributes().getSoccer().getStatistics();
        arrayList3 = arrayList2;
        Object object6 = object;
        arrayList3();
        object = object6.getHomeStatistics().getTopMatchStats();
        object2 = object6.getAwayStatistics().getTopMatchStats();
        object3 = object6.getHomeStatistics().getAttackingStats();
        Object object7 = object6.getAwayStatistics().getAttackingStats();
        Object object8 = object6.getHomeStatistics().getDefenseStats();
        string2 = object6.getAwayStatistics().getDefenseStats();
        Object[] objectArray = new SoccerGameStats[9];
        object4 = soccerGameStats18;
        object5 = object.getPossession();
        Number number = object2.getPossession();
        soccerGameStats18 = new SoccerGameStats("Possession", (Number)object5, number);
        objectArray[0] = object4;
        object4 = soccerGameStats17;
        object5 = object.getShots();
        number = object2.getShots();
        soccerGameStats17 = new SoccerGameStats("Shots", (Number)object5, number);
        objectArray[1] = object4;
        object4 = soccerGameStats16;
        object5 = object.getShotsOnTarget();
        number = object2.getShotsOnTarget();
        soccerGameStats16 = new SoccerGameStats("Shots on target", (Number)object5, number);
        objectArray[2] = object4;
        object4 = soccerGameStats15;
        object5 = object.getPasses();
        number = object2.getPasses();
        soccerGameStats15 = new SoccerGameStats("Passes", (Number)object5, number);
        objectArray[3] = object4;
        object4 = soccerGameStats14;
        object5 = object.getOffsides();
        number = object2.getOffsides();
        soccerGameStats14 = new SoccerGameStats("Offsides", (Number)object5, number);
        objectArray[4] = object4;
        object4 = soccerGameStats13;
        object5 = object.getYellowCards();
        number = object2.getYellowCards();
        soccerGameStats13 = new SoccerGameStats("Yellow cards", (Number)object5, number);
        objectArray[5] = object4;
        object4 = soccerGameStats12;
        object5 = object.getRedCards();
        number = object2.getRedCards();
        soccerGameStats12 = new SoccerGameStats("Red cards", (Number)object5, number);
        objectArray[6] = object4;
        object4 = soccerGameStats11;
        object5 = object.getCornerKicks();
        number = object2.getCornerKicks();
        soccerGameStats11 = new SoccerGameStats("Corner kicks", (Number)object5, number);
        objectArray[7] = object4;
        object4 = soccerGameStats10;
        object = object.getFreeKicks();
        object2 = object2.getFreeKicks();
        soccerGameStats10 = new SoccerGameStats("Free kicks", (Number)object, (Number)object2);
        objectArray[8] = object4;
        arrayList2.add(new SoccerGameStatsGroup("Top Match Stats", CollectionsKt.listOf((Object[])objectArray)));
        Object[] objectArray2 = new SoccerGameStats[4];
        object = soccerGameStats9;
        object2 = (double)object3.getPossession();
        object4 = (double)object7.getPossession();
        soccerGameStats9 = new SoccerGameStats("Possession", (Number)object2, (Number)object4);
        objectArray2[0] = object;
        object = soccerGameStats8;
        object2 = object3.getPassingAccuracy();
        object4 = object7.getPassingAccuracy();
        soccerGameStats8 = new SoccerGameStats("Passing accuracy", (Number)object2, (Number)object4);
        objectArray2[1] = object;
        object = soccerGameStats7;
        object2 = object3.getChancesCreated();
        object4 = object7.getChancesCreated();
        soccerGameStats7 = new SoccerGameStats("Chances created", (Number)object2, (Number)object4);
        objectArray2[2] = object;
        object = soccerGameStats6;
        object2 = object3.getSuccessfulCrosses();
        object3 = object7.getSuccessfulCrosses();
        soccerGameStats6 = new SoccerGameStats("Successful crosses", (Number)object2, (Number)object3);
        objectArray2[3] = object;
        arrayList2.add(new SoccerGameStatsGroup("Attacking stats", CollectionsKt.listOf((Object[])objectArray2)));
        Object[] objectArray3 = new SoccerGameStats[5];
        object = soccerGameStats5;
        object2 = object8.getTacklesMade();
        object3 = string2.getTacklesMade();
        soccerGameStats5 = new SoccerGameStats("Tackles made", (Number)object2, (Number)object3);
        objectArray3[0] = object;
        object = soccerGameStats4;
        object2 = object8.getInterceptions();
        object3 = string2.getInterceptions();
        soccerGameStats4 = new SoccerGameStats("Interceptions", (Number)object2, (Number)object3);
        objectArray3[1] = object;
        object = soccerGameStats3;
        object2 = object8.getBlockedShots();
        object3 = string2.getBlockedShots();
        soccerGameStats3 = new SoccerGameStats("Blocked shots", (Number)object2, (Number)object3);
        objectArray3[2] = object;
        object = soccerGameStats2;
        object2 = object8.getClearances();
        object3 = string2.getClearances();
        soccerGameStats2 = new SoccerGameStats("Clearances", (Number)object2, (Number)object3);
        objectArray3[3] = object;
        object = soccerGameStats;
        object2 = object8.getDuelsWon();
        object3 = string2.getDuelsWon();
        soccerGameStats = new SoccerGameStats("Duels won", (Number)object2, (Number)object3);
        objectArray3[4] = object;
        arrayList2.add(new SoccerGameStatsGroup("Defence stats", CollectionsKt.listOf((Object[])objectArray3)));
        SoccerPerformers soccerPerformers = responseData.getAttributes().getSoccer().getStatistics().getPerfomers();
        object = soccerPerformers.getAttackPerformer();
        object2 = soccerPerformers.getMidfieldPerformer();
        object3 = soccerPerformers.getDefensePerformer();
        object7 = arrayList;
        arrayList = new ArrayList();
        if (object.hasPerfomer()) {
            SoccerGamePlayerStats soccerGamePlayerStats;
            SoccerGamePlayerStats soccerGamePlayerStats2;
            SoccerGamePlayerStats soccerGamePlayerStats3;
            SoccerGamePlayerStats soccerGamePlayerStats4;
            SoccerGamePlayerStats soccerGamePlayerStats5;
            String string3 = object.getPerfomer().getPhoto();
            String string4 = object.getPerfomer().getName();
            Object[] objectArray4 = new SoccerGamePlayerStats[5];
            object8 = soccerGamePlayerStats5;
            soccerGamePlayerStats5 = new SoccerGamePlayerStats("G", object.getAttackStats().getGoals());
            objectArray4[0] = object8;
            object8 = soccerGamePlayerStats4;
            soccerGamePlayerStats4 = new SoccerGamePlayerStats("A", object.getAttackStats().getAssists());
            objectArray4[1] = object8;
            object8 = soccerGamePlayerStats3;
            soccerGamePlayerStats3 = new SoccerGamePlayerStats("SH", object.getAttackStats().getShots());
            objectArray4[2] = object8;
            object8 = soccerGamePlayerStats2;
            soccerGamePlayerStats2 = new SoccerGamePlayerStats("PKG", object.getAttackStats().getPenaltyKickGoals());
            objectArray4[3] = object8;
            object8 = soccerGamePlayerStats;
            soccerGamePlayerStats = new SoccerGamePlayerStats("SHG", object.getAttackStats().getShotsOnGoal());
            objectArray4[4] = object8;
            object = CollectionsKt.listOf((Object[])objectArray4);
            object7.add(new SoccerGameTopPlayerStats(string3, "Attack", string4, null, (List<SoccerGamePlayerStats>)object));
        }
        if (object2.hasPerfomer()) {
            SoccerGamePlayerStats soccerGamePlayerStats;
            SoccerGamePlayerStats soccerGamePlayerStats6;
            SoccerGamePlayerStats soccerGamePlayerStats7;
            SoccerGamePlayerStats soccerGamePlayerStats8;
            SoccerGamePlayerStats soccerGamePlayerStats9;
            Object[] objectArray5 = new SoccerGamePlayerStats[5];
            object = soccerGamePlayerStats9;
            soccerGamePlayerStats9 = new SoccerGamePlayerStats("G", object2.getMidfieldStats().getGoals());
            objectArray5[0] = object;
            object = soccerGamePlayerStats8;
            soccerGamePlayerStats8 = new SoccerGamePlayerStats("A", object2.getMidfieldStats().getAssists());
            objectArray5[1] = object;
            object = soccerGamePlayerStats7;
            soccerGamePlayerStats7 = new SoccerGamePlayerStats("KEY", object2.getMidfieldStats().getKeyPasses());
            objectArray5[2] = object;
            object = soccerGamePlayerStats6;
            soccerGamePlayerStats6 = new SoccerGamePlayerStats("CRS", object2.getMidfieldStats().getCrosses());
            objectArray5[3] = object;
            object = soccerGamePlayerStats;
            soccerGamePlayerStats = new SoccerGamePlayerStats("COR", object2.getMidfieldStats().getCorners());
            objectArray5[4] = object;
            object = CollectionsKt.listOf((Object[])objectArray5);
            object7.add(new SoccerGameTopPlayerStats(object2.getPerfomer().getPhoto(), "Midfield", object2.getPerfomer().getName(), null, (List<SoccerGamePlayerStats>)object));
        }
        if (object3.hasPerfomer()) {
            SoccerGamePlayerStats soccerGamePlayerStats;
            SoccerGamePlayerStats soccerGamePlayerStats10;
            SoccerGamePlayerStats soccerGamePlayerStats11;
            SoccerGamePlayerStats soccerGamePlayerStats12;
            SoccerGamePlayerStats soccerGamePlayerStats13;
            Object[] objectArray6 = new SoccerGamePlayerStats[5];
            object = soccerGamePlayerStats13;
            soccerGamePlayerStats13 = new SoccerGamePlayerStats("G", object3.getDefenseStats().getGoals());
            objectArray6[0] = object;
            object = soccerGamePlayerStats12;
            soccerGamePlayerStats12 = new SoccerGamePlayerStats("A", object3.getDefenseStats().getAssists());
            objectArray6[1] = object;
            object = soccerGamePlayerStats11;
            soccerGamePlayerStats11 = new SoccerGamePlayerStats("TCK", object3.getDefenseStats().getTacklesMade());
            objectArray6[2] = object;
            object = soccerGamePlayerStats10;
            soccerGamePlayerStats10 = new SoccerGamePlayerStats("INT", object3.getDefenseStats().getInterceptions());
            objectArray6[3] = object;
            object = soccerGamePlayerStats;
            soccerGamePlayerStats = new SoccerGamePlayerStats("BLK", object3.getDefenseStats().getBlockedShots());
            objectArray6[4] = object;
            object = CollectionsKt.listOf((Object[])objectArray6);
            object7.add(new SoccerGameTopPlayerStats(object3.getPerfomer().getPhoto(), "Defense", object3.getPerfomer().getName(), null, (List<SoccerGamePlayerStats>)object));
        }
        return new SoccerGameSummary(soccerGame2, arrayList3, (List)object7, null, 8, null);
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SoccerMatchActivityType.values().length];
            nArray[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_GOAL.ordinal()] = 1;
            nArray[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_YELLOW_CARD.ordinal()] = 2;
            nArray[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_RED_CARD.ordinal()] = 3;
            nArray[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_SUBSTITUTION.ordinal()] = 4;
            nArray[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_HALF_TIME.ordinal()] = 5;
            nArray[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_FULL_TIME.ordinal()] = 6;
            nArray[SoccerMatchActivityType.SOCCER_MATCH_ACTIVITY_UNSET.ordinal()] = 7;
            nArray[SoccerMatchActivityType.UNRECOGNIZED.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

