/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.dagger.modules;

import com.google.gson.Gson;
import dagger.Module;
import dagger.Provides;
import io.streamlayer.common.dagger.modules.NetworkModule;
import io.streamlayer.common.data.environment.Environment;
import io.streamlayer.common.data.environment.EnvironmentManager;
import io.streamlayer.common.data.retrofit.CDNService;
import io.streamlayer.common.utils.GsonUtil;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Module(includes={NetworkModule.class})
@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0003\u001a\u00020\u0002H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007R\u0016\u0010\u000b\u001a\u00020\n8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/common/dagger/modules/ApiServiceModule;", "", "Lio/streamlayer/common/data/environment/EnvironmentManager;", "environmentManager", "Lokhttp3/OkHttpClient;", "client", "Lretrofit2/Retrofit;", "retrofit", "Lio/streamlayer/common/data/retrofit/CDNService;", "cdnService", "Lio/streamlayer/common/data/environment/Environment;", "environment", "Lio/streamlayer/common/data/environment/Environment;", "<init>", "(Lio/streamlayer/common/data/environment/Environment;)V", "sdk_originalRelease"})
public final class ApiServiceModule {
    @NotNull
    private final Environment environment;

    public ApiServiceModule(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
    }

    @Provides
    @Singleton
    @NotNull
    public final EnvironmentManager environmentManager() {
        return new EnvironmentManager(this.environment);
    }

    @Provides
    @Singleton
    @NotNull
    public final Retrofit retrofit(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"client");
        Retrofit retrofit = new Retrofit.Builder().client(okHttpClient).baseUrl("https://api.openweathermap.org/data/2.5/").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)GsonUtil.INSTANCE.getDefaultGson())).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"Builder()\n            .c\u2026on))\n            .build()");
        return retrofit;
    }

    @Provides
    @Singleton
    @NotNull
    public final CDNService cdnService(@NotNull Retrofit retrofit) {
        Retrofit retrofit2 = retrofit;
        Intrinsics.checkNotNullParameter((Object)retrofit2, (String)"retrofit");
        Object object = retrofit2.create(CDNService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"retrofit.create(CDNService::class.java)");
        return (CDNService)object;
    }
}

