/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.ContextCompat;
import com.google.gson.Gson;
import io.streamlayer.common.data.notifications.NotificationChannelsHelper;
import io.streamlayer.common.data.notifications.NotificationUtil;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.utils.GsonUtil;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.deeplink.DeepLinkHandler;
import io.streamlayer.sdk.deeplink.DeepLinkRoute;
import io.streamlayer.sdk.model.analytics.AnalyticsDataKt;
import io.streamlayer.sdk.model.analytics.CommonKind;
import io.streamlayer.sdk.model.analytics.NotificationType;
import io.streamlayer.sdk.model.deeplink.Payload;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageHead;
import io.streamlayer.sdk.model.messaging.ChatMessageHeadPayload;
import io.streamlayer.sdk.model.messaging.ChatMessageKt;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.TopicKt;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationKt;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\b\u0007\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ(\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002J&\u0010\f\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\r\u001a\u00020\u0006H\u0002J\u001a\u0010\u0010\u001a\u00020\b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000eR\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lio/streamlayer/common/data/notifications/PushNotificationsService;", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "Lio/streamlayer/sdk/model/deeplink/Payload;", "payload", "", "groupKey", "", "showSystemNotification", "Landroid/app/PendingIntent;", "pendingIntent", "updateSummary", "getNotificationTag", "", "data", "handlePushMessage", "Landroid/content/Context;", "context", "Landroid/content/Context;", "Lio/streamlayer/common/session/Session;", "session", "Lio/streamlayer/common/session/Session;", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "analyticsRepo", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "<init>", "(Landroid/content/Context;Lio/streamlayer/common/session/Session;Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;)V", "Companion", "sdk_originalRelease"})
public final class PushNotificationsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Session session;
    @NotNull
    private final AnalyticsRepo analyticsRepo;

    @Inject
    public PushNotificationsService(@NotNull Context context, @NotNull Session session, @NotNull AnalyticsRepo analyticsRepo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)analyticsRepo, (String)"analyticsRepo");
        this.context = context;
        this.session = session;
        this.analyticsRepo = analyticsRepo;
    }

    private final void showSystemNotification(Notification notification, Payload payload, String string2) {
        Number number = notification.getId();
        number = number == null ? null : Integer.valueOf((int)number.longValue());
        int n = number == null ? notification.hashCode() : ((Integer)number).intValue();
        Context context = ((PushNotificationsService)((Object)string3)).context;
        DeepLinkRoute deepLinkRoute = DeepLinkRoute.MAIN;
        Uri uri = NotificationKt.deepLink(notification);
        payload = DeepLinkHandler.INSTANCE.buildDeepLinkIntent$sdk_originalRelease(context, deepLinkRoute, uri, payload);
        payload = PendingIntent.getActivity((Context)((PushNotificationsService)((Object)string3)).context, (int)n, (Intent)payload, (int)0x8000000);
        context = new NotificationCompat.Builder(((PushNotificationsService)((Object)string3)).context, NotificationChannelsHelper.Channel.streamlayer_high.name()).setSmallIcon(R.drawable.slr_ic_logo).setColor(ContextCompat.getColor((Context)((PushNotificationsService)((Object)string3)).context, (int)R.color.slr_primaryBlue)).setAutoCancel(true).setCategory("msg").setContentTitle((CharSequence)notification.getTitle()).setContentText((CharSequence)notification.getDescription());
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"Builder(context, Notific\u2026notification.description)");
        if (payload != null) {
            context.setContentIntent((PendingIntent)payload);
        }
        if (string2 != null) {
            context.setGroup(((PushNotificationsService)((Object)string3)).context.getPackageName() + '.' + string2);
        }
        PushNotificationsService pushNotificationsService = string3;
        pushNotificationsService.updateSummary(notification, string2, (PendingIntent)payload);
        String string3 = ((PushNotificationsService)((Object)string3)).getNotificationTag();
        notification = context.build();
        NotificationManagerCompat.from((Context)pushNotificationsService.context).notify(string3, n, (android.app.Notification)notification);
    }

    static /* synthetic */ void showSystemNotification$default(PushNotificationsService pushNotificationsService, Notification notification, Payload payload, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            payload = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        pushNotificationsService.showSystemNotification(notification, payload, string2);
    }

    private final void updateSummary(Notification notification, String string2, PendingIntent object) {
        notification = new NotificationCompat.Builder(pushNotificationsService2.context, NotificationChannelsHelper.Channel.streamlayer_high.name()).setSmallIcon(R.drawable.slr_ic_logo).setColor(ContextCompat.getColor((Context)pushNotificationsService2.context, (int)R.color.slr_primaryBlue)).setGroupSummary(true).setAutoCancel(true).setCategory("msg").setContentTitle((CharSequence)notification.getTitle()).setContentText((CharSequence)notification.getDescription()).setGroupAlertBehavior(2).setOnlyAlertOnce(true);
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"Builder(context, Notific\u2026  .setOnlyAlertOnce(true)");
        if (object != null) {
            notification.setContentIntent((PendingIntent)object);
        }
        if (string2 != null) {
            notification.setGroup(pushNotificationsService2.context.getPackageName() + '.' + string2);
        }
        PushNotificationsService pushNotificationsService = pushNotificationsService2;
        PushNotificationsService pushNotificationsService2 = NotificationManagerCompat.from((Context)pushNotificationsService.context);
        object = pushNotificationsService.getNotificationTag();
        int n = string2 != null ? string2.hashCode() : 0;
        PushNotificationsService pushNotificationsService3 = pushNotificationsService2;
        pushNotificationsService2 = notification.build();
        pushNotificationsService3.notify((String)object, n, (android.app.Notification)pushNotificationsService2);
    }

    static /* synthetic */ void updateSummary$default(PushNotificationsService pushNotificationsService, Notification notification, String string2, PendingIntent pendingIntent, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        pushNotificationsService.updateSummary(notification, string2, pendingIntent);
    }

    private final String getNotificationTag() {
        return Intrinsics.stringPlus((String)this.context.getPackageName(), (Object)"StreamLayer");
    }

    public final void handlePushMessage(@NotNull Map<String, String> map2) {
        Object object;
        Notification notification;
        Intrinsics.checkNotNullParameter(map2, (String)"data");
        if (!this.session.isLoggedIn()) {
            return;
        }
        Object object2 = map2.get("category");
        Object object3 = GsonUtil.INSTANCE.getDefaultGson();
        ChatMessage chatMessage = (Intrinsics.areEqual((Object)object2, (Object)"sl_chat") ? true : Intrinsics.areEqual((Object)object2, (Object)"sl_watch_party")) ? (ChatMessage)object3.fromJson(map2.get("extra"), ChatMessage.class) : null;
        object3 = (Intrinsics.areEqual((Object)object2, (Object)"sl_chat") ? true : Intrinsics.areEqual((Object)object2, (Object)"sl_watch_party")) ? (ChatMessageHeadPayload)object3.fromJson(map2.get("extra"), ChatMessageHeadPayload.class) : null;
        object2 = Intrinsics.areEqual((Object)object2, (Object)"sl_chat") ? io.streamlayer.sdk.model.notifications.NotificationType.Chat : (Intrinsics.areEqual((Object)object2, (Object)"sl_watch_party") ? io.streamlayer.sdk.model.notifications.NotificationType.WatchParty : io.streamlayer.sdk.model.notifications.NotificationType.Universal);
        boolean bl = chatMessage instanceof ChatMessage;
        if (bl) {
            notification = NotificationUtilKt.toNotification(chatMessage, (io.streamlayer.sdk.model.notifications.NotificationType)((Object)object2));
            object = WhenMappings.$EnumSwitchMapping$0[((Enum)object2).ordinal()] == 1 ? Long.valueOf((long)chatMessage.getTopicId().hashCode() + (long)chatMessage.getSeqId()) : Long.valueOf(chatMessage.getTopicId().hashCode());
            notification.setId((Long)object);
        } else {
            Notification notification2;
            notification = notification2;
            object = ((Enum)object2).name();
            notification2 = new Notification(null, null, null, (String)object, null, null, null, null, 247, null);
        }
        if (object3 instanceof ChatMessageHeadPayload) {
            if (ChatMessageKt.isWave((ChatMessageHeadPayload)object3)) {
                Gson gson = object3;
                object = gson.getHead();
                object = object == null ? null : ((ChatMessageHead)object).getEventId();
                object3 = new Payload.Wave((String)object);
            } else {
                Payload.Notification notification3;
                object3 = notification3;
                notification3 = new Payload.Notification((io.streamlayer.sdk.model.notifications.NotificationType)((Object)object2), false, 2, null);
            }
        } else {
            object3 = null;
        }
        object = bl ? chatMessage.getTopicId() : "general_group";
        String string2 = map2.get("title");
        if (string2 != null) {
            notification.setTitle(string2);
        }
        string2 = map2.get("body");
        if (string2 != null) {
            notification.setDescription(string2);
        }
        SLRLog.INSTANCE.i("PushNotificationsService", Intrinsics.stringPlus((String)"handlePush ", map2));
        boolean bl2 = false;
        if (bl && object2 == io.streamlayer.sdk.model.notifications.NotificationType.Chat) {
            if (TopicKt.isP2PTopic(chatMessage.getTopicId())) {
                return;
            }
            if (TopicKt.isGroupTopic(chatMessage.getTopicId()) && chatMessage.getSeqId() == 0) {
                return;
            }
            if (chatMessage.getSeqId() > 0) {
                chatMessage.updateStatus(ChatMessageStatus.Success);
                bl2 = true;
            }
        }
        if (((NotificationUtil)(object2 = NotificationUtil.INSTANCE)).isNotificationEnabled$sdk_originalRelease(this.session, notification) && !((NotificationUtil)object2).isAppInForeground()) {
            if (bl2) {
                this.session.incrementTotalUnreadMessagesCount();
            }
            PushNotificationsService pushNotificationsService = this;
            pushNotificationsService.showSystemNotification(notification, (Payload)object3, (String)object);
            AnalyticsRepo.DefaultImpls.triggerNotificationEvent$default(pushNotificationsService.analyticsRepo, NotificationType.PUSH, AnalyticsDataKt.toKind(notification.getType()), CommonKind.NOTIFICATION_RECEIVED, null, null, 24, null);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u0006\u001a\u00020\u00052\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002\u00a8\u0006\t"}, d2={"Lio/streamlayer/common/data/notifications/PushNotificationsService$Companion;", "", "", "", "data", "", "isStreamLayerPush", "<init>", "()V", "sdk_originalRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final boolean isStreamLayerPush(@NotNull Map<String, String> map2) {
            Map<String, String> map3 = map2;
            Intrinsics.checkNotNullParameter(map3, (String)"data");
            return map3.containsKey("category") && ArraysKt.contains((Object[])new String[]{"sl_chat", "sl_watch_party"}, (Object)map2.get("category"));
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[io.streamlayer.sdk.model.notifications.NotificationType.values().length];
            nArray[io.streamlayer.sdk.model.notifications.NotificationType.Chat.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

