/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.watchparty;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus;
import io.streamlayer.sdk.model.calls.WatchPartyRelation;
import io.streamlayer.sdk.model.calls.WatchPartyStatus;
import io.streamlayer.sdk.model.calls.WatchPartyType;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatRelation;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.watchparty.WatchPartyDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;

public final class WatchPartyDao_Impl
implements WatchPartyDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<WatchPartyStatus> __insertionAdapterOfWatchPartyStatus;
    private final Converters __converters;
    private final EntityDeletionOrUpdateAdapter<WatchPartyStatus> __updateAdapterOfWatchPartyStatus;
    private final SharedSQLiteStatement __preparedStmtOfUpdateWatchPartyStatusParticipated;
    private final SharedSQLiteStatement __preparedStmtOfDeleteWatchPartyStatus;
    private final SharedSQLiteStatement __preparedStmtOfDeleteTopic;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChatParticipantCrossRef;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChatOwnerCrossRef;
    private final SharedSQLiteStatement __preparedStmtOfSetWatchPartyPrivate;
    private final SharedSQLiteStatement __preparedStmtOfHidePublicWatchParties;

    public WatchPartyDao_Impl(RoomDatabase roomDatabase) {
        SharedSQLiteStatement sharedSQLiteStatement;
        SharedSQLiteStatement sharedSQLiteStatement2;
        SharedSQLiteStatement sharedSQLiteStatement3;
        SharedSQLiteStatement sharedSQLiteStatement4;
        SharedSQLiteStatement sharedSQLiteStatement5;
        SharedSQLiteStatement sharedSQLiteStatement6;
        SharedSQLiteStatement sharedSQLiteStatement7;
        EntityDeletionOrUpdateAdapter<WatchPartyStatus> entityDeletionOrUpdateAdapter;
        EntityInsertionAdapter<WatchPartyStatus> entityInsertionAdapter;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<WatchPartyStatus>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `WatchPartyStatus` (`chatId`,`participantStatuses`,`isPrivate`,`isParticipated`,`type`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WatchPartyStatus watchPartyStatus) {
                if (watchPartyStatus.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, watchPartyStatus.getChatId());
                }
                String string2 = WatchPartyDao_Impl.this.__converters.participantStatusesToString(watchPartyStatus.getParticipantStatuses());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                long l = (long)watchPartyStatus.isPrivate();
                supportSQLiteStatement.bindLong(3, l);
                l = (long)watchPartyStatus.isParticipated();
                supportSQLiteStatement.bindLong(4, l);
                if (watchPartyStatus.getType() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, WatchPartyDao_Impl.this.__WatchPartyType_enumToString(watchPartyStatus.getType()));
                }
            }
        };
        this.__insertionAdapterOfWatchPartyStatus = converters2;
        converters2 = entityDeletionOrUpdateAdapter;
        entityDeletionOrUpdateAdapter = new EntityDeletionOrUpdateAdapter<WatchPartyStatus>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `WatchPartyStatus` SET `chatId` = ?,`participantStatuses` = ?,`isPrivate` = ?,`isParticipated` = ?,`type` = ? WHERE `chatId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WatchPartyStatus watchPartyStatus) {
                if (watchPartyStatus.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, watchPartyStatus.getChatId());
                }
                String string2 = WatchPartyDao_Impl.this.__converters.participantStatusesToString(watchPartyStatus.getParticipantStatuses());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                long l = (long)watchPartyStatus.isPrivate();
                supportSQLiteStatement.bindLong(3, l);
                l = (long)watchPartyStatus.isParticipated();
                supportSQLiteStatement.bindLong(4, l);
                if (watchPartyStatus.getType() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, WatchPartyDao_Impl.this.__WatchPartyType_enumToString(watchPartyStatus.getType()));
                }
                if (watchPartyStatus.getChatId() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, watchPartyStatus.getChatId());
                }
            }
        };
        this.__updateAdapterOfWatchPartyStatus = converters2;
        converters2 = sharedSQLiteStatement7;
        sharedSQLiteStatement7 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE WatchPartyStatus SET isParticipated=1 WHERE WatchPartyStatus.chatId = ?";
            }
        };
        this.__preparedStmtOfUpdateWatchPartyStatusParticipated = converters2;
        converters2 = sharedSQLiteStatement6;
        sharedSQLiteStatement6 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM WatchPartyStatus WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteWatchPartyStatus = converters2;
        converters2 = sharedSQLiteStatement5;
        sharedSQLiteStatement5 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Topic WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteTopic = converters2;
        converters2 = sharedSQLiteStatement4;
        sharedSQLiteStatement4 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatParticipantCrossRef WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteChatParticipantCrossRef = converters2;
        converters2 = sharedSQLiteStatement3;
        sharedSQLiteStatement3 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatOwnerCrossRef WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteChatOwnerCrossRef = converters2;
        converters2 = sharedSQLiteStatement2;
        sharedSQLiteStatement2 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE WatchPartyStatus SET isPrivate=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfSetWatchPartyPrivate = converters2;
        converters2 = sharedSQLiteStatement;
        sharedSQLiteStatement = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE WatchPartyStatus SET isPrivate=1 WHERE type =? AND isParticipated=0";
            }
        };
        this.__preparedStmtOfHidePublicWatchParties = converters2;
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private String __WatchPartyType_enumToString(WatchPartyType watchPartyType) {
        if (watchPartyType == null) {
            return null;
        }
        int n = 27.$SwitchMap$io$streamlayer$sdk$model$calls$WatchPartyType[watchPartyType.ordinal()];
        if (n != 1) {
            if (n == 2) {
                return "REGULAR";
            }
            throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + (Object)((Object)watchPartyType));
        }
        return "PUBLIC";
    }

    private WatchPartyType __WatchPartyType_stringToEnum(String string2) {
        if (string2 == null) {
            return null;
        }
        if (!string2.equals("PUBLIC")) {
            if (string2.equals("REGULAR")) {
                return WatchPartyType.REGULAR;
            }
            throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + string2);
        }
        return WatchPartyType.PUBLIC;
    }

    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact(ArrayMap<String, TinodeContact> arrayMap) {
        int n;
        Set set = arrayMap.keySet();
        if (set.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n2 = 0;
            int n3 = arrayMap.size();
            for (int i = 0; i < n3; ++i) {
                ArrayMap arrayMap3;
                set.put((String)arrayMap.keyAt(i), null);
                if (++n2 != 999) continue;
                watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set);
                arrayMap.putAll((Map)((Object)set));
                set = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n2 = 0;
            }
            if (n2 > 0) {
                watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set);
                arrayMap.putAll((Map)((Object)set));
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,_junction.`chatId` FROM `ChatOwnerCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        int n4 = set.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
        int n5 = 1;
        for (String string2 : set) {
            if (string2 == null) {
                roomSQLiteQuery.bindNull(n5);
            } else {
                roomSQLiteQuery.bindString(n5, string2);
            }
            ++n5;
        }
        WatchPartyDao_Impl watchPartyDao_Impl = DBUtil.query((RoomDatabase)watchPartyDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"chatUserId");
        n5 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"externalId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"chatName");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"online");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"photoData");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"privateData");
        }
        catch (Throwable throwable) {
            watchPartyDao_Impl.close();
            throw throwable;
        }
        while (true) {
            TinodeContact tinodeContact;
            String string3;
            String string4;
            boolean bl;
            String string5;
            String string6;
            String string7;
            Object object;
            block40: {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block31: {
                                                    if (!watchPartyDao_Impl.moveToNext()) break;
                                                    ArrayMap<String, TinodeContact> arrayMap4 = arrayMap;
                                                    object = watchPartyDao_Impl.getString(6);
                                                    if (!arrayMap4.containsKey(object)) continue;
                                                    if (!watchPartyDao_Impl.isNull(n6)) break block31;
                                                    string7 = null;
                                                    break block32;
                                                }
                                                string7 = watchPartyDao_Impl.getString(n6);
                                            }
                                            if (!watchPartyDao_Impl.isNull(n5)) break block33;
                                            string6 = null;
                                            break block34;
                                        }
                                        string6 = watchPartyDao_Impl.getString(n5);
                                    }
                                    if (!watchPartyDao_Impl.isNull(n7)) break block35;
                                    string5 = null;
                                    break block36;
                                }
                                string5 = watchPartyDao_Impl.getString(n7);
                            }
                            bl = watchPartyDao_Impl.getInt(n8) != 0;
                            if (!watchPartyDao_Impl.isNull(n9)) break block37;
                            string4 = null;
                            break block38;
                        }
                        string4 = watchPartyDao_Impl.getString(n9);
                    }
                    if (!watchPartyDao_Impl.isNull(n)) break block39;
                    string3 = null;
                    break block40;
                }
                string3 = watchPartyDao_Impl.getString(n);
            }
            ArrayMap<String, TinodeContact> arrayMap5 = arrayMap;
            String string8 = object;
            object = tinodeContact;
            tinodeContact = new TinodeContact(string7, string6, string5, bl, string4, string3);
            arrayMap5.put((Object)string8, object);
        }
        watchPartyDao_Impl.close();
        return;
    }

    private void __fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus(ArrayMap<String, WatchPartyStatus> arrayMap) {
        int n;
        int n2;
        RoomSQLiteQuery roomSQLiteQuery;
        block27: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n3 = 0;
                int n4 = arrayMap.size();
                for (int i = 0; i < n4; ++i) {
                    ArrayMap arrayMap3;
                    set.put((String)arrayMap.keyAt(i), null);
                    if (++n3 != 999) continue;
                    this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)set);
                    arrayMap.putAll((Map)((Object)set));
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)set);
                    arrayMap.putAll((Map)((Object)set));
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatId`,`participantStatuses`,`isPrivate`,`isParticipated`,`type` FROM `WatchPartyStatus` WHERE `chatId` IN (");
            int n5 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
            n2 = 1;
            for (String string2 : set) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                ++n2;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatId");
            if (n2 != -1) break block27;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery2;
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery2, (String)"chatId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery4, (String)"participantStatuses");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery5, (String)"isPrivate");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery6, (String)"isParticipated");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery3, (String)"type");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            Object object;
            String string3;
            Object object2;
            block31: {
                block30: {
                    block29: {
                        block28: {
                            if (!roomSQLiteQuery.moveToNext()) break;
                            ArrayMap<String, WatchPartyStatus> arrayMap4 = arrayMap;
                            object2 = roomSQLiteQuery.getString(n2);
                            if (!arrayMap4.containsKey(object2)) continue;
                            if (!roomSQLiteQuery.isNull(n6)) break block28;
                            string3 = null;
                            break block29;
                        }
                        string3 = roomSQLiteQuery.getString(n6);
                    }
                    if (!roomSQLiteQuery.isNull(n7)) break block30;
                    object = null;
                    break block31;
                }
                object = roomSQLiteQuery.getString(n7);
            }
            RoomSQLiteQuery roomSQLiteQuery7 = roomSQLiteQuery;
            int n10 = n8;
            object = this.__converters.stringToParticipantStatuses((String)object);
            boolean bl = roomSQLiteQuery7.getInt(n10) != 0;
            boolean bl2 = roomSQLiteQuery.getInt(n9) != 0;
            ArrayMap<String, WatchPartyStatus> arrayMap5 = arrayMap;
            String string4 = object2;
            object2 = this.__WatchPartyType_stringToEnum(roomSQLiteQuery.getString(n));
            arrayMap5.put((Object)string4, (Object)new WatchPartyStatus(string3, (List<WatchPartyParticipantStatus>)object, bl, bl2, (WatchPartyType)((Object)object2)));
        }
        roomSQLiteQuery.close();
        return;
    }

    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1(ArrayMap<String, ArrayList<TinodeContact>> arrayMap) {
        int n;
        Set set = arrayMap.keySet();
        if (set.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n2 = 0;
            int n3 = arrayMap.size();
            for (int i = 0; i < n3; ++i) {
                ArrayMap arrayMap3;
                String string2 = (String)arrayMap.keyAt(i);
                set.put(string2, (ArrayList)arrayMap.valueAt(i));
                if (++n2 != 999) continue;
                watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set);
                set = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n2 = 0;
            }
            if (n2 > 0) {
                watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,_junction.`chatId` FROM `ChatParticipantCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        int n4 = set.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
        int n5 = 1;
        for (String string3 : set) {
            if (string3 == null) {
                roomSQLiteQuery.bindNull(n5);
            } else {
                roomSQLiteQuery.bindString(n5, string3);
            }
            ++n5;
        }
        WatchPartyDao_Impl watchPartyDao_Impl = DBUtil.query((RoomDatabase)watchPartyDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"chatUserId");
        n5 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"externalId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"chatName");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"online");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"photoData");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)watchPartyDao_Impl, (String)"privateData");
        }
        catch (Throwable throwable) {
            watchPartyDao_Impl.close();
            throw throwable;
        }
        while (true) {
            String string4;
            String string5;
            boolean bl;
            String string6;
            String string7;
            String string8;
            ArrayList arrayList;
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        block31: {
                                            block30: {
                                                block29: {
                                                    if (!watchPartyDao_Impl.moveToNext()) break;
                                                    arrayList = (ArrayList)arrayMap.get((Object)watchPartyDao_Impl.getString(6));
                                                    if (arrayList == null) continue;
                                                    if (!watchPartyDao_Impl.isNull(n6)) break block29;
                                                    string8 = null;
                                                    break block30;
                                                }
                                                string8 = watchPartyDao_Impl.getString(n6);
                                            }
                                            if (!watchPartyDao_Impl.isNull(n5)) break block31;
                                            string7 = null;
                                            break block32;
                                        }
                                        string7 = watchPartyDao_Impl.getString(n5);
                                    }
                                    if (!watchPartyDao_Impl.isNull(n7)) break block33;
                                    string6 = null;
                                    break block34;
                                }
                                string6 = watchPartyDao_Impl.getString(n7);
                            }
                            bl = watchPartyDao_Impl.getInt(n8) != 0;
                            if (!watchPartyDao_Impl.isNull(n9)) break block35;
                            string5 = null;
                            break block36;
                        }
                        string5 = watchPartyDao_Impl.getString(n9);
                    }
                    if (!watchPartyDao_Impl.isNull(n)) break block37;
                    string4 = null;
                    break block38;
                }
                string4 = watchPartyDao_Impl.getString(n);
            }
            arrayList.add(new TinodeContact(string8, string7, string6, bl, string5, string4));
        }
        watchPartyDao_Impl.close();
        return;
    }

    private void __fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage(ArrayMap<String, ArrayList<ChatMessage>> arrayMap) {
        int n;
        int n2;
        RoomSQLiteQuery roomSQLiteQuery;
        block45: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n3 = 0;
                int n4 = arrayMap.size();
                for (int i = 0; i < n4; ++i) {
                    ArrayMap arrayMap3;
                    String string2 = (String)arrayMap.keyAt(i);
                    set.put(string2, (ArrayList)arrayMap.valueAt(i));
                    if (++n3 != 999) continue;
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatMessageTopicId`,`senderUserId`,`remoteSeqId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`,`uuid` FROM `ChatMessage` WHERE `chatMessageTopicId` IN (");
            int n5 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
            n2 = 1;
            for (String string3 : set) {
                if (string3 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string3);
                }
                ++n2;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatMessageTopicId");
            if (n2 != -1) break block45;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery7 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery8 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery9 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery10 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery11 = roomSQLiteQuery2;
        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery2, (String)"chatMessageTopicId");
        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery9, (String)"senderUserId");
        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery10, (String)"remoteSeqId");
        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery11, (String)"date");
        int n10 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery7, (String)"text");
        int n11 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery8, (String)"type");
        int n12 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery5, (String)"subtype");
        int n13 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery6, (String)"replyTo");
        int n14 = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery3, (String)"status");
        try {
            n = CursorUtil.getColumnIndexOrThrow((Cursor)roomSQLiteQuery4, (String)"uuid");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            ChatMessage chatMessage;
            String string4;
            ArrayList arrayList;
            block63: {
                block62: {
                    ChatMessage chatMessage2;
                    Object object;
                    String string5;
                    String string6;
                    String string7;
                    String string8;
                    Comparable<Long> comparable;
                    int n15;
                    String string9;
                    block61: {
                        block60: {
                            block59: {
                                block58: {
                                    block57: {
                                        block56: {
                                            block55: {
                                                block54: {
                                                    block53: {
                                                        block52: {
                                                            block51: {
                                                                block50: {
                                                                    block49: {
                                                                        block48: {
                                                                            block47: {
                                                                                block46: {
                                                                                    if (!roomSQLiteQuery.moveToNext()) break;
                                                                                    arrayList = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(n2));
                                                                                    if (arrayList == null) continue;
                                                                                    if (!roomSQLiteQuery.isNull(n6)) break block46;
                                                                                    string4 = null;
                                                                                    break block47;
                                                                                }
                                                                                string4 = roomSQLiteQuery.getString(n6);
                                                                            }
                                                                            if (!roomSQLiteQuery.isNull(n7)) break block48;
                                                                            string9 = null;
                                                                            break block49;
                                                                        }
                                                                        string9 = roomSQLiteQuery.getString(n7);
                                                                    }
                                                                    RoomSQLiteQuery roomSQLiteQuery12 = roomSQLiteQuery;
                                                                    int n16 = n9;
                                                                    n15 = roomSQLiteQuery.getInt(n8);
                                                                    if (!roomSQLiteQuery12.isNull(n16)) break block50;
                                                                    comparable = null;
                                                                    break block51;
                                                                }
                                                                comparable = roomSQLiteQuery.getLong(n9);
                                                            }
                                                            RoomSQLiteQuery roomSQLiteQuery13 = roomSQLiteQuery;
                                                            int n17 = n10;
                                                            comparable = this.__converters.timestampToDate((Long)comparable);
                                                            if (!roomSQLiteQuery13.isNull(n17)) break block52;
                                                            string8 = null;
                                                            break block53;
                                                        }
                                                        string8 = roomSQLiteQuery.getString(n10);
                                                    }
                                                    if (!roomSQLiteQuery.isNull(n11)) break block54;
                                                    string7 = null;
                                                    break block55;
                                                }
                                                string7 = roomSQLiteQuery.getString(n11);
                                            }
                                            if (!roomSQLiteQuery.isNull(n12)) break block56;
                                            string6 = null;
                                            break block57;
                                        }
                                        string6 = roomSQLiteQuery.getString(n12);
                                    }
                                    if (!roomSQLiteQuery.isNull(n13)) break block58;
                                    string5 = null;
                                    break block59;
                                }
                                string5 = roomSQLiteQuery.getString(n13);
                            }
                            if (!roomSQLiteQuery.isNull(n14)) break block60;
                            object = null;
                            break block61;
                        }
                        object = roomSQLiteQuery.getString(n14);
                    }
                    RoomSQLiteQuery roomSQLiteQuery14 = roomSQLiteQuery;
                    int n18 = n;
                    object = this.__converters.stringToChatStatus((String)object);
                    chatMessage = chatMessage2;
                    chatMessage2 = new ChatMessage(string4, string9, n15, (Date)comparable, string8, string7, string6, string5, (ChatMessageStatus)((Object)object));
                    if (!roomSQLiteQuery14.isNull(n18)) break block62;
                    string4 = null;
                    break block63;
                }
                string4 = roomSQLiteQuery.getString(n);
            }
            ChatMessage chatMessage3 = chatMessage;
            chatMessage3.setId(string4);
            arrayList.add(chatMessage3);
        }
        roomSQLiteQuery.close();
        return;
    }

    static /* synthetic */ void access$1300(WatchPartyDao_Impl watchPartyDao_Impl, ArrayMap arrayMap) {
        watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)arrayMap);
    }

    static /* synthetic */ void access$1400(WatchPartyDao_Impl watchPartyDao_Impl, ArrayMap arrayMap) {
        watchPartyDao_Impl.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)arrayMap);
    }

    static /* synthetic */ void access$1500(WatchPartyDao_Impl watchPartyDao_Impl, ArrayMap arrayMap) {
        watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)arrayMap);
    }

    static /* synthetic */ void access$1600(WatchPartyDao_Impl watchPartyDao_Impl, ArrayMap arrayMap) {
        watchPartyDao_Impl.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)arrayMap);
    }

    @Override
    public Object saveWatchPartyStatus(final WatchPartyStatus watchPartyStatus, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                Unit unit;
                10 v0 = this;
                v0.WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    v0.WatchPartyDao_Impl.this.__insertionAdapterOfWatchPartyStatus.insert((Object)watchPartyStatus);
                    v0.WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    WatchPartyDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object updateWatchPartyStatus(final WatchPartyStatus watchPartyStatus, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                11 v0 = this;
                v0.WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    v0.WatchPartyDao_Impl.this.__updateAdapterOfWatchPartyStatus.handle((Object)watchPartyStatus);
                }
                catch (Throwable throwable) {
                    WatchPartyDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                v0.WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                WatchPartyDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteWatchParty(final String string2, Continuation<? super Unit> continuation) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> continuation) {
                return WatchPartyDao.DefaultImpls.deleteWatchParty(WatchPartyDao_Impl.this, string2, continuation);
            }
        }, continuation);
    }

    @Override
    public Object updateWatchPartyStatusParticipated(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                13 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfUpdateWatchPartyStatusParticipated.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    13 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfUpdateWatchPartyStatusParticipated.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                13 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfUpdateWatchPartyStatusParticipated.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteWatchPartyStatus(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                14 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteWatchPartyStatus.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    14 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteWatchPartyStatus.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                14 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteWatchPartyStatus.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteTopic(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                15 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteTopic.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    15 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteTopic.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                15 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteTopic.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteChatParticipantCrossRef(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                16 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantCrossRef.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    16 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantCrossRef.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                16 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantCrossRef.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteChatOwnerCrossRef(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                17 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatOwnerCrossRef.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    17 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatOwnerCrossRef.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                17 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatOwnerCrossRef.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object setWatchPartyPrivate(final String string2, final boolean bl, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                18 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfSetWatchPartyPrivate.acquire();
                supportSQLiteStatement.bindLong(1, (long)bl);
                int n = 2;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    18 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfSetWatchPartyPrivate.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                18 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfSetWatchPartyPrivate.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object hidePublicWatchParties(final WatchPartyType watchPartyType, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                19 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfHidePublicWatchParties.acquire();
                int n = 1;
                WatchPartyType watchPartyType2 = v0.watchPartyType;
                if (watchPartyType2 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, WatchPartyDao_Impl.this.__WatchPartyType_enumToString(watchPartyType2));
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    19 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfHidePublicWatchParties.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                19 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfHidePublicWatchParties.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Flow<WatchPartyStatus> observeWatchPartyStatus(String stringArray) {
        Callable<WatchPartyStatus> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WatchPartyStatus WHERE WatchPartyStatus.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = "WatchPartyStatus";
        Callable<WatchPartyStatus> callable2 = callable;
        callable = new Callable<WatchPartyStatus>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public WatchPartyStatus call() throws Exception {
                WatchPartyStatus watchPartyStatus;
                Cursor cursor;
                block26: {
                    block19: {
                        void var5_13;
                        void var4_9;
                        WatchPartyStatus watchPartyStatus2;
                        Object object;
                        String string2;
                        int n;
                        Object object2;
                        block25: {
                            int n2;
                            block24: {
                                int bl2;
                                block23: {
                                    int n22;
                                    block22: {
                                        block21: {
                                            int n3;
                                            block20: {
                                                cursor = DBUtil.query((RoomDatabase)object2.WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)object2.roomSQLiteQuery, (boolean)false, null);
                                                try {
                                                    n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatId");
                                                }
                                                catch (Throwable throwable) {
                                                    cursor.close();
                                                    throw throwable;
                                                }
                                                n22 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"participantStatuses");
                                                bl2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPrivate");
                                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isParticipated");
                                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
                                                if (!cursor.moveToFirst()) break block19;
                                                if (!cursor.isNull(n3)) break block20;
                                                string2 = null;
                                                break block21;
                                            }
                                            string2 = cursor.getString(n3);
                                        }
                                        if (!cursor.isNull(n22)) break block22;
                                        object = null;
                                        break block23;
                                    }
                                    object = cursor.getString(n22);
                                }
                                Cursor cursor2 = cursor;
                                int n3 = bl2;
                                object = object2.WatchPartyDao_Impl.this.__converters.stringToParticipantStatuses((String)object);
                                if (cursor2.getInt(n3) != 0) {
                                    boolean bl = true;
                                    break block24;
                                }
                                boolean bl = false;
                            }
                            if (cursor.getInt(n2) != 0) {
                                boolean bl = true;
                                break block25;
                            }
                            boolean bl = false;
                        }
                        object2 = object2.WatchPartyDao_Impl.this.__WatchPartyType_stringToEnum(cursor.getString(n));
                        watchPartyStatus = watchPartyStatus2;
                        watchPartyStatus2 = new WatchPartyStatus(string2, (List<WatchPartyParticipantStatus>)object, (boolean)var4_9, (boolean)var5_13, (WatchPartyType)((Object)object2));
                        break block26;
                    }
                    watchPartyStatus = null;
                }
                cursor.close();
                return watchPartyStatus;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Object getWatchPartyStatus(String string2, Continuation<? super WatchPartyStatus> continuation) {
        Callable<WatchPartyStatus> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WatchPartyStatus WHERE WatchPartyStatus.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<WatchPartyStatus> callable2 = callable;
        callable = new Callable<WatchPartyStatus>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public WatchPartyStatus call() throws Exception {
                WatchPartyStatus watchPartyStatus;
                Cursor cursor;
                block26: {
                    block19: {
                        void var5_13;
                        void var4_9;
                        WatchPartyStatus watchPartyStatus2;
                        Object object;
                        String string2;
                        int n;
                        block25: {
                            int n2;
                            block24: {
                                int bl2;
                                block23: {
                                    int n22;
                                    block22: {
                                        block21: {
                                            int n3;
                                            block20: {
                                                cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                try {
                                                    n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatId");
                                                }
                                                catch (Throwable throwable) {
                                                    cursor.close();
                                                    roomSQLiteQuery.release();
                                                    throw throwable;
                                                }
                                                n22 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"participantStatuses");
                                                bl2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPrivate");
                                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isParticipated");
                                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
                                                if (!cursor.moveToFirst()) break block19;
                                                if (!cursor.isNull(n3)) break block20;
                                                string2 = null;
                                                break block21;
                                            }
                                            string2 = cursor.getString(n3);
                                        }
                                        if (!cursor.isNull(n22)) break block22;
                                        object = null;
                                        break block23;
                                    }
                                    object = cursor.getString(n22);
                                }
                                Cursor cursor2 = cursor;
                                int n3 = bl2;
                                object = WatchPartyDao_Impl.this.__converters.stringToParticipantStatuses((String)object);
                                if (cursor2.getInt(n3) != 0) {
                                    boolean bl = true;
                                    break block24;
                                }
                                boolean bl = false;
                            }
                            if (cursor.getInt(n2) != 0) {
                                boolean bl = true;
                                break block25;
                            }
                            boolean bl = false;
                        }
                        WatchPartyType watchPartyType = WatchPartyDao_Impl.this.__WatchPartyType_stringToEnum(cursor.getString(n));
                        watchPartyStatus = watchPartyStatus2;
                        watchPartyStatus2 = new WatchPartyStatus(string2, (List<WatchPartyParticipantStatus>)object, (boolean)var4_9, (boolean)var5_13, watchPartyType);
                        break block26;
                    }
                    watchPartyStatus = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return watchPartyStatus;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object getWatchPartyRelation(String string2, Continuation<? super WatchPartyRelation> continuation) {
        Callable<WatchPartyRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<WatchPartyRelation> callable2 = callable;
        callable = new Callable<WatchPartyRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public WatchPartyRelation call() throws Exception {
                block111: {
                    block89: {
                        block91: {
                            block110: {
                                block93: {
                                    block109: {
                                        block108: {
                                            block103: {
                                                block107: {
                                                    block106: {
                                                        block105: {
                                                            block104: {
                                                                block102: {
                                                                    block101: {
                                                                        block100: {
                                                                            block99: {
                                                                                block98: {
                                                                                    block97: {
                                                                                        block96: {
                                                                                            block95: {
                                                                                                block94: {
                                                                                                    block92: {
                                                                                                        block90: {
                                                                                                            var1_1 = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.access$200(WatchPartyDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                                                            var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                                                            var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                                                            var4_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                                                            var5_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                                                            var6_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                                                            var7_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                                                            var8_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                                                            var9_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"isWPTopic");
                                                                                                            var10_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                                                            var11_20 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                                                            var12_22 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                                                            var13_25 = v0;
                                                                                                            v0 = new ArrayMap();
                                                                                                            var14_26 = v1;
                                                                                                            v1 = new ArrayMap();
                                                                                                            var15_27 = v2;
                                                                                                            v2 = new ArrayMap();
                                                                                                            var16_28 = v3;
                                                                                                            try {
                                                                                                                v3 = new ArrayMap();
                                                                                                                ** while (var1_1.moveToNext())
                                                                                                            }
                                                                                                            catch (Throwable v4) {
                                                                                                                var1_1.close();
                                                                                                                roomSQLiteQuery.release();
                                                                                                                throw v4;
                                                                                                            }
lbl-1000:
                                                                                                            // 1 sources

                                                                                                            {
                                                                                                                block88: {
                                                                                                                    v5 = var15_27;
                                                                                                                    v6 = var1_1;
                                                                                                                    v7 = var2_2;
                                                                                                                    v8 = var14_26;
                                                                                                                    v9 = var1_1;
                                                                                                                    v10 = var2_2;
                                                                                                                    var13_25.put((Object)var1_1.getString(var2_2), null);
                                                                                                                    v8.put((Object)v9.getString(v10), null);
                                                                                                                    var17_29 = v6.getString(v7);
                                                                                                                    if ((ArrayList)v5.get(var17_29) != null) break block88;
                                                                                                                    v11 = var15_27;
                                                                                                                    v12 = var17_29;
                                                                                                                    var17_29 = v13;
                                                                                                                    v13 = new ArrayList<E>();
                                                                                                                    v11.put((Object)v12, var17_29);
                                                                                                                }
                                                                                                                v14 = var16_28;
                                                                                                                var17_29 = var1_1.getString(var2_2);
                                                                                                                if ((ArrayList)v14.get(var17_29) != null) continue;
                                                                                                                v15 = var16_28;
                                                                                                                v16 = var17_29;
                                                                                                                var17_29 = v17;
                                                                                                                v17 = new ArrayList<E>();
                                                                                                                v15.put(v16, var17_29);
                                                                                                                continue;
                                                                                                            }
lbl81:
                                                                                                            // 2 sources

                                                                                                            v18 = var1_1;
                                                                                                            v19 = this;
                                                                                                            v20 = v19;
                                                                                                            v21 = v19;
                                                                                                            v22 = v19;
                                                                                                            v23 = v19;
                                                                                                            var1_1.moveToPosition(-1);
                                                                                                            WatchPartyDao_Impl.access$1300(v20.WatchPartyDao_Impl.this, var13_25);
                                                                                                            WatchPartyDao_Impl.access$1400(v21.WatchPartyDao_Impl.this, var14_26);
                                                                                                            WatchPartyDao_Impl.access$1500(v22.WatchPartyDao_Impl.this, var15_27);
                                                                                                            WatchPartyDao_Impl.access$1600(v23.WatchPartyDao_Impl.this, var16_28);
                                                                                                            if (!v18.moveToFirst()) break block89;
                                                                                                            if (!var1_1.isNull(var2_2)) break block90;
                                                                                                            if (!var1_1.isNull(var3_4)) break block90;
                                                                                                            if (!var1_1.isNull(var4_6)) break block90;
                                                                                                            if (!var1_1.isNull(var5_9)) break block90;
                                                                                                            if (!var1_1.isNull(var6_12)) break block90;
                                                                                                            if (!var1_1.isNull(var7_14)) break block90;
                                                                                                            if (!var1_1.isNull(var8_16)) break block90;
                                                                                                            if (!var1_1.isNull((int)var9_18)) break block90;
                                                                                                            if (!var1_1.isNull(var10_19)) break block90;
                                                                                                            if (!var1_1.isNull(var11_20)) break block90;
                                                                                                            if (!var1_1.isNull(var12_22)) break block90;
                                                                                                            var3_5 = null;
                                                                                                            break block91;
                                                                                                        }
                                                                                                        if (!var1_1.isNull(var2_2)) break block92;
                                                                                                        if (!var1_1.isNull(var3_4)) break block92;
                                                                                                        if (!var1_1.isNull(var4_6)) break block92;
                                                                                                        if (!var1_1.isNull(var5_9)) break block92;
                                                                                                        if (!var1_1.isNull(var6_12)) break block92;
                                                                                                        if (!var1_1.isNull(var7_14)) break block92;
                                                                                                        if (!var1_1.isNull(var8_16)) break block92;
                                                                                                        if (!var1_1.isNull((int)var9_18)) break block92;
                                                                                                        if (!var1_1.isNull(var10_19)) break block92;
                                                                                                        if (!var1_1.isNull(var11_20)) break block92;
                                                                                                        if (!var1_1.isNull(var12_22)) break block92;
                                                                                                        var3_5 = null;
                                                                                                        break block93;
                                                                                                    }
                                                                                                    if (!var1_1.isNull(var2_2)) break block94;
                                                                                                    var17_29 = null;
                                                                                                    break block95;
                                                                                                }
                                                                                                var17_29 = var1_1.getString(var2_2);
                                                                                            }
                                                                                            if (!var1_1.isNull(var3_4)) break block96;
                                                                                            var3_5 = null;
                                                                                            break block97;
                                                                                        }
                                                                                        var3_5 = var1_1.getString(var3_4);
                                                                                    }
                                                                                    v24 = var1_1;
                                                                                    v25 = var7_14;
                                                                                    v26 = var1_1;
                                                                                    v27 = var6_12;
                                                                                    v28 = var1_1;
                                                                                    v29 = var5_9;
                                                                                    var4_6 = var1_1.getInt(var4_6);
                                                                                    var5_9 = v28.getInt(v29);
                                                                                    var6_12 = v26.getInt(v27);
                                                                                    if (!v24.isNull(v25)) break block98;
                                                                                    var7_15 /* !! */  = null;
                                                                                    break block99;
                                                                                }
                                                                                var7_15 /* !! */  = var1_1.getLong(var7_14);
                                                                            }
                                                                            v30 = var1_1;
                                                                            v31 = var8_16;
                                                                            var7_15 /* !! */  = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var7_15 /* !! */ );
                                                                            if (!v30.isNull(v31)) break block100;
                                                                            var8_17 /* !! */  = null;
                                                                            break block101;
                                                                        }
                                                                        var8_17 /* !! */  = var1_1.getLong(var8_16);
                                                                    }
                                                                    v32 = var1_1;
                                                                    v33 = var9_18;
                                                                    var8_17 /* !! */  = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var8_17 /* !! */ );
                                                                    var9_18 = v32.getInt((int)v33) != 0;
                                                                    if (!var1_1.isNull(var11_20)) break block102;
                                                                    if (!var1_1.isNull(var12_22)) break block102;
                                                                    var11_21 = null;
                                                                    break block103;
                                                                }
                                                                if (!var1_1.isNull(var11_20)) break block104;
                                                                var11_21 = null;
                                                                break block105;
                                                            }
                                                            var11_21 = var1_1.getString(var11_20);
                                                        }
                                                        if (!var1_1.isNull(var12_22)) break block106;
                                                        var12_23 = null;
                                                        break block107;
                                                    }
                                                    var12_23 = var1_1.getString(var12_22);
                                                }
                                                var18_30 = v34;
                                                v34 = new Access((String)var11_21, var12_23);
                                                var11_21 = var18_30;
                                            }
                                            v35 = var1_1;
                                            v36 = var10_19;
                                            var12_24 = v37;
                                            v37 = new Topic((String)var17_29, (String)var3_5, var4_6, var5_9, var6_12, (Date)var7_15 /* !! */ , (Date)var8_17 /* !! */ , var9_18, (Access)var11_21);
                                            if (!v35.isNull(v36)) break block108;
                                            var3_5 = null;
                                            break block109;
                                        }
                                        var3_5 = var1_1.getString(var10_19);
                                    }
                                    var12_24.setWatchPartyStreamId((String)var3_5);
                                    var3_5 = var12_24;
                                }
                                var4_7 = (ArrayList)var15_27.get((Object)var1_1.getString(var2_2));
                                if (var4_7 != null) ** GOTO lbl250
                                var4_7 = v38;
                                v38 = new ArrayList<E>();
lbl250:
                                // 2 sources

                                if ((var5_10 = (ArrayList)var16_28.get((Object)var1_1.getString(var2_2))) != null) break block110;
                                var5_10 = v39;
                                v39 = new ArrayList<E>();
                            }
                            var6_13 = v40;
                            v40 = new ChatRelation((Topic)var3_5, var4_7, var5_10);
                            var3_5 = var6_13;
                        }
                        v41 = var14_26;
                        v42 = var1_1;
                        v43 = var2_2;
                        var2_3 = (TinodeContact)var13_25.get((Object)var1_1.getString(var2_2));
                        var4_8 = (WatchPartyStatus)v41.get((Object)v42.getString(v43));
                        var5_11 = v44;
                        v44 = new WatchPartyRelation((ChatRelation)var3_5, var2_3, var4_8);
                        break block111;
                    }
                    var5_11 = null;
                }
                var1_1.close();
                roomSQLiteQuery.release();
                return var5_11;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object getWatchPartyOwner(String string2, Continuation<? super String> continuation) {
        Callable<String> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT ChatOwnerCrossRef.chatUserId FROM ChatOwnerCrossRef WHERE ChatOwnerCrossRef.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<String> callable2 = callable;
        callable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String string2;
                Cursor cursor;
                block5: {
                    block4: {
                        cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                        try {
                            if (!cursor.moveToFirst()) break block4;
                        }
                        catch (Throwable throwable) {
                            cursor.close();
                            roomSQLiteQuery.release();
                            throw throwable;
                        }
                        if (cursor.isNull(0)) break block4;
                        string2 = cursor.getString(0);
                        break block5;
                    }
                    string2 = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return string2;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object isParticipatedInPublicParty(String string2, Continuation<? super Boolean> continuation) {
        Callable<Boolean> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT WatchPartyStatus.isParticipated FROM WatchPartyStatus WHERE WatchPartyStatus.chatId =?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<Boolean> callable2 = callable;
        callable = new Callable<Boolean>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Boolean call() throws Exception {
                void var2_10;
                Cursor cursor;
                block12: {
                    block8: {
                        void var2_4;
                        block10: {
                            block9: {
                                cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                try {
                                    if (!cursor.moveToFirst()) break block8;
                                }
                                catch (Throwable throwable) {
                                    cursor.close();
                                    roomSQLiteQuery.release();
                                    throw throwable;
                                }
                                if (!cursor.isNull(0)) break block9;
                                Object var2_2 = null;
                                break block10;
                            }
                            Integer n = cursor.getInt(0);
                        }
                        if (var2_4 != null) {
                            void var2_7;
                            block11: {
                                if (var2_4.intValue() != 0) {
                                    boolean bl = true;
                                    break block11;
                                }
                                boolean bl = false;
                            }
                            Boolean bl = (boolean)var2_7;
                            break block12;
                        }
                    }
                    Object var2_9 = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return var2_10;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Flow<List<WatchPartyRelation>> getWatchPartiesRelation() {
        Callable<List<WatchPartyRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE isWPTopic = 1 ORDER BY Topic.updatedAt DESC", (int)0);
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "ChatOwnerCrossRef";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "WatchPartyStatus";
        stringArray[3] = "ChatParticipantCrossRef";
        stringArray[4] = "ChatMessage";
        stringArray[5] = "Topic";
        Callable<List<WatchPartyRelation>> callable2 = callable;
        callable = new Callable<List<WatchPartyRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<WatchPartyRelation> call() throws Exception {
                v0 = this;
                WatchPartyDao_Impl.access$200(v0.WatchPartyDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.access$200(v0.WatchPartyDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                var4_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                var5_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                var6_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                var7_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                var8_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                var9_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"isWPTopic");
                var10_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                var11_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                var12_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                var13_14 = v1;
                v1 = new ArrayMap();
                var14_15 = v2;
                v2 = new ArrayMap();
                var15_16 = v3;
                v3 = new ArrayMap();
                var16_17 = v4;
                v4 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block94: {
                        v5 = var15_16;
                        v6 = var1_1;
                        v7 = var2_2;
                        v8 = var14_15;
                        v9 = var1_1;
                        v10 = var2_2;
                        var13_14.put((Object)var1_1.getString(var2_2), null);
                        v8.put((Object)v9.getString(v10), null);
                        var17_18 = v6.getString(v7);
                        if ((ArrayList)v5.get(var17_18) != null) break block94;
                        v11 = var15_16;
                        v12 = var17_18;
                        var17_18 = v13;
                        v13 = new ArrayList<E>();
                        v11.put(v12, var17_18);
                    }
                    v14 = var16_17;
                    var17_18 = var1_1.getString(var2_2);
                    if ((ArrayList)v14.get(var17_18) != null) continue;
                    v15 = var16_17;
                    v16 = var17_18;
                    var17_18 = v17;
                    v17 = new ArrayList<E>();
                    v15.put(v16, var17_18);
                    continue;
                }
lbl80:
                // 2 sources

                v18 = this;
                v19 = v18;
                v20 = v18;
                v21 = v18;
                v22 = v18;
                var1_1.moveToPosition(-1);
                WatchPartyDao_Impl.access$1300(v19.WatchPartyDao_Impl.this, var13_14);
                WatchPartyDao_Impl.access$1400(v20.WatchPartyDao_Impl.this, var14_15);
                WatchPartyDao_Impl.access$1500(v21.WatchPartyDao_Impl.this, var15_16);
                WatchPartyDao_Impl.access$1600(v22.WatchPartyDao_Impl.this, var16_17);
                var17_18 = v23;
                v23 = new ArrayList<E>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block96: {
                        block115: {
                            block98: {
                                block114: {
                                    block113: {
                                        block108: {
                                            block112: {
                                                block111: {
                                                    block110: {
                                                        block109: {
                                                            block107: {
                                                                block106: {
                                                                    block105: {
                                                                        block104: {
                                                                            block103: {
                                                                                block102: {
                                                                                    block101: {
                                                                                        block100: {
                                                                                            block99: {
                                                                                                block97: {
                                                                                                    block95: {
                                                                                                        if (!var1_1.isNull(var2_2)) break block95;
                                                                                                        if (!var1_1.isNull(var3_4)) break block95;
                                                                                                        if (!var1_1.isNull(var4_5)) break block95;
                                                                                                        if (!var1_1.isNull(var5_6)) break block95;
                                                                                                        if (!var1_1.isNull(var6_7)) break block95;
                                                                                                        if (!var1_1.isNull(var7_8)) break block95;
                                                                                                        if (!var1_1.isNull(var8_9)) break block95;
                                                                                                        if (!var1_1.isNull(var9_10)) break block95;
                                                                                                        if (!var1_1.isNull(var10_11)) break block95;
                                                                                                        if (!var1_1.isNull(var11_12)) break block95;
                                                                                                        if (!var1_1.isNull(var12_13)) break block95;
                                                                                                        var18_19 = null;
                                                                                                        break block96;
                                                                                                    }
                                                                                                    if (!var1_1.isNull(var2_2)) break block97;
                                                                                                    if (!var1_1.isNull(var3_4)) break block97;
                                                                                                    if (!var1_1.isNull(var4_5)) break block97;
                                                                                                    if (!var1_1.isNull(var5_6)) break block97;
                                                                                                    if (!var1_1.isNull(var6_7)) break block97;
                                                                                                    if (!var1_1.isNull(var7_8)) break block97;
                                                                                                    if (!var1_1.isNull(var8_9)) break block97;
                                                                                                    if (!var1_1.isNull(var9_10)) break block97;
                                                                                                    if (!var1_1.isNull(var10_11)) break block97;
                                                                                                    if (!var1_1.isNull(var11_12)) break block97;
                                                                                                    if (!var1_1.isNull(var12_13)) break block97;
                                                                                                    var18_19 = null;
                                                                                                    break block98;
                                                                                                }
                                                                                                if (!var1_1.isNull(var2_2)) break block99;
                                                                                                var18_19 = null;
                                                                                                break block100;
                                                                                            }
                                                                                            var18_19 = var1_1.getString(var2_2);
                                                                                        }
                                                                                        if (!var1_1.isNull(var3_4)) break block101;
                                                                                        var19_20 = null;
                                                                                        break block102;
                                                                                    }
                                                                                    var19_20 = var1_1.getString(var3_4);
                                                                                }
                                                                                v24 = var1_1;
                                                                                v25 = var7_8;
                                                                                v26 = var1_1;
                                                                                v27 = var6_7;
                                                                                v28 = var1_1;
                                                                                v29 = var5_6;
                                                                                var20_22 = var1_1.getInt(var4_5);
                                                                                var21_24 = v28.getInt(v29);
                                                                                var22_25 = v26.getInt(v27);
                                                                                if (!v24.isNull(v25)) break block103;
                                                                                var23_26 /* !! */  = null;
                                                                                break block104;
                                                                            }
                                                                            var23_26 /* !! */  = var1_1.getLong(var7_8);
                                                                        }
                                                                        v30 = var1_1;
                                                                        v31 = var8_9;
                                                                        var23_26 /* !! */  = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var23_26 /* !! */ );
                                                                        if (!v30.isNull(v31)) break block105;
                                                                        var24_27 /* !! */  = null;
                                                                        break block106;
                                                                    }
                                                                    var24_27 /* !! */  = var1_1.getLong(var8_9);
                                                                }
                                                                v32 = var1_1;
                                                                v33 = var9_10;
                                                                var24_27 /* !! */  = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var24_27 /* !! */ );
                                                                var25_28 = v32.getInt(v33) != 0;
                                                                if (!var1_1.isNull(var11_12)) break block107;
                                                                if (!var1_1.isNull(var12_13)) break block107;
                                                                var26_29 = null;
                                                                break block108;
                                                            }
                                                            if (!var1_1.isNull(var11_12)) break block109;
                                                            var26_29 = null;
                                                            break block110;
                                                        }
                                                        var26_29 = var1_1.getString(var11_12);
                                                    }
                                                    if (!var1_1.isNull(var12_13)) break block111;
                                                    var27_30 = null;
                                                    break block112;
                                                }
                                                var27_30 = var1_1.getString(var12_13);
                                            }
                                            var28_31 = v34;
                                            v34 = new Access((String)var26_29, (String)var27_30);
                                            var26_29 = var28_31;
                                        }
                                        v35 = var1_1;
                                        v36 = var10_11;
                                        var27_30 = v37;
                                        v37 = new Topic((String)var18_19, (String)var19_20, var20_22, var21_24, var22_25, (Date)var23_26 /* !! */ , (Date)var24_27 /* !! */ , var25_28, (Access)var26_29);
                                        if (!v35.isNull(v36)) break block113;
                                        var18_19 = null;
                                        break block114;
                                    }
                                    var18_19 = var1_1.getString(var10_11);
                                }
                                var27_30.setWatchPartyStreamId((String)var18_19);
                                var18_19 = var27_30;
                            }
                            var19_20 = (ArrayList)var15_16.get((Object)var1_1.getString(var2_2));
                            if (var19_20 != null) ** GOTO lbl251
                            var19_20 = v38;
                            v38 = new ArrayList<E>();
lbl251:
                            // 2 sources

                            if ((var20_21 = (ArrayList)var16_17.get((Object)var1_1.getString(var2_2))) != null) break block115;
                            var20_21 = v39;
                            v39 = new ArrayList<E>();
                        }
                        var21_23 = v40;
                        v40 = new ChatRelation((Topic)var18_19, (List<TinodeContact>)var19_20, (List<ChatMessage>)var20_21);
                        var18_19 = var21_23;
                    }
                    v41 = var17_18;
                    v42 = var14_15;
                    v43 = var1_1;
                    v44 = var2_2;
                    var19_20 = (TinodeContact)var13_14.get((Object)var1_1.getString(var2_2));
                    var20_21 = (WatchPartyStatus)v42.get((Object)v43.getString(v44));
                    v41.add(new WatchPartyRelation((ChatRelation)var18_19, (TinodeContact)var19_20, (WatchPartyStatus)var20_21));
                    continue;
                }
lbl274:
                // 2 sources

                v45 = var17_18;
                v46 = this;
                v47 = var1_1;
                WatchPartyDao_Impl.access$200(WatchPartyDao_Impl.this).setTransactionSuccessful();
                v47.close();
                {
                    catch (Throwable v48) {
                        WatchPartyDao_Impl.access$200(WatchPartyDao_Impl.this).endTransaction();
                        throw v48;
                    }
                }
                WatchPartyDao_Impl.access$200(v46.WatchPartyDao_Impl.this).endTransaction();
                return v45;
                catch (Throwable var2_3) {
                    var1_1.close();
                    throw var2_3;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<WatchPartyRelation> observeWatchPartyRelation(String stringArray) {
        Callable<WatchPartyRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[6];
        stringArray = stringArray2;
        stringArray2[0] = "ChatOwnerCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "WatchPartyStatus";
        stringArray2[3] = "ChatParticipantCrossRef";
        stringArray2[4] = "ChatMessage";
        stringArray2[5] = "Topic";
        Callable<WatchPartyRelation> callable2 = callable;
        callable = new Callable<WatchPartyRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public WatchPartyRelation call() throws Exception {
                block111: {
                    block89: {
                        block91: {
                            block110: {
                                block93: {
                                    block109: {
                                        block108: {
                                            block103: {
                                                block107: {
                                                    block106: {
                                                        block105: {
                                                            block104: {
                                                                block102: {
                                                                    block101: {
                                                                        block100: {
                                                                            block99: {
                                                                                block98: {
                                                                                    block97: {
                                                                                        block96: {
                                                                                            block95: {
                                                                                                block94: {
                                                                                                    block92: {
                                                                                                        block90: {
                                                                                                            var1_1 = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.access$200(WatchPartyDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                                                            var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                                                            var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                                                            var4_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                                                            var5_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                                                            var6_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                                                            var7_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                                                            var8_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                                                            var9_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"isWPTopic");
                                                                                                            var10_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                                                            var11_22 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                                                            var12_25 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                                                            var13_27 = v0;
                                                                                                            v0 = new ArrayMap();
                                                                                                            var14_28 = v1;
                                                                                                            v1 = new ArrayMap();
                                                                                                            var15_29 = v2;
                                                                                                            v2 = new ArrayMap();
                                                                                                            var16_30 = v3;
                                                                                                            try {
                                                                                                                v3 = new ArrayMap();
                                                                                                                ** while (var1_1.moveToNext())
                                                                                                            }
                                                                                                            catch (Throwable v4) {
                                                                                                                var1_1.close();
                                                                                                                throw v4;
                                                                                                            }
lbl-1000:
                                                                                                            // 1 sources

                                                                                                            {
                                                                                                                block88: {
                                                                                                                    v5 = var15_29;
                                                                                                                    v6 = var1_1;
                                                                                                                    v7 = var2_2;
                                                                                                                    v8 = var14_28;
                                                                                                                    v9 = var1_1;
                                                                                                                    v10 = var2_2;
                                                                                                                    var13_27.put((Object)var1_1.getString(var2_2), null);
                                                                                                                    v8.put((Object)v9.getString(v10), null);
                                                                                                                    var17_31 = v6.getString(v7);
                                                                                                                    if ((ArrayList)v5.get(var17_31) != null) break block88;
                                                                                                                    v11 = var15_29;
                                                                                                                    v12 = var17_31;
                                                                                                                    var17_31 = v13;
                                                                                                                    v13 = new ArrayList<E>();
                                                                                                                    v11.put((Object)v12, var17_31);
                                                                                                                }
                                                                                                                v14 = var16_30;
                                                                                                                var17_31 = var1_1.getString(var2_2);
                                                                                                                if ((ArrayList)v14.get(var17_31) != null) continue;
                                                                                                                v15 = var16_30;
                                                                                                                v16 = var17_31;
                                                                                                                var17_31 = v17;
                                                                                                                v17 = new ArrayList<E>();
                                                                                                                v15.put(v16, var17_31);
                                                                                                                continue;
                                                                                                            }
lbl80:
                                                                                                            // 2 sources

                                                                                                            v18 = var1_1;
                                                                                                            v19 = this;
                                                                                                            v20 = v19;
                                                                                                            v21 = v19;
                                                                                                            v22 = v19;
                                                                                                            v23 = v19;
                                                                                                            var1_1.moveToPosition(-1);
                                                                                                            WatchPartyDao_Impl.access$1300(v20.WatchPartyDao_Impl.this, var13_27);
                                                                                                            WatchPartyDao_Impl.access$1400(v21.WatchPartyDao_Impl.this, var14_28);
                                                                                                            WatchPartyDao_Impl.access$1500(v22.WatchPartyDao_Impl.this, var15_29);
                                                                                                            WatchPartyDao_Impl.access$1600(v23.WatchPartyDao_Impl.this, var16_30);
                                                                                                            if (!v18.moveToFirst()) break block89;
                                                                                                            if (!var1_1.isNull(var2_2)) break block90;
                                                                                                            if (!var1_1.isNull(var3_4)) break block90;
                                                                                                            if (!var1_1.isNull(var4_8)) break block90;
                                                                                                            if (!var1_1.isNull(var5_11)) break block90;
                                                                                                            if (!var1_1.isNull(var6_13)) break block90;
                                                                                                            if (!var1_1.isNull(var7_14)) break block90;
                                                                                                            if (!var1_1.isNull(var8_16)) break block90;
                                                                                                            if (!var1_1.isNull(var9_19)) break block90;
                                                                                                            if (!var1_1.isNull(var10_21)) break block90;
                                                                                                            if (!var1_1.isNull(var11_22)) break block90;
                                                                                                            if (!var1_1.isNull(var12_25)) break block90;
                                                                                                            this = null;
                                                                                                            break block91;
                                                                                                        }
                                                                                                        if (!var1_1.isNull(var2_2)) break block92;
                                                                                                        if (!var1_1.isNull(var3_4)) break block92;
                                                                                                        if (!var1_1.isNull(var4_8)) break block92;
                                                                                                        if (!var1_1.isNull(var5_11)) break block92;
                                                                                                        if (!var1_1.isNull(var6_13)) break block92;
                                                                                                        if (!var1_1.isNull(var7_14)) break block92;
                                                                                                        if (!var1_1.isNull(var8_16)) break block92;
                                                                                                        if (!var1_1.isNull(var9_19)) break block92;
                                                                                                        if (!var1_1.isNull(var10_21)) break block92;
                                                                                                        if (!var1_1.isNull(var11_22)) break block92;
                                                                                                        if (!var1_1.isNull(var12_25)) break block92;
                                                                                                        this = null;
                                                                                                        break block93;
                                                                                                    }
                                                                                                    if (!var1_1.isNull(var2_2)) break block94;
                                                                                                    var17_31 = null;
                                                                                                    break block95;
                                                                                                }
                                                                                                var17_31 = var1_1.getString(var2_2);
                                                                                            }
                                                                                            if (!var1_1.isNull(var3_4)) break block96;
                                                                                            var3_5 = null;
                                                                                            break block97;
                                                                                        }
                                                                                        var3_5 = var1_1.getString(var3_4);
                                                                                    }
                                                                                    v24 = var1_1;
                                                                                    v25 = var7_14;
                                                                                    v26 = var1_1;
                                                                                    v27 = var6_13;
                                                                                    v28 = var1_1;
                                                                                    v29 = var5_11;
                                                                                    var4_8 = var1_1.getInt(var4_8);
                                                                                    var5_11 = v28.getInt(v29);
                                                                                    var6_13 = v26.getInt(v27);
                                                                                    if (!v24.isNull(v25)) break block98;
                                                                                    var7_15 /* !! */  = null;
                                                                                    break block99;
                                                                                }
                                                                                var7_15 /* !! */  = var1_1.getLong(var7_14);
                                                                            }
                                                                            v30 = var1_1;
                                                                            v31 = var8_16;
                                                                            var7_15 /* !! */  = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var7_15 /* !! */ );
                                                                            if (!v30.isNull(v31)) break block100;
                                                                            var8_17 = null;
                                                                            break block101;
                                                                        }
                                                                        var8_17 = var1_1.getLong(var8_16);
                                                                    }
                                                                    v32 = var1_1;
                                                                    v33 = var9_19;
                                                                    this = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var8_17);
                                                                    var8_18 = v32.getInt(v33) != 0;
                                                                    if (!var1_1.isNull(var11_22)) break block102;
                                                                    if (!var1_1.isNull(var12_25)) break block102;
                                                                    var9_20 = null;
                                                                    break block103;
                                                                }
                                                                if (!var1_1.isNull(var11_22)) break block104;
                                                                var9_20 = null;
                                                                break block105;
                                                            }
                                                            var9_20 = var1_1.getString(var11_22);
                                                        }
                                                        if (!var1_1.isNull(var12_25)) break block106;
                                                        var11_23 = null;
                                                        break block107;
                                                    }
                                                    var11_23 = var1_1.getString(var12_25);
                                                }
                                                var12_26 = v34;
                                                v34 = new Access((String)var9_20, var11_23);
                                                var9_20 = var12_26;
                                            }
                                            v35 = var1_1;
                                            v36 = var10_21;
                                            var11_24 = v37;
                                            v37 = new Topic((String)var17_31, var3_5, var4_8, var5_11, var6_13, (Date)var7_15 /* !! */ , (Date)this, var8_18, (Access)var9_20);
                                            if (!v35.isNull(v36)) break block108;
                                            this = null;
                                            break block109;
                                        }
                                        this = var1_1.getString(var10_21);
                                    }
                                    var11_24.setWatchPartyStreamId((String)this);
                                    this = var11_24;
                                }
                                var3_6 = (ArrayList)var15_29.get((Object)var1_1.getString(var2_2));
                                if (var3_6 != null) ** GOTO lbl249
                                var3_6 = v38;
                                v38 = new ArrayList<E>();
lbl249:
                                // 2 sources

                                if ((var4_9 = (ArrayList)var16_30.get((Object)var1_1.getString(var2_2))) != null) break block110;
                                var4_9 = v39;
                                v39 = new ArrayList<E>();
                            }
                            var5_12 = v40;
                            v40 = new ChatRelation((Topic)this, var3_6, var4_9);
                            this = var5_12;
                        }
                        v41 = var14_28;
                        v42 = var1_1;
                        v43 = var2_2;
                        var2_3 = (TinodeContact)var13_27.get((Object)var1_1.getString(var2_2));
                        var3_7 = (WatchPartyStatus)v41.get((Object)v42.getString(v43));
                        var4_10 = v44;
                        v44 = new WatchPartyRelation((ChatRelation)this, var2_3, var3_7);
                        break block111;
                    }
                    var4_10 = null;
                }
                var1_1.close();
                return var4_10;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Flow<List<WatchParty>> observeWatchParties(Function1<? super WatchPartyRelation, WatchParty> function1) {
        return WatchPartyDao.DefaultImpls.observeWatchParties(this, function1);
    }
}

