/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.fs;

import android.content.Context;
import android.graphics.Bitmap;
import io.streamlayer.common.data.fs.FileSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J \u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016R\u0016\u0010\f\u001a\u00020\u000b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0016\u0010\u0010\u001a\u00020\u00078V@\u0016X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lio/streamlayer/common/data/fs/FileSystemImpl;", "Lio/streamlayer/common/data/fs/FileSystem;", "", "name", "extension", "Landroid/graphics/Bitmap;", "bitmap", "Ljava/io/File;", "createTempFile", "", "deleteTempFile", "Landroid/content/Context;", "context", "Landroid/content/Context;", "getCacheDirectory", "()Ljava/io/File;", "cacheDirectory", "<init>", "(Landroid/content/Context;)V", "sdk_originalRelease"})
public final class FileSystemImpl
implements FileSystem {
    @NotNull
    private final Context context;

    @Inject
    public FileSystemImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @NotNull
    public File getCacheDirectory() {
        File file = this.context.getCacheDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.cacheDir");
        return file;
    }

    @Override
    @NotNull
    public File createTempFile(@NotNull String object, @NotNull String string, @NotNull Bitmap bitmap) {
        FileOutputStream fileOutputStream;
        Intrinsics.checkNotNullParameter((Object)object, (String)"name");
        Intrinsics.checkNotNullParameter((Object)string, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        File file = File.createTempFile((String)object, string, ((FileSystemImpl)((Object)file)).getCacheDirectory());
        object = fileOutputStream;
        ((FileOutputStream)object)(file);
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)object);
        fileOutputStream.close();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        return file;
    }

    @Override
    public boolean deleteTempFile(@NotNull String string, @NotNull String string2) {
        File file;
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"extension");
        File file2 = file;
        return new File(this.getCacheDirectory(), string + '.' + string2).exists() ? file2.delete() : false;
    }
}

