/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.notifications;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.LayerDrawable;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import io.streamlayer.common.extensions.CoilExtensionsKt;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemNotificationBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationCustomBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationPredictionsBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationPredictionsResultBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationWatchPartyBinding;
import io.streamlayer.sdk.databinding.SlrPredictionsBannerBinding;
import io.streamlayer.sdk.main.notifications.NotificationViewsKt;
import io.streamlayer.sdk.main.notifications.NotificationViewsProvider;
import io.streamlayer.sdk.main.notifications.NotificationViewsProvider$BaseNotificationView$showAnimate$lambda-8$;
import io.streamlayer.sdk.main.notifications.NotificationsLayout;
import io.streamlayer.sdk.main.notifications.NotificationsLayoutKt;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationBuilder;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.predictions.view.ExtensionsKt;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.Iterator;
import java.util.LinkedList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\b\u0000\u0018\u00002\u00020\u0001:\n !\"#$%&'()B\u0017\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002R\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00128\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u00020\u00158\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00158\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\"\u0010\u0019\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0017\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006*"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "", "Landroid/view/ViewGroup;", "parent", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "getNotificationView", "view", "", "addToPool", "clearPool", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;", "listener", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;", "Landroid/content/res/Resources;", "resources", "Landroid/content/res/Resources;", "Ljava/util/LinkedList;", "notificationViewsPool", "Ljava/util/LinkedList;", "", "bottomMargin", "I", "startMargin", "overlayHeight", "getOverlayHeight", "()I", "setOverlayHeight", "(I)V", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;Landroid/content/res/Resources;)V", "BaseNotificationPredictionsView", "BaseNotificationView", "NotificationCustomViewHolder", "NotificationFriendJoinToChatView", "NotificationPredictionsBannerView", "NotificationPredictionsResultView", "NotificationPredictionsView", "NotificationTouchListener", "NotificationView", "NotificationWatchPartyView", "sdk_originalRelease"})
public final class NotificationViewsProvider {
    @NotNull
    private final NotificationsLayout.NotificationViewAction listener;
    @NotNull
    private final Resources resources;
    @NotNull
    private final LinkedList<NotificationsLayout.BaseNotificationView> notificationViewsPool;
    private final int bottomMargin;
    private final int startMargin;
    private int overlayHeight;

    public NotificationViewsProvider(@NotNull NotificationsLayout.NotificationViewAction notificationViewAction2, @NotNull Resources resources) {
        NotificationViewsProvider notificationViewsProvider = this;
        Intrinsics.checkNotNullParameter((Object)notificationViewAction2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        this.listener = notificationViewAction2;
        notificationViewsProvider.resources = resources;
        notificationViewsProvider.notificationViewsPool = new LinkedList();
        this.bottomMargin = resources.getDimensionPixelSize(R.dimen.slr_activity_vertical_margin);
        this.startMargin = resources.getDimensionPixelSize(R.dimen.slr_activity_vertical_margin_small);
    }

    public static final /* synthetic */ int access$getStartMargin$p(NotificationViewsProvider notificationViewsProvider) {
        return notificationViewsProvider.startMargin;
    }

    public final int getOverlayHeight() {
        return this.overlayHeight;
    }

    public final void setOverlayHeight(int n) {
        this.overlayHeight = n;
    }

    @NotNull
    public final NotificationsLayout.BaseNotificationView getNotificationView(@NotNull ViewGroup object, @NotNull Notification notification) {
        Object object2;
        block9: {
            block8: {
                Notification notification2 = notification;
                Intrinsics.checkNotNullParameter((Object)object, (String)"parent");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                notification = LayoutInflater.from((Context)object.getContext());
                switch (WhenMappings.$EnumSwitchMapping$0[notification2.getType().ordinal()]) {
                    default: {
                        NotificationView notificationView;
                        if (!((NotificationViewsProvider)this).notificationViewsPool.isEmpty()) break;
                        object2 = notificationView;
                        object = SlrItemNotificationBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationView = (NotificationViewsProvider)this.new NotificationView((SlrItemNotificationBinding)object);
                        break block8;
                    }
                    case 6: {
                        NotificationCustomViewHolder notificationCustomViewHolder;
                        object2 = notificationCustomViewHolder;
                        object = SlrItemNotificationCustomBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(\n               \u2026  false\n                )");
                        notificationCustomViewHolder = (NotificationViewsProvider)this.new NotificationCustomViewHolder((SlrItemNotificationCustomBinding)object);
                        break block9;
                    }
                    case 5: {
                        NotificationPredictionsBannerView notificationPredictionsBannerView;
                        object2 = notificationPredictionsBannerView;
                        object = SlrPredictionsBannerBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationPredictionsBannerView = (NotificationViewsProvider)this.new NotificationPredictionsBannerView((SlrPredictionsBannerBinding)object);
                        break block9;
                    }
                    case 4: {
                        NotificationPredictionsResultView notificationPredictionsResultView;
                        object2 = notificationPredictionsResultView;
                        object = SlrItemNotificationPredictionsResultBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationPredictionsResultView = (NotificationViewsProvider)this.new NotificationPredictionsResultView((SlrItemNotificationPredictionsResultBinding)object);
                        break block9;
                    }
                    case 3: {
                        NotificationPredictionsView notificationPredictionsView;
                        object2 = notificationPredictionsView;
                        object = SlrItemNotificationPredictionsBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationPredictionsView = (NotificationViewsProvider)this.new NotificationPredictionsView((SlrItemNotificationPredictionsBinding)object);
                        break block9;
                    }
                    case 2: {
                        NotificationWatchPartyView notificationWatchPartyView;
                        object2 = notificationWatchPartyView;
                        object = SlrItemNotificationWatchPartyBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationWatchPartyView = (NotificationViewsProvider)this.new NotificationWatchPartyView((SlrItemNotificationWatchPartyBinding)object);
                        break block9;
                    }
                    case 1: {
                        NotificationFriendJoinToChatView notificationFriendJoinToChatView;
                        object2 = notificationFriendJoinToChatView;
                        object = SlrItemNotificationBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(\n               \u2026  false\n                )");
                        notificationFriendJoinToChatView = (NotificationViewsProvider)this.new NotificationFriendJoinToChatView((SlrItemNotificationBinding)object);
                        break block9;
                    }
                }
                object2 = this = ((NotificationViewsProvider)this).notificationViewsPool.removeFirst();
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n                if (no\u2026moveFirst()\n            }");
        }
        return object2;
    }

    public final void addToPool(@NotNull NotificationsLayout.BaseNotificationView baseNotificationView) {
        Intrinsics.checkNotNullParameter((Object)baseNotificationView, (String)"view");
        if (!this.notificationViewsPool.contains(baseNotificationView)) {
            this.notificationViewsPool.addLast(baseNotificationView);
        }
    }

    public final void clearPool(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        Iterator iterator = this.notificationViewsPool.iterator();
        while (iterator.hasNext()) {
            viewGroup.removeView(((NotificationsLayout.BaseNotificationView)iterator.next()).getBinding().getRoot());
        }
        this.notificationViewsPool.clear();
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016R\u0019\u0010\t\u001a\u00020\b8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u000fR\u0016\u0010\u0012\u001a\u00020\r8\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationTouchListener;", "Landroid/view/View$OnTouchListener;", "Landroid/view/View;", "view", "Landroid/view/MotionEvent;", "motionEvent", "", "onTouch", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "getNotification", "()Lio/streamlayer/sdk/model/notifications/Notification;", "", "dY", "F", "y1", "y2", "swipeThreshold", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/model/notifications/Notification;)V", "sdk_originalRelease"})
    public final class NotificationTouchListener
    implements View.OnTouchListener {
        @NotNull
        private final Notification notification;
        private float dY;
        private float y1;
        private float y2;
        private final float swipeThreshold;

        public NotificationTouchListener(Notification notification) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            this.notification = notification;
            this.swipeThreshold = 50.0f;
        }

        @NotNull
        public final Notification getNotification() {
            return this.notification;
        }

        public boolean onTouch(@NotNull View view2, @NotNull MotionEvent motionEvent) {
            MotionEvent motionEvent2 = motionEvent;
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
            Intrinsics.checkNotNullParameter((Object)motionEvent2, (String)"motionEvent");
            int n = motionEvent2.getAction();
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        view2.setY(motionEvent.getRawY() + this.dY);
                    }
                } else {
                    NotificationTouchListener notificationTouchListener;
                    this.y2 = view2.getY();
                    if (Math.abs(Math.abs(notificationTouchListener.y1) - Math.abs(this.y2)) < this.swipeThreshold) {
                        NotificationViewsProvider.this.listener.onExpand(this.notification, view2);
                    } else {
                        float f;
                        float f2 = this.y2;
                        if (f < this.y1 && Math.abs(Math.abs(f2) - Math.abs(this.y1)) > this.swipeThreshold) {
                            NotificationViewsProvider.this.listener.onHide(this.notification, view2);
                        } else {
                            float f3;
                            float f4 = this.y1;
                            if (f3 < this.y2 && Math.abs(Math.abs(f4) - Math.abs(this.y2)) > this.swipeThreshold) {
                                NotificationViewsProvider.this.listener.hideAll();
                            }
                        }
                    }
                }
            } else {
                this.dY = view2.getY() - motionEvent.getRawY();
                this.y1 = view2.getY();
            }
            return true;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\tH\u0016R\u001d\u0010\u000f\u001a\u00020\f8D@\u0004X\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0012\u001a\u00020\u00118\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "parent", "", "prepareView", "Landroidx/constraintlayout/widget/ConstraintSet;", "constraintSet", "setConstraintParams", "Lkotlin/Function0;", "onEnd", "showAnimate", "", "isPortrait$delegate", "Lkotlin/Lazy;", "isPortrait", "()Z", "", "fullHeight", "I", "getFullHeight", "()I", "setFullHeight", "(I)V", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;)V", "sdk_originalRelease"})
    public abstract class BaseNotificationView
    implements NotificationsLayout.BaseNotificationView {
        @NotNull
        private final Lazy isPortrait$delegate;
        private int fullHeight;
        final /* synthetic */ NotificationViewsProvider this$0;

        public BaseNotificationView(NotificationViewsProvider notificationViewsProvider) {
            NotificationViewsProvider notificationViewsProvider2 = notificationViewsProvider;
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider2, (String)"this$0");
            this.this$0 = notificationViewsProvider2;
            this.isPortrait$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
                final /* synthetic */ BaseNotificationView this$0;
                {
                    this.this$0 = baseNotificationView;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    Context context = this.this$0.getBinding().getRoot().getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                    return OtherExtensionsKt.isScreenPortrait(context);
                }
            });
        }

        private static final void prepareView$lambda-1(BaseNotificationView baseNotificationView, ConstraintLayout constraintLayout, NotificationViewsProvider notificationViewsProvider) {
            BaseNotificationView baseNotificationView2 = baseNotificationView;
            Intrinsics.checkNotNullParameter((Object)baseNotificationView, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"$parent");
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider, (String)"this$1");
            View view2 = baseNotificationView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"binding.root");
            ViewExtensionsKt.invisible(view2);
            View view3 = baseNotificationView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"binding.root");
            ViewGroup.LayoutParams layoutParams = view3.getLayoutParams();
            if (layoutParams != null) {
                int n = baseNotificationView.isPortrait() ? constraintLayout.getWidth() - ViewExtensionsKt.getDp(16.0f) : notificationViewsProvider.resources.getDimensionPixelSize(R.dimen.slr_notification_landscape_width);
                BaseNotificationView baseNotificationView3 = baseNotificationView;
                layoutParams.width = n;
                view3.setLayoutParams(layoutParams);
                baseNotificationView3.setFullHeight(baseNotificationView3.getBinding().getRoot().getHeight());
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        private static final void showAnimate$lambda-8$lambda-4(View view2, BaseNotificationView baseNotificationView, ValueAnimator object) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"$view");
            Intrinsics.checkNotNullParameter((Object)baseNotificationView, (String)"this$0");
            ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
            if (layoutParams != null) {
                if ((object = object.getAnimatedValue()) != null) {
                    layoutParams.width = (Integer)object;
                    layoutParams.height = baseNotificationView.getFullHeight();
                    view2.setLayoutParams(layoutParams);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        protected final boolean isPortrait() {
            return (Boolean)this.isPortrait$delegate.getValue();
        }

        @Override
        public int getFullHeight() {
            return this.fullHeight;
        }

        @Override
        public void setFullHeight(int n) {
            this.fullHeight = n;
        }

        @Override
        public void prepareView(@NotNull ConstraintLayout constraintLayout) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().post(() -> BaseNotificationView.prepareView$lambda-1(this, constraintLayout, this.this$0));
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintSet constraintSet) {
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            constraintSet.setTranslationZ(this.getBinding().getRoot().getId(), 20.0f);
            NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            int n = this.getBinding().getRoot().getId();
            NotificationsLayoutKt.setBottomSide(constraintSet, n, this.this$0.bottomMargin);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void showAnimate(@Nullable Function0<Unit> function0) {
            int n;
            BaseNotificationView baseNotificationView = notificationViewsProvider;
            View view2 = baseNotificationView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"binding.root");
            if (baseNotificationView.isPortrait()) {
                ViewParent viewParent = notificationViewsProvider.getBinding().getRoot().getParent();
                if (viewParent == null) throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout");
                n = ((ConstraintLayout)viewParent).getWidth() - ViewExtensionsKt.getDp(16.0f);
            } else {
                n = ((BaseNotificationView)((Object)notificationViewsProvider)).this$0.resources.getDimensionPixelSize(R.dimen.slr_notification_landscape_width);
            }
            ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, n});
            BaseNotificationView baseNotificationView2 = notificationViewsProvider;
            ValueAnimator valueAnimator2 = valueAnimator;
            NotificationViewsProvider notificationViewsProvider = ((BaseNotificationView)((Object)notificationViewsProvider)).this$0;
            valueAnimator2.setDuration(400L);
            valueAnimator2.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            valueAnimator.addUpdateListener(arg_0 -> BaseNotificationView.showAnimate$lambda-8$lambda-4(view2, baseNotificationView2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"");
            valueAnimator.addListener(new Animator.AnimatorListener(view2){
                final /* synthetic */ View $view$inlined;
                {
                    this.$view$inlined = view2;
                }

                public void onAnimationRepeat(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationEnd(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationCancel(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    BaseNotificationView$showAnimate$lambda-8$$inlined$doOnStart$1 v0 = this;
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    ViewExtensionsKt.visible(v0.$view$inlined);
                    v0.$view$inlined.animate().alpha(1.0f).translationX(-20.0f).setStartDelay(200L).setDuration(200L).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).withEndAction(new Runnable(this.$view$inlined){
                        final /* synthetic */ View $view;
                        {
                            this.$view = view2;
                        }

                        public final void run() {
                            this.$view.animate().translationX(0.0f).setDuration(200L).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).start();
                        }
                    }).start();
                }
            });
            valueAnimator.addListener(new Animator.AnimatorListener(view2, function0, notificationViewsProvider){
                final /* synthetic */ View $view$inlined;
                final /* synthetic */ Function0 $onEnd$inlined;
                final /* synthetic */ NotificationViewsProvider this$0;
                {
                    this.$view$inlined = view2;
                    this.$onEnd$inlined = function0;
                    this.this$0 = notificationViewsProvider;
                }

                public void onAnimationRepeat(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationEnd(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    animator = this.$view$inlined;
                    ViewGroup.LayoutParams layoutParams = animator.getLayoutParams();
                    if (layoutParams != null) {
                        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
                        int n = NotificationViewsProvider.access$getStartMargin$p(this.this$0);
                        int n2 = marginLayoutParams.topMargin;
                        int n3 = NotificationViewsProvider.access$getStartMargin$p(this.this$0);
                        int n4 = marginLayoutParams.bottomMargin;
                        marginLayoutParams.setMargins(n, n2, n3, n4);
                        animator.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
                        Function0 function0 = this.$onEnd$inlined;
                        if (function0 != null) {
                            function0.invoke();
                        }
                        return;
                    }
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                }

                public void onAnimationCancel(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }
            });
            valueAnimator.start();
        }

        @Override
        public void clear() {
            NotificationsLayout.BaseNotificationView.DefaultImpls.clear(this);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016R\u001c\u0010\b\u001a\u00020\u00078\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationWatchPartyView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;)V", "sdk_originalRelease"})
    public final class NotificationWatchPartyView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationWatchPartyBinding binding;

        public NotificationWatchPartyView(SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationWatchPartyBinding, (String)"binding");
            super(NotificationViewsProvider.this);
            this.binding = slrItemNotificationWatchPartyBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationWatchPartyBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            NotificationWatchPartyView notificationWatchPartyView = this;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding = notificationWatchPartyView.getBinding();
            NotificationViewsProvider notificationViewsProvider = notificationWatchPartyView.NotificationViewsProvider.this;
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding2 = slrItemNotificationWatchPartyBinding;
            slrItemNotificationWatchPartyBinding2.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            slrItemNotificationWatchPartyBinding2.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            if (WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()] == 1) {
                slrItemNotificationWatchPartyBinding = slrItemNotificationWatchPartyBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationWatchPartyBinding, (String)"slNotifIconIV");
                Object object = notification.getNotificationIcon();
                object = object == null ? null : ((NotificationIcon)object).getAvatarUrl();
                Object object2 = notification.getNotificationIcon();
                object2 = object2 == null ? null : ((NotificationIcon)object2).getAvatarName();
                ProfileExtensionsKt.loadUserAvatar$default((ImageView)slrItemNotificationWatchPartyBinding, (String)object, (String)object2, null, 4, null);
            } else {
                AppCompatImageView appCompatImageView = slrItemNotificationWatchPartyBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                CoilExtensionsKt.clear((ImageView)appCompatImageView, bind.1.1.INSTANCE);
            }
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                nArray[NotificationType.WatchParty.ordinal()] = 1;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0096\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0014\u0010\u0007\u001a\u00020\u0006*\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0003J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0003J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016R\u001c\u0010\u0010\u001a\u00020\u000f8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Landroid/view/View;", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "type", "", "setPadding", "", "getIcon", "getColor", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "bind", "clear", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;)V", "sdk_originalRelease"})
    public class NotificationView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationBinding binding;

        public NotificationView(SlrItemNotificationBinding slrItemNotificationBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationBinding, (String)"binding");
            super(NotificationViewsProvider.this);
            this.binding = slrItemNotificationBinding;
        }

        private final void setPadding(View view2, NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n = 0;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n = ViewExtensionsKt.getDp(4.0f);
                }
            }
            int n2 = n;
            view2.setPadding(n2, n2, n2, n2);
        }

        @DrawableRes
        private final int getIcon(NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    n = 0;
                    break;
                }
                case 8: 
                case 12: {
                    n = R.drawable.slr_ic_watch_party_centered;
                    break;
                }
                case 6: 
                case 7: {
                    n = R.drawable.slr_ic_profile;
                    break;
                }
                case 5: {
                    n = R.drawable.slr_ic_betting;
                    break;
                }
                case 3: {
                    n = R.drawable.slr_ic_twitter;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n = R.drawable.slr_ic_chat;
                }
            }
            return n;
        }

        @ColorRes
        private final int getColor(NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 13: {
                    n = 0;
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n = 17170445;
                    break;
                }
                case 8: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 6: 
                case 7: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 5: {
                    n = R.color.slr_orange;
                    break;
                }
                case 4: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 3: {
                    n = R.color.slr_twitter;
                    break;
                }
                case 2: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 1: {
                    n = R.color.slr_primaryBlue;
                }
            }
            return n;
        }

        public static final /* synthetic */ void access$setPadding(NotificationView notificationView, View view2, NotificationType notificationType) {
            notificationView.setPadding(view2, notificationType);
        }

        public static final /* synthetic */ int access$getIcon(NotificationView notificationView, NotificationType notificationType) {
            return notificationView.getIcon(notificationType);
        }

        @Override
        @NotNull
        public SlrItemNotificationBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Unit unit;
            ConstraintSet constraintSet;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationBinding slrItemNotificationBinding = this.getBinding();
            NotificationViewsProvider notificationViewsProvider = NotificationViewsProvider.this;
            slrItemNotificationBinding.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            Object object = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"slNotifTitleTV");
            String string2 = notification.getTitle();
            boolean bl = string2 == null || string2.length() == 0;
            ViewExtensionsKt.visibleIf((View)object, bl ^ true);
            slrItemNotificationBinding.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            object = constraintSet;
            object();
            constraintSet.clone(slrItemNotificationBinding.slNotification);
            String string3 = notification.getDescription();
            boolean bl2 = string3 == null || string3.length() == 0;
            if (bl2) {
                object.connect(slrItemNotificationBinding.slNotifTitleTV.getId(), 3, slrItemNotificationBinding.slNotifIconIV.getId(), 3);
                object.connect(slrItemNotificationBinding.slNotifTitleTV.getId(), 4, slrItemNotificationBinding.slNotifIconIV.getId(), 4);
            } else {
                int n = ViewExtensionsKt.getDp(4.0f);
                object.connect(slrItemNotificationBinding.slNotifTitleTV.getId(), 3, 0, 3, n);
            }
            object.applyTo(slrItemNotificationBinding.slNotification);
            object = slrItemNotificationBinding.slNotifDescriptionTV;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"slNotifDescriptionTV");
            String string4 = notification.getDescription();
            boolean bl3 = string4 == null || string4.length() == 0;
            ViewExtensionsKt.visibleIf((View)object, bl3 ^ true);
            object = notification.getNotificationIcon();
            if (object == null) {
                unit = null;
            } else {
                if (object.getAvatarName() != null) {
                    AppCompatImageView appCompatImageView = slrItemNotificationBinding.slNotifIconIV;
                    AppCompatTextView appCompatTextView = object;
                    Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                    object = appCompatTextView.getAvatarUrl();
                    ProfileExtensionsKt.loadUserAvatar$default((ImageView)appCompatImageView, (String)object, appCompatTextView.getAvatarName(), null, 4, null);
                } else if (object.getAvatarUrl() != null) {
                    Function1<Boolean, Unit> function1;
                    AppCompatImageView appCompatImageView = slrItemNotificationBinding.slNotifIconIV;
                    Object object2 = appCompatImageView;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifIconIV");
                    object = object.getAvatarUrl();
                    Intrinsics.checkNotNull((Object)object);
                    object2 = this.getIcon(notification.getType());
                    AppCompatTextView appCompatTextView = object;
                    object = function1;
                    function1 = new Function1<Boolean, Unit>(this, slrItemNotificationBinding, notification){
                        final /* synthetic */ NotificationView this$0;
                        final /* synthetic */ SlrItemNotificationBinding $this_with;
                        final /* synthetic */ Notification $data;
                        {
                            this.this$0 = notificationView;
                            this.$this_with = slrItemNotificationBinding;
                            this.$data = notification;
                            super(1);
                        }

                        public final void invoke(boolean bl) {
                            if (!bl) {
                                AppCompatImageView appCompatImageView = this.$this_with.slNotifIconIV;
                                Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                                NotificationView.access$setPadding(this.this$0, (View)appCompatImageView, this.$data.getType());
                            }
                        }
                    };
                    ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)appCompatTextView, false, (Integer)object2, (Function1)object, 2, null);
                }
                slrItemNotificationBinding.slNotifIconIV.setBackgroundTintList(null);
                unit = Unit.INSTANCE;
            }
            if (unit == null) {
                SlrItemNotificationBinding slrItemNotificationBinding2 = slrItemNotificationBinding = slrItemNotificationBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationBinding2, (String)"");
                CoilExtensionsKt.clear((ImageView)slrItemNotificationBinding2, (Function1<? super ImageView, Unit>)new Function1<ImageView, Unit>(this, notification){
                    final /* synthetic */ NotificationView this$0;
                    final /* synthetic */ Notification $data;
                    {
                        this.this$0 = notificationView;
                        this.$data = notification;
                        super(1);
                    }

                    public final void invoke(@NotNull ImageView imageView) {
                        Intrinsics.checkNotNullParameter((Object)imageView, (String)"$this$clear");
                        imageView.setImageResource(NotificationView.access$getIcon(this.this$0, this.$data.getType()));
                    }
                });
                this.setPadding((View)slrItemNotificationBinding, notification.getType());
                slrItemNotificationBinding.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)slrItemNotificationBinding.getContext(), (int)this.getColor(notification.getType()))));
                Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationBinding, (String)"run {\n                  \u2026      }\n                }");
            }
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
        }

        @Override
        public void clear() {
            SlrItemNotificationBinding slrItemNotificationBinding = this.getBinding();
            slrItemNotificationBinding.slNotifTitleTV.setText(null);
            AppCompatTextView appCompatTextView = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slNotifTitleTV");
            ViewExtensionsKt.gone((View)appCompatTextView);
            slrItemNotificationBinding.slNotifDescriptionTV.setText(null);
            AppCompatTextView appCompatTextView2 = slrItemNotificationBinding.slNotifDescriptionTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView2, (String)"slNotifDescriptionTV");
            ViewExtensionsKt.gone((View)appCompatTextView2);
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                nArray[NotificationType.Universal.ordinal()] = 1;
                nArray[NotificationType.Chat.ordinal()] = 2;
                nArray[NotificationType.Twitter.ordinal()] = 3;
                nArray[NotificationType.Alert.ordinal()] = 4;
                nArray[NotificationType.Inplay.ordinal()] = 5;
                nArray[NotificationType.ArrivingFriend.ordinal()] = 6;
                nArray[NotificationType.WaveReply.ordinal()] = 7;
                nArray[NotificationType.CreateNewWatchParty.ordinal()] = 8;
                nArray[NotificationType.Prediction.ordinal()] = 9;
                nArray[NotificationType.PredictionResult.ordinal()] = 10;
                nArray[NotificationType.PredictionOnboarding.ordinal()] = 11;
                nArray[NotificationType.WatchParty.ordinal()] = 12;
                nArray[NotificationType.Custom.ordinal()] = 13;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u0014"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationFriendJoinToChatView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Lio/streamlayer/sdk/model/notifications/Notification;", "item", "", "bind", "Lkotlin/Function0;", "onEnd", "showAnimate", "Landroidx/constraintlayout/widget/ConstraintSet;", "constraintSet", "setConstraintParams", "Landroidx/constraintlayout/widget/ConstraintLayout;", "parent", "prepareView", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "binding", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;)V", "sdk_originalRelease"})
    public final class NotificationFriendJoinToChatView
    extends NotificationView {
        public NotificationFriendJoinToChatView(SlrItemNotificationBinding slrItemNotificationBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationBinding, (String)"binding");
            super(slrItemNotificationBinding);
        }

        private static final void showAnimate$lambda-2(NotificationFriendJoinToChatView notificationFriendJoinToChatView) {
            NotificationFriendJoinToChatView notificationFriendJoinToChatView2 = notificationFriendJoinToChatView;
            Intrinsics.checkNotNullParameter((Object)notificationFriendJoinToChatView2, (String)"this$0");
            ConstraintLayout constraintLayout = notificationFriendJoinToChatView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            ViewExtensionsKt.visible((View)constraintLayout);
        }

        private static final void prepareView$lambda-5(NotificationFriendJoinToChatView notificationFriendJoinToChatView, NotificationViewsProvider notificationViewsProvider) {
            Intrinsics.checkNotNullParameter((Object)notificationFriendJoinToChatView, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider, (String)"this$1");
            notificationFriendJoinToChatView = notificationFriendJoinToChatView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)notificationFriendJoinToChatView, (String)"binding.root");
            ViewGroup.LayoutParams layoutParams = notificationFriendJoinToChatView.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.width = notificationViewsProvider.resources.getDimensionPixelSize(R.dimen.slr_overlay_content_landscape_width) - ViewExtensionsKt.getDp(12.0f);
                notificationFriendJoinToChatView.setLayoutParams(layoutParams);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        @Override
        public void bind(@NotNull Notification notification) {
            StyleSpan styleSpan;
            SpannableStringBuilder spannableStringBuilder;
            NotificationFriendJoinToChatView notificationFriendJoinToChatView = notificationFriendJoinToChatView3;
            Notification notification2 = notification;
            Intrinsics.checkNotNullParameter((Object)notification2, (String)"item");
            super.bind(notification2);
            SpannableStringBuilder spannableStringBuilder2 = spannableStringBuilder;
            NotificationFriendJoinToChatView notificationFriendJoinToChatView2 = notificationFriendJoinToChatView3;
            SpannableStringBuilder spannableStringBuilder3 = spannableStringBuilder2;
            SpannableStringBuilder spannableStringBuilder4 = spannableStringBuilder2;
            spannableStringBuilder4();
            NotificationFriendJoinToChatView notificationFriendJoinToChatView3 = styleSpan;
            styleSpan = new StyleSpan(1);
            int n = spannableStringBuilder4.length();
            spannableStringBuilder3.append((CharSequence)notification.getTitle());
            int n2 = spannableStringBuilder3.length();
            spannableStringBuilder3.setSpan((Object)notificationFriendJoinToChatView3, n, n2, 17);
            notificationFriendJoinToChatView3 = spannableStringBuilder.append((CharSequence)Intrinsics.stringPlus((String)" ", (Object)notificationFriendJoinToChatView2.NotificationViewsProvider.this.resources.getText(R.string.slr_messaging_chat_friend_joined_template)));
            SlrItemNotificationBinding slrItemNotificationBinding = notificationFriendJoinToChatView.getBinding();
            slrItemNotificationBinding.slNotifTitleTV.setText((CharSequence)((Object)notificationFriendJoinToChatView3));
            slrItemNotificationBinding.getRoot().setOnTouchListener(null);
            slrItemNotificationBinding.slNotification.setBackground(ContextCompat.getDrawable((Context)slrItemNotificationBinding.getRoot().getContext(), (int)R.drawable.slr_bg_notification_friend_arrived));
            slrItemNotificationBinding.slNotifIconIV.setBackground(null);
            slrItemNotificationBinding.slNotifTitleTV.setTextColor(ContextCompat.getColor((Context)slrItemNotificationBinding.getRoot().getContext(), (int)R.color.slr_white));
        }

        @Override
        public void showAnimate(@Nullable Function0<Unit> function0) {
            this.getBinding().getRoot().animate().translationX(0.0f).setDuration(400L).withStartAction(() -> NotificationFriendJoinToChatView.showAnimate$lambda-2(this)).start();
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintSet constraintSet) {
            NotificationFriendJoinToChatView notificationFriendJoinToChatView = this;
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            constraintSet.setTranslationZ(this.getBinding().getRoot().getId(), 20.0f);
            int n = notificationFriendJoinToChatView.getBinding().getRoot().getId();
            ViewParent viewParent = notificationFriendJoinToChatView.getBinding().getRoot().getParent();
            if (viewParent != null) {
                constraintSet.setTranslationX(n, -((float)((ConstraintLayout)viewParent).getWidth()));
                if (this.isPortrait()) {
                    NotificationsLayoutKt.setTopSide(constraintSet, this.getBinding().getRoot().getId(), ViewExtensionsKt.getDp(75.0f));
                    NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
                } else {
                    NotificationsLayoutKt.setTopSide(constraintSet, this.getBinding().getRoot().getId(), ViewExtensionsKt.getDp(60.0f));
                }
                NotificationsLayoutKt.setStartSide(constraintSet, this.getBinding().getRoot().getId(), 0);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout");
        }

        @Override
        public void prepareView(@NotNull ConstraintLayout constraintLayout) {
            NotificationFriendJoinToChatView notificationFriendJoinToChatView = this;
            ConstraintLayout constraintLayout2 = constraintLayout;
            Intrinsics.checkNotNullParameter((Object)constraintLayout2, (String)"parent");
            super.prepareView(constraintLayout2);
            if (!notificationFriendJoinToChatView.isPortrait()) {
                NotificationFriendJoinToChatView notificationFriendJoinToChatView2 = this;
                this.getBinding().getRoot().post(() -> NotificationFriendJoinToChatView.prepareView$lambda-5(notificationFriendJoinToChatView2, notificationFriendJoinToChatView2.NotificationViewsProvider.this));
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00a6\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0004R\u0019\u0010\t\u001a\u00020\b8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationPredictionsView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Landroidx/constraintlayout/widget/ConstraintSet;", "constraintSet", "", "setConstraintParams", "showAnimatePortrait", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "type", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "getType", "()Lio/streamlayer/sdk/model/notifications/NotificationType;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/model/notifications/NotificationType;)V", "sdk_originalRelease"})
    public abstract class BaseNotificationPredictionsView
    extends BaseNotificationView {
        @NotNull
        private final NotificationType type;

        public BaseNotificationPredictionsView(NotificationType notificationType) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)notificationType), (String)"type");
            super(NotificationViewsProvider.this);
            this.type = notificationType;
        }

        @NotNull
        public final NotificationType getType() {
            return this.type;
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintSet constraintSet) {
            BaseNotificationPredictionsView baseNotificationPredictionsView = this;
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            boolean bl = NotificationViewsKt.isLikePrediction(baseNotificationPredictionsView.type);
            boolean bl2 = baseNotificationPredictionsView.type == NotificationType.PredictionOnboarding;
            BaseNotificationPredictionsView baseNotificationPredictionsView2 = this;
            NotificationViewsProvider notificationViewsProvider = baseNotificationPredictionsView2.NotificationViewsProvider.this;
            int n = baseNotificationPredictionsView2.getBinding().getRoot().getId();
            float f = bl ? 30.0f : 20.0f;
            constraintSet.setTranslationZ(n, f);
            if (bl) {
                BaseNotificationPredictionsView baseNotificationPredictionsView3 = this;
                n = baseNotificationPredictionsView3.getBinding().getRoot().getId();
                int n2 = baseNotificationPredictionsView3.isPortrait() ? 0 : ViewExtensionsKt.getDp(20.0f);
                NotificationsLayoutKt.setStartSide(constraintSet, n, n2);
            }
            if (bl && this.isPortrait() || !bl) {
                NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            }
            if (bl2 && !this.isPortrait()) {
                NotificationsLayoutKt.setStartSide(constraintSet, this.getBinding().getRoot().getId(), ViewExtensionsKt.getDp(20.0f));
            }
            Context context = this.getBinding().getRoot().getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
            if (OtherExtensionsKt.isScreenPortrait(context) && bl) {
                NotificationsLayoutKt.setTopSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            } else {
                int n3 = this.getBinding().getRoot().getId();
                NotificationsLayoutKt.setBottomSide(constraintSet, n3, notificationViewsProvider.bottomMargin);
            }
        }

        protected final void showAnimatePortrait() {
            View view2 = this.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"binding.root");
            ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
            if (layoutParams != null) {
                BaseNotificationPredictionsView baseNotificationPredictionsView = this;
                ((ViewGroup.MarginLayoutParams)layoutParams).height = -2;
                view2.setLayoutParams((ViewGroup.LayoutParams)((ViewGroup.MarginLayoutParams)layoutParams));
                baseNotificationPredictionsView.getBinding().getRoot().setAlpha(0.0f);
                baseNotificationPredictionsView.getBinding().getRoot().setTranslationX(-((float)this.getBinding().getRoot().getContext().getResources().getDisplayMetrics().widthPixels));
                View view3 = baseNotificationPredictionsView.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"binding.root");
                ViewExtensionsKt.visible(view3);
                baseNotificationPredictionsView.getBinding().getRoot().animate().setDuration(500L).alpha(1.0f).translationX(0.0f).start();
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007H\u0016R\u001c\u0010\u000b\u001a\u00020\n8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationPredictionsView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationPredictionsView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Lkotlin/Function0;", "onEnd", "showAnimate", "Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;)V", "sdk_originalRelease"})
    public final class NotificationPredictionsView
    extends BaseNotificationPredictionsView {
        @NotNull
        private final SlrItemNotificationPredictionsBinding binding;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public NotificationPredictionsView(SlrItemNotificationPredictionsBinding slrItemNotificationPredictionsBinding) {
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsView.NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationPredictionsBinding, (String)"binding");
            super(NotificationType.Prediction);
            notificationPredictionsView.binding = slrItemNotificationPredictionsBinding;
            if (notificationPredictionsView.isPortrait()) return;
            notificationPredictionsView.NotificationViewsProvider.this = notificationPredictionsView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)notificationPredictionsView.NotificationViewsProvider.this, (String)"binding.root");
            slrItemNotificationPredictionsBinding = notificationPredictionsView.NotificationViewsProvider.this.getLayoutParams();
            if (slrItemNotificationPredictionsBinding == null) throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
            ((ViewGroup.LayoutParams)slrItemNotificationPredictionsBinding).width = notificationPredictionsView.getBinding().getRoot().getContext().getResources().getDimensionPixelSize(R.dimen.slr_predictions_notification_landscape_width);
            notificationPredictionsView.NotificationViewsProvider.this.setLayoutParams((ViewGroup.LayoutParams)slrItemNotificationPredictionsBinding);
            notificationPredictionsView.NotificationViewsProvider.this = notificationPredictionsView.getBinding().slNotification;
            Intrinsics.checkNotNullExpressionValue((Object)notificationPredictionsView.NotificationViewsProvider.this, (String)"binding.slNotification");
            slrItemNotificationPredictionsBinding = notificationPredictionsView.NotificationViewsProvider.this.getLayoutParams();
            if (slrItemNotificationPredictionsBinding == null) throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
            ((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding).topToTop = -1;
            ((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding).bottomToBottom = 0;
            notificationPredictionsView.NotificationViewsProvider.this.setLayoutParams((ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding));
            notificationPredictionsView.NotificationViewsProvider.this = notificationPredictionsView.getBinding().slrNotificationIcon;
            Intrinsics.checkNotNullExpressionValue((Object)notificationPredictionsView.NotificationViewsProvider.this, (String)"binding.slrNotificationIcon");
            slrItemNotificationPredictionsBinding = notificationPredictionsView.NotificationViewsProvider.this.getLayoutParams();
            if (slrItemNotificationPredictionsBinding == null) throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
            NotificationPredictionsView notificationPredictionsView = (ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding;
            ((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding).topToTop = -1;
            ((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding).bottomToBottom = 0;
            notificationPredictionsView.NotificationViewsProvider.this.setLayoutParams((ViewGroup.LayoutParams)notificationPredictionsView);
        }

        private static final void showAnimate$lambda-9$lambda-8$lambda-7(ValueAnimator object, NotificationPredictionsView notificationPredictionsView, ValueAnimator valueAnimator) {
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsView, (String)"this$0");
            object = object.getAnimatedValue();
            if (object != null) {
                int n = (Integer)object;
                valueAnimator = notificationPredictionsView.getBinding().slrNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"binding.slrNotificationIcon");
                boolean bl = n > ViewExtensionsKt.getDp(73.0f);
                ViewExtensionsKt.visibleIf((View)valueAnimator, bl);
                notificationPredictionsView = notificationPredictionsView.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)notificationPredictionsView, (String)"binding.root");
                valueAnimator = notificationPredictionsView.getLayoutParams();
                if (valueAnimator != null) {
                    valueAnimator.width = n;
                    notificationPredictionsView.setLayoutParams((ViewGroup.LayoutParams)valueAnimator);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }

        private static final void showAnimate$lambda-9(NotificationPredictionsView notificationPredictionsView) {
            NotificationPredictionsView notificationPredictionsView2 = notificationPredictionsView;
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsView2, (String)"this$0");
            if (!notificationPredictionsView2.isPortrait()) {
                NotificationPredictionsView notificationPredictionsView3 = notificationPredictionsView;
                ConstraintLayout constraintLayout = notificationPredictionsView3.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                ViewExtensionsKt.visible((View)constraintLayout);
                ConstraintLayout constraintLayout2 = notificationPredictionsView3.getBinding().slNotification;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"binding.slNotification");
                ViewExtensionsKt.invisible((View)constraintLayout2);
                ImageView imageView = notificationPredictionsView3.getBinding().slrNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slrNotificationIcon");
                ViewExtensionsKt.invisible((View)imageView);
                ImageView imageView2 = notificationPredictionsView3.getBinding().slrLeftSide;
                Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.slrLeftSide");
                ViewExtensionsKt.invisible((View)imageView2);
                int n = (int)notificationPredictionsView3.getBinding().getRoot().getContext().getResources().getDimension(R.dimen.slr_notification_landscape_width);
                ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, n});
                valueAnimator.setDuration(300L);
                valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(notificationPredictionsView){
                    final /* synthetic */ NotificationPredictionsView this$0;
                    {
                        this.this$0 = notificationPredictionsView;
                    }

                    public void onAnimationStart(@NotNull Animator animator) {
                        showAnimate.1.1.1 v0 = this;
                        Intrinsics.checkNotNullParameter((Object)animator, (String)"var1");
                        ConstraintLayout constraintLayout = v0.this$0.getBinding().slNotification;
                        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.slNotification");
                        ViewExtensionsKt.visible((View)constraintLayout);
                        ImageView imageView = v0.this$0.getBinding().slrLeftSide;
                        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slrLeftSide");
                        ViewExtensionsKt.visible((View)imageView);
                    }
                });
                valueAnimator.addUpdateListener(arg_0 -> NotificationPredictionsView.showAnimate$lambda-9$lambda-8$lambda-7(valueAnimator, notificationPredictionsView, arg_0));
                valueAnimator.start();
            } else {
                notificationPredictionsView.showAnimatePortrait();
            }
        }

        @Override
        @NotNull
        public SlrItemNotificationPredictionsBinding getBinding() {
            return this.binding;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void bind(@NotNull Notification var1_1) {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            v0 = this;
                            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"data");
                            this = v0.getBinding();
                            var2_2 = v0.NotificationViewsProvider.this;
                            this.slrQuestionText.setText((CharSequence)var1_1.getTitle());
                            var3_3 = var1_1.getNotificationIcon();
                            if (var3_3 == null) {
                                while (true) {
                                    var3_3 = null;
                                    break;
                                }
                            } else {
                                if ((var3_3 = var3_3.getMeta()) == null) ** continue;
                                var3_3 = (String)var3_3.get("icon");
                            }
                            var4_5 = var1_1.getNotificationIcon();
                            if (var4_5 == null) {
                                while (true) {
                                    var4_5 = null;
                                    break;
                                }
                            } else {
                                if ((var4_5 = var4_5.getMeta()) == null) ** continue;
                                var4_5 = (String)var4_5.get("smallIcon");
                            }
                            if (var3_3 != null) {
                                v1 = this.slrNotificationIcon;
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"slrNotificationIcon");
                                ExtensionsKt.load(v1, (String)var3_3);
                            } else {
                                this.slrNotificationIcon.setImageResource(0);
                            }
                            if (var4_5 != null) {
                                v2 = this.slrNotificationsSmallIcon;
                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"slrNotificationsSmallIcon");
                                ExtensionsKt.load(v2, (String)var4_5);
                            } else {
                                this.slrNotificationsSmallIcon.setImageResource(0);
                            }
                            v3 = var1_1;
                            var3_3 = v3.getDataJson();
                            if (var3_3 != null) break block19;
                            var3_3 = null;
                            break block20;
                        }
                        var3_3 = StringsKt.replace$default((String)var3_3, (String)"\"", (String)"", (boolean)false, (int)4, null);
                    }
                    try {
                        var3_3 = Result.constructor-impl((Object)Color.parseColor((String)var3_3));
                    }
                    catch (Throwable v4) {
                        var3_3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)v4));
                    }
                    if (Result.isFailure-impl((Object)var3_3)) {
                        var3_3 = null;
                    }
                    if ((var3_3 = (Integer)var3_3) == null) break block21;
                    var3_4 = var3_3.intValue();
                    var4_5 = this.slrLeftSide.getBackground();
                    if (var4_5 == null) break block22;
                    ((LayerDrawable)var4_5).getDrawable(0).setTint(var3_4);
                }
                this.getRoot().setOnTouchListener((View.OnTouchListener)var2_2.new NotificationTouchListener(var1_1));
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
        }

        @Override
        public void showAnimate(@Nullable Function0<Unit> function0) {
            this.getBinding().getRoot().post(() -> NotificationPredictionsView.showAnimate$lambda-9(this));
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u001c\u0010\u000b\u001a\u00020\n8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationPredictionsBannerView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationPredictionsView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Landroidx/constraintlayout/widget/ConstraintSet;", "constraintSet", "setConstraintParams", "Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;)V", "sdk_originalRelease"})
    public final class NotificationPredictionsBannerView
    extends BaseNotificationPredictionsView {
        @NotNull
        private final SlrPredictionsBannerBinding binding;

        public NotificationPredictionsBannerView(SlrPredictionsBannerBinding slrPredictionsBannerBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrPredictionsBannerBinding, (String)"binding");
            super(NotificationType.PredictionOnboarding);
            this.binding = slrPredictionsBannerBinding;
        }

        @Override
        @NotNull
        public SlrPredictionsBannerBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)new NotificationTouchListener(notification));
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintSet constraintSet) {
            NotificationPredictionsBannerView notificationPredictionsBannerView = this;
            NotificationPredictionsBannerView notificationPredictionsBannerView2 = this;
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            NotificationViewsProvider notificationViewsProvider = notificationPredictionsBannerView2.NotificationViewsProvider.this;
            constraintSet.setTranslationZ(notificationPredictionsBannerView2.getBinding().getRoot().getId(), 30.0f);
            int n = notificationPredictionsBannerView.getBinding().getRoot().getId();
            int n2 = notificationPredictionsBannerView.isPortrait() ? 0 : ViewExtensionsKt.getDp(20.0f);
            NotificationsLayoutKt.setStartSide(constraintSet, n, n2);
            NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            int n3 = this.getBinding().getRoot().getId();
            NotificationsLayoutKt.setBottomSide(constraintSet, n3, notificationViewsProvider.bottomMargin);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007H\u0016R\u001c\u0010\u000b\u001a\u00020\n8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationPredictionsResultView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationPredictionsView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Lkotlin/Function0;", "onEnd", "showAnimate", "Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsResultBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsResultBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsResultBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsResultBinding;)V", "sdk_originalRelease"})
    public final class NotificationPredictionsResultView
    extends BaseNotificationPredictionsView {
        @NotNull
        private final SlrItemNotificationPredictionsResultBinding binding;

        public NotificationPredictionsResultView(SlrItemNotificationPredictionsResultBinding slrItemNotificationPredictionsResultBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationPredictionsResultBinding, (String)"binding");
            super(NotificationType.PredictionResult);
            this.binding = slrItemNotificationPredictionsResultBinding;
        }

        private static final void bind$lambda-0(boolean bl, NotificationPredictionsResultView notificationPredictionsResultView, Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsResultView, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"$data");
            if (bl) {
                NotificationPredictionsResultView notificationPredictionsResultView2 = notificationPredictionsResultView;
                notificationPredictionsResultView2.getBinding().slWinText.setText((CharSequence)notificationPredictionsResultView.getBinding().getRoot().getContext().getString(R.string.slr_predictions_result_congratulations));
                notificationPredictionsResultView2.getBinding().slWinPoints.setText((CharSequence)notification.getDescription());
                TextView textView = notificationPredictionsResultView2.getBinding().slWinText;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slWinText");
                ViewExtensionsKt.visible((View)textView);
                TextView textView2 = notificationPredictionsResultView2.getBinding().slWinPoints;
                Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.slWinPoints");
                ViewExtensionsKt.visible((View)textView2);
                TextView textView3 = notificationPredictionsResultView2.getBinding().slYouWon;
                Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"binding.slYouWon");
                ViewExtensionsKt.visible((View)textView3);
                ImageView imageView = notificationPredictionsResultView2.getBinding().slLooseIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slLooseIcon");
                ViewExtensionsKt.invisible((View)imageView);
                TextView textView4 = notificationPredictionsResultView2.getBinding().slLooseText1;
                Intrinsics.checkNotNullExpressionValue((Object)textView4, (String)"binding.slLooseText1");
                ViewExtensionsKt.invisible((View)textView4);
                TextView textView5 = notificationPredictionsResultView2.getBinding().slLooseText2;
                Intrinsics.checkNotNullExpressionValue((Object)textView5, (String)"binding.slLooseText2");
                ViewExtensionsKt.invisible((View)textView5);
            } else {
                NotificationPredictionsResultView notificationPredictionsResultView3 = notificationPredictionsResultView;
                TextView textView = notificationPredictionsResultView3.getBinding().slWinText;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slWinText");
                ViewExtensionsKt.invisible((View)textView);
                TextView textView6 = notificationPredictionsResultView3.getBinding().slWinPoints;
                Intrinsics.checkNotNullExpressionValue((Object)textView6, (String)"binding.slWinPoints");
                ViewExtensionsKt.invisible((View)textView6);
                TextView textView7 = notificationPredictionsResultView3.getBinding().slYouWon;
                Intrinsics.checkNotNullExpressionValue((Object)textView7, (String)"binding.slYouWon");
                ViewExtensionsKt.invisible((View)textView7);
                ImageView imageView = notificationPredictionsResultView3.getBinding().slLooseIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slLooseIcon");
                ViewExtensionsKt.visible((View)imageView);
                TextView textView8 = notificationPredictionsResultView3.getBinding().slLooseText1;
                Intrinsics.checkNotNullExpressionValue((Object)textView8, (String)"binding.slLooseText1");
                ViewExtensionsKt.visible((View)textView8);
                TextView textView9 = notificationPredictionsResultView3.getBinding().slLooseText2;
                Intrinsics.checkNotNullExpressionValue((Object)textView9, (String)"binding.slLooseText2");
                ViewExtensionsKt.visible((View)textView9);
                ImageView imageView2 = notificationPredictionsResultView3.getBinding().slBigIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.slBigIcon");
                ViewExtensionsKt.invisible((View)imageView2);
            }
        }

        private static final void showAnimate$lambda-4$lambda-3$lambda-2(ValueAnimator object, NotificationPredictionsResultView notificationPredictionsResultView, ValueAnimator valueAnimator) {
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsResultView, (String)"this$0");
            object = object.getAnimatedValue();
            if (object != null) {
                int n = (Integer)object;
                valueAnimator = notificationPredictionsResultView.getBinding().slWinNotification;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"binding.slWinNotification");
                boolean bl = n > ViewExtensionsKt.getDp(73.0f);
                ViewExtensionsKt.visibleIf((View)valueAnimator, bl);
                notificationPredictionsResultView = notificationPredictionsResultView.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)notificationPredictionsResultView, (String)"binding.root");
                valueAnimator = notificationPredictionsResultView.getLayoutParams();
                if (valueAnimator != null) {
                    valueAnimator.width = n;
                    notificationPredictionsResultView.setLayoutParams((ViewGroup.LayoutParams)valueAnimator);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }

        private static final void showAnimate$lambda-4(NotificationPredictionsResultView notificationPredictionsResultView) {
            NotificationPredictionsResultView notificationPredictionsResultView2 = notificationPredictionsResultView;
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsResultView2, (String)"this$0");
            if (!notificationPredictionsResultView2.isPortrait()) {
                NotificationPredictionsResultView notificationPredictionsResultView3 = notificationPredictionsResultView;
                ConstraintLayout constraintLayout = notificationPredictionsResultView3.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                ViewExtensionsKt.visible((View)constraintLayout);
                ConstraintLayout constraintLayout2 = notificationPredictionsResultView3.getBinding().slWinNotification;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"binding.slWinNotification");
                ViewExtensionsKt.invisible((View)constraintLayout2);
                int n = (int)notificationPredictionsResultView3.getBinding().getRoot().getContext().getResources().getDimension(R.dimen.slr_notification_landscape_width);
                ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, n});
                valueAnimator.setDuration(300L);
                valueAnimator.addUpdateListener(arg_0 -> NotificationPredictionsResultView.showAnimate$lambda-4$lambda-3$lambda-2(valueAnimator, notificationPredictionsResultView, arg_0));
                valueAnimator.start();
            } else {
                notificationPredictionsResultView.showAnimatePortrait();
            }
        }

        @Override
        @NotNull
        public SlrItemNotificationPredictionsResultBinding getBinding() {
            return this.binding;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void bind(@NotNull Notification notification) {
            Notification notification2 = notification;
            Intrinsics.checkNotNullParameter((Object)notification2, (String)"data");
            boolean bl = notification2.getDescription() != null;
            Object object = notification.getNotificationIcon();
            object = object == null || (object = ((NotificationIcon)object).getMeta()) == null ? null : (String)object.get("icon");
            if (object != null) {
                NotificationPredictionsResultView notificationPredictionsResultView = this;
                ImageView imageView = notificationPredictionsResultView.getBinding().slBigIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slBigIcon");
                ExtensionsKt.load(imageView, (String)object);
                ImageView imageView2 = notificationPredictionsResultView.getBinding().slBigIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.slBigIcon");
                ViewExtensionsKt.visible((View)imageView2);
            }
            NotificationPredictionsResultView notificationPredictionsResultView = this;
            notificationPredictionsResultView.getBinding().slWinText.setText((CharSequence)notification.getTitle());
            TextView textView = notificationPredictionsResultView.getBinding().slWinText;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slWinText");
            ViewExtensionsKt.visible((View)textView);
            TextView textView2 = notificationPredictionsResultView.getBinding().slWinPoints;
            Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.slWinPoints");
            ViewExtensionsKt.invisible((View)textView2);
            TextView textView3 = notificationPredictionsResultView.getBinding().slYouWon;
            Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"binding.slYouWon");
            ViewExtensionsKt.invisible((View)textView3);
            ImageView imageView = notificationPredictionsResultView.getBinding().slLooseIcon;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slLooseIcon");
            ViewExtensionsKt.invisible((View)imageView);
            TextView textView4 = notificationPredictionsResultView.getBinding().slLooseText1;
            Intrinsics.checkNotNullExpressionValue((Object)textView4, (String)"binding.slLooseText1");
            ViewExtensionsKt.invisible((View)textView4);
            TextView textView5 = notificationPredictionsResultView.getBinding().slLooseText2;
            Intrinsics.checkNotNullExpressionValue((Object)textView5, (String)"binding.slLooseText2");
            ViewExtensionsKt.invisible((View)textView5);
            notificationPredictionsResultView.getBinding().getRoot().postDelayed(() -> NotificationPredictionsResultView.bind$lambda-0(bl, this, notification), 10000L);
            notificationPredictionsResultView.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)new NotificationTouchListener(notification));
        }

        @Override
        public void showAnimate(@Nullable Function0<Unit> function0) {
            this.getBinding().getRoot().post(() -> NotificationPredictionsResultView.showAnimate$lambda-4(this));
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016R\u001c\u0010\b\u001a\u00020\u00078\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationCustomViewHolder;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;)V", "sdk_originalRelease"})
    public final class NotificationCustomViewHolder
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationCustomBinding binding;

        public NotificationCustomViewHolder(SlrItemNotificationCustomBinding slrItemNotificationCustomBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationCustomBinding, (String)"binding");
            super(NotificationViewsProvider.this);
            this.binding = slrItemNotificationCustomBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationCustomBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
                    Object object = notificationCustomViewHolder.getBinding().getRoot().getContext();
                    NotificationBuilder notificationBuilder = notification.getCustomBuilder();
                    if (notificationBuilder == null) break block7;
                    NotificationViewsProvider notificationViewsProvider = notificationCustomViewHolder.NotificationViewsProvider.this;
                    Object object2 = LayoutInflater.from((Context)object);
                    if (notificationBuilder.getLayoutId() != null) {
                        Integer n = notificationBuilder.getLayoutId();
                        Intrinsics.checkNotNull((Object)n);
                        object = object2.inflate(n.intValue(), (ViewGroup)notificationCustomViewHolder.getBinding().getRoot(), false);
                    } else {
                        object2 = SlrItemNotificationBinding.inflate(object2, (ViewGroup)notificationCustomViewHolder.getBinding().getRoot(), false);
                        object2.slNotifTitleTV.setText((CharSequence)notificationBuilder.getTitle());
                        object2.slNotifDescriptionTV.setText((CharSequence)notificationBuilder.getDescription());
                        Integer n = notificationBuilder.getIconBackgroundColor();
                        if (n != null) {
                            int n2 = n;
                            object2.slNotifIconIV.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)object, (int)n2)));
                        }
                        object = notificationBuilder.getIconUrl();
                        if (object != null) {
                            AppCompatImageView appCompatImageView = object2.slNotifIconIV;
                            Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                            ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)object, false, null, null, 14, null);
                        }
                        object = notificationCustomViewHolder.getBinding().getRoot();
                    }
                    Context context = object;
                    notificationCustomViewHolder.getBinding().getRoot().addView((View)object);
                    context.setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
                    NotificationCustomViewHolder notificationCustomViewHolder = context.getLayoutParams();
                    if (notificationCustomViewHolder == null) break block8;
                    Object object3 = object;
                    notificationCustomViewHolder = (FrameLayout.LayoutParams)notificationCustomViewHolder;
                    v4.gravity = 80;
                    object3.setLayoutParams((ViewGroup.LayoutParams)notificationCustomViewHolder);
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"view");
                    notificationBuilder.bindView((View)object);
                }
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            nArray[NotificationType.WaveReply.ordinal()] = 1;
            nArray[NotificationType.WatchParty.ordinal()] = 2;
            nArray[NotificationType.Prediction.ordinal()] = 3;
            nArray[NotificationType.PredictionResult.ordinal()] = 4;
            nArray[NotificationType.PredictionOnboarding.ordinal()] = 5;
            nArray[NotificationType.Custom.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

