/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.betting;

import io.streamlayer.sdk.model.betting.Competitor;
import io.streamlayer.sdk.model.betting.CompetitorType;
import io.streamlayer.sdk.model.betting.Country;
import io.streamlayer.sdk.model.betting.EventTime;
import io.streamlayer.sdk.model.betting.Game;
import io.streamlayer.sdk.model.betting.GameStatus;
import io.streamlayer.sdk.model.betting.League;
import io.streamlayer.sdk.model.betting.Market;
import io.streamlayer.sdk.model.betting.MarketStatus;
import io.streamlayer.sdk.model.betting.Period;
import io.streamlayer.sdk.model.betting.Score;
import io.streamlayer.sdk.model.betting.Selection;
import io.streamlayer.sdk.model.betting.SelectionOutcome;
import io.streamlayer.sdk.model.betting.SelectionRange;
import io.streamlayer.sdk.model.betting.SelectionResult;
import io.streamlayer.sdk.model.betting.SelectionResultStatus;
import io.streamlayer.sdk.model.betting.SelectionStatus;
import io.streamlayer.sdk.model.betting.Sport;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u001a\u0010\u0010\u0003\u001a\u00020\u0002*\u00060\u0000j\u0002`\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u0006*\u00060\u0004j\u0002`\u0005H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\t*\u00060\u0007j\u0002`\bH\u0000\u001a\u0010\u0010\u0003\u001a\u00020\f*\u00060\nj\u0002`\u000bH\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u000f*\u00060\rj\u0002`\u000eH\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u0012*\u00060\u0010j\u0002`\u0011H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u0015*\u00060\u0013j\u0002`\u0014H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u0018*\u00060\u0016j\u0002`\u0017H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u001b*\u00060\u0019j\u0002`\u001aH\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u001e*\u00060\u001cj\u0002`\u001dH\u0000\u001a\u0010\u0010\u0003\u001a\u00020!*\u00060\u001fj\u0002` H\u0000\u001a\u0010\u0010\u0003\u001a\u00020$*\u00060\"j\u0002`#H\u0000\u001a\u0010\u0010\u0003\u001a\u00020'*\u00060%j\u0002`&H\u0000\u001a\u0010\u0010\u0003\u001a\u00020**\u00060(j\u0002`)H\u0000\u001a\u0010\u0010\u0003\u001a\u00020-*\u00060+j\u0002`,H\u0000\u001a\u0010\u0010\u0003\u001a\u000200*\u00060.j\u0002`/H\u0000\u001a\u0010\u0010\u0003\u001a\u000203*\u000601j\u0002`2H\u0000*\f\b\u0000\u00104\"\u00020(2\u00020(*\f\b\u0000\u00105\"\u00020+2\u00020+*\f\b\u0000\u00106\"\u00020\n2\u00020\n*\f\b\u0000\u00107\"\u00020\u00042\u00020\u0004*\f\b\u0000\u00108\"\u00020\u00002\u00020\u0000*\f\b\u0000\u00109\"\u00020.2\u00020.*\f\b\u0000\u0010:\"\u00020\u00102\u00020\u0010*\f\b\u0000\u0010;\"\u00020%2\u00020%*\f\b\u0000\u0010<\"\u00020\r2\u00020\r*\f\b\u0000\u0010=\"\u00020\u00072\u00020\u0007*\f\b\u0000\u0010>\"\u00020\u001c2\u00020\u001c*\f\b\u0000\u0010?\"\u00020\u00132\u00020\u0013*\f\b\u0000\u0010@\"\u00020\u00192\u00020\u0019*\f\b\u0000\u0010A\"\u00020\u00162\u00020\u0016*\f\b\u0000\u0010B\"\u00020\u001f2\u00020\u001f*\f\b\u0000\u0010C\"\u00020\"2\u00020\"*\f\b\u0000\u0010D\"\u0002012\u000201\u00a8\u0006E"}, d2={"Lcom/streamlayer/inplay/common/GameStatus;", "Lio/streamlayer/sdk/model/betting/GameStatusProto;", "Lio/streamlayer/sdk/model/betting/GameStatus;", "toDomain", "Lcom/streamlayer/inplay/common/Game;", "Lio/streamlayer/sdk/model/betting/GameProto;", "Lio/streamlayer/sdk/model/betting/Game;", "Lcom/streamlayer/inplay/common/Score;", "Lio/streamlayer/sdk/model/betting/ScoreProto;", "Lio/streamlayer/sdk/model/betting/Score;", "Lcom/streamlayer/inplay/common/EventTime;", "Lio/streamlayer/sdk/model/betting/EventTimeProto;", "Lio/streamlayer/sdk/model/betting/EventTime;", "Lcom/streamlayer/inplay/common/Period;", "Lio/streamlayer/sdk/model/betting/PeriodProto;", "Lio/streamlayer/sdk/model/betting/Period;", "Lcom/streamlayer/inplay/common/Market;", "Lio/streamlayer/sdk/model/betting/MarketProto;", "Lio/streamlayer/sdk/model/betting/Market;", "Lcom/streamlayer/inplay/common/Selection;", "Lio/streamlayer/sdk/model/betting/SelectionProto;", "Lio/streamlayer/sdk/model/betting/Selection;", "Lcom/streamlayer/inplay/common/SelectionResult;", "Lio/streamlayer/sdk/model/betting/SelectionResultProto;", "Lio/streamlayer/sdk/model/betting/SelectionResult;", "Lcom/streamlayer/inplay/common/SelectionRange;", "Lio/streamlayer/sdk/model/betting/SelectionRangeProto;", "Lio/streamlayer/sdk/model/betting/SelectionRange;", "Lcom/streamlayer/inplay/common/SelectionOutcome;", "Lio/streamlayer/sdk/model/betting/SelectionOutcomeProto;", "Lio/streamlayer/sdk/model/betting/SelectionOutcome;", "Lcom/streamlayer/inplay/common/SelectionResultStatus;", "Lio/streamlayer/sdk/model/betting/SelectionResultStatusProto;", "Lio/streamlayer/sdk/model/betting/SelectionResultStatus;", "Lcom/streamlayer/inplay/common/SelectionStatus;", "Lio/streamlayer/sdk/model/betting/SelectionStatusProto;", "Lio/streamlayer/sdk/model/betting/SelectionStatus;", "Lcom/streamlayer/inplay/common/MarketStatus;", "Lio/streamlayer/sdk/model/betting/MarketStatusProto;", "Lio/streamlayer/sdk/model/betting/MarketStatus;", "Lcom/streamlayer/inplay/common/Competitor;", "Lio/streamlayer/sdk/model/betting/CompetitorProto;", "Lio/streamlayer/sdk/model/betting/Competitor;", "Lcom/streamlayer/inplay/common/CompetitorType;", "Lio/streamlayer/sdk/model/betting/CompetitorTypeProto;", "Lio/streamlayer/sdk/model/betting/CompetitorType;", "Lcom/streamlayer/inplay/League;", "Lio/streamlayer/sdk/model/betting/LeagueProto;", "Lio/streamlayer/sdk/model/betting/League;", "Lcom/streamlayer/inplay/Sport;", "Lio/streamlayer/sdk/model/betting/SportProto;", "Lio/streamlayer/sdk/model/betting/Sport;", "CompetitorProto", "CompetitorTypeProto", "EventTimeProto", "GameProto", "GameStatusProto", "LeagueProto", "MarketProto", "MarketStatusProto", "PeriodProto", "ScoreProto", "SelectionOutcomeProto", "SelectionProto", "SelectionRangeProto", "SelectionResultProto", "SelectionResultStatusProto", "SelectionStatusProto", "SportProto", "sdk_originalRelease"})
public final class BettingKt {
    @NotNull
    public static final GameStatus toDomain(@NotNull com.streamlayer.inplay.common.GameStatus gameStatus) {
        GameStatus gameStatus2;
        Intrinsics.checkNotNullParameter((Object)gameStatus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[gameStatus.ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 4: 
            case 5: {
                gameStatus2 = GameStatus.GAME_STATUS_UNSET;
                break;
            }
            case 3: {
                gameStatus2 = GameStatus.GAME_STATUS_FINISHED;
                break;
            }
            case 2: {
                gameStatus2 = GameStatus.GAME_STATUS_STARTED;
                break;
            }
            case 1: {
                gameStatus2 = GameStatus.GAME_STATUS_NOT_STARTED;
            }
        }
        return gameStatus2;
    }

    @NotNull
    public static final Game toDomain(@NotNull com.streamlayer.inplay.common.Game object) {
        ArrayList<Period> arrayList;
        ArrayList<Market> arrayList2;
        com.streamlayer.inplay.common.Game game = object;
        Intrinsics.checkNotNullParameter((Object)game, (String)"<this>");
        String string2 = game.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id");
        String string3 = game.getSport();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sport");
        String string4 = game.getScheduled();
        String string5 = game.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"name");
        String string6 = game.getLeague();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"league");
        com.streamlayer.inplay.common.Competitor competitor = game.getHome();
        Intrinsics.checkNotNullExpressionValue((Object)competitor, (String)"home");
        Competitor competitor2 = BettingKt.toDomain(competitor);
        com.streamlayer.inplay.common.Competitor competitor3 = game.getAway();
        Intrinsics.checkNotNullExpressionValue((Object)competitor3, (String)"away");
        Competitor competitor4 = BettingKt.toDomain(competitor3);
        long l = game.getScheduledTimestamp();
        Object object2 = game.getMarketsList();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"marketsList");
        Object object3 = arrayList2;
        arrayList2 = new ArrayList<Market>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            com.streamlayer.inplay.common.Market market = (com.streamlayer.inplay.common.Market)object2.next();
            Intrinsics.checkNotNullExpressionValue((Object)market, (String)"it");
            object3.add(BettingKt.toDomain(market));
        }
        object2 = CollectionsKt.toMutableList(object3);
        object3 = object.getPeriodsList();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"periodsList");
        ArrayList<Period> arrayList3 = arrayList;
        arrayList = new ArrayList<Period>(CollectionsKt.collectionSizeOrDefault(object3, (int)10));
        object3 = object3.iterator();
        while (object3.hasNext()) {
            com.streamlayer.inplay.common.Period period = (com.streamlayer.inplay.common.Period)object3.next();
            Intrinsics.checkNotNullExpressionValue((Object)period, (String)"it");
            arrayList3.add(BettingKt.toDomain(period));
        }
        com.streamlayer.inplay.common.Game game2 = object;
        com.streamlayer.inplay.common.EventTime eventTime = game2.getEventTime();
        Intrinsics.checkNotNullExpressionValue((Object)eventTime, (String)"eventTime");
        object = BettingKt.toDomain(eventTime);
        com.streamlayer.inplay.common.Score score = game2.getScore();
        Intrinsics.checkNotNullExpressionValue((Object)score, (String)"score");
        object3 = BettingKt.toDomain(score);
        com.streamlayer.inplay.common.GameStatus gameStatus = game2.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)gameStatus, (String)"status");
        GameStatus gameStatus2 = BettingKt.toDomain(gameStatus);
        return new Game(string2, string3, string4, string5, string6, competitor2, competitor4, l, (List<Market>)object2, arrayList3, (EventTime)object, (Score)object3, gameStatus2);
    }

    @NotNull
    public static final Score toDomain(@NotNull com.streamlayer.inplay.common.Score score) {
        Intrinsics.checkNotNullParameter((Object)score, (String)"<this>");
        com.streamlayer.inplay.common.Score score2 = score;
        int n = score2.getHome();
        return new Score(n, score2.getAway());
    }

    @NotNull
    public static final EventTime toDomain(@NotNull com.streamlayer.inplay.common.EventTime object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.inplay.common.EventTime eventTime = object;
        object = eventTime.getClock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clock");
        return new EventTime((String)object, eventTime.getPeriod());
    }

    @NotNull
    public static final Period toDomain(@NotNull com.streamlayer.inplay.common.Period period) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"<this>");
        com.streamlayer.inplay.common.Period period2 = period;
        int n = period2.getNumber();
        int n2 = period2.getScoreHome();
        int n3 = period2.getScoreAway();
        return new Period(n, n2, n3);
    }

    @NotNull
    public static final Market toDomain(@NotNull com.streamlayer.inplay.common.Market object) {
        ArrayList<Selection> arrayList;
        com.streamlayer.inplay.common.Market market = object;
        Intrinsics.checkNotNullParameter((Object)market, (String)"<this>");
        object = market.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"id");
        int n = market.getSequence();
        String string2 = market.getExpiryUtc();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expiryUtc");
        String string3 = market.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
        String string4 = market.getGame();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"game");
        double d = market.getHandicap();
        String string5 = market.getUpdated();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"updated");
        int n2 = market.getExpiryUtcTimestamp();
        com.streamlayer.inplay.common.MarketStatus marketStatus = market.getTradingStatus();
        Intrinsics.checkNotNullExpressionValue((Object)marketStatus, (String)"tradingStatus");
        MarketStatus marketStatus2 = BettingKt.toDomain(marketStatus);
        Object object2 = market.getSelectionsList();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"selectionsList");
        ArrayList<Selection> arrayList2 = arrayList;
        arrayList = new ArrayList<Selection>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            com.streamlayer.inplay.common.Selection selection = (com.streamlayer.inplay.common.Selection)object2.next();
            Intrinsics.checkNotNullExpressionValue((Object)selection, (String)"it");
            arrayList2.add(BettingKt.toDomain(selection));
        }
        return new Market((String)object, n, string2, string3, string4, d, string5, n2, marketStatus2, arrayList2);
    }

    @NotNull
    public static final Selection toDomain(@NotNull com.streamlayer.inplay.common.Selection object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.inplay.common.Selection selection = object;
        object = selection.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"id");
        String string2 = selection.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        int n = selection.getNumerator();
        int n2 = selection.getDenominator();
        double d = selection.getDecimal();
        double d2 = selection.getProbability();
        String string3 = selection.getUpdated();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"updated");
        com.streamlayer.inplay.common.SelectionStatus selectionStatus = selection.getTradingStatus();
        Intrinsics.checkNotNullExpressionValue((Object)selectionStatus, (String)"tradingStatus");
        SelectionStatus selectionStatus2 = BettingKt.toDomain(selectionStatus);
        com.streamlayer.inplay.common.SelectionOutcome selectionOutcome = selection.getOutcome();
        Intrinsics.checkNotNullExpressionValue((Object)selectionOutcome, (String)"outcome");
        SelectionOutcome selectionOutcome2 = BettingKt.toDomain(selectionOutcome);
        com.streamlayer.inplay.common.SelectionRange selectionRange = selection.getRange();
        Intrinsics.checkNotNullExpressionValue((Object)selectionRange, (String)"range");
        SelectionRange selectionRange2 = BettingKt.toDomain(selectionRange);
        com.streamlayer.inplay.common.SelectionResult selectionResult = selection.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)selectionResult, (String)"result");
        SelectionResult selectionResult2 = BettingKt.toDomain(selectionResult);
        com.streamlayer.inplay.common.SelectionResultStatus selectionResultStatus = selection.getResultStatus();
        Intrinsics.checkNotNullExpressionValue((Object)selectionResultStatus, (String)"resultStatus");
        SelectionResultStatus selectionResultStatus2 = BettingKt.toDomain(selectionResultStatus);
        double d3 = selection.getMoneyline();
        return new Selection((String)object, string2, n, n2, d, d2, string3, selectionStatus2, selectionOutcome2, selectionRange2, selectionResult2, selectionResultStatus2, d3);
    }

    @NotNull
    public static final SelectionResult toDomain(@NotNull com.streamlayer.inplay.common.SelectionResult object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        object = object.getResultStatus();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resultStatus");
        return new SelectionResult((String)object);
    }

    @NotNull
    public static final SelectionRange toDomain(@NotNull com.streamlayer.inplay.common.SelectionRange selectionRange) {
        Intrinsics.checkNotNullParameter((Object)selectionRange, (String)"<this>");
        com.streamlayer.inplay.common.SelectionRange selectionRange2 = selectionRange;
        double d = selectionRange2.getLow();
        double d2 = selectionRange2.getHigh();
        return new SelectionRange(d, d2);
    }

    @NotNull
    public static final SelectionOutcome toDomain(@NotNull com.streamlayer.inplay.common.SelectionOutcome selectionOutcome) {
        Intrinsics.checkNotNullParameter((Object)selectionOutcome, (String)"<this>");
        com.streamlayer.inplay.common.SelectionOutcome selectionOutcome2 = selectionOutcome;
        int n = selectionOutcome2.getId();
        String string2 = selectionOutcome2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        return new SelectionOutcome(n, string2);
    }

    @NotNull
    public static final SelectionResultStatus toDomain(@NotNull com.streamlayer.inplay.common.SelectionResultStatus selectionResultStatus) {
        SelectionResultStatus selectionResultStatus2;
        Intrinsics.checkNotNullParameter((Object)selectionResultStatus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[selectionResultStatus.ordinal()]) {
            default: {
                selectionResultStatus2 = SelectionResultStatus.UNSET;
                break;
            }
            case 6: {
                selectionResultStatus2 = SelectionResultStatus.SELECTION_RESULT_STATUS_WINNER;
                break;
            }
            case 5: {
                selectionResultStatus2 = SelectionResultStatus.SELECTION_RESULT_STATUS_PUSHED;
                break;
            }
            case 4: {
                selectionResultStatus2 = SelectionResultStatus.SELECTION_RESULT_STATUS_PLACED;
                break;
            }
            case 3: {
                selectionResultStatus2 = SelectionResultStatus.SELECTION_RESULT_STATUS_PARTIAL;
                break;
            }
            case 2: {
                selectionResultStatus2 = SelectionResultStatus.SELECTION_RESULT_STATUS_NONE;
                break;
            }
            case 1: {
                selectionResultStatus2 = SelectionResultStatus.SELECTION_RESULT_STATUS_LOSER;
            }
        }
        return selectionResultStatus2;
    }

    @NotNull
    public static final SelectionStatus toDomain(@NotNull com.streamlayer.inplay.common.SelectionStatus selectionStatus) {
        SelectionStatus selectionStatus2;
        Intrinsics.checkNotNullParameter((Object)selectionStatus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$2[selectionStatus.ordinal()]) {
            default: {
                selectionStatus2 = SelectionStatus.UNSET;
                break;
            }
            case 4: {
                selectionStatus2 = SelectionStatus.SELECTION_STATUS_UNPRICED;
                break;
            }
            case 3: {
                selectionStatus2 = SelectionStatus.SELECTION_STATUS_TRADING;
                break;
            }
            case 2: {
                selectionStatus2 = SelectionStatus.SELECTION_STATUS_SUSPENDED;
                break;
            }
            case 1: {
                selectionStatus2 = SelectionStatus.SELECTION_STATUS_NON_RUNNER;
            }
        }
        return selectionStatus2;
    }

    @NotNull
    public static final MarketStatus toDomain(@NotNull com.streamlayer.inplay.common.MarketStatus marketStatus) {
        Intrinsics.checkNotNullParameter((Object)marketStatus, (String)"<this>");
        int n = WhenMappings.$EnumSwitchMapping$3[marketStatus.ordinal()];
        return n != 1 ? (n != 2 ? (n != 3 ? MarketStatus.UNSET : MarketStatus.MARKET_STATUS_SUSPENDED) : MarketStatus.MARKET_STATUS_OPEN) : MarketStatus.MARKET_STATUS_CLOSED;
    }

    @NotNull
    public static final Competitor toDomain(@NotNull com.streamlayer.inplay.common.Competitor object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.inplay.common.Competitor competitor = object;
        object = competitor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
        com.streamlayer.inplay.common.CompetitorType competitorType = competitor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)competitorType, (String)"type");
        CompetitorType competitorType2 = BettingKt.toDomain(competitorType);
        long l = competitor.getId();
        String string2 = competitor.getLogo();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"logo");
        String string3 = competitor.getColors();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"colors");
        return new Competitor((String)object, competitorType2, l, string2, string3);
    }

    @NotNull
    public static final CompetitorType toDomain(@NotNull com.streamlayer.inplay.common.CompetitorType competitorType) {
        Intrinsics.checkNotNullParameter((Object)competitorType, (String)"<this>");
        int n = WhenMappings.$EnumSwitchMapping$4[competitorType.ordinal()];
        return n != 1 ? (n != 2 ? CompetitorType.UNSET : CompetitorType.COMPETITOR_TYPE_TEAM) : CompetitorType.COMPETITOR_TYPE_PERSON;
    }

    @NotNull
    public static final League toDomain(@NotNull com.streamlayer.inplay.League object) {
        com.streamlayer.inplay.League league = object;
        Intrinsics.checkNotNullParameter((Object)league, (String)"<this>");
        long l = league.getId();
        object = league.getName();
        long l2 = league.getSportId();
        String string2 = league.getRegion();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"region");
        return new League(l, (String)object, string2, l2);
    }

    @NotNull
    public static final Sport toDomain(@NotNull com.streamlayer.inplay.Sport object) {
        ArrayList<Country> arrayList;
        com.streamlayer.inplay.Sport sport = object;
        Intrinsics.checkNotNullParameter((Object)sport, (String)"<this>");
        long l = sport.getId();
        object = sport.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
        Object object2 = sport.getCountriesList();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"countriesList");
        ArrayList<Country> arrayList2 = arrayList;
        arrayList = new ArrayList<Country>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3;
            com.streamlayer.inplay.Country country = object3 = (com.streamlayer.inplay.Country)object2.next();
            object3 = country.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"ct.name");
            List list = country.getLeaguesList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ct.leaguesList");
            String string2 = country.getAlpha2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ct.alpha2");
            String string3 = country.getAlpha3();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ct.alpha3");
            arrayList2.add(new Country((String)object3, list, string2, string3));
        }
        return new Sport(l, (String)object, arrayList2);
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[com.streamlayer.inplay.common.GameStatus.values().length];
            nArray[com.streamlayer.inplay.common.GameStatus.GAME_STATUS_NOT_STARTED.ordinal()] = 1;
            nArray[com.streamlayer.inplay.common.GameStatus.GAME_STATUS_STARTED.ordinal()] = 2;
            nArray[com.streamlayer.inplay.common.GameStatus.GAME_STATUS_FINISHED.ordinal()] = 3;
            nArray[com.streamlayer.inplay.common.GameStatus.GAME_STATUS_UNSET.ordinal()] = 4;
            nArray[com.streamlayer.inplay.common.GameStatus.UNRECOGNIZED.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
            int[] nArray2 = new int[com.streamlayer.inplay.common.SelectionResultStatus.values().length];
            nArray2[com.streamlayer.inplay.common.SelectionResultStatus.SELECTION_RESULT_STATUS_LOSER.ordinal()] = 1;
            nArray2[com.streamlayer.inplay.common.SelectionResultStatus.SELECTION_RESULT_STATUS_NONE.ordinal()] = 2;
            nArray2[com.streamlayer.inplay.common.SelectionResultStatus.SELECTION_RESULT_STATUS_PARTIAL.ordinal()] = 3;
            nArray2[com.streamlayer.inplay.common.SelectionResultStatus.SELECTION_RESULT_STATUS_PLACED.ordinal()] = 4;
            nArray2[com.streamlayer.inplay.common.SelectionResultStatus.SELECTION_RESULT_STATUS_PUSHED.ordinal()] = 5;
            nArray2[com.streamlayer.inplay.common.SelectionResultStatus.SELECTION_RESULT_STATUS_WINNER.ordinal()] = 6;
            $EnumSwitchMapping$1 = nArray2;
            int[] nArray3 = new int[com.streamlayer.inplay.common.SelectionStatus.values().length];
            nArray3[com.streamlayer.inplay.common.SelectionStatus.SELECTION_STATUS_NON_RUNNER.ordinal()] = 1;
            nArray3[com.streamlayer.inplay.common.SelectionStatus.SELECTION_STATUS_SUSPENDED.ordinal()] = 2;
            nArray3[com.streamlayer.inplay.common.SelectionStatus.SELECTION_STATUS_TRADING.ordinal()] = 3;
            nArray3[com.streamlayer.inplay.common.SelectionStatus.SELECTION_STATUS_UNPRICED.ordinal()] = 4;
            $EnumSwitchMapping$2 = nArray3;
            int[] nArray4 = new int[com.streamlayer.inplay.common.MarketStatus.values().length];
            nArray4[com.streamlayer.inplay.common.MarketStatus.MARKET_STATUS_CLOSED.ordinal()] = 1;
            nArray4[com.streamlayer.inplay.common.MarketStatus.MARKET_STATUS_OPEN.ordinal()] = 2;
            nArray4[com.streamlayer.inplay.common.MarketStatus.MARKET_STATUS_SUSPENDED.ordinal()] = 3;
            $EnumSwitchMapping$3 = nArray4;
            int[] nArray5 = new int[com.streamlayer.inplay.common.CompetitorType.values().length];
            nArray5[com.streamlayer.inplay.common.CompetitorType.COMPETITOR_TYPE_PERSON.ordinal()] = 1;
            nArray5[com.streamlayer.inplay.common.CompetitorType.COMPETITOR_TYPE_TEAM.ordinal()] = 2;
            $EnumSwitchMapping$4 = nArray5;
        }
    }
}

