/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.SoundPool;
import io.streamlayer.common.data.notifications.NotificationUtil;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.analytics.AnalyticsDataKt;
import io.streamlayer.sdk.model.analytics.CommonKind;
import io.streamlayer.sdk.model.analytics.NotificationKind;
import io.streamlayer.sdk.model.analytics.NotificationType;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.messaging.TopicType;
import io.streamlayer.sdk.model.messaging.WaveMessage;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationKt;
import io.streamlayer.sdk.model.predictions.QuestionNotification;
import io.streamlayer.sdk.model.sdksettings.ClientSettings;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010/\u001a\u00020.\u0012\u0006\u00102\u001a\u000201\u0012\u0006\u00105\u001a\u000204\u0012\u0006\u00108\u001a\u000207\u00a2\u0006\u0004\bN\u0010OJ\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\tJ\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012J\u0006\u0010\u0015\u001a\u00020\u0004J>\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\tJ\u0016\u0010!\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010$\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\"J\u000e\u0010'\u001a\u00020\u00042\u0006\u0010&\u001a\u00020%J\u000e\u0010(\u001a\u00020\u00042\u0006\u0010&\u001a\u00020%J\u000e\u0010)\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010*\u001a\u00020\u0004J\u0016\u0010-\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0016R\u0016\u0010/\u001a\u00020.8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0016\u00102\u001a\u0002018\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00105\u001a\u0002048\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0016\u00108\u001a\u0002078\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u001c\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00160:8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0016\u0010>\u001a\u00020=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u001e\u0010B\u001a\n A*\u0004\u0018\u00010@0@8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0016\u0010D\u001a\u00020\u001b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0016\u0010F\u001a\u00020\u001b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010ER\u0018\u0010I\u001a\u0004\u0018\u00010\u00168B@\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0018\u0010M\u001a\u0004\u0018\u00010J8B@\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006P"}, d2={"Lio/streamlayer/common/data/notifications/InAppNotificationsService;", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "", "showNotification", "showInAppNotification", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "type", "", "isSoundEnabled", "playNotificationSound", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "chatMessage", "increment", "notifyChatMessage", "Lio/streamlayer/sdk/model/calls/WatchParty;", "watchParty", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "inviterContact", "notifyWatchParty", "notifyPredictionBanner", "", "questionId", "result", "icon", "smallIcon", "", "points", "right", "notifyPredictionResult", "Lio/streamlayer/sdk/model/predictions/QuestionNotification;", "questionNotification", "notifyPrediction", "Lio/streamlayer/sdk/model/social/Tweet;", "tweet", "notifyTweet", "Lio/streamlayer/sdk/model/messaging/WaveMessage;", "waveMessage", "notifyFriendJoinToChat", "notifyWaveMessage", "playSound", "disconnect", "pause", "chatId", "pauseNotifications", "Landroid/content/Context;", "context", "Landroid/content/Context;", "Lio/streamlayer/common/session/Session;", "session", "Lio/streamlayer/common/session/Session;", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "notificationsRepo", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "analyticsRepo", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "", "pausedTopicsNotifications", "Ljava/util/List;", "", "lastTimestampSoundPlayed", "J", "Landroid/media/SoundPool;", "kotlin.jvm.PlatformType", "soundPool", "Landroid/media/SoundPool;", "generalSound", "I", "messageSound", "getTinodeUserId", "()Ljava/lang/String;", "tinodeUserId", "Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "getSettings", "()Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "settings", "<init>", "(Landroid/content/Context;Lio/streamlayer/common/session/Session;Lio/streamlayer/sdk/repository/notifications/NotificationRepo;Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;)V", "sdk_originalRelease"})
public final class InAppNotificationsService {
    @NotNull
    private final Context context;
    @NotNull
    private final Session session;
    @NotNull
    private final NotificationRepo notificationsRepo;
    @NotNull
    private final AnalyticsRepo analyticsRepo;
    @NotNull
    private final List<String> pausedTopicsNotifications;
    private long lastTimestampSoundPlayed;
    private final SoundPool soundPool;
    private final int generalSound;
    private final int messageSound;

    public InAppNotificationsService(@NotNull Context context, @NotNull Session session2, @NotNull NotificationRepo notificationRepo, @NotNull AnalyticsRepo analyticsRepo) {
        InAppNotificationsService inAppNotificationsService = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)notificationRepo, (String)"notificationsRepo");
        Intrinsics.checkNotNullParameter((Object)analyticsRepo, (String)"analyticsRepo");
        this.context = context;
        this.session = session2;
        this.notificationsRepo = notificationRepo;
        inAppNotificationsService.analyticsRepo = analyticsRepo;
        inAppNotificationsService.pausedTopicsNotifications = new ArrayList<String>();
        session2 = new SoundPool.Builder().setMaxStreams(2).setAudioAttributes(new AudioAttributes.Builder().setUsage(5).setContentType(4).build()).build();
        this.soundPool = session2;
        this.generalSound = session2.load(context, R.raw.slr_general_notification, 1);
        inAppNotificationsService.messageSound = session2.load(context, R.raw.slr_message_notification, 1);
    }

    private final String getTinodeUserId() {
        return this.session.getTinodeUserId();
    }

    private final ClientSettings getSettings() {
        return this.session.getClientSettings();
    }

    public static /* synthetic */ void notifyChatMessage$default(InAppNotificationsService inAppNotificationsService, ChatMessage chatMessage, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        inAppNotificationsService.notifyChatMessage(chatMessage, bl);
    }

    public static /* synthetic */ void notifyPredictionResult$default(InAppNotificationsService inAppNotificationsService, String string, String string2, String string3, String string4, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        inAppNotificationsService.notifyPredictionResult(string, string2, string3, string4, n, bl);
    }

    private final void showNotification(Notification notification) {
        NotificationUtil notificationUtil = NotificationUtil.INSTANCE;
        if (notificationUtil.isNotificationEnabled$sdk_originalRelease(this.session, notification) && notificationUtil.isAppInForeground()) {
            this.showInAppNotification(notification);
        }
    }

    private final void showInAppNotification(Notification object) {
        if (ArraysKt.contains((Object[])new io.streamlayer.sdk.model.notifications.NotificationType[]{io.streamlayer.sdk.model.notifications.NotificationType.WatchParty, io.streamlayer.sdk.model.notifications.NotificationType.WaveReply}, (Object)((Object)object.getType()))) {
            object2.notificationsRepo.upsertNotificationBySourceId((Notification)object);
        } else {
            object2.notificationsRepo.saveNotification((Notification)object);
        }
        if (NotificationUtil.INSTANCE.isAppInForeground()) {
            InAppNotificationsService inAppNotificationsService = object2;
            inAppNotificationsService.playSound(object.getType());
            Notification notification = object;
            Object object2 = NotificationType.IN_APP;
            object = AnalyticsDataKt.toKind(notification.getType());
            CommonKind commonKind = CommonKind.NOTIFICATION_RECEIVED;
            String string = NotificationKt.getTopicId(notification);
            AnalyticsRepo.DefaultImpls.triggerNotificationEvent$default(inAppNotificationsService.analyticsRepo, (NotificationType)((Object)object2), (NotificationKind)((Object)object), commonKind, null, string, 8, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isSoundEnabled(io.streamlayer.sdk.model.notifications.NotificationType var1_1) {
        switch (WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()]) lbl-1000:
        // 4 sources

        {
            default: {
                v0 = true;
                break;
            }
lbl5:
            // 4 sources

            case 4: {
                v0 = false;
                break;
            }
            case 3: {
                if ((this = this.getSettings()) == null || !this.getFriendsSound()) ** GOTO lbl5
                ** GOTO lbl-1000
            }
            case 2: {
                if ((this = this.getSettings()) == null || !this.getCallsSound()) ** GOTO lbl5
                ** GOTO lbl-1000
            }
            case 1: {
                if ((this = this.getSettings()) == null || !this.getMessagesSound()) ** GOTO lbl5
                ** GOTO lbl-1000
            }
        }
        return v0;
    }

    private final void playNotificationSound(io.streamlayer.sdk.model.notifications.NotificationType notificationType) {
        long l = System.currentTimeMillis();
        if (l > this.lastTimestampSoundPlayed + (long)1200) {
            this.lastTimestampSoundPlayed = l;
            int n = WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()] == 1 ? this.messageSound : this.generalSound;
            this.soundPool.play(n, 1.0f, 1.0f, 0, 0, 1.0f);
        }
    }

    public final void notifyChatMessage(@NotNull ChatMessage object, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"chatMessage");
        if (!NotificationUtil.INSTANCE.isAppInForeground()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)((ChatMessage)object).getSenderUserId(), (Object)this.getTinodeUserId()) && !StringsKt.isBlank((CharSequence)((ChatMessage)object).getText())) {
            ChatMessage chatMessage = object;
            object = chatMessage.getTopicId();
            Notification notification = NotificationUtilKt.toNotification$default(chatMessage, null, 1, null);
            if (!this.pausedTopicsNotifications.contains(object)) {
                if (bl) {
                    this.session.incrementTotalUnreadMessagesCount();
                }
                this.showNotification(notification);
            }
            return;
        }
    }

    public final void notifyWatchParty(@NotNull WatchParty object, @Nullable TinodeContact object2) {
        Object object3;
        WatchParty watchParty = object;
        Intrinsics.checkNotNullParameter((Object)watchParty, (String)"watchParty");
        Topic topic2 = watchParty.getData();
        if (topic2.getType() != TopicType.MANAGED_WP && !Intrinsics.areEqual((Object)((object3 = ((WatchParty)object).getOwner()) == null ? null : ((TinodeContact)object3).getChatUserId()), (Object)this.getTinodeUserId()) && !Intrinsics.areEqual((Object)(object2 == null ? null : ((TinodeContact)object2).getChatUserId()), (Object)this.getTinodeUserId())) {
            Notification notification;
            Date date;
            object3 = topic2.getChatId();
            Long l = null;
            Object object4 = this.context;
            int n = R.string.slr_s_is_having_a_watch_party;
            Object object5 = new Object[1];
            int n2 = 0;
            Object object6 = object2 == null ? null : ((TinodeContact)object2).getChatName();
            WatchParty watchParty2 = object;
            object5[n2] = object6;
            object = object4.getString(n, object5);
            object4 = watchParty2.getStreamTitle();
            String string2 = io.streamlayer.sdk.model.notifications.NotificationType.WatchParty.name();
            object5 = date;
            date = new Date();
            String string3 = Intrinsics.stringPlus((String)"topic_", (Object)topic2.getChatId());
            if (object2 == null) {
                object2 = null;
            } else {
                TinodeContact tinodeContact = object2;
                object2 = NotificationIcon.Companion;
                object6 = tinodeContact.getPhotoData();
                String string4 = tinodeContact.getChatName();
                if (string4 == null) {
                    string4 = "";
                }
                object2 = ((NotificationIcon.Companion)object2).buildAvatarIcon((String)object6, string4);
            }
            object6 = notification;
            notification = new Notification(l, (String)object, (String)object4, string2, (Date)object5, string3, topic2, (NotificationIcon)object2);
            if (!this.pausedTopicsNotifications.contains(object3)) {
                this.showNotification((Notification)object6);
            }
            return;
        }
    }

    public final void notifyPredictionBanner() {
        Date date;
        InAppNotificationsService inAppNotificationsService = string2;
        String string2 = io.streamlayer.sdk.model.notifications.NotificationType.PredictionOnboarding.name();
        Date date2 = date;
        date = new Date();
        inAppNotificationsService.showNotification(new Notification(null, null, null, string2, date2, null, null, null, 230, null));
    }

    public final void notifyPredictionResult(@NotNull String string2, @NotNull String string3, @Nullable String string4, @Nullable String object, int n, boolean bl) {
        Date date;
        NotificationIcon notificationIcon;
        LinkedHashMap<String, String> linkedHashMap;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"questionId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"result");
        LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<String, String>();
        if (string4 != null) {
            linkedHashMap2.put("icon", string4);
        }
        if (object != null) {
            linkedHashMap2.put("smallIcon", (String)object);
        }
        string4 = bl ? n + "pts!" : null;
        InAppNotificationsService inAppNotificationsService = string5;
        String string5 = io.streamlayer.sdk.model.notifications.NotificationType.PredictionResult.name();
        object = notificationIcon;
        notificationIcon = new NotificationIcon(linkedHashMap2);
        Date date2 = date;
        date = new Date();
        inAppNotificationsService.showInAppNotification(new Notification(null, string3, string4, string5, date2, string2, null, (NotificationIcon)object, 64, null));
    }

    public final void notifyPrediction(@NotNull QuestionNotification questionNotification, @NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)questionNotification, (String)"questionNotification");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"questionId");
        this.showNotification(NotificationUtilKt.toNotification(questionNotification, string3));
    }

    public final void notifyTweet(@NotNull Tweet tweet) {
        Tweet tweet2 = tweet;
        Intrinsics.checkNotNullParameter((Object)tweet2, (String)"tweet");
        this.showNotification(NotificationUtilKt.toNotification(tweet2));
    }

    public final void notifyFriendJoinToChat(@NotNull WaveMessage object) {
        Date date;
        InAppNotificationsService inAppNotificationsService = string2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"waveMessage");
        SLRLog.INSTANCE.d("InAppNotificationsService", Intrinsics.stringPlus((String)"Friend join to chat ", (Object)object));
        WaveMessage waveMessage = object;
        String string2 = waveMessage.getUserName();
        String string3 = io.streamlayer.sdk.model.notifications.NotificationType.JoinToChat.name();
        Date date2 = date;
        date = new Date();
        String string4 = NotificationUtilKt.toWaveSourceId(waveMessage.getChatId());
        WaveMessage waveMessage2 = object;
        object = waveMessage2.getUserAvatar();
        object = NotificationIcon.Companion.buildAvatarIcon((String)object, waveMessage2.getUserName());
        inAppNotificationsService.showNotification(new Notification(null, string2, null, string3, date2, string4, null, (NotificationIcon)object, 64, null));
    }

    public final void notifyWaveMessage(@NotNull WaveMessage waveMessage) {
        Intrinsics.checkNotNullParameter((Object)waveMessage, (String)"waveMessage");
        SLRLog.INSTANCE.d("InAppNotificationsService", Intrinsics.stringPlus((String)"Wave message waveMessage ", (Object)waveMessage));
        String string2 = this.context.getString(R.string.slr_friend_has_arrived, new Object[]{waveMessage.getUserName()});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026ed, waveMessage.userName)");
        this.showNotification(NotificationUtilKt.toNotification(waveMessage, string2));
    }

    public final void playSound(@NotNull io.streamlayer.sdk.model.notifications.NotificationType notificationType) {
        io.streamlayer.sdk.model.notifications.NotificationType notificationType2 = notificationType;
        Intrinsics.checkNotNullParameter((Object)((Object)notificationType2), (String)"type");
        if (!this.isSoundEnabled(notificationType2)) {
            return;
        }
        this.playNotificationSound(notificationType);
    }

    public final void disconnect() {
        this.notificationsRepo.deleteAllNotifications();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void pauseNotifications(boolean bl, @NotNull String string2) {
        InAppNotificationsService inAppNotificationsService;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"chatId");
        if (bl) {
            this.pausedTopicsNotifications.add(string2);
            return;
        }
        try {
            inAppNotificationsService = this;
        }
        catch (Throwable throwable) {
            Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return;
        }
        {
            Result.constructor-impl((Object)inAppNotificationsService.pausedTopicsNotifications.remove(string2));
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[io.streamlayer.sdk.model.notifications.NotificationType.values().length];
            nArray[io.streamlayer.sdk.model.notifications.NotificationType.Chat.ordinal()] = 1;
            nArray[io.streamlayer.sdk.model.notifications.NotificationType.WatchParty.ordinal()] = 2;
            nArray[io.streamlayer.sdk.model.notifications.NotificationType.ArrivingFriend.ordinal()] = 3;
            nArray[io.streamlayer.sdk.model.notifications.NotificationType.WaveReply.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

