/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.extensions;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowMetrics;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import androidx.viewbinding.ViewBinding;
import io.streamlayer.common.extensions.FragmentViewBindingDelegate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a'\u0010\u0005\u001a\u00020\u0004*\u00020\u00002\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001\"\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0014\u0010\t\u001a\u00020\b*\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u001a0\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\"\b\b\u0000\u0010\u000b*\u00020\n*\u00020\u00002\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\fH\u0000\u001a\f\u0010\u0011\u001a\u00020\u0004*\u00020\u0000H\u0000\u001a\f\u0010\u0013\u001a\u00020\b*\u00020\u0012H\u0000\u001a\u0018\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u0014H\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/fragment/app/Fragment;", "", "", "permissions", "", "checkSelfPermission", "(Landroidx/fragment/app/Fragment;[Ljava/lang/String;)Z", "on", "", "keepOnScreen", "Landroidx/viewbinding/ViewBinding;", "T", "Lkotlin/Function1;", "Landroid/view/View;", "viewBindingFactory", "Lio/streamlayer/common/extensions/FragmentViewBindingDelegate;", "bindingDelegate", "canUseBinding", "Landroidx/appcompat/app/AppCompatActivity;", "setFullScreen", "Landroid/app/Activity;", "Lkotlin/Pair;", "", "getScreenSize", "sdk_originalRelease"})
public final class FragmentExtensionsKt {
    public static final boolean checkSelfPermission(@NotNull Fragment fragment, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"permissions");
        for (String string2 : stringArray) {
            if (ContextCompat.checkSelfPermission((Context)fragment.requireContext(), (String)string2) != -1) continue;
            return false;
        }
        return true;
    }

    public static final void keepOnScreen(@NotNull Fragment fragment, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"<this>");
        if (bl) {
            fragment.requireActivity().getWindow().addFlags(128);
        } else {
            fragment.requireActivity().getWindow().clearFlags(128);
        }
    }

    @NotNull
    public static final <T extends ViewBinding> FragmentViewBindingDelegate<T> bindingDelegate(@NotNull Fragment fragment, @NotNull Function1<? super View, ? extends T> function1) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"<this>");
        Intrinsics.checkNotNullParameter(function1, (String)"viewBindingFactory");
        return new FragmentViewBindingDelegate<T>(fragment, function1);
    }

    public static final boolean canUseBinding(@NotNull Fragment fragment) {
        boolean bl;
        Fragment fragment2 = fragment;
        Intrinsics.checkNotNullParameter((Object)fragment2, (String)"<this>");
        try {
            Lifecycle lifecycle = fragment2.getViewLifecycleOwner().getLifecycle();
            Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"viewLifecycleOwner.lifecycle");
            bl = lifecycle.getCurrentState().isAtLeast(Lifecycle.State.INITIALIZED);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static final void setFullScreen(@NotNull AppCompatActivity appCompatActivity) {
        AppCompatActivity appCompatActivity2 = appCompatActivity;
        Intrinsics.checkNotNullParameter((Object)appCompatActivity2, (String)"<this>");
        Window window = appCompatActivity2.getWindow();
        window.clearFlags(0x4000000);
        window.setFlags(1024, 1024);
        window.addFlags(Integer.MIN_VALUE);
        window.addFlags(0x8000000);
        window.getDecorView().setSystemUiVisibility(3846);
        window.setStatusBarColor(0);
    }

    @NotNull
    public static final Pair<Integer, Integer> getScreenSize(@NotNull Activity activity) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"<this>");
        if (Build.VERSION.SDK_INT >= 30) {
            Pair pair2;
            WindowMetrics windowMetrics = activity.getWindowManager().getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"windowManager.currentWindowMetrics");
            activity = windowMetrics.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
            Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"windowMetrics.windowInse\u2026Insets.Type.systemBars())");
            int n = windowMetrics.getBounds().width() - activity.left - activity.right;
            int n2 = windowMetrics.getBounds().height() - activity.top - activity.bottom;
            pair = pair2;
            Integer n3 = n;
            pair2 = new Pair((Object)n3, (Object)n2);
        } else {
            Pair pair3;
            DisplayMetrics displayMetrics;
            DisplayMetrics displayMetrics2 = displayMetrics;
            displayMetrics2();
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics2);
            int n = displayMetrics.widthPixels;
            int n4 = displayMetrics.heightPixels;
            pair = pair3;
            Integer n5 = n;
            pair3 = new Pair((Object)n5, (Object)n4);
        }
        return pair;
    }
}

