/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.database;

import androidx.room.TypeConverter;
import com.google.gson.reflect.TypeToken;
import io.streamlayer.common.utils.GsonUtil;
import io.streamlayer.sdk.model.advertising.AdvertisingImage;
import io.streamlayer.sdk.model.advertising.AdvertisingVideo;
import io.streamlayer.sdk.model.analytics.AnalyticsEventType;
import io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.TopicType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Converters {
    @TypeConverter
    @Nullable
    public final Date timestampToDate(@Nullable Long l) {
        Object object;
        if (l != null) {
            Date date;
            object = date;
            date = new Date(l);
        } else {
            object = (Date)((Object)l);
        }
        return object;
    }

    @TypeConverter
    @Nullable
    public final Long dateToString(@Nullable Date date) {
        return date == null ? null : Long.valueOf(date.getTime());
    }

    @TypeConverter
    @Nullable
    public final List<String> stringToStringList(@Nullable String string) {
        Type type2 = new TypeToken<List<? extends String>>(){}.getType();
        return (List)GsonUtil.INSTANCE.getDefaultGson().fromJson(string, type2);
    }

    @TypeConverter
    @Nullable
    public final String stringListToString(@Nullable List<String> list) {
        return GsonUtil.INSTANCE.getDefaultGson().toJson(list);
    }

    @TypeConverter
    @Nullable
    public final ChatMessageStatus stringToChatStatus(@Nullable String string) {
        return string == null ? null : ChatMessageStatus.valueOf(string);
    }

    @TypeConverter
    @Nullable
    public final String chatStatusToString(@Nullable ChatMessageStatus chatMessageStatus) {
        return chatMessageStatus == null ? null : chatMessageStatus.name();
    }

    @TypeConverter
    @Nullable
    public final Map<String, String> stringToStringMap(@Nullable String string) {
        Type type2 = new TypeToken<Map<String, ? extends String>>(){}.getType();
        return (Map)GsonUtil.INSTANCE.getDefaultGson().fromJson(string, type2);
    }

    @TypeConverter
    @Nullable
    public final String stringMapToString(@Nullable Map<String, String> map2) {
        return GsonUtil.INSTANCE.getDefaultGson().toJson(map2);
    }

    @TypeConverter
    @Nullable
    public final List<AdvertisingImage> stringToAdvertisingImages(@Nullable String string) {
        Type type2 = new TypeToken<List<? extends AdvertisingImage>>(){}.getType();
        return (List)GsonUtil.INSTANCE.getDefaultGson().fromJson(string, type2);
    }

    @TypeConverter
    @Nullable
    public final String advertisingImagesToString(@Nullable List<AdvertisingImage> list) {
        return GsonUtil.INSTANCE.getDefaultGson().toJson(list);
    }

    @TypeConverter
    @Nullable
    public final List<AdvertisingVideo> stringToAdvertisingVideos(@Nullable String string) {
        Type type2 = new TypeToken<List<? extends AdvertisingVideo>>(){}.getType();
        return (List)GsonUtil.INSTANCE.getDefaultGson().fromJson(string, type2);
    }

    @TypeConverter
    @Nullable
    public final String advertisingVideosToString(@Nullable List<AdvertisingVideo> list) {
        return GsonUtil.INSTANCE.getDefaultGson().toJson(list);
    }

    @TypeConverter
    @Nullable
    public final List<WatchPartyParticipantStatus> stringToParticipantStatuses(@Nullable String string) {
        Type type2 = new TypeToken<List<? extends WatchPartyParticipantStatus>>(){}.getType();
        return (List)GsonUtil.INSTANCE.getDefaultGson().fromJson(string, type2);
    }

    @TypeConverter
    @Nullable
    public final String participantStatusesToString(@Nullable List<WatchPartyParticipantStatus> list) {
        return GsonUtil.INSTANCE.getDefaultGson().toJson(list);
    }

    @TypeConverter
    @NotNull
    public final AnalyticsEventType stringToAnalyticsEventType(@NotNull String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"value");
        return AnalyticsEventType.valueOf(string2);
    }

    @TypeConverter
    @NotNull
    public final String analyticsEventTypeToString(@NotNull AnalyticsEventType analyticsEventType) {
        AnalyticsEventType analyticsEventType2 = analyticsEventType;
        Intrinsics.checkNotNullParameter((Object)((Object)analyticsEventType2), (String)"value");
        return analyticsEventType2.name();
    }

    @TypeConverter
    public final int topicTypeToInt(@NotNull TopicType topicType) {
        TopicType topicType2 = topicType;
        Intrinsics.checkNotNullParameter((Object)((Object)topicType2), (String)"value");
        return topicType2.ordinal();
    }

    @TypeConverter
    @NotNull
    public final TopicType intToTopicType(int n) {
        TopicType topicType2;
        block2: {
            for (TopicType topicType2 : TopicType.values()) {
                if (!(topicType2.ordinal() == n)) continue;
                break block2;
            }
            topicType2 = null;
        }
        if (topicType2 == null) {
            topicType2 = TopicType.CHAT;
        }
        return topicType2;
    }
}

