/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.content.Context;
import io.streamlayer.common.data.notifications.NotificationUtil;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.analytics.AnalyticsDataKt;
import io.streamlayer.sdk.model.analytics.CommonKind;
import io.streamlayer.sdk.model.analytics.NotificationKind;
import io.streamlayer.sdk.model.analytics.NotificationType;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.messaging.TopicType;
import io.streamlayer.sdk.model.messaging.WaveMessage;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationKt;
import io.streamlayer.sdk.model.predictions.QuestionNotification;
import io.streamlayer.sdk.model.sdksettings.ClientSettings;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InAppNotificationsService {
    @NotNull
    private final Context context;
    @NotNull
    private final Session session;
    @NotNull
    private final NotificationRepo notificationsRepo;
    @NotNull
    private final AnalyticsRepo analyticsRepo;
    @NotNull
    private final List<String> pausedTopicsNotifications;

    public InAppNotificationsService(@NotNull Context context, @NotNull Session session2, @NotNull NotificationRepo notificationRepo, @NotNull AnalyticsRepo analyticsRepo) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)notificationRepo, (String)"notificationsRepo");
        Intrinsics.checkNotNullParameter((Object)analyticsRepo, (String)"analyticsRepo");
        ((InAppNotificationsService)((Object)arrayList2)).context = context;
        ((InAppNotificationsService)((Object)arrayList2)).session = session2;
        ((InAppNotificationsService)((Object)arrayList2)).notificationsRepo = notificationRepo;
        ((InAppNotificationsService)((Object)arrayList2)).analyticsRepo = analyticsRepo;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.pausedTopicsNotifications = arrayList2;
    }

    private final String getTinodeUserId() {
        return this.session.getTinodeUserId();
    }

    private final ClientSettings getSettings() {
        return this.session.getClientSettings();
    }

    public static /* synthetic */ void notifyChatMessage$default(InAppNotificationsService inAppNotificationsService, ChatMessage chatMessage, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        inAppNotificationsService.notifyChatMessage(chatMessage, bl);
    }

    private final void showNotification(Notification notification) {
        NotificationUtil notificationUtil = NotificationUtil.INSTANCE;
        if (notificationUtil.isNotificationEnabled$sdk_originalRelease(this.session, notification) && notificationUtil.isAppInForeground()) {
            this.showInAppNotification(notification);
        }
    }

    private final void showInAppNotification(Notification object) {
        if (ArraysKt.contains((Object[])new io.streamlayer.sdk.model.notifications.NotificationType[]{io.streamlayer.sdk.model.notifications.NotificationType.WatchParty, io.streamlayer.sdk.model.notifications.NotificationType.WaveReply}, (Object)((Object)object.getType()))) {
            object2.notificationsRepo.upsertNotificationBySourceId((Notification)object);
        } else {
            object2.notificationsRepo.saveNotification((Notification)object);
        }
        if (NotificationUtil.INSTANCE.isAppInForeground()) {
            Notification notification = object;
            Object object2 = NotificationType.IN_APP;
            object = AnalyticsDataKt.toKind(notification.getType());
            CommonKind commonKind = CommonKind.NOTIFICATION_RECEIVED;
            String string = NotificationKt.getTopicId(notification);
            AnalyticsRepo.DefaultImpls.triggerNotificationEvent$default(object2.analyticsRepo, (NotificationType)((Object)object2), (NotificationKind)((Object)object), commonKind, null, string, 8, null);
        }
    }

    public final void notifyChatMessage(@NotNull ChatMessage object, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"chatMessage");
        if (!NotificationUtil.INSTANCE.isAppInForeground()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)((ChatMessage)object).getSenderUserId(), (Object)this.getTinodeUserId()) && !StringsKt.isBlank((CharSequence)((ChatMessage)object).getText())) {
            ChatMessage chatMessage = object;
            object = chatMessage.getTopicId();
            Notification notification = NotificationUtilKt.toNotification$default(chatMessage, null, 1, null);
            if (!this.pausedTopicsNotifications.contains(object)) {
                if (bl) {
                    this.session.incrementTotalUnreadMessagesCount();
                }
                this.showNotification(notification);
            }
            return;
        }
    }

    public final void notifyWatchParty(@NotNull WatchParty object, @Nullable TinodeContact object2) {
        Object object3;
        WatchParty watchParty = object;
        Intrinsics.checkNotNullParameter((Object)watchParty, (String)"watchParty");
        Topic topic2 = watchParty.getData();
        if (topic2.getType() != TopicType.MANAGED_WP && !Intrinsics.areEqual((Object)((object3 = ((WatchParty)object).getOwner()) == null ? null : ((TinodeContact)object3).getChatUserId()), (Object)this.getTinodeUserId()) && !Intrinsics.areEqual((Object)(object2 == null ? null : ((TinodeContact)object2).getChatUserId()), (Object)this.getTinodeUserId())) {
            Notification notification;
            Date date;
            object3 = topic2.getChatId();
            Long l = null;
            Object object4 = this.context;
            int n = R.string.slr_s_is_having_a_watch_party;
            Object object5 = new Object[1];
            int n2 = 0;
            Object object6 = object2 == null ? null : ((TinodeContact)object2).getChatName();
            WatchParty watchParty2 = object;
            object5[n2] = object6;
            object = object4.getString(n, object5);
            object4 = watchParty2.getStreamTitle();
            String string2 = io.streamlayer.sdk.model.notifications.NotificationType.WatchParty.name();
            object5 = date;
            date = new Date();
            String string3 = Intrinsics.stringPlus((String)"topic_", (Object)topic2.getChatId());
            if (object2 == null) {
                object2 = null;
            } else {
                TinodeContact tinodeContact = object2;
                object2 = NotificationIcon.Companion;
                object6 = tinodeContact.getPhotoData();
                String string4 = tinodeContact.getChatName();
                if (string4 == null) {
                    string4 = "";
                }
                object2 = ((NotificationIcon.Companion)object2).buildAvatarIcon((String)object6, string4);
            }
            object6 = notification;
            notification = new Notification(l, (String)object, (String)object4, string2, (Date)object5, string3, topic2, (NotificationIcon)object2);
            if (!this.pausedTopicsNotifications.contains(object3)) {
                this.showNotification((Notification)object6);
            }
            return;
        }
    }

    public final void notifyPredictionBanner() {
        Date date;
        InAppNotificationsService inAppNotificationsService = string2;
        String string2 = io.streamlayer.sdk.model.notifications.NotificationType.PredictionOnboarding.name();
        Date date2 = date;
        date = new Date();
        inAppNotificationsService.showNotification(new Notification(null, null, null, string2, date2, null, null, null, 230, null));
    }

    public final void notifyPrediction(@NotNull QuestionNotification questionNotification, @NotNull String string2, @NotNull io.streamlayer.sdk.model.notifications.NotificationType notificationType) {
        io.streamlayer.sdk.model.notifications.NotificationType notificationType2 = notificationType;
        Intrinsics.checkNotNullParameter((Object)questionNotification, (String)"questionNotification");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"questionId");
        Intrinsics.checkNotNullParameter((Object)((Object)notificationType2), (String)"type");
        this.showNotification(NotificationUtilKt.toNotification(questionNotification, notificationType2, string2));
    }

    public final void notifyTweet(@NotNull Tweet tweet) {
        Tweet tweet2 = tweet;
        Intrinsics.checkNotNullParameter((Object)tweet2, (String)"tweet");
        this.showNotification(NotificationUtilKt.toNotification(tweet2));
    }

    public final void notifyFriendJoinToChat(@NotNull WaveMessage object) {
        Date date;
        InAppNotificationsService inAppNotificationsService = string2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"waveMessage");
        SLRLog.INSTANCE.d("InAppNotificationsService", Intrinsics.stringPlus((String)"Friend join to chat ", (Object)object));
        WaveMessage waveMessage = object;
        String string2 = waveMessage.getUserName();
        String string3 = io.streamlayer.sdk.model.notifications.NotificationType.JoinToChat.name();
        Date date2 = date;
        date = new Date();
        String string4 = NotificationUtilKt.toWaveSourceId(waveMessage.getChatId());
        WaveMessage waveMessage2 = object;
        object = waveMessage2.getUserAvatar();
        object = NotificationIcon.Companion.buildAvatarIcon((String)object, waveMessage2.getUserName());
        inAppNotificationsService.showNotification(new Notification(null, string2, null, string3, date2, string4, null, (NotificationIcon)object, 64, null));
    }

    public final void notifyWaveMessage(@NotNull WaveMessage waveMessage) {
        Intrinsics.checkNotNullParameter((Object)waveMessage, (String)"waveMessage");
        SLRLog.INSTANCE.d("InAppNotificationsService", Intrinsics.stringPlus((String)"Wave message waveMessage ", (Object)waveMessage));
        String string2 = this.context.getString(R.string.slr_friend_has_arrived, new Object[]{waveMessage.getUserName()});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026ed, waveMessage.userName)");
        this.showNotification(NotificationUtilKt.toNotification(waveMessage, string2));
    }

    public final void disconnect() {
        this.notificationsRepo.deleteAllNotifications();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void pauseNotifications(boolean bl, @NotNull String string2) {
        InAppNotificationsService inAppNotificationsService;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"chatId");
        if (bl) {
            this.pausedTopicsNotifications.add(string2);
            return;
        }
        try {
            inAppNotificationsService = this;
        }
        catch (Throwable throwable) {
            Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return;
        }
        {
            Result.constructor-impl((Object)inAppNotificationsService.pausedTopicsNotifications.remove(string2));
        }
    }
}

