/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import androidx.annotation.RequiresApi;
import io.streamlayer.sdk.R;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class NotificationChannelsHelper {
    @NotNull
    public static final NotificationChannelsHelper INSTANCE = new NotificationChannelsHelper();

    private NotificationChannelsHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getChannelName(Context context, Channel channel) {
        String string2;
        int n = WhenMappings.$EnumSwitchMapping$0[channel.ordinal()];
        if (n != 1) {
            if (n != 2) throw new NoWhenBranchMatchedException();
            string2 = context.getString(R.string.slr_notif_channel_low_importance);
        } else {
            string2 = context.getString(R.string.slr_notif_channel_high_importance);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (channel) {\n       \u2026nel_low_importance)\n    }");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getChannelDescription(Context context, Channel channel) {
        String string2;
        int n = WhenMappings.$EnumSwitchMapping$0[channel.ordinal()];
        if (n != 1) {
            if (n != 2) throw new NoWhenBranchMatchedException();
            string2 = context.getString(R.string.slr_notif_channel_low_importance_info);
        } else {
            string2 = context.getString(R.string.slr_notif_channel_high_importance_info);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (channel) {\n       \u2026ow_importance_info)\n    }");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresApi(api=26)
    private final int getChannelPriority(Channel channel) {
        int n = WhenMappings.$EnumSwitchMapping$0[channel.ordinal()];
        if (n == 1) return 4;
        if (n != 2) throw new NoWhenBranchMatchedException();
        return 2;
    }

    public final void initChannels(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = context.getSystemService("notification");
            if (object != null) {
                object = (NotificationManager)object;
                for (Channel channel : Channel.values()) {
                    NotificationChannel notificationChannel;
                    Object object2;
                    if (object.getNotificationChannel(channel.name()) != null) continue;
                    NotificationChannel notificationChannel2 = object2 = notificationChannel;
                    object2 = channel.name();
                    String string2 = this.getChannelName(context, channel);
                    int n = this.getChannelPriority(channel);
                    notificationChannel2((String)object2, (CharSequence)string2, n);
                    notificationChannel.setDescription(this.getChannelDescription(context, channel));
                    object.createNotificationChannel(notificationChannel);
                }
            } else {
                throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
            }
        }
    }

    public static enum Channel {
        streamlayer_high,
        streamlayer_low;

    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Channel.values().length];
            nArray[Channel.streamlayer_high.ordinal()] = 1;
            nArray[Channel.streamlayer_low.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

