/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.voximplant;

import android.content.Context;
import com.voximplant.sdk.Voximplant;
import com.voximplant.sdk.call.CallSettings;
import com.voximplant.sdk.call.ICall;
import com.voximplant.sdk.call.ICallListener;
import com.voximplant.sdk.call.IQualityIssueListener;
import com.voximplant.sdk.call.VideoCodec;
import com.voximplant.sdk.call.VideoFlags;
import com.voximplant.sdk.client.AuthParams;
import com.voximplant.sdk.client.ClientState;
import com.voximplant.sdk.client.IClient;
import com.voximplant.sdk.client.IClientLoginListener;
import com.voximplant.sdk.client.IClientSessionListener;
import com.voximplant.sdk.client.LoginError;
import com.voximplant.sdk.hardware.VideoQuality;
import io.streamlayer.common.data.voximplant.AuthError;
import io.streamlayer.common.data.voximplant.VoxClientManagerKt;
import io.streamlayer.common.data.voximplant.VoximplantClientListener;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.model.auth.VoximplantUser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VoxClientManager
implements IClientSessionListener,
IClientLoginListener {
    @NotNull
    private final IClient client;
    @Nullable
    private VoximplantUser voximplantUser;
    @NotNull
    private final List<String> servers;
    @Nullable
    private Function1<? super AuthError, Unit> reconnectCompletion;
    @NotNull
    private final List<VoximplantClientListener> listeners;

    public VoxClientManager(@NotNull IClient iClient, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)iClient, (String)"client");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.client = iClient;
        this.servers = new ArrayList<String>();
        this.listeners = new ArrayList<VoximplantClientListener>();
        iClient.setClientLoginListener((IClientLoginListener)this);
        iClient.setClientSessionListener((IClientSessionListener)this);
        Voximplant.getCameraManager((Context)context).setCamera(1, VideoQuality.VIDEO_QUALITY_MEDIUM);
    }

    private final VoximplantClientListener getSubscribedListener() {
        Object var1_1;
        block1: {
            for (Object e : ((VoxClientManager)this).listeners) {
                var1_1 = e;
                if (!((VoximplantClientListener)e).isSubscribed()) continue;
                break block1;
            }
            var1_1 = null;
        }
        return var1_1;
    }

    public static /* synthetic */ void connect$default(VoxClientManager voxClientManager, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        voxClientManager.connect((Function1<? super AuthError, Unit>)function1);
    }

    private final void internalLogin() {
        block8: {
            SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"internalLogin ", (Object)((VoxClientManager)this).client.getClientState()));
            if (((VoxClientManager)this).client.getClientState() == ClientState.DISCONNECTED) {
                IClient iClient = ((VoxClientManager)this).client;
                boolean bl = false;
                try {
                    iClient.connect(bl, ((VoxClientManager)this).servers);
                }
                catch (IllegalStateException illegalStateException) {
                    VoximplantClientListener voximplantClientListener = ((VoxClientManager)this).getSubscribedListener();
                    if (voximplantClientListener == null) break block8;
                    voximplantClientListener.onConnectionFailed(AuthError.NetworkIssues);
                }
            }
        }
        if (((VoxClientManager)this).client.getClientState() == ClientState.CONNECTED) {
            Unit unit;
            Object object = ((VoxClientManager)this).voximplantUser;
            if (object == null) {
                unit = null;
            } else {
                VoximplantUser voximplantUser = object;
                object = voximplantUser.getUsername();
                ((VoxClientManager)this).getClient().login((String)object, voximplantUser.getPassword());
                unit = Unit.INSTANCE;
            }
            if (unit == null && (this = ((VoxClientManager)this).getSubscribedListener()) != null) {
                this.onLoginFailed(AuthError.InvalidUsername);
            }
        }
    }

    @NotNull
    public final IClient getClient() {
        return this.client;
    }

    public final void register(@NotNull VoximplantClientListener voximplantClientListener, @Nullable VoximplantUser voximplantUser) {
        VoxClientManager voxClientManager = this;
        Intrinsics.checkNotNullParameter((Object)voximplantClientListener, (String)"listener");
        SLRLog.INSTANCE.d("VoximplantClientManager", Intrinsics.stringPlus((String)"register ", (Object)voximplantClientListener));
        boolean bl = voxClientManager.listeners.isEmpty();
        if (voxClientManager.listeners.isEmpty() ^ true) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((VoximplantClientListener)iterator.next()).updateSubscription(false);
            }
        }
        this.listeners.add(voximplantClientListener);
        voximplantClientListener.updateSubscription(true);
        if (bl && voximplantUser != null) {
            this.login(voximplantUser);
        }
    }

    public final void unregister(@NotNull VoximplantClientListener voximplantClientListener) {
        Intrinsics.checkNotNullParameter((Object)voximplantClientListener, (String)"listener");
        SLRLog.INSTANCE.d("VoximplantClientManager", Intrinsics.stringPlus((String)"unregister ", (Object)voximplantClientListener));
        this.listeners.remove(voximplantClientListener);
        voximplantClientListener.updateSubscription(false);
        if (this.listeners.isEmpty()) {
            this.logout();
        } else {
            ((VoximplantClientListener)CollectionsKt.last(this.listeners)).updateSubscription(true);
        }
    }

    public final void login(@NotNull VoximplantUser voximplantUser) {
        Intrinsics.checkNotNullParameter((Object)voximplantUser, (String)"user");
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"login ", (Object)this.client.getClientState()));
        if (Intrinsics.areEqual((Object)this.voximplantUser, (Object)voximplantUser)) {
            return;
        }
        this.voximplantUser = voximplantUser;
        this.internalLogin();
    }

    public final void logout() {
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"logout ", (Object)this.client.getClientState()));
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            this.client.disconnect();
        }
        this.voximplantUser = null;
    }

    public final void connect(@Nullable Function1<? super AuthError, Unit> function1) {
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"connect ", (Object)this.client.getClientState()));
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            if (function1 != null) {
                function1.invoke(null);
            }
            return;
        }
        this.reconnectCompletion = function1;
        this.internalLogin();
    }

    public void onConnectionEstablished() {
        this.internalLogin();
    }

    public void onConnectionFailed(@Nullable String function1) {
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"onConnectionFailed ", (Object)function1));
        function1 = this.getSubscribedListener();
        if (function1 != null) {
            function1.onConnectionFailed(AuthError.NetworkIssues);
        }
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onConnectionClosed() {
        SLRLog.INSTANCE.i("VoximplantClientManager", "onConnectionClosed");
        Function1<? super AuthError, Unit> function1 = this.getSubscribedListener();
        if (function1 != null) {
            function1.onConnectionClosed();
        }
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginSuccessful(@NotNull String function1, @Nullable AuthParams object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"displayName");
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"onLoginSuccessful ", (Object)function1));
        object = this.getSubscribedListener();
        if (object != null) {
            object.onLoginSuccess((String)function1);
        }
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke(null);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginFailed(@NotNull LoginError object) {
        LoginError loginError = object;
        Intrinsics.checkNotNullParameter((Object)loginError, (String)"reason");
        object = VoxClientManagerKt.access$makeAuthError(loginError);
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"onLoginFailed ", (Object)object));
        Function1<? super AuthError, Unit> function1 = this.getSubscribedListener();
        if (function1 != null) {
            function1.onLoginFailed((AuthError)((Object)object));
        }
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke(object);
        }
        this.reconnectCompletion = null;
    }

    public void onOneTimeKeyGenerated(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"key");
    }

    public void onRefreshTokenFailed(@NotNull LoginError loginError) {
        Intrinsics.checkNotNullParameter((Object)loginError, (String)"reason");
    }

    public void onRefreshTokenSuccess(@NotNull AuthParams authParams) {
        Intrinsics.checkNotNullParameter((Object)authParams, (String)"authParams");
    }

    @Nullable
    public final ICall createCall(@NotNull String string2, boolean bl, @Nullable ICallListener iCallListener, @Nullable IQualityIssueListener iQualityIssueListener) {
        CallSettings callSettings;
        VoxClientManager voxClientManager = voxClientManager2;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        SLRLog.INSTANCE.i("VoximplantClientManager", Intrinsics.stringPlus((String)"createCall ", (Object)string2));
        VoxClientManager voxClientManager2 = callSettings;
        new CallSettings().videoFlags = new VideoFlags(true, bl);
        new CallSettings().preferredVideoCodec = VideoCodec.AUTO;
        voxClientManager2 = voxClientManager.client.callConference(Intrinsics.stringPlus((String)"conf_", (Object)string2), (CallSettings)voxClientManager2);
        if (voxClientManager2 != null) {
            VoxClientManager voxClientManager3 = voxClientManager2;
            voxClientManager3.addCallListener(iCallListener);
            voxClientManager3.setQualityIssueListener(iQualityIssueListener);
            voxClientManager3.start();
        }
        return voxClientManager2;
    }

    public final void endCall(@NotNull ICall iCall, @Nullable ICallListener iCallListener) {
        Intrinsics.checkNotNullParameter((Object)iCall, (String)"call");
        if (iCallListener != null) {
            iCall.removeCallListener(iCallListener);
        }
        ICall iCall2 = iCall;
        iCall2.setQualityIssueListener(null);
        iCall2.hangup(null);
    }
}

