/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.extensions;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowMetrics;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import androidx.viewbinding.ViewBinding;
import io.streamlayer.common.extensions.FragmentViewBindingDelegate;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class FragmentExtensionsKt {
    public static final boolean checkSelfPermission(@NotNull Fragment fragment, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"permissions");
        for (String string2 : stringArray) {
            if (ContextCompat.checkSelfPermission((Context)fragment.requireContext(), (String)string2) != -1) continue;
            return false;
        }
        return true;
    }

    public static final void keepOnScreen(@NotNull Fragment fragment, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"<this>");
        if (bl) {
            fragment.requireActivity().getWindow().addFlags(128);
        } else {
            fragment.requireActivity().getWindow().clearFlags(128);
        }
    }

    @NotNull
    public static final <T extends ViewBinding> FragmentViewBindingDelegate<T> bindingDelegate(@NotNull Fragment fragment, @NotNull Function1<? super View, ? extends T> function1) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"<this>");
        Intrinsics.checkNotNullParameter(function1, (String)"viewBindingFactory");
        return new FragmentViewBindingDelegate<T>(fragment, function1);
    }

    public static final boolean canUseBinding(@NotNull Fragment fragment) {
        boolean bl;
        Fragment fragment2 = fragment;
        Intrinsics.checkNotNullParameter((Object)fragment2, (String)"<this>");
        try {
            Lifecycle lifecycle = fragment2.getViewLifecycleOwner().getLifecycle();
            Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"viewLifecycleOwner.lifecycle");
            bl = lifecycle.getCurrentState().isAtLeast(Lifecycle.State.INITIALIZED);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static final void setFullScreen(@NotNull AppCompatActivity appCompatActivity) {
        AppCompatActivity appCompatActivity2 = appCompatActivity;
        Intrinsics.checkNotNullParameter((Object)appCompatActivity2, (String)"<this>");
        Window window = appCompatActivity2.getWindow();
        window.clearFlags(0x4000000);
        window.setFlags(1024, 1024);
        window.addFlags(Integer.MIN_VALUE);
        window.addFlags(0x8000000);
        window.getDecorView().setSystemUiVisibility(3846);
        window.setStatusBarColor(0);
    }

    @NotNull
    public static final Pair<Integer, Integer> getScreenSize(@NotNull Activity activity) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"<this>");
        if (Build.VERSION.SDK_INT >= 30) {
            Pair pair2;
            WindowMetrics windowMetrics = activity.getWindowManager().getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"windowManager.currentWindowMetrics");
            activity = windowMetrics.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
            Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"windowMetrics.windowInse\u2026Insets.Type.systemBars())");
            int n = windowMetrics.getBounds().width() - activity.left - activity.right;
            int n2 = windowMetrics.getBounds().height() - activity.top - activity.bottom;
            pair = pair2;
            Integer n3 = n;
            pair2 = new Pair((Object)n3, (Object)n2);
        } else {
            Pair pair3;
            DisplayMetrics displayMetrics;
            DisplayMetrics displayMetrics2 = displayMetrics;
            displayMetrics2();
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics2);
            int n = displayMetrics.widthPixels;
            int n4 = displayMetrics.heightPixels;
            pair = pair3;
            Integer n5 = n;
            pair3 = new Pair((Object)n5, (Object)n4);
        }
        return pair;
    }
}

