/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.extensions;

import android.view.View;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.viewbinding.ViewBinding;
import io.streamlayer.common.extensions.FragmentExtensionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FragmentViewBindingDelegate<T extends ViewBinding>
implements ReadOnlyProperty<Fragment, T> {
    @NotNull
    private final Fragment fragment;
    @NotNull
    private final Function1<View, T> viewBindingFactory;
    @Nullable
    private T binding;

    public FragmentViewBindingDelegate(@NotNull Fragment fragment, @NotNull Function1<? super View, ? extends T> function1) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(function1, (String)"viewBindingFactory");
        this.fragment = fragment;
        this.viewBindingFactory = function1;
        fragment.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(){
            @NotNull
            private final Observer<LifecycleOwner> viewLifecycleOwnerLiveDataObserver = arg_0 -> 1.viewLifecycleOwnerLiveDataObserver$lambda-0(fragmentViewBindingDelegate, arg_0);

            private static final void viewLifecycleOwnerLiveDataObserver$lambda-0(FragmentViewBindingDelegate fragmentViewBindingDelegate, LifecycleOwner lifecycleOwner2) {
                Intrinsics.checkNotNullParameter((Object)fragmentViewBindingDelegate, (String)"this$0");
                if (lifecycleOwner2 == null) {
                    return;
                }
                lifecycleOwner2.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(fragmentViewBindingDelegate){
                    final /* synthetic */ FragmentViewBindingDelegate<T> this$0;
                    {
                        this.this$0 = fragmentViewBindingDelegate;
                    }

                    public void onDestroy(@NotNull LifecycleOwner lifecycleOwner2) {
                        Intrinsics.checkNotNullParameter((Object)lifecycleOwner2, (String)"owner");
                        FragmentViewBindingDelegate.access$setBinding$p(this.this$0, null);
                    }
                });
            }

            @NotNull
            public final Observer<LifecycleOwner> getViewLifecycleOwnerLiveDataObserver() {
                return this.viewLifecycleOwnerLiveDataObserver;
            }

            public void onCreate(@NotNull LifecycleOwner lifecycleOwner2) {
                Intrinsics.checkNotNullParameter((Object)lifecycleOwner2, (String)"owner");
                this.getFragment().getViewLifecycleOwnerLiveData().observeForever(this.viewLifecycleOwnerLiveDataObserver);
            }

            public void onDestroy(@NotNull LifecycleOwner lifecycleOwner2) {
                Intrinsics.checkNotNullParameter((Object)lifecycleOwner2, (String)"owner");
                this.getFragment().getViewLifecycleOwnerLiveData().removeObserver(this.viewLifecycleOwnerLiveDataObserver);
            }
        });
    }

    public static final /* synthetic */ void access$setBinding$p(FragmentViewBindingDelegate fragmentViewBindingDelegate, ViewBinding viewBinding) {
        fragmentViewBindingDelegate.binding = viewBinding;
    }

    @NotNull
    public final Fragment getFragment() {
        return this.fragment;
    }

    @NotNull
    public final Function1<View, T> getViewBindingFactory() {
        return this.viewBindingFactory;
    }

    @NotNull
    public T getValue(@NotNull Fragment fragment, @NotNull KProperty<?> object) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"thisRef");
        Intrinsics.checkNotNullParameter(object, (String)"property");
        object = this.binding;
        if (object != null) {
            return (T)object;
        }
        if (FragmentExtensionsKt.canUseBinding(this.fragment)) {
            View view2 = fragment.requireView();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"thisRef.requireView()");
            this.binding = (ViewBinding)this.viewBindingFactory.invoke((Object)view2);
            return this.binding;
        }
        throw new IllegalStateException("Should not attempt to get bindings when Fragment views are destroyed.");
    }
}

