/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.extensions;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import io.streamlayer.common.extensions.KeyboardExtensionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class KeyboardExtensionsKt {
    private static final float KEYBOARD_MIN_HEIGHT_RATIO = 0.15f;

    public static final boolean isKeyboardVisible(@NotNull FragmentActivity object) {
        int n;
        Rect rect;
        FragmentActivity fragmentActivity = object;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"<this>");
        Rect rect2 = rect;
        rect = new Rect();
        View view2 = KeyboardExtensionsKt.getActivityRoot(fragmentActivity);
        view2.getWindowVisibleDisplayFrame(rect2);
        object = new int[2];
        KeyboardExtensionsKt.getContentRoot(object).getLocationOnScreen((int[])object);
        int n2 = view2.getRootView().getHeight();
        return (float)(n - rect2.height() - object[1]) > (float)n2 * 0.15f;
    }

    public static final int getKeyboardHeight(@NotNull FragmentActivity object) {
        Rect rect;
        FragmentActivity fragmentActivity = object;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"<this>");
        Rect rect2 = rect;
        rect = new Rect();
        View view2 = KeyboardExtensionsKt.getActivityRoot(fragmentActivity);
        view2.getWindowVisibleDisplayFrame(rect2);
        object = new int[2];
        KeyboardExtensionsKt.getContentRoot(object).getLocationOnScreen((int[])object);
        return view2.getRootView().getHeight() - rect2.height() - object[1];
    }

    @NotNull
    public static final View getActivityRoot(@NotNull FragmentActivity fragmentActivity) {
        FragmentActivity fragmentActivity2 = fragmentActivity;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity2, (String)"<this>");
        View view2 = KeyboardExtensionsKt.getContentRoot(fragmentActivity2).getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getContentRoot().rootView");
        return view2;
    }

    @NotNull
    public static final ViewGroup getContentRoot(@NotNull FragmentActivity fragmentActivity) {
        FragmentActivity fragmentActivity2 = fragmentActivity;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity2, (String)"<this>");
        View view2 = fragmentActivity2.findViewById(0x1020002);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(android.R.id.content)");
        return (ViewGroup)view2;
    }

    public static final void setInputKeyboardEventListener(@NotNull Fragment fragment, @NotNull Function1<? super Boolean, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"<this>");
        Intrinsics.checkNotNullParameter(function1, (String)"listener");
        FragmentActivity fragmentActivity = fragment.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
        if ((fragmentActivity.getWindow().getAttributes().softInputMode & 0xF0 & 0x30) != 48) {
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener2 = onGlobalLayoutListener;
            onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(fragmentActivity, function1){
                private boolean wasOpened;
                final /* synthetic */ FragmentActivity $activity;
                final /* synthetic */ Function1<Boolean, Unit> $listener;
                {
                    this.$activity = fragmentActivity;
                    this.$listener = function1;
                }

                public void onGlobalLayout() {
                    boolean bl = KeyboardExtensionsKt.isKeyboardVisible(this.$activity);
                    if (bl == this.wasOpened) {
                        return;
                    }
                    this.wasOpened = bl;
                    this.$listener.invoke((Object)bl);
                }
            };
            KeyboardExtensionsKt.getActivityRoot(fragmentActivity).getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener2);
            fragment.getViewLifecycleOwner().getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(fragment, onGlobalLayoutListener2){
                final /* synthetic */ Fragment $this_setInputKeyboardEventListener;
                final /* synthetic */ setInputKeyboardEventListener.layoutListener.1 $layoutListener;
                {
                    this.$this_setInputKeyboardEventListener = fragment;
                    this.$layoutListener = var2_2;
                }

                public void onDestroy(@NotNull LifecycleOwner lifecycleOwner2) {
                    setInputKeyboardEventListener.2 v0 = this;
                    Intrinsics.checkNotNullParameter((Object)lifecycleOwner2, (String)"owner");
                    v0.$this_setInputKeyboardEventListener.getViewLifecycleOwner().getLifecycle().removeObserver((LifecycleObserver)this);
                    FragmentActivity fragmentActivity = v0.$this_setInputKeyboardEventListener.requireActivity();
                    Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
                    KeyboardExtensionsKt.getActivityRoot(fragmentActivity).getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.$layoutListener);
                }
            });
            return;
        }
        throw new IllegalArgumentException("Parameter:activity window SoftInputMethod is SOFT_INPUT_ADJUST_NOTHING. In this case window will not be resized".toString());
    }

    public static final boolean keyboardIsVisible(@NotNull View view2) {
        View view3 = view2;
        Intrinsics.checkNotNullParameter((Object)view3, (String)"<this>");
        view2 = ViewCompat.getRootWindowInsets((View)view3);
        return view2 == null ? false : view2.isVisible(WindowInsetsCompat.Type.ime());
    }
}

