/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.extensions;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.utils.SLRLog;
import java.io.File;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OtherExtensionsKt {
    @NotNull
    public static final String toHex(@NotNull byte[] object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        object = (Object)toHex.1.INSTANCE;
        return ArraysKt.joinToString$default((byte[])object, (CharSequence)"", null, null, (int)0, null, (Function1)object, (int)30, null);
    }

    @NotNull
    public static final String md5(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<this>");
        byte[] byArray = MessageDigest.getInstance("MD5").digest(FilesKt.readBytes((File)file));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(\"MD5\").digest(readBytes())");
        return OtherExtensionsKt.toHex(byArray);
    }

    @NotNull
    public static final String md5(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<this>");
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getInstance(\"MD5\").digest(toByteArray())");
        return OtherExtensionsKt.toHex(byArray2);
    }

    @NotNull
    public static final String toOrdinalString(int n) {
        String string2;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        stringArray[0] = "th";
        stringArray[1] = "st";
        stringArray[2] = "nd";
        stringArray[3] = "rd";
        stringArray[4] = "th";
        stringArray[5] = "th";
        stringArray[6] = "th";
        stringArray[7] = "th";
        stringArray[8] = "th";
        stringArray[9] = "th";
        switch (n % 100) {
            default: {
                string2 = n + stringArray2[n % 10];
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                string2 = String.format("%dth", Arrays.copyOf(new Object[]{n}, 1));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            }
        }
        return string2;
    }

    @NotNull
    public static final String getAppName(@NotNull Context object) {
        Context context = object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"<this>");
        PackageManager packageManager = context.getPackageManager();
        try {
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"this.packageManager");
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(object.getPackageName(), 0);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"pm.getApplicationInfo(this.packageName, 0)");
            object = ((Object)packageManager.getApplicationLabel(applicationInfo)).toString();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = "";
        }
        return object;
    }

    @NotNull
    public static final <T> Flow<T> catchDefault(@NotNull Flow<? extends T> flow, @NotNull String string2, @Nullable String string3) {
        Intrinsics.checkNotNullParameter(flow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"tag");
        return FlowKt.catch(flow, (Function3)new Function3<FlowCollector<? super T>, Throwable, Continuation<? super Unit>, Object>(string2, string3, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ String $tag;
            final /* synthetic */ String $message;
            {
                this.$tag = string2;
                this.$message = string3;
                super(3, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    ResultKt.throwOnFailure((Object)object);
                    object = (Throwable)object2.L$0;
                    catchDefault.1 v0 = object2;
                    Object object2 = v0.$tag;
                    SLRLog.INSTANCE.e((String)object2, v0.$message, (Throwable)object);
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super T> flowCollector, @NotNull Throwable throwable, @Nullable Continuation<? super Unit> continuation) {
                catchDefault.1 v0 = object;
                Object object = v0.$tag;
                new /* invalid duplicate definition of identical inner class */.L$0 = throwable;
                return new /* invalid duplicate definition of identical inner class */.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
    }

    public static /* synthetic */ Flow catchDefault$default(Flow flow, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        return OtherExtensionsKt.catchDefault(flow, string2, string3);
    }

    public static final boolean isScreenPortrait(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"<this>");
        return context2.getResources().getConfiguration().orientation == 1;
    }
}

