/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.extensions;

import android.view.MotionEvent;
import android.view.View;
import org.jetbrains.annotations.Nullable;

public abstract class SwipeListener
implements View.OnTouchListener {
    private final boolean isStartSide;
    private final int swipeThreshold;
    private float x1;
    private float x2;

    public SwipeListener(boolean bl, int n) {
        this.isStartSide = bl;
        this.swipeThreshold = n;
    }

    public final boolean isStartSide() {
        return this.isStartSide;
    }

    public final int getSwipeThreshold() {
        return this.swipeThreshold;
    }

    public boolean onTouch(@Nullable View object, @Nullable MotionEvent motionEvent) {
        object = motionEvent == null ? null : Integer.valueOf(motionEvent.getAction());
        if (object != null && (Integer)object == 0) {
            this.x1 = motionEvent.getX();
        } else {
            int n = 1;
            if (object != null && (Integer)object == n) {
                float f;
                this.x2 = f = motionEvent.getX();
                boolean bl = this.isStartSide;
                f = bl ? (f -= this.x1) : this.x1 - f;
                if (bl && Math.abs(f) > (float)this.swipeThreshold && this.x2 < this.x1 || !this.isStartSide && Math.abs(f) > (float)this.swipeThreshold && this.x1 < this.x2) {
                    this.onSwipe();
                    this.x1 = 0.0f;
                    this.x2 = 0.0f;
                }
            }
        }
        return false;
    }

    public abstract void onSwipe();
}

