/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.mvvm;

import androidx.lifecycle.ViewModel;
import io.streamlayer.sdk.model.analytics.CommonCategory;
import io.streamlayer.sdk.model.analytics.CommonKind;
import io.streamlayer.sdk.model.analytics.InteractionActionType;
import io.streamlayer.sdk.model.analytics.InvitationCategory;
import io.streamlayer.sdk.model.analytics.NotificationKind;
import io.streamlayer.sdk.model.analytics.NotificationType;
import io.streamlayer.sdk.model.analytics.PermissionType;
import io.streamlayer.sdk.model.analytics.WaveCategory;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultViewModel
extends ViewModel
implements AnalyticsRepo {
    @NotNull
    private final AnalyticsRepo analyticsRepo;

    public DefaultViewModel(@NotNull AnalyticsRepo analyticsRepo) {
        Intrinsics.checkNotNullParameter((Object)analyticsRepo, (String)"analyticsRepo");
        this.analyticsRepo = analyticsRepo;
    }

    @Override
    public void triggerAuthenticationEvent(@NotNull CommonKind commonKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerAuthenticationEvent(commonKind);
    }

    @Override
    public void triggerCallEvent(@NotNull String string2, @NotNull CommonKind commonKind, @Nullable Integer n, @Nullable CommonCategory commonCategory) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerCallEvent(string2, commonKind, n, commonCategory);
    }

    @Override
    public void triggerConversationEvent(@NotNull String string2, @NotNull CommonKind commonKind, @Nullable Integer n, @Nullable CommonCategory commonCategory) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerConversationEvent(string2, commonKind, n, commonCategory);
    }

    @Override
    public void triggerInteractionEvent(@NotNull InteractionActionType interactionActionType, @Nullable CommonCategory commonCategory) {
        Intrinsics.checkNotNullParameter((Object)((Object)interactionActionType), (String)"actionType");
        this.analyticsRepo.triggerInteractionEvent(interactionActionType, commonCategory);
    }

    @Override
    public void triggerInvitationEvent(@NotNull CommonKind commonKind, @Nullable String string2, @Nullable InvitationCategory invitationCategory) {
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerInvitationEvent(commonKind, string2, invitationCategory);
    }

    @Override
    public void triggerLaunchButtonInitEvent() {
        this.analyticsRepo.triggerLaunchButtonInitEvent();
    }

    @Override
    public void triggerLaunchButtonTappedEvent() {
        this.analyticsRepo.triggerLaunchButtonTappedEvent();
    }

    @Override
    public void triggerNotificationEvent(@NotNull NotificationType notificationType, @NotNull NotificationKind notificationKind, @NotNull CommonKind commonKind, @Nullable CommonCategory commonCategory, @Nullable String string2) {
        Intrinsics.checkNotNullParameter((Object)((Object)notificationType), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)notificationKind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"commonKind");
        this.analyticsRepo.triggerNotificationEvent(notificationType, notificationKind, commonKind, commonCategory, string2);
    }

    @Override
    public void triggerPermissionEvent(@NotNull PermissionType permissionType, @NotNull CommonKind commonKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)permissionType), (String)"permission");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        this.analyticsRepo.triggerPermissionEvent(permissionType, commonKind);
    }

    @Override
    public void triggerPollEvent(@NotNull String string2, @NotNull CommonKind commonKind, @Nullable CommonCategory commonCategory) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"commonKind");
        this.analyticsRepo.triggerPollEvent(string2, commonKind, commonCategory);
    }

    @Override
    public void triggerSessionHeartbeat(@Nullable String string2) {
        this.analyticsRepo.triggerSessionHeartbeat(string2);
    }

    @Override
    public void triggerWaveEvent(@NotNull CommonKind commonKind, @NotNull String string2, @Nullable WaveCategory waveCategory) {
        Intrinsics.checkNotNullParameter((Object)((Object)commonKind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"eventId");
        this.analyticsRepo.triggerWaveEvent(commonKind, string2, waveCategory);
    }
}

