/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.permissions;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import io.streamlayer.common.permissions.PermissionManager;
import io.streamlayer.common.permissions.PermissionResult;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class PermissionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WeakReference<Fragment> fragment;
    @NotNull
    private final List<String> requiredPermissions;
    @NotNull
    private Function1<? super PermissionResult, Unit> onFail;
    @NotNull
    private Function0<Unit> onSuccess;
    @Nullable
    private final ActivityResultLauncher<String[]> permissionCheck;

    private PermissionManager(WeakReference<Fragment> fragment) {
        PermissionManager permissionManager = this;
        permissionManager.fragment = fragment;
        permissionManager.requiredPermissions = new ArrayList<String>();
        permissionManager.onFail = onFail.1.INSTANCE;
        permissionManager.onSuccess = onSuccess.1.INSTANCE;
        fragment = (Fragment)fragment.get();
        if (fragment == null) {
            fragment = null;
        } else {
            ActivityResultContracts.RequestMultiplePermissions requestMultiplePermissions;
            Fragment fragment2 = fragment;
            fragment = requestMultiplePermissions;
            requestMultiplePermissions = new ActivityResultContracts.RequestMultiplePermissions();
            fragment = fragment2.registerForActivityResult((ActivityResultContract)fragment, arg_0 -> PermissionManager.permissionCheck$lambda-0(this, arg_0));
        }
        this.permissionCheck = fragment;
    }

    private final PermissionResult resolveResult(Map<String, Boolean> object) {
        Fragment fragment;
        PermissionResult permissionResult2;
        PermissionResult permissionResult3 = permissionResult2;
        Fragment fragment2 = fragment;
        fragment = new Function0<Unit>(this){
            final /* synthetic */ PermissionManager this$0;
            {
                this.this$0 = permissionManager;
                super(0);
            }

            public final void invoke() {
                Fragment fragment = (Fragment)PermissionManager.access$getFragment$p(this.this$0).get();
                if (fragment != null && (fragment = fragment.requireActivity()) != null) {
                    PermissionManager.access$goToSettings(this.this$0, (FragmentActivity)fragment);
                }
            }
        };
        permissionResult2 = new PermissionResult((Function0)new Function0<Unit>(this){
            final /* synthetic */ PermissionManager this$0;
            {
                this.this$0 = permissionManager;
                super(0);
            }

            public final void invoke() {
                PermissionManager.access$handlePermissionRequest(this.this$0);
            }
        }, (Function0)fragment2, null, null, null, 28, null);
        fragment2 = (Fragment)this.fragment.get();
        if (fragment2 != null) {
            object = object.entrySet().iterator();
            while (object.hasNext()) {
                String string2 = (String)((Map.Entry)object.next()).getKey();
                if (this.permissionGranted(fragment2, string2)) {
                    permissionResult3.getAccepted().add(string2);
                    continue;
                }
                if (fragment2.shouldShowRequestPermissionRationale(string2)) {
                    permissionResult3.getDenied().add(string2);
                    continue;
                }
                permissionResult3.getForeverDenied().add(string2);
            }
        }
        return permissionResult3;
    }

    private final void handlePermissionRequest() {
        Fragment fragment = (Fragment)this.fragment.get();
        if (fragment != null) {
            if (this.areAllPermissionsGranted(fragment)) {
                this.onSuccess.invoke();
            } else {
                this.requestPermissions();
            }
        }
    }

    private final void requestPermissions() {
        block3: {
            block2: {
                ActivityResultLauncher<String[]> activityResultLauncher = stringArray.permissionCheck;
                if (activityResultLauncher == null) break block2;
                String[] stringArray = stringArray.requiredPermissions.toArray(new String[0]);
                if (stringArray == null) break block3;
                activityResultLauncher.launch((Object)stringArray);
            }
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean areAllPermissionsGranted(Fragment fragment) {
        List<String> list = this.requiredPermissions;
        if (list instanceof Collection && list.isEmpty()) {
            return true;
        }
        list = list.iterator();
        do {
            if (!list.hasNext()) return true;
        } while (this.permissionGranted(fragment, (String)list.next()));
        return false;
    }

    private final boolean permissionGranted(Fragment fragment, String string2) {
        return ContextCompat.checkSelfPermission((Context)fragment.requireContext(), (String)string2) == 0;
    }

    private final void goToSettings(FragmentActivity fragmentActivity) {
        Intent intent;
        PermissionManager permissionManager = intent;
        intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)fragmentActivity.getPackageName(), null));
        fragmentActivity.startActivity((Intent)permissionManager);
    }

    private static final void permissionCheck$lambda-0(PermissionManager permissionManager, Map object) {
        Map map2 = object;
        Intrinsics.checkNotNullParameter((Object)permissionManager, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"it");
        object = permissionManager.resolveResult(map2);
        if (((PermissionResult)object).succeed(permissionManager.requiredPermissions)) {
            permissionManager.onSuccess.invoke();
        } else {
            permissionManager.onFail.invoke(object);
        }
    }

    public /* synthetic */ PermissionManager(WeakReference weakReference, DefaultConstructorMarker defaultConstructorMarker) {
        this(weakReference);
    }

    public static final /* synthetic */ void access$handlePermissionRequest(PermissionManager permissionManager) {
        permissionManager.handlePermissionRequest();
    }

    public static final /* synthetic */ WeakReference access$getFragment$p(PermissionManager permissionManager) {
        return permissionManager.fragment;
    }

    public static final /* synthetic */ void access$goToSettings(PermissionManager permissionManager, FragmentActivity fragmentActivity) {
        permissionManager.goToSettings(fragmentActivity);
    }

    public final void askPermission(@NotNull String string2, @NotNull Function0<Unit> function0, @NotNull Function1<? super PermissionResult, Unit> function1) {
        PermissionManager permissionManager = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"permission");
        Intrinsics.checkNotNullParameter(function0, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(function1, (String)"onFail");
        permissionManager.requiredPermissions.clear();
        permissionManager.requiredPermissions.add(string2);
        this.onSuccess = function0;
        this.onFail = function1;
        this.handlePermissionRequest();
    }

    public final void askPermissions(@NotNull List<String> list, @NotNull Function0<Unit> function0, @NotNull Function1<? super PermissionResult, Unit> function1) {
        PermissionManager permissionManager = this;
        Intrinsics.checkNotNullParameter(list, (String)"permissions");
        Intrinsics.checkNotNullParameter(function0, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(function1, (String)"onFail");
        permissionManager.requiredPermissions.clear();
        permissionManager.requiredPermissions.addAll(list);
        this.onSuccess = function0;
        this.onFail = function1;
        this.handlePermissionRequest();
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @NotNull
        public final PermissionManager from(@NotNull Fragment fragment) {
            WeakReference<Fragment> weakReference;
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            WeakReference<Fragment> weakReference2 = weakReference;
            weakReference = new WeakReference<Fragment>(fragment);
            return new PermissionManager(weakReference2, null);
        }
    }
}

