/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.permissions;

import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PermissionResult {
    @NotNull
    private final Function0<Unit> askAgain;
    @NotNull
    private final Function0<Unit> goToSettings;
    @NotNull
    private final List<String> accepted;
    @NotNull
    private final List<String> denied;
    @NotNull
    private final List<String> foreverDenied;

    public PermissionResult(@NotNull Function0<Unit> function0, @NotNull Function0<Unit> function02, @NotNull List<String> list, @NotNull List<String> list2, @NotNull List<String> list3) {
        Intrinsics.checkNotNullParameter(function0, (String)"askAgain");
        Intrinsics.checkNotNullParameter(function02, (String)"goToSettings");
        Intrinsics.checkNotNullParameter(list, (String)"accepted");
        Intrinsics.checkNotNullParameter(list2, (String)"denied");
        Intrinsics.checkNotNullParameter(list3, (String)"foreverDenied");
        this.askAgain = function0;
        this.goToSettings = function02;
        this.accepted = list;
        this.denied = list2;
        this.foreverDenied = list3;
    }

    public /* synthetic */ PermissionResult(Function0 function0, Function0 function02, List list, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ArrayList arrayList;
            list = arrayList;
            arrayList = new ArrayList();
        }
        if ((n & 8) != 0) {
            ArrayList arrayList;
            list2 = arrayList;
            arrayList = new ArrayList();
        }
        if ((n & 0x10) != 0) {
            ArrayList arrayList;
            list3 = arrayList;
            arrayList = new ArrayList();
        }
        this((Function0<Unit>)function0, (Function0<Unit>)function02, list, list2, list3);
    }

    public static /* synthetic */ PermissionResult copy$default(PermissionResult permissionResult2, Function0 function0, Function0 function02, List list, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = permissionResult2.askAgain;
        }
        if ((n & 2) != 0) {
            function02 = permissionResult2.goToSettings;
        }
        if ((n & 4) != 0) {
            list = permissionResult2.accepted;
        }
        if ((n & 8) != 0) {
            list2 = permissionResult2.denied;
        }
        if ((n & 0x10) != 0) {
            list3 = permissionResult2.foreverDenied;
        }
        return permissionResult2.copy(function0, function02, list, list2, list3);
    }

    @NotNull
    public final Function0<Unit> getAskAgain() {
        return this.askAgain;
    }

    @NotNull
    public final Function0<Unit> getGoToSettings() {
        return this.goToSettings;
    }

    @NotNull
    public final List<String> getAccepted() {
        return this.accepted;
    }

    @NotNull
    public final List<String> getDenied() {
        return this.denied;
    }

    @NotNull
    public final List<String> getForeverDenied() {
        return this.foreverDenied;
    }

    public final boolean succeed(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"required");
        return this.accepted.containsAll(list);
    }

    public final boolean hasDenied() {
        return this.denied.isEmpty() ^ true;
    }

    public final boolean hasForeverDenied() {
        return this.foreverDenied.isEmpty() ^ true;
    }

    public final void askAgain() {
        this.askAgain.invoke();
    }

    public final void goToSettings() {
        this.goToSettings.invoke();
    }

    @NotNull
    public final Function0<Unit> component1() {
        return this.askAgain;
    }

    @NotNull
    public final Function0<Unit> component2() {
        return this.goToSettings;
    }

    @NotNull
    public final List<String> component3() {
        return this.accepted;
    }

    @NotNull
    public final List<String> component4() {
        return this.denied;
    }

    @NotNull
    public final List<String> component5() {
        return this.foreverDenied;
    }

    @NotNull
    public final PermissionResult copy(@NotNull Function0<Unit> function0, @NotNull Function0<Unit> function02, @NotNull List<String> list, @NotNull List<String> list2, @NotNull List<String> list3) {
        Intrinsics.checkNotNullParameter(function0, (String)"askAgain");
        Intrinsics.checkNotNullParameter(function02, (String)"goToSettings");
        Intrinsics.checkNotNullParameter(list, (String)"accepted");
        Intrinsics.checkNotNullParameter(list2, (String)"denied");
        Intrinsics.checkNotNullParameter(list3, (String)"foreverDenied");
        return new PermissionResult(function0, function02, list, list2, list3);
    }

    @NotNull
    public String toString() {
        return "PermissionResult(askAgain=" + this.askAgain + ", goToSettings=" + this.goToSettings + ", accepted=" + this.accepted + ", denied=" + this.denied + ", foreverDenied=" + this.foreverDenied + ')';
    }

    public int hashCode() {
        return (((this.askAgain.hashCode() * 31 + this.goToSettings.hashCode()) * 31 + ((Object)this.accepted).hashCode()) * 31 + ((Object)this.denied).hashCode()) * 31 + ((Object)this.foreverDenied).hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PermissionResult)) {
            return false;
        }
        object = (PermissionResult)object;
        if (!Intrinsics.areEqual(this.askAgain, ((PermissionResult)object).askAgain)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.goToSettings, ((PermissionResult)object).goToSettings)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.accepted, ((PermissionResult)object).accepted)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.denied, ((PermissionResult)object).denied)) {
            return false;
        }
        return Intrinsics.areEqual(this.foreverDenied, ((PermissionResult)object).foreverDenied);
    }
}

