/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.recyclerview;

import android.content.Context;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class VerticalOffsetDecoration
extends RecyclerView.ItemDecoration {
    private final int spanCount;
    private final int offset;

    public VerticalOffsetDecoration(@NotNull Context context, float f, int n) {
        VerticalOffsetDecoration verticalOffsetDecoration = verticalOffsetDecoration2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        verticalOffsetDecoration2.spanCount = n;
        VerticalOffsetDecoration verticalOffsetDecoration2 = context.getResources().getDisplayMetrics();
        verticalOffsetDecoration.offset = (int)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)verticalOffsetDecoration2);
    }

    public void getItemOffsets(@NotNull Rect rect, @NotNull View view2, @NotNull RecyclerView recyclerView, @NotNull RecyclerView.State state2) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        rect.top = recyclerView.getChildAdapterPosition(view2) < this.spanCount ? 0 : this.offset / 2;
        state2 = recyclerView.getAdapter();
        rect.bottom = (state2 == null ? 0 : state2.getItemCount()) - recyclerView.getChildAdapterPosition(view2) < this.spanCount ? 0 : this.offset / 2;
    }
}

