/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.session;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.datastore.core.DataStore;
import androidx.datastore.preferences.PreferenceDataStoreDelegateKt;
import androidx.datastore.preferences.core.Preferences;
import androidx.datastore.preferences.core.PreferencesKeys;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.streamlayer.common.dispatcher.CoroutineDispatcherProvider;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.common.session.SessionPrefImpl$collectPreference$1$invokeSuspend$;
import io.streamlayer.common.session.SessionPrefImpl$getClientSettingsChangeListener$;
import io.streamlayer.common.session.SessionPrefImpl$getTotalUnreadMessagesCountListener$;
import io.streamlayer.common.session.SessionPrefImpl$getUserLoggedInListener$;
import io.streamlayer.common.session.SessionPrefImpl$isTopicMuted$1$invokeSuspend$;
import io.streamlayer.common.session.SessionPrefImplKt;
import io.streamlayer.common.utils.GsonUtil;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.model.auth.AuthByType;
import io.streamlayer.sdk.model.auth.User;
import io.streamlayer.sdk.model.auth.VoximplantUser;
import io.streamlayer.sdk.model.sdksettings.ClientSettings;
import io.streamlayer.sdk.model.sdksettings.OrganizationSettings;
import io.streamlayer.sdk.model.sports.StatisticsDataOptions;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference2;
import kotlin.jvm.internal.PropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SessionPrefImpl
implements Session {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final Preferences.Key<String> KEY_SDK_KEY;
    @NotNull
    private static final Preferences.Key<String> KEY_USER;
    @NotNull
    private static final Preferences.Key<String> KEY_VOXIMPLANT_USER;
    @NotNull
    private static final Preferences.Key<String> KEY_TINODE_USER_ID;
    @NotNull
    private static final Preferences.Key<String> KEY_TOKEN;
    @NotNull
    private static final Preferences.Key<Integer> KEY_TOTAL_UNREAD_MESSAGES;
    @NotNull
    private static final Preferences.Key<String> KEY_CLIENT_SETTINGS;
    @NotNull
    private static final Preferences.Key<String> KEY_ORGANIZATION_SETTINGS;
    @NotNull
    private static final Preferences.Key<String> KEY_AUTH_BY_SDK;
    @NotNull
    private static final Preferences.Key<String> KEY_FIREBASE_TOKEN;
    @NotNull
    private static final Preferences.Key<Boolean> KEY_FIREBASE_TOKEN_CHANGED;
    @NotNull
    private static final Preferences.Key<String> KEY_INVITED_CONTACT_IDS;
    @NotNull
    private static final Preferences.Key<String> KEY_ANSWERED_QUESTIONS_IDS;
    @NotNull
    private static final Preferences.Key<String> KEY_RESULT_NOTIFIED_QUESTIONS_IDS;
    @NotNull
    private static final Preferences.Key<String> KEY_ONBOARDING_EVENT_IDS;
    @NotNull
    private static final String KEY_MUTED_TOPIC = "muted_topic_";
    @NotNull
    private static final String KEY_ENCRYPTED_VOXIMPLANT_USER = "slr_voximplant_user";
    @NotNull
    private final Context context;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ReadOnlyProperty dataStore$delegate;
    @NotNull
    private final Lazy encryptedSharedPreferences$delegate;
    @NotNull
    private List<String> _onboardingEventIds;
    @Nullable
    private StatisticsDataOptions statisticsDataOptions;
    @NotNull
    private List<String> _answeredQuestionsIds;
    @NotNull
    private List<String> _resultNotifiedQuestionsIds;
    @NotNull
    private AuthByType _authByType;
    @Nullable
    private String publicWatchPartyData;
    @Nullable
    private String _sdkKey;
    @Nullable
    private String _token;
    @Nullable
    private User _user;
    @Nullable
    private VoximplantUser _voxUser;
    @Nullable
    private String _tinodeUserId;
    @Nullable
    private OrganizationSettings _organizationSettings;
    @Nullable
    private ClientSettings _clientSettings;
    @NotNull
    private String _firebaseToken;
    private boolean _isFirebaseTokenChanged;
    private int _totalUnreadMessagesCount;
    @Nullable
    private String activeWpId;
    private boolean _isPhoneContactsEnabled;
    @NotNull
    private List<Integer> invitedContactIds;

    public SessionPrefImpl(@NotNull Context object, @NotNull CoroutineDispatcherProvider coroutineDispatcherProvider) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"context");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcherProvider, (String)"dispatcherProvider");
        this.context = object;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)coroutineDispatcherProvider.getIo());
        object = dataStore.2.INSTANCE;
        this.dataStore$delegate = PreferenceDataStoreDelegateKt.preferencesDataStore$default((String)"io.streamlayer.sdk_session", null, (Function1)object, null, (int)10, null);
        this.encryptedSharedPreferences$delegate = LazyKt.lazy((Function0)new Function0<SharedPreferences>(this){
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(0);
            }

            @Nullable
            public final SharedPreferences invoke() {
                encryptedSharedPreferences.2 this_;
                try {
                    this_ = EncryptedSharedPreferences.create((Context)SessionPrefImpl.access$getContext$p(this_.this$0), (String)"io.streamlayer.sdk_encrypted_session", (MasterKey)new MasterKey.Builder(SessionPrefImpl.access$getContext$p(this_.this$0), "_androidx_security_master_key_").setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build(), (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
                }
                catch (Throwable throwable) {
                    SLRLog.INSTANCE.e("SessionPrefImpl", "Can not create encrypted storage", throwable);
                    this_ = null;
                }
                return this_;
            }
        });
        this._onboardingEventIds = CollectionsKt.emptyList();
        this._answeredQuestionsIds = CollectionsKt.emptyList();
        this._resultNotifiedQuestionsIds = CollectionsKt.emptyList();
        this._authByType = AuthByType.INTERNAL;
        this._firebaseToken = "";
        this._isFirebaseTokenChanged = true;
        this._isPhoneContactsEnabled = true;
        this.collectPreferences();
        this.invitedContactIds = new ArrayList<Integer>();
    }

    private final Preferences.Key<Boolean> getMutedTopicKey(String string2) {
        return PreferencesKeys.booleanKey((String)Intrinsics.stringPlus((String)KEY_MUTED_TOPIC, (Object)string2));
    }

    private final DataStore<Preferences> getDataStore(Context context) {
        return (DataStore)this.dataStore$delegate.getValue((Object)context, $$delegatedProperties[0]);
    }

    private final void collectPreferences() {
        Function2<String, Continuation<? super Unit>, Object> function2;
        Function2<String, Continuation<? super Unit>, Object> function22;
        Function2<String, Continuation<? super Unit>, Object> function23;
        Function2<String, Continuation<? super Unit>, Object> function24;
        Function2<Boolean, Continuation<? super Unit>, Object> function25;
        Function2<String, Continuation<? super Unit>, Object> function26;
        Function2<String, Continuation<? super Unit>, Object> function27;
        Function2<String, Continuation<? super Unit>, Object> function28;
        Function2<String, Continuation<? super Unit>, Object> function29;
        Function2<Integer, Continuation<? super Unit>, Object> function210;
        Function2<String, Continuation<? super Unit>, Object> function211;
        Function2<String, Continuation<? super Unit>, Object> function212;
        Function2<String, Continuation<? super Unit>, Object> function213;
        Function2<String, Continuation<? super Unit>, Object> function214;
        Function2<String, Continuation<? super Unit>, Object> function215;
        SessionPrefImpl sessionPrefImpl = this;
        Object object = KEY_SDK_KEY;
        Object object2 = function215;
        function215 = new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    collectPreferences.1 v0 = object2;
                    ResultKt.throwOnFailure((Object)object);
                    Object object2 = (String)v0.L$0;
                    SessionPrefImpl.access$set_sdkKey$p(v0.this$0, (String)object2);
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable String string2, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(string2, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_TOKEN;
        object2 = function214;
        function214 = new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    collectPreferences.2 v0 = object2;
                    ResultKt.throwOnFailure((Object)object);
                    Object object2 = (String)v0.L$0;
                    SessionPrefImpl.access$set_token$p(v0.this$0, (String)object2);
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable String string2, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(string2, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_TINODE_USER_ID;
        object2 = function213;
        function213 = new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    collectPreferences.3 v0 = object2;
                    ResultKt.throwOnFailure((Object)object);
                    Object object2 = (String)v0.L$0;
                    SessionPrefImpl.access$set_tinodeUserId$p(v0.this$0, (String)object2);
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable String string2, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(string2, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_USER;
        object2 = function212;
        function212 = new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    ResultKt.throwOnFailure((Object)object);
                    object = (String)object2.L$0;
                    Object object2 = object2.this$0;
                    object = object == null ? null : (User)GsonUtil.INSTANCE.getDefaultGson().fromJson((String)object, User.class);
                    SessionPrefImpl.access$set_user$p((SessionPrefImpl)object2, (User)object);
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable String string2, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(string2, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_VOXIMPLANT_USER;
        object2 = function211;
        function211 = new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    ResultKt.throwOnFailure((Object)object);
                    object = (String)object2.L$0;
                    Object object2 = object2.this$0;
                    object = object == null ? null : (VoximplantUser)GsonUtil.INSTANCE.getDefaultGson().fromJson((String)object, VoximplantUser.class);
                    SessionPrefImpl.access$set_voxUser$p((SessionPrefImpl)object2, (VoximplantUser)object);
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable String string2, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(string2, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_TOTAL_UNREAD_MESSAGES;
        object2 = function210;
        function210 = new Function2<Integer, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    ResultKt.throwOnFailure((Object)object);
                    object = (Integer)object2.L$0;
                    Object object2 = object2.this$0;
                    int n = object == null ? 0 : (Integer)object;
                    SessionPrefImpl.access$set_totalUnreadMessagesCount$p((SessionPrefImpl)object2, n);
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Integer n, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(n, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_CLIENT_SETTINGS;
        object2 = function29;
        function29 = new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    ResultKt.throwOnFailure((Object)object);
                    object = (String)object2.L$0;
                    Object object2 = object2.this$0;
                    object = object == null ? null : (ClientSettings)GsonUtil.INSTANCE.getDefaultGson().fromJson((String)object, ClientSettings.class);
                    SessionPrefImpl.access$set_clientSettings$p((SessionPrefImpl)object2, (ClientSettings)object);
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable String string2, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(string2, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_ORGANIZATION_SETTINGS;
        object2 = function28;
        function28 = new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    collectPreferences.8 v0 = object2;
                    ResultKt.throwOnFailure((Object)object);
                    Object object2 = (String)v0.L$0;
                    SessionPrefImpl sessionPrefImpl = v0.this$0;
                    SessionPrefImpl.access$set_organizationSettings$p(sessionPrefImpl, SessionPrefImpl.access$deserializeOrganizationSetting(sessionPrefImpl, (String)object2));
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable String string2, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(string2, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_AUTH_BY_SDK;
        object2 = function27;
        function27 = new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    ResultKt.throwOnFailure((Object)object);
                    object = (String)object2.L$0;
                    Object object2 = object2.this$0;
                    object = object == null ? null : AuthByType.valueOf((String)object);
                    if (object == null) {
                        object = AuthByType.INTERNAL;
                    }
                    SessionPrefImpl.access$set_authByType$p((SessionPrefImpl)object2, (AuthByType)((Object)object));
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable String string2, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(string2, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_FIREBASE_TOKEN;
        object2 = function26;
        function26 = new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    ResultKt.throwOnFailure((Object)object);
                    object = (String)object2.L$0;
                    Object object2 = object2.this$0;
                    if (object == null) {
                        object = "";
                    }
                    SessionPrefImpl.access$set_firebaseToken$p((SessionPrefImpl)object2, (String)object);
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable String string2, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(string2, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_FIREBASE_TOKEN_CHANGED;
        object2 = function25;
        function25 = new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    ResultKt.throwOnFailure((Object)object);
                    object = (Boolean)object2.L$0;
                    Object object2 = object2.this$0;
                    boolean bl = object == null ? true : (Boolean)object;
                    SessionPrefImpl.access$set_isFirebaseTokenChanged$p((SessionPrefImpl)object2, bl);
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Boolean bl, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(bl, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_INVITED_CONTACT_IDS;
        object2 = function24;
        function24 = new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    collectPreferences.12 v0 = object2;
                    ResultKt.throwOnFailure((Object)object);
                    Object object2 = (String)v0.L$0;
                    SessionPrefImpl sessionPrefImpl = v0.this$0;
                    SessionPrefImpl.access$setInvitedContactIds$p(sessionPrefImpl, SessionPrefImpl.access$deserializeInvitedContactIds(sessionPrefImpl, (String)object2));
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable String string2, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(string2, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_ANSWERED_QUESTIONS_IDS;
        object2 = function23;
        function23 = new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    collectPreferences.13 v0 = object2;
                    ResultKt.throwOnFailure((Object)object);
                    Object object2 = (String)v0.L$0;
                    SessionPrefImpl sessionPrefImpl = v0.this$0;
                    SessionPrefImpl.access$set_answeredQuestionsIds$p(sessionPrefImpl, SessionPrefImpl.access$deserializeAnsweredQuestionsIds(sessionPrefImpl, (String)object2));
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable String string2, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(string2, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_RESULT_NOTIFIED_QUESTIONS_IDS;
        object2 = function22;
        function22 = new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    collectPreferences.14 v0 = object2;
                    ResultKt.throwOnFailure((Object)object);
                    Object object2 = (String)v0.L$0;
                    SessionPrefImpl sessionPrefImpl = v0.this$0;
                    SessionPrefImpl.access$set_resultNotifiedQuestionsIds$p(sessionPrefImpl, SessionPrefImpl.access$deserializeAnsweredQuestionsIds(sessionPrefImpl, (String)object2));
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable String string2, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(string2, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
        object = KEY_ONBOARDING_EVENT_IDS;
        object2 = function2;
        function2 = new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SessionPrefImpl this$0;
            {
                this.this$0 = sessionPrefImpl;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.label == 0) {
                    collectPreferences.15 v0 = object2;
                    ResultKt.throwOnFailure((Object)object);
                    Object object2 = (String)v0.L$0;
                    SessionPrefImpl sessionPrefImpl = v0.this$0;
                    SessionPrefImpl.access$set_onboardingEventIds$p(sessionPrefImpl, SessionPrefImpl.access$deserializeAnsweredQuestionsIds(sessionPrefImpl, (String)object2));
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable String string2, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(string2, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        sessionPrefImpl.collectPreference((Preferences.Key)object, (Function2)object2);
    }

    private final <T> void collectPreference(Preferences.Key<T> key, Function2<? super T, ? super Continuation<? super Unit>, ? extends Object> function2) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function23 = function22;
        function22 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, function2, key, null){
            int label;
            final /* synthetic */ SessionPrefImpl this$0;
            final /* synthetic */ Function2<T, Continuation<? super Unit>, Object> $block;
            final /* synthetic */ Preferences.Key<T> $key;
            {
                this.this$0 = sessionPrefImpl;
                this.$block = function2;
                this.$key = key;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object function2) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure(function2);
                    return Unit.INSTANCE;
                } else {
                    FlowCollector<T> flowCollector;
                    collectPreference.1 v0 = this;
                    ResultKt.throwOnFailure(function2);
                    SessionPrefImpl sessionPrefImpl = v0.this$0;
                    function2 = SessionPrefImpl.access$getDataStore(sessionPrefImpl, SessionPrefImpl.access$getContext$p(sessionPrefImpl)).getData();
                    Preferences.Key<T> key = v0.$key;
                    Flow<T> flow = new Flow<T>((Flow)function2, key){
                        final /* synthetic */ Flow $this_unsafeTransform$inlined;
                        final /* synthetic */ Preferences.Key $key$inlined;
                        {
                            this.$this_unsafeTransform$inlined = flow;
                            this.$key$inlined = key;
                        }

                        @Nullable
                        public Object collect(@NotNull FlowCollector flowCollector, @NotNull Continuation continuation) {
                            Object object = object.$this_unsafeTransform$inlined.collect((FlowCollector)new FlowCollector<Preferences>(flowCollector, object.$key$inlined){
                                final /* synthetic */ FlowCollector $this_unsafeFlow$inlined;
                                final /* synthetic */ Preferences.Key $key$inlined;
                                {
                                    this.$this_unsafeFlow$inlined = flowCollector;
                                    this.$key$inlined = key;
                                }

                                /*
                                 * Unable to fully structure code
                                 * Could not resolve type clashes
                                 */
                                @Nullable
                                public Object emit(Object var1_1, @NotNull Continuation var2_2) {
                                    if (!(var2_2 /* !! */  instanceof collectPreference$1$invokeSuspend$$inlined$map$1$2$1)) ** GOTO lbl-1000
                                    var3_3 = var2_2 /* !! */ ;
                                    var4_4 = var3_3.label;
                                    if ((var4_4 & -2147483648) != 0) {
                                        var3_3.label = var4_4 - -2147483648;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        var3_3 = v0;
                                        v0 = new ContinuationImpl(this, var2_2 /* !! */ ){
                                            /* synthetic */ Object result;
                                            int label;
                                            Object L$0;
                                            final /* synthetic */ collectPreference$1$invokeSuspend$$inlined$map$1$2 this$0;
                                            {
                                                this.this$0 = var1_1;
                                                super(continuation);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                collectPreference$1$invokeSuspend$$inlined$map$1$2$1 v0 = this;
                                                v0.result = object;
                                                v0.label |= Integer.MIN_VALUE;
                                                return v0.this$0.emit(null, (Continuation)this);
                                            }
                                        };
                                    }
                                    v1 = var3_3;
                                    var2_2 /* !! */  = v1.result;
                                    var4_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    var5_6 = v1.label;
                                    if (var5_6 == 0) ** GOTO lbl18
                                    if (var5_6 == 1) {
                                        ResultKt.throwOnFailure((Object)var2_2 /* !! */ );
                                    } else {
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
lbl18:
                                        // 1 sources

                                        ResultKt.throwOnFailure((Object)var2_2 /* !! */ );
                                        this = ((Preferences)var1_1).get(this.$key$inlined);
                                        var3_3.label = 1;
                                        if (this.$this_unsafeFlow$inlined.emit(this, (Continuation)var3_3) == var4_5) {
                                            return var4_5;
                                        }
                                    }
                                    return Unit.INSTANCE;
                                }
                            }, continuation);
                            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                return object;
                            }
                            return Unit.INSTANCE;
                        }
                    };
                    function2 = this.$block;
                    FlowCollector<T> flowCollector2 = flowCollector;
                    flowCollector = new FlowCollector<T>(function2){
                        final /* synthetic */ Function2 $action;
                        {
                            this.$action = function2;
                        }

                        @Nullable
                        public Object emit(T t, @NotNull Continuation<? super Unit> continuation) {
                            Object object = object.$action.invoke(t, continuation);
                            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                return object;
                            }
                            return Unit.INSTANCE;
                        }
                    };
                    this.label = 1;
                    if (FlowKt.distinctUntilChanged((Flow)flow).collect((FlowCollector)flowCollector2, (Continuation)this) != object) return Unit.INSTANCE;
                    return object;
                }
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object function2, @NotNull Continuation<?> continuation) {
                collectPreference.1 v0 = object;
                Object object = v0.this$0;
                function2 = v0.$block;
                Preferences.Key<T> key = v0.$key;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)function23, (int)3, null);
    }

    private final <T> void updateValue(Preferences.Key<T> key, T t) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, key, t, null){
            int label;
            final /* synthetic */ SessionPrefImpl this$0;
            final /* synthetic */ Preferences.Key<T> $key;
            final /* synthetic */ T $value;
            {
                this.this$0 = sessionPrefImpl;
                this.$key = key;
                this.$value = t;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object key) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure(key);
                    return Unit.INSTANCE;
                } else {
                    ResultKt.throwOnFailure(key);
                    SessionPrefImpl sessionPrefImpl = this.this$0;
                    updateValue.1 v1 = this;
                    key = v1.$key;
                    T t = v1.$value;
                    v1.label = 1;
                    if (SessionPrefImplKt.update((DataStore<Preferences>)SessionPrefImpl.access$getDataStore(sessionPrefImpl, SessionPrefImpl.access$getContext$p(sessionPrefImpl)), key, t, (Continuation<? super Unit>)this) != object) return Unit.INSTANCE;
                    return object;
                }
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object key, @NotNull Continuation<?> continuation) {
                updateValue.1 v0 = object;
                Object object = v0.this$0;
                key = v0.$key;
                T t = v0.$value;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)function22, (int)3, null);
    }

    private final SharedPreferences getEncryptedSharedPreferences() {
        return (SharedPreferences)this.encryptedSharedPreferences$delegate.getValue();
    }

    private final OrganizationSettings deserializeOrganizationSetting(String string2) {
        Object object;
        Gson gson;
        block4: {
            gson = GsonUtil.INSTANCE.getDefaultGson();
            if (string2 != null) break block4;
            string2 = "[]";
        }
        try {
            object = (OrganizationSettings)gson.fromJson(string2, OrganizationSettings.class);
        }
        catch (Exception exception) {
            ((SessionPrefImpl)object).updateValue(KEY_ORGANIZATION_SETTINGS, null);
            object = null;
        }
        return object;
    }

    private final List<Integer> deserializeInvitedContactIds(String string2) {
        Object object = new TypeToken<ArrayList<Integer>>(){}.getType();
        Gson gson = GsonUtil.INSTANCE.getDefaultGson();
        if (string2 == null) {
            string2 = "[]";
        }
        if ((object = gson.fromJson(string2, (Type)object)) != null) {
            return (ArrayList)object;
        }
        throw new NullPointerException("null cannot be cast to non-null type java.util.ArrayList<kotlin.Int>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.Int> }");
    }

    private final List<String> deserializeAnsweredQuestionsIds(String string2) {
        Object object = new TypeToken<ArrayList<String>>(){}.getType();
        Gson gson = GsonUtil.INSTANCE.getDefaultGson();
        if (string2 == null) {
            string2 = "[]";
        }
        if ((object = gson.fromJson(string2, (Type)object)) != null) {
            return (List)object;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
    }

    public static final /* synthetic */ void access$set_sdkKey$p(SessionPrefImpl sessionPrefImpl, String string2) {
        sessionPrefImpl._sdkKey = string2;
    }

    public static final /* synthetic */ void access$set_token$p(SessionPrefImpl sessionPrefImpl, String string2) {
        sessionPrefImpl._token = string2;
    }

    public static final /* synthetic */ void access$set_tinodeUserId$p(SessionPrefImpl sessionPrefImpl, String string2) {
        sessionPrefImpl._tinodeUserId = string2;
    }

    public static final /* synthetic */ void access$set_user$p(SessionPrefImpl sessionPrefImpl, User user2) {
        sessionPrefImpl._user = user2;
    }

    public static final /* synthetic */ void access$set_voxUser$p(SessionPrefImpl sessionPrefImpl, VoximplantUser voximplantUser) {
        sessionPrefImpl._voxUser = voximplantUser;
    }

    public static final /* synthetic */ void access$set_totalUnreadMessagesCount$p(SessionPrefImpl sessionPrefImpl, int n) {
        sessionPrefImpl._totalUnreadMessagesCount = n;
    }

    public static final /* synthetic */ void access$set_clientSettings$p(SessionPrefImpl sessionPrefImpl, ClientSettings clientSettings) {
        sessionPrefImpl._clientSettings = clientSettings;
    }

    public static final /* synthetic */ void access$set_organizationSettings$p(SessionPrefImpl sessionPrefImpl, OrganizationSettings organizationSettings2) {
        sessionPrefImpl._organizationSettings = organizationSettings2;
    }

    public static final /* synthetic */ OrganizationSettings access$deserializeOrganizationSetting(SessionPrefImpl sessionPrefImpl, String string2) {
        return sessionPrefImpl.deserializeOrganizationSetting(string2);
    }

    public static final /* synthetic */ void access$set_authByType$p(SessionPrefImpl sessionPrefImpl, AuthByType authByType2) {
        sessionPrefImpl._authByType = authByType2;
    }

    public static final /* synthetic */ void access$set_firebaseToken$p(SessionPrefImpl sessionPrefImpl, String string2) {
        sessionPrefImpl._firebaseToken = string2;
    }

    public static final /* synthetic */ void access$set_isFirebaseTokenChanged$p(SessionPrefImpl sessionPrefImpl, boolean bl) {
        sessionPrefImpl._isFirebaseTokenChanged = bl;
    }

    public static final /* synthetic */ void access$setInvitedContactIds$p(SessionPrefImpl sessionPrefImpl, List list) {
        sessionPrefImpl.invitedContactIds = list;
    }

    public static final /* synthetic */ List access$deserializeInvitedContactIds(SessionPrefImpl sessionPrefImpl, String string2) {
        return sessionPrefImpl.deserializeInvitedContactIds(string2);
    }

    public static final /* synthetic */ void access$set_answeredQuestionsIds$p(SessionPrefImpl sessionPrefImpl, List list) {
        sessionPrefImpl._answeredQuestionsIds = list;
    }

    public static final /* synthetic */ List access$deserializeAnsweredQuestionsIds(SessionPrefImpl sessionPrefImpl, String string2) {
        return sessionPrefImpl.deserializeAnsweredQuestionsIds(string2);
    }

    public static final /* synthetic */ void access$set_resultNotifiedQuestionsIds$p(SessionPrefImpl sessionPrefImpl, List list) {
        sessionPrefImpl._resultNotifiedQuestionsIds = list;
    }

    public static final /* synthetic */ void access$set_onboardingEventIds$p(SessionPrefImpl sessionPrefImpl, List list) {
        sessionPrefImpl._onboardingEventIds = list;
    }

    public static final /* synthetic */ DataStore access$getDataStore(SessionPrefImpl sessionPrefImpl, Context context) {
        return sessionPrefImpl.getDataStore(context);
    }

    public static final /* synthetic */ Context access$getContext$p(SessionPrefImpl sessionPrefImpl) {
        return sessionPrefImpl.context;
    }

    public static final /* synthetic */ Preferences.Key access$getKEY_USER$cp() {
        return KEY_USER;
    }

    public static final /* synthetic */ Preferences.Key access$getKEY_TOKEN$cp() {
        return KEY_TOKEN;
    }

    public static final /* synthetic */ Preferences.Key access$getMutedTopicKey(SessionPrefImpl sessionPrefImpl, String string2) {
        return sessionPrefImpl.getMutedTopicKey(string2);
    }

    public static final /* synthetic */ Preferences.Key access$getKEY_TOTAL_UNREAD_MESSAGES$cp() {
        return KEY_TOTAL_UNREAD_MESSAGES;
    }

    public static final /* synthetic */ Preferences.Key access$getKEY_CLIENT_SETTINGS$cp() {
        return KEY_CLIENT_SETTINGS;
    }

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property2((PropertyReference2)new PropertyReference2Impl(SessionPrefImpl.class, "dataStore", "getDataStore(Landroid/content/Context;)Landroidx/datastore/core/DataStore;", 0))};
        Companion = new Companion(null);
        KEY_SDK_KEY = PreferencesKeys.stringKey((String)"sdk_key");
        KEY_USER = PreferencesKeys.stringKey((String)"session_user");
        KEY_VOXIMPLANT_USER = PreferencesKeys.stringKey((String)"voximplant_user");
        KEY_TINODE_USER_ID = PreferencesKeys.stringKey((String)"session_tinode_user_id");
        KEY_TOKEN = PreferencesKeys.stringKey((String)"session_token");
        KEY_TOTAL_UNREAD_MESSAGES = PreferencesKeys.intKey((String)"total_unread_messages");
        KEY_CLIENT_SETTINGS = PreferencesKeys.stringKey((String)"session_client_settings");
        KEY_ORGANIZATION_SETTINGS = PreferencesKeys.stringKey((String)"organization_settings");
        KEY_AUTH_BY_SDK = PreferencesKeys.stringKey((String)"auth_by_type");
        KEY_FIREBASE_TOKEN = PreferencesKeys.stringKey((String)"firebase_token");
        KEY_FIREBASE_TOKEN_CHANGED = PreferencesKeys.booleanKey((String)"firebase_token_changed");
        KEY_INVITED_CONTACT_IDS = PreferencesKeys.stringKey((String)"invited_contact_ids");
        KEY_ANSWERED_QUESTIONS_IDS = PreferencesKeys.stringKey((String)"answered_questions_ids");
        KEY_RESULT_NOTIFIED_QUESTIONS_IDS = PreferencesKeys.stringKey((String)"result_notified_questions_ids");
        KEY_ONBOARDING_EVENT_IDS = PreferencesKeys.stringKey((String)"onboarding_event_ids");
    }

    @Override
    @NotNull
    public List<String> getOnboardingEventIds() {
        return this._onboardingEventIds;
    }

    @Override
    public void setOnboardingEventIds(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"value");
        this.updateValue(KEY_ONBOARDING_EVENT_IDS, GsonUtil.INSTANCE.getDefaultGson().toJson(list));
    }

    @Override
    @Nullable
    public StatisticsDataOptions getStatisticsDataOptions() {
        return this.statisticsDataOptions;
    }

    @Override
    public void setStatisticsDataOptions(@Nullable StatisticsDataOptions statisticsDataOptions) {
        this.statisticsDataOptions = statisticsDataOptions;
    }

    @Override
    @NotNull
    public List<String> getAnsweredQuestionsIds() {
        return this._answeredQuestionsIds;
    }

    @Override
    public void setAnsweredQuestionsIds(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"value");
        this.updateValue(KEY_ANSWERED_QUESTIONS_IDS, GsonUtil.INSTANCE.getDefaultGson().toJson(list));
    }

    @Override
    @NotNull
    public List<String> getResultNotifiedQuestionsIds() {
        return this._resultNotifiedQuestionsIds;
    }

    @Override
    public void setResultNotifiedQuestionsIds(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"value");
        this.updateValue(KEY_RESULT_NOTIFIED_QUESTIONS_IDS, GsonUtil.INSTANCE.getDefaultGson().toJson(list));
    }

    @Override
    @NotNull
    public AuthByType getAuthByType() {
        return this._authByType;
    }

    @Override
    public void setAuthByType(@NotNull AuthByType authByType2) {
        Preferences.Key<String> key = key2;
        AuthByType authByType3 = authByType2;
        Intrinsics.checkNotNullParameter((Object)((Object)authByType3), (String)"value");
        Preferences.Key<String> key2 = KEY_AUTH_BY_SDK;
        super.updateValue(key2, authByType3.name());
    }

    @Override
    @Nullable
    public String getPublicWatchPartyData() {
        return this.publicWatchPartyData;
    }

    @Override
    public void setPublicWatchPartyData(@Nullable String string2) {
        this.publicWatchPartyData = string2;
    }

    @Override
    @Nullable
    public String getSdkKey() {
        return this._sdkKey;
    }

    @Override
    public void setSdkKey(@Nullable String string2) {
        this.updateValue(KEY_SDK_KEY, string2);
    }

    @Override
    @Nullable
    public String getToken() {
        return this._token;
    }

    @Override
    public void setToken(@Nullable String string2) {
        this.updateValue(KEY_TOKEN, string2);
    }

    @Override
    @Nullable
    public User getUser() {
        return this._user;
    }

    @Override
    public void setUser(@Nullable User user2) {
        this.updateValue(KEY_USER, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)user2));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public VoximplantUser getVoximplantUser() {
        block3: {
            if (this.getEncryptedSharedPreferences() == null) lbl-1000:
            // 2 sources

            {
                while (true) {
                    var1_1 = null;
                    break block3;
                    break;
                }
            }
            ** while ((var1_1 = (var1_1 = this.getEncryptedSharedPreferences()) == null ? null : var1_1.getString((String)"slr_voximplant_user", null)) == null || var1_1.length() == 0)
lbl6:
            // 1 sources

            var1_1 = (VoximplantUser)GsonUtil.INSTANCE.getDefaultGson().fromJson((String)var1_1, VoximplantUser.class);
        }
        if (var1_1 == null) {
            var1_1 = this._voxUser;
        }
        return var1_1;
    }

    @Override
    public void setVoximplantUser(@Nullable VoximplantUser voximplantUser) {
        SharedPreferences sharedPreferences = this.getEncryptedSharedPreferences();
        if (sharedPreferences == null) {
            sharedPreferences = null;
        } else {
            sharedPreferences.edit().putString(KEY_ENCRYPTED_VOXIMPLANT_USER, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)voximplantUser)).apply();
        }
        if (sharedPreferences == null) {
            this.updateValue(KEY_VOXIMPLANT_USER, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)voximplantUser));
        }
    }

    @Override
    @Nullable
    public String getTinodeUserId() {
        return this._tinodeUserId;
    }

    @Override
    public void setTinodeUserId(@Nullable String string2) {
        this.updateValue(KEY_TINODE_USER_ID, string2);
    }

    @Override
    @Nullable
    public OrganizationSettings getOrganizationSettings() {
        return this._organizationSettings;
    }

    @Override
    public void setOrganizationSettings(@Nullable OrganizationSettings organizationSettings2) {
        this.updateValue(KEY_ORGANIZATION_SETTINGS, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)organizationSettings2));
    }

    @Override
    @Nullable
    public ClientSettings getClientSettings() {
        return this._clientSettings;
    }

    @Override
    public void setClientSettings(@Nullable ClientSettings clientSettings) {
        this.updateValue(KEY_CLIENT_SETTINGS, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)clientSettings));
    }

    @Override
    @NotNull
    public String getFirebaseToken() {
        return this._firebaseToken;
    }

    @Override
    public void setFirebaseToken(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"value");
        this.updateValue(KEY_FIREBASE_TOKEN, string2);
    }

    @Override
    public boolean isFirebaseTokenChanged() {
        return this._isFirebaseTokenChanged;
    }

    @Override
    public void setFirebaseTokenChanged(boolean bl) {
        Preferences.Key<Boolean> key = key2;
        Preferences.Key<Boolean> key2 = KEY_FIREBASE_TOKEN_CHANGED;
        super.updateValue(key2, Boolean.valueOf(bl));
    }

    @Override
    public int getTotalUnreadMessagesCount() {
        return this._totalUnreadMessagesCount;
    }

    @Override
    public void setTotalUnreadMessagesCount(int n) {
        Preferences.Key<Integer> key = key2;
        Preferences.Key<Integer> key2 = KEY_TOTAL_UNREAD_MESSAGES;
        super.updateValue(key2, Integer.valueOf(n));
    }

    @Override
    @Nullable
    public String getActiveWpId() {
        return this.activeWpId;
    }

    @Override
    public void setActiveWpId(@Nullable String string2) {
        this.activeWpId = string2;
    }

    @Override
    public void incrementTotalUnreadMessagesCount() {
        SessionPrefImpl sessionPrefImpl = this;
        sessionPrefImpl.setTotalUnreadMessagesCount(sessionPrefImpl.getTotalUnreadMessagesCount() + 1);
    }

    @Override
    public void decreaseTotalUnreadMessagesCount(int n) {
        SessionPrefImpl sessionPrefImpl = this;
        sessionPrefImpl.setTotalUnreadMessagesCount(Math.max(0, sessionPrefImpl.getTotalUnreadMessagesCount() - n));
    }

    @Override
    public void setLoggedIn(@Nullable String string2, @Nullable User user2) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, user2, string2, null){
            int label;
            final /* synthetic */ SessionPrefImpl this$0;
            final /* synthetic */ User $user;
            final /* synthetic */ String $token;
            {
                this.this$0 = sessionPrefImpl;
                this.$user = user2;
                this.$token = string2;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                block5: {
                    Object object2;
                    block6: {
                        block2: {
                            block3: {
                                block4: {
                                    object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    int n = this.label;
                                    if (n == 0) break block2;
                                    if (n == 1) break block3;
                                    if (n != 2) break block4;
                                    ResultKt.throwOnFailure((Object)object);
                                    break block5;
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            ResultKt.throwOnFailure((Object)object);
                            break block6;
                        }
                        ResultKt.throwOnFailure((Object)object);
                        SessionPrefImpl sessionPrefImpl = this.this$0;
                        object = SessionPrefImpl.access$getKEY_USER$cp();
                        String string2 = GsonUtil.INSTANCE.getDefaultGson().toJson((Object)this.$user);
                        this.label = 1;
                        if (SessionPrefImplKt.update((DataStore<Preferences>)SessionPrefImpl.access$getDataStore(sessionPrefImpl, SessionPrefImpl.access$getContext$p(sessionPrefImpl)), object, string2, (Continuation<? super Unit>)this) == object2) {
                            return object2;
                        }
                    }
                    SessionPrefImpl sessionPrefImpl = this.this$0;
                    object = SessionPrefImpl.access$getKEY_TOKEN$cp();
                    String string3 = this.$token;
                    this.label = 2;
                    if (SessionPrefImplKt.update((DataStore<Preferences>)SessionPrefImpl.access$getDataStore(sessionPrefImpl, SessionPrefImpl.access$getContext$p(sessionPrefImpl)), object, string3, (Continuation<? super Unit>)this) == object2) {
                        return object2;
                    }
                }
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                setLoggedIn.1 v0 = object2;
                Object object2 = v0.this$0;
                object = v0.$user;
                String string2 = v0.$token;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)function22, (int)3, null);
    }

    @Override
    public boolean isLoggedIn() {
        String string2 = this.getToken();
        return !(string2 == null || string2.length() == 0) && this.getUser() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canConnectToTinodeServer() {
        if (!((SessionPrefImpl)this).isLoggedIn()) return false;
        if (!((SessionPrefImpl)this).hasTinodeHost()) return false;
        if ((this = ((SessionPrefImpl)this).getSdkKey()) == null) return false;
        if (this.length() != 0) return true;
        return false;
    }

    @Override
    public boolean isPhoneContactsEnabled() {
        return this._isPhoneContactsEnabled;
    }

    @Override
    public void setPhoneContactsEnabled(boolean bl) {
        this._isPhoneContactsEnabled = bl;
    }

    @Override
    @NotNull
    public Flow<Boolean> getUserLoggedInListener() {
        SessionPrefImpl sessionPrefImpl = sessionPrefImpl2;
        SessionPrefImpl sessionPrefImpl2 = sessionPrefImpl.getDataStore(sessionPrefImpl.context).getData();
        return FlowKt.distinctUntilChanged((Flow)new Flow<Boolean>((Flow)sessionPrefImpl2){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            @Nullable
            public Object collect(@NotNull FlowCollector flowCollector, @NotNull Continuation continuation) {
                Object object = object.$this_unsafeTransform$inlined.collect((FlowCollector)new FlowCollector<Preferences>(flowCollector){
                    final /* synthetic */ FlowCollector $this_unsafeFlow$inlined;
                    {
                        this.$this_unsafeFlow$inlined = flowCollector;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public Object emit(Object var1_1, @NotNull Continuation var2_2) {
                        if (!(var2_2 instanceof getUserLoggedInListener$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = var2_2;
                        var4_4 = var3_3.label;
                        if ((var4_4 & -2147483648) != 0) {
                            var3_3.label = var4_4 - -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var3_3 = v0;
                            v0 = new ContinuationImpl(this, (Continuation)var2_2){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ getUserLoggedInListener$$inlined$map$1$2 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(continuation);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    getUserLoggedInListener$$inlined$map$1$2$1 v0 = this;
                                    v0.result = object;
                                    v0.label |= Integer.MIN_VALUE;
                                    return v0.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        v1 = var3_3;
                        var2_2 = v1.result;
                        var4_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        var5_6 = v1.label;
                        if (var5_6 == 0) ** GOTO lbl18
                        if (var5_6 == 1) {
                            ResultKt.throwOnFailure((Object)var2_2);
                        } else {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
lbl18:
                            // 1 sources

                            ResultKt.throwOnFailure((Object)var2_2);
                            this = this.$this_unsafeFlow$inlined;
                            var1_1 = (Preferences)var1_1;
                            var2_2 = (CharSequence)var1_1.get(SessionPrefImpl.access$getKEY_TOKEN$cp());
                            var3_3.label = 1;
                            if (this.emit(Boxing.boxBoolean((boolean)((var2_2 == null || var2_2.length() == 0) == false && var1_1.get(SessionPrefImpl.access$getKEY_USER$cp()) != null)), (Continuation)var3_3) == var4_5) {
                                return var4_5;
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }, continuation);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    @NotNull
    public Flow<Integer> getTotalUnreadMessagesCountListener() {
        SessionPrefImpl sessionPrefImpl = sessionPrefImpl2;
        SessionPrefImpl sessionPrefImpl2 = sessionPrefImpl.getDataStore(sessionPrefImpl.context).getData();
        return FlowKt.distinctUntilChanged((Flow)new Flow<Integer>((Flow)sessionPrefImpl2){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            @Nullable
            public Object collect(@NotNull FlowCollector flowCollector, @NotNull Continuation continuation) {
                Object object = object.$this_unsafeTransform$inlined.collect((FlowCollector)new FlowCollector<Preferences>(flowCollector){
                    final /* synthetic */ FlowCollector $this_unsafeFlow$inlined;
                    {
                        this.$this_unsafeFlow$inlined = flowCollector;
                    }

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    @Nullable
                    public Object emit(Object var1_1, @NotNull Continuation var2_2) {
                        if (!(var2_2 /* !! */  instanceof getTotalUnreadMessagesCountListener$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = var2_2 /* !! */ ;
                        var4_4 = var3_3.label;
                        if ((var4_4 & -2147483648) != 0) {
                            var3_3.label = var4_4 - -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var3_3 = v0;
                            v0 = new ContinuationImpl(this, var2_2 /* !! */ ){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ getTotalUnreadMessagesCountListener$$inlined$map$1$2 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(continuation);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    getTotalUnreadMessagesCountListener$$inlined$map$1$2$1 v0 = this;
                                    v0.result = object;
                                    v0.label |= Integer.MIN_VALUE;
                                    return v0.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        v1 = var3_3;
                        var2_2 /* !! */  = v1.result;
                        var4_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        var5_6 = v1.label;
                        if (var5_6 == 0) ** GOTO lbl18
                        if (var5_6 == 1) {
                            ResultKt.throwOnFailure((Object)var2_2 /* !! */ );
                        } else {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
lbl18:
                            // 1 sources

                            ResultKt.throwOnFailure((Object)var2_2 /* !! */ );
                            this = this.$this_unsafeFlow$inlined;
                            var1_1 = (Integer)((Preferences)var1_1).get(SessionPrefImpl.access$getKEY_TOTAL_UNREAD_MESSAGES$cp());
                            var3_3.label = 1;
                            if (this.emit(Boxing.boxInt((int)(var1_1 == null ? 0 : var1_1.intValue())), (Continuation)var3_3) == var4_5) {
                                return var4_5;
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }, continuation);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    public void logout() {
        SessionPrefImpl sessionPrefImpl = this;
        sessionPrefImpl.setLoggedIn(null, null);
        sessionPrefImpl.setTinodeUserId(null);
        sessionPrefImpl.setClientSettings(null);
        sessionPrefImpl.setFirebaseTokenChanged(true);
        sessionPrefImpl.setTotalUnreadMessagesCount(0);
        sessionPrefImpl.setVoximplantUser(null);
        sessionPrefImpl.setAnsweredQuestionsIds(CollectionsKt.emptyList());
        sessionPrefImpl.setResultNotifiedQuestionsIds(CollectionsKt.emptyList());
        sessionPrefImpl.setOnboardingEventIds(CollectionsKt.emptyList());
    }

    @Override
    public boolean hasTinodeHost() {
        boolean bl;
        if ((this = ((SessionPrefImpl)this).getOrganizationSettings()) == null) {
            bl = false;
        } else {
            boolean bl2 = (this = ((OrganizationSettings)this).getTinodeHost()) == null || this.length() == 0;
            bl = bl2 ^ true;
        }
        return bl;
    }

    @Override
    @NotNull
    public List<Integer> getInvitedContactIds() {
        return this.invitedContactIds;
    }

    @Override
    public void addInvitedContact(int n) {
        SessionPrefImpl sessionPrefImpl = this;
        sessionPrefImpl.invitedContactIds.add(n);
        sessionPrefImpl.updateValue(KEY_INVITED_CONTACT_IDS, GsonUtil.INSTANCE.getDefaultGson().toJson(this.invitedContactIds));
    }

    @Override
    @NotNull
    public Flow<ClientSettings> getClientSettingsChangeListener() {
        SessionPrefImpl sessionPrefImpl = sessionPrefImpl2;
        SessionPrefImpl sessionPrefImpl2 = sessionPrefImpl.getDataStore(sessionPrefImpl.context).getData();
        return FlowKt.distinctUntilChanged((Flow)new Flow<ClientSettings>((Flow)sessionPrefImpl2){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            @Nullable
            public Object collect(@NotNull FlowCollector flowCollector, @NotNull Continuation continuation) {
                Object object = object.$this_unsafeTransform$inlined.collect((FlowCollector)new FlowCollector<Preferences>(flowCollector){
                    final /* synthetic */ FlowCollector $this_unsafeFlow$inlined;
                    {
                        this.$this_unsafeFlow$inlined = flowCollector;
                    }

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    @Nullable
                    public Object emit(Object var1_1, @NotNull Continuation var2_2) {
                        if (!(var2_2 /* !! */  instanceof getClientSettingsChangeListener$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = var2_2 /* !! */ ;
                        var4_4 = var3_3.label;
                        if ((var4_4 & -2147483648) != 0) {
                            var3_3.label = var4_4 - -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var3_3 = v0;
                            v0 = new ContinuationImpl(this, var2_2 /* !! */ ){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ getClientSettingsChangeListener$$inlined$map$1$2 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(continuation);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    getClientSettingsChangeListener$$inlined$map$1$2$1 v0 = this;
                                    v0.result = object;
                                    v0.label |= Integer.MIN_VALUE;
                                    return v0.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        v1 = var3_3;
                        var2_2 /* !! */  = v1.result;
                        var4_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        var5_6 = v1.label;
                        if (var5_6 == 0) ** GOTO lbl18
                        if (var5_6 == 1) {
                            ResultKt.throwOnFailure((Object)var2_2 /* !! */ );
                        } else {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
lbl18:
                            // 1 sources

                            ResultKt.throwOnFailure((Object)var2_2 /* !! */ );
                            this = this.$this_unsafeFlow$inlined;
                            var1_1 = (String)((Preferences)var1_1).get(SessionPrefImpl.access$getKEY_CLIENT_SETTINGS$cp());
                            var1_1 = var1_1 == null ? null : (ClientSettings)GsonUtil.INSTANCE.getDefaultGson().fromJson((String)var1_1, ClientSettings.class);
                            var3_3.label = 1;
                            if (this.emit(var1_1, (Continuation)var3_3) == var4_5) {
                                return var4_5;
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }, continuation);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    public void setTopicMuted(boolean bl, @NotNull String string2) {
        Preferences.Key<Boolean> key = key2;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Preferences.Key<Boolean> key2 = key2.getMutedTopicKey(string2);
        super.updateValue(key2, Boolean.valueOf(bl));
    }

    @Override
    public boolean isTopicMuted(@NotNull String string2) {
        Function2<CoroutineScope, Continuation<? super Boolean>, Object> function2;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Function2<CoroutineScope, Continuation<? super Boolean>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, string2, null){
            int label;
            final /* synthetic */ SessionPrefImpl this$0;
            final /* synthetic */ String $topicId;
            {
                this.this$0 = sessionPrefImpl;
                this.$topicId = string2;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = bl.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object);
                } else {
                    isTopicMuted$1$invokeSuspend$$inlined$map$1 v2;
                    isTopicMuted.1 v0 = bl;
                    ResultKt.throwOnFailure((Object)object);
                    SessionPrefImpl sessionPrefImpl = v0.this$0;
                    object = SessionPrefImpl.access$getDataStore(sessionPrefImpl, SessionPrefImpl.access$getContext$p(sessionPrefImpl)).getData();
                    SessionPrefImpl sessionPrefImpl2 = v0.this$0;
                    String string2 = v0.$topicId;
                    isTopicMuted$1$invokeSuspend$$inlined$map$1 var5_6 = v2;
                    var5_6((Flow)object, sessionPrefImpl2, string2);
                    bl.label = 1;
                    object = FlowKt.firstOrNull((Flow)v2, (Continuation)bl);
                    if (object == object2) {
                        return object2;
                    }
                }
                Boolean bl = (Boolean)object;
                return Boxing.boxBoolean((boolean)(bl == null ? false : bl));
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                isTopicMuted.1 v0 = object2;
                Object object2 = v0.this$0;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Boolean> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        return (Boolean)BuildersKt.runBlocking$default(null, (Function2)function22, (int)1, null);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

