/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.utils;

import com.github.marlonlom.utilities.timeago.TimeAgo;
import io.streamlayer.common.utils.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DateUtil {
    @NotNull
    public static final DateUtil INSTANCE = new DateUtil();
    private static boolean is24HourFormat;
    @NotNull
    private static final Lazy fullDateFormat$delegate;
    @NotNull
    private static final Lazy twitterDateFormat$delegate;
    @NotNull
    private static final Lazy dateFormat$delegate;
    @NotNull
    private static final Lazy shortDate24Format$delegate;
    @NotNull
    private static final Lazy shortDateFormat$delegate;
    @NotNull
    private static final Lazy weekDayFormat$delegate;
    @NotNull
    private static final Lazy dayMonthFormat$delegate;
    @NotNull
    private static final Lazy weekDayMonthDayFormat$delegate;
    @NotNull
    private static final Lazy requestDateFormat$delegate;

    private DateUtil() {
    }

    private final SimpleDateFormat getFullDateFormat() {
        return (SimpleDateFormat)fullDateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getTwitterDateFormat() {
        return (SimpleDateFormat)twitterDateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getDateFormat() {
        return (SimpleDateFormat)dateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getShortDate24Format() {
        return (SimpleDateFormat)shortDate24Format$delegate.getValue();
    }

    private final SimpleDateFormat getShortDateFormat() {
        return (SimpleDateFormat)shortDateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getWeekDayFormat() {
        return (SimpleDateFormat)weekDayFormat$delegate.getValue();
    }

    private final SimpleDateFormat getDayMonthFormat() {
        return (SimpleDateFormat)dayMonthFormat$delegate.getValue();
    }

    private final SimpleDateFormat getWeekDayMonthDayFormat() {
        return (SimpleDateFormat)weekDayMonthDayFormat$delegate.getValue();
    }

    public static /* synthetic */ Date fromString$default(DateUtil dateUtil, String string2, TimeZone timeZone, int n, Object object) {
        if ((n & 2) != 0) {
            timeZone = TimeZone.getTimeZone("UTC");
            Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getTimeZone(\"UTC\")");
        }
        return dateUtil.fromString(string2, timeZone);
    }

    static {
        fullDateFormat$delegate = LazyKt.lazy((Function0)fullDateFormat.2.INSTANCE);
        twitterDateFormat$delegate = LazyKt.lazy((Function0)twitterDateFormat.2.INSTANCE);
        dateFormat$delegate = LazyKt.lazy((Function0)dateFormat.2.INSTANCE);
        shortDate24Format$delegate = LazyKt.lazy((Function0)shortDate24Format.2.INSTANCE);
        shortDateFormat$delegate = LazyKt.lazy((Function0)shortDateFormat.2.INSTANCE);
        weekDayFormat$delegate = LazyKt.lazy((Function0)weekDayFormat.2.INSTANCE);
        dayMonthFormat$delegate = LazyKt.lazy((Function0)dayMonthFormat.2.INSTANCE);
        weekDayMonthDayFormat$delegate = LazyKt.lazy((Function0)weekDayMonthDayFormat.2.INSTANCE);
        requestDateFormat$delegate = LazyKt.lazy((Function0)requestDateFormat.2.INSTANCE);
    }

    public final boolean is24HourFormat() {
        return is24HourFormat;
    }

    public final void set24HourFormat(boolean bl) {
        is24HourFormat = bl;
    }

    @NotNull
    public final SimpleDateFormat getRequestDateFormat() {
        return (SimpleDateFormat)requestDateFormat$delegate.getValue();
    }

    @NotNull
    public final String toWeekDayMonthDay(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        String string2 = this.getWeekDayMonthDayFormat().format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"weekDayMonthDayFormat.format(value)");
        return string2;
    }

    @Nullable
    public final Date fromString(@NotNull String string2, @NotNull TimeZone timeZone) {
        DateUtil dateUtil = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        dateUtil.getFullDateFormat().setTimeZone(timeZone);
        return dateUtil.getFullDateFormat().parse(string2);
    }

    @Nullable
    public final String toDateTimeString(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return this.getFullDateFormat().format(date);
    }

    @NotNull
    public final String toDateString(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        String string2 = this.getDateFormat().format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dateFormat.format(value)");
        return string2;
    }

    @Nullable
    public final Date dateFromString(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"value");
        return this.getDateFormat().parse(string2);
    }

    @Nullable
    public final String toShort(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return is24HourFormat ? this.getShortDate24Format().format(date) : this.getShortDateFormat().format(date);
    }

    @Nullable
    public final String toWeekDay(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return this.getWeekDayFormat().format(date);
    }

    @Nullable
    public final String toDayMonth(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return this.getDayMonthFormat().format(date);
    }

    public final boolean isSameDay(@NotNull Date date, @NotNull Date date2) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date1");
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date2");
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        return calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1);
    }

    @NotNull
    public final String toRelativeTimeString(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return TimeAgo.Companion.using$default((TimeAgo.Companion)TimeAgo.Companion, (long)date.getTime(), null, (int)2, null);
    }

    @Nullable
    public final Date fromTwitterStringToDate(@Nullable String string2) {
        if (string2 == null) {
            return null;
        }
        return this.getTwitterDateFormat().parse(string2);
    }

    @Nullable
    public final String fromDateToTwitterString(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        return this.getTwitterDateFormat().format(date);
    }
}

