/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.utils;

import android.net.Uri;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import io.streamlayer.sdk.R;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavigationUtils {
    @NotNull
    public static final NavigationUtils INSTANCE = new NavigationUtils();

    private NavigationUtils() {
    }

    private final String cleanUri(String string2) {
        return StringsKt.removeSuffix((String)string2, (CharSequence)"/");
    }

    @NotNull
    public final Uri buildChatMessageDeepLink(@Nullable String string2) {
        String string3 = "streamlayer://chats/";
        if (string2 == null) {
            string2 = "";
        }
        Uri uri = Uri.parse((String)this.cleanUri(Intrinsics.stringPlus((String)string3, (Object)string2)));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(cleanUri(DEEP_LINK\u2026HATS + chatId.orEmpty()))");
        return uri;
    }

    @NotNull
    public final Uri buildWatchPartyDeepLink(@Nullable String string2) {
        String string3 = "streamlayer://calls/";
        if (string2 == null) {
            string2 = "";
        }
        Uri uri = Uri.parse((String)this.cleanUri(Intrinsics.stringPlus((String)string3, (Object)string2)));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(cleanUri(DEEP_LINK\u2026LLS + topicId.orEmpty()))");
        return uri;
    }

    public final boolean isWatchPartyDeepLink(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        String string2 = uri2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.toString()");
        return StringsKt.startsWith$default((String)string2, (String)"streamlayer://calls/", (boolean)false, (int)2, null);
    }

    public final boolean isInviteDeepLink(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)uri2.toString(), (Object)"streamlayer://invite");
    }

    @NotNull
    public final Uri buildInviteDeepLink() {
        Uri uri = Uri.parse((String)"streamlayer://invite");
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(DEEP_LINK_SCHEME_PREFIX + DEEP_LINK_INVITE)");
        return uri;
    }

    @NotNull
    public final Uri buildTweetDeepLink(@Nullable String string2) {
        String string3 = "streamlayer://tweets/";
        if (string2 == null) {
            string2 = "";
        }
        Uri uri = Uri.parse((String)this.cleanUri(Intrinsics.stringPlus((String)string3, (Object)string2)));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(cleanUri(DEEP_LINK\u2026ETS + tweetId.orEmpty()))");
        return uri;
    }

    @NotNull
    public final Uri buildStatisticsDeepLink() {
        Uri uri = Uri.parse((String)this.cleanUri("streamlayer://statistics/"));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(cleanUri(DEEP_LINK\u2026 + DEEP_LINK_STATISTICS))");
        return uri;
    }

    public final boolean isChatDeepLink(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        String string2 = uri2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.toString()");
        return StringsKt.contains$default((CharSequence)string2, (CharSequence)"chats/", (boolean)false, (int)2, null);
    }

    @NotNull
    public final NavOptions.Builder defaultNavOptionsBuilder() {
        NavOptions.Builder builder = new NavOptions.Builder().setEnterAnim(R.anim.slr_slide_from_right).setExitAnim(R.anim.slr_slide_to_left).setPopEnterAnim(R.anim.slr_slide_from_left).setPopExitAnim(R.anim.slr_slide_to_right);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder()\n        .setEn\u2026.anim.slr_slide_to_right)");
        return builder;
    }

    @NotNull
    public final NavOptions.Builder fadeNavOptionsBuilder() {
        NavOptions.Builder builder = new NavOptions.Builder().setEnterAnim(R.anim.slr_fade_in).setExitAnim(R.anim.slr_fade_out).setPopEnterAnim(R.anim.slr_fade_in).setPopExitAnim(R.anim.slr_fade_out);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder()\n        .setEn\u2026Anim(R.anim.slr_fade_out)");
        return builder;
    }

    public final boolean isChat(@NotNull NavDestination navDestination) {
        NavDestination navDestination2 = navDestination;
        Intrinsics.checkNotNullParameter((Object)navDestination2, (String)"<this>");
        return navDestination2.getId() == R.id.fragmentMessagingChat || navDestination.getId() == R.id.fragmentMessagingChatNested;
    }
}

