/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventTeam;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventTeamsInfoView
extends ConstraintLayout {
    @NotNull
    public Map<Integer, View> _$_findViewCache;

    @JvmOverloads
    public EventTeamsInfoView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        this._$_findViewCache = new LinkedHashMap<Integer, View>();
        View.inflate((Context)context, (int)R.layout.slr_view_event_info, (ViewGroup)this);
    }

    public /* synthetic */ EventTeamsInfoView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public EventTeamsInfoView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public EventTeamsInfoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public final void setInfo(@NotNull EventSummary eventSummary2) {
        EventTeamsInfoView eventTeamsInfoView = this;
        EventSummary eventSummary3 = eventSummary2;
        Intrinsics.checkNotNullParameter((Object)eventSummary3, (String)"eventSummary");
        EventTeam eventTeam = eventSummary3.getHomeTeam();
        EventTeam eventTeam2 = eventSummary3.getAwayTeam();
        int n = eventSummary3.getHomeScore();
        int n2 = eventSummary3.getAwayScore();
        ((TextView)eventTeamsInfoView._$_findCachedViewById(R.id.slEventInfoLeftTeamNameTV)).setText((CharSequence)eventTeam.getAlias());
        ImageView imageView = (ImageView)eventTeamsInfoView._$_findCachedViewById(R.id.slEventInfoLeftTeamLogoIV);
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slEventInfoLeftTeamLogoIV");
        ViewExtensionsKt.loadUrl$default(imageView, eventTeam.getLogo(), false, null, null, 14, null);
        ((TextView)eventTeamsInfoView._$_findCachedViewById(R.id.slEventInfoRightTeamNameTV)).setText((CharSequence)eventTeam2.getAlias());
        ImageView imageView2 = (ImageView)eventTeamsInfoView._$_findCachedViewById(R.id.slEventInfoRightTeamLogoIV);
        Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"slEventInfoRightTeamLogoIV");
        ViewExtensionsKt.loadUrl$default(imageView2, eventTeam2.getLogo(), false, null, null, 14, null);
        if (eventSummary2.getStatus() == EventStatus.Active) {
            EventTeamsInfoView eventTeamsInfoView2 = this;
            ((TextView)eventTeamsInfoView2._$_findCachedViewById(R.id.slEventInfoCurrentPhaseTV)).setText((CharSequence)this.getContext().getString(R.string.slr_s_qtr, new Object[]{OtherExtensionsKt.toOrdinalString(eventSummary2.getPeriodsCount())}));
            ((TextView)eventTeamsInfoView2._$_findCachedViewById(R.id.slEventInfoCurrentPhaseTV)).setBackground(null);
        } else {
            EventTeamsInfoView eventTeamsInfoView3 = this;
            ((TextView)eventTeamsInfoView3._$_findCachedViewById(R.id.slEventInfoCurrentPhaseTV)).setText((CharSequence)"VS");
            ((TextView)eventTeamsInfoView3._$_findCachedViewById(R.id.slEventInfoCurrentPhaseTV)).setBackgroundResource(R.drawable.slr_bg_versus_text);
        }
        EventTeamsInfoView eventTeamsInfoView4 = this;
        ((TextView)eventTeamsInfoView4._$_findCachedViewById(R.id.slEventInfoLeftScoreTV)).setText((CharSequence)String.valueOf(n));
        ((TextView)eventTeamsInfoView4._$_findCachedViewById(R.id.slEventInfoRightScoreTV)).setText((CharSequence)String.valueOf(n2));
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int n) {
        Map<Integer, View> map2 = this._$_findViewCache;
        View view2 = map2.get(n);
        if (view2 == null) {
            view2 = this.findViewById(n);
            if (view2 == null) {
                view2 = null;
            } else {
                map2.put(n, view2);
            }
        }
        return view2;
    }
}

