/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TableLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.sports.EventPeriod;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventTeam;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SLRBoxScoreStatsView
extends TableLayout {
    @NotNull
    public Map<Integer, View> _$_findViewCache;
    private int viewType;

    public SLRBoxScoreStatsView(@NotNull Context context) {
        LinkedHashMap linkedHashMap;
        SLRBoxScoreStatsView sLRBoxScoreStatsView = object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        Object object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        sLRBoxScoreStatsView._$_findViewCache = object;
        sLRBoxScoreStatsView.viewType = -1;
        sLRBoxScoreStatsView.init(context, null, null);
    }

    public SLRBoxScoreStatsView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        LinkedHashMap linkedHashMap;
        SLRBoxScoreStatsView sLRBoxScoreStatsView = object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet);
        Object object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        sLRBoxScoreStatsView._$_findViewCache = object;
        sLRBoxScoreStatsView.viewType = -1;
        sLRBoxScoreStatsView.init(context, attributeSet, null);
    }

    private final void init(Context context, AttributeSet attributeSet, Integer n) {
        View.inflate((Context)context, (int)R.layout.slr_view_boxscore_stats, (ViewGroup)this);
        if (attributeSet != null) {
            context = context.obtainStyledAttributes(attributeSet, R.styleable.SLRBoxScoreStatsView);
            this.viewType = context.getInt(R.styleable.SLRBoxScoreStatsView_slrBoxScoreType, 0);
            this.setupUI();
            context.recycle();
        }
    }

    private final void setupUI() {
        int n = this.viewType;
        if (n != 0) {
            if (n == 1) {
                ((TextView)this._$_findCachedViewById(R.id.slBoxScore4thLabel)).setText(R.string.slr_box_score_overtime_abr);
            }
        } else {
            ((TextView)this._$_findCachedViewById(R.id.slBoxScore4thLabel)).setText(R.string.slr_box_score_4th_qt);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getPeriodScore(List<EventPeriod> list, boolean bl, int n) {
        void var2_6;
        void var1_5;
        block6: {
            for (Object e : list) {
                void var3_7;
                if (!(((EventPeriod)e).getNumber() == var3_7)) continue;
                break block6;
            }
            Object var1_4 = null;
        }
        Object object = (EventPeriod)var1_5;
        if (var2_6 != false) {
            if (object == null) {
                return "-";
            }
            if ((object = Integer.valueOf(((EventPeriod)object).getHomeScore()).toString()) != null) return object;
            return "-";
        }
        if (object == null) {
            return "-";
        }
        if ((object = Integer.valueOf(((EventPeriod)object).getAwayScore()).toString()) != null) return object;
        return "-";
    }

    private final void setCurrentPeriod(List<EventPeriod> object, EventStatus eventStatus) {
        ArrayList<Integer> arrayList;
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(((EventPeriod)object.next()).getNumber());
        }
        object = (Integer)CollectionsKt.maxOrNull(arrayList2);
        if (eventStatus == EventStatus.Active) {
            if (object != null) {
                this.markCurrentPeriod(((Number)object).intValue());
            }
        } else {
            this.markCurrentPeriod(0);
        }
    }

    private final void markCurrentPeriod(int n) {
        TextView textView = (TextView)this._$_findCachedViewById(R.id.slBoxScore1stLabel);
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"slBoxScore1stLabel");
        boolean bl = n == 1;
        SLRBoxScoreStatsView sLRBoxScoreStatsView = this;
        sLRBoxScoreStatsView.markPeriodLabel(textView, bl);
        textView = (TextView)sLRBoxScoreStatsView._$_findCachedViewById(R.id.slBoxScore2ndLabel);
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"slBoxScore2ndLabel");
        bl = n == 2;
        SLRBoxScoreStatsView sLRBoxScoreStatsView2 = this;
        sLRBoxScoreStatsView2.markPeriodLabel(textView, bl);
        textView = (TextView)sLRBoxScoreStatsView2._$_findCachedViewById(R.id.slBoxScore3rdLabel);
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"slBoxScore3rdLabel");
        bl = n == 3;
        SLRBoxScoreStatsView sLRBoxScoreStatsView3 = this;
        sLRBoxScoreStatsView3.markPeriodLabel(textView, bl);
        TextView textView2 = (TextView)sLRBoxScoreStatsView3._$_findCachedViewById(R.id.slBoxScore4thLabel);
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"slBoxScore4thLabel");
        boolean bl2 = n == 4;
        this.markPeriodLabel(textView2, bl2);
    }

    private final void markPeriodLabel(TextView textView, boolean bl) {
        SLRBoxScoreStatsView sLRBoxScoreStatsView = ContextCompat.getDrawable((Context)sLRBoxScoreStatsView.getContext(), (int)R.drawable.slr_indicator_period_underline);
        if (!bl) {
            sLRBoxScoreStatsView = null;
        }
        TextView textView2 = textView;
        textView2.setBackground((Drawable)sLRBoxScoreStatsView);
        textView2.setTypeface(textView2.getTypeface(), bl ? 1 : 0);
    }

    public final void setStats(@NotNull EventSummary eventSummary2) {
        SLRBoxScoreStatsView sLRBoxScoreStatsView = this;
        SLRBoxScoreStatsView sLRBoxScoreStatsView2 = this;
        EventSummary eventSummary3 = eventSummary2;
        Intrinsics.checkNotNullParameter((Object)eventSummary3, (String)"eventSummary");
        Object object = eventSummary3.getHomeTeam();
        EventTeam eventTeam = eventSummary3.getAwayTeam();
        ((TextView)sLRBoxScoreStatsView2._$_findCachedViewById(R.id.slBoxScoreHomeTeamNameTV)).setText((CharSequence)((EventTeam)object).getAlias());
        ImageView imageView = (ImageView)sLRBoxScoreStatsView2._$_findCachedViewById(R.id.slBoxScoreHomeTeamLogoIV);
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slBoxScoreHomeTeamLogoIV");
        ViewExtensionsKt.loadUrl$default(imageView, ((EventTeam)object).getLogo(), false, null, null, 14, null);
        ((TextView)sLRBoxScoreStatsView2._$_findCachedViewById(R.id.slBoxScoreAwayTeamNameTV)).setText((CharSequence)eventTeam.getAlias());
        ImageView imageView2 = (ImageView)sLRBoxScoreStatsView2._$_findCachedViewById(R.id.slBoxScoreAwayTeamLogoIV);
        Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"slBoxScoreAwayTeamLogoIV");
        ViewExtensionsKt.loadUrl$default(imageView2, eventTeam.getLogo(), false, null, null, 14, null);
        object = eventSummary2.getPeriods();
        ((TextView)sLRBoxScoreStatsView._$_findCachedViewById(R.id.slBoxScoreHome1stScoreTV)).setText((CharSequence)this.getPeriodScore((List<EventPeriod>)object, true, 1));
        ((TextView)sLRBoxScoreStatsView._$_findCachedViewById(R.id.slBoxScoreHome2ndScoreTV)).setText((CharSequence)this.getPeriodScore((List<EventPeriod>)object, true, 2));
        ((TextView)sLRBoxScoreStatsView._$_findCachedViewById(R.id.slBoxScoreHome3rdScoreTV)).setText((CharSequence)this.getPeriodScore((List<EventPeriod>)object, true, 3));
        ((TextView)sLRBoxScoreStatsView._$_findCachedViewById(R.id.slBoxScoreHome4thScoreTV)).setText((CharSequence)this.getPeriodScore((List<EventPeriod>)object, true, 4));
        ((TextView)sLRBoxScoreStatsView._$_findCachedViewById(R.id.slBoxScoreAway1stScoreTV)).setText((CharSequence)this.getPeriodScore((List<EventPeriod>)object, false, 1));
        ((TextView)sLRBoxScoreStatsView._$_findCachedViewById(R.id.slBoxScoreAway2ndScoreTV)).setText((CharSequence)this.getPeriodScore((List<EventPeriod>)object, false, 2));
        ((TextView)sLRBoxScoreStatsView._$_findCachedViewById(R.id.slBoxScoreAway3rdScoreTV)).setText((CharSequence)this.getPeriodScore((List<EventPeriod>)object, false, 3));
        ((TextView)sLRBoxScoreStatsView._$_findCachedViewById(R.id.slBoxScoreAway4thScoreTV)).setText((CharSequence)this.getPeriodScore((List<EventPeriod>)object, false, 4));
        if (sLRBoxScoreStatsView.viewType == 1 && object.size() < 4) {
            SLRBoxScoreStatsView sLRBoxScoreStatsView3 = this;
            TextView textView = (TextView)sLRBoxScoreStatsView3._$_findCachedViewById(R.id.slBoxScore4thLabel);
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"slBoxScore4thLabel");
            ViewExtensionsKt.gone((View)textView);
            TextView textView2 = (TextView)sLRBoxScoreStatsView3._$_findCachedViewById(R.id.slBoxScoreHome4thScoreTV);
            Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"slBoxScoreHome4thScoreTV");
            ViewExtensionsKt.gone((View)textView2);
            TextView textView3 = (TextView)sLRBoxScoreStatsView3._$_findCachedViewById(R.id.slBoxScoreAway4thScoreTV);
            Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"slBoxScoreAway4thScoreTV");
            ViewExtensionsKt.gone((View)textView3);
        }
        SLRBoxScoreStatsView sLRBoxScoreStatsView4 = this;
        ((TextView)sLRBoxScoreStatsView4._$_findCachedViewById(R.id.slBoxScoreHomeTotScoreTV)).setText((CharSequence)String.valueOf(eventSummary2.getHomeScore()));
        ((TextView)sLRBoxScoreStatsView4._$_findCachedViewById(R.id.slBoxScoreAwayTotScoreTV)).setText((CharSequence)String.valueOf(eventSummary2.getAwayScore()));
        this.setCurrentPeriod((List<EventPeriod>)object, eventSummary2.getStatus());
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int n) {
        Map<Integer, View> map2 = this._$_findViewCache;
        View view2 = map2.get(n);
        if (view2 == null) {
            view2 = this.findViewById(n);
            if (view2 == null) {
                view2 = null;
            } else {
                map2.put(n, view2);
            }
        }
        return view2;
    }
}

