/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrViewPercentageStatisticBinding;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SLRStatsPercentageView
extends ConstraintLayout {
    @NotNull
    public Map<Integer, View> _$_findViewCache;
    @NotNull
    private final SlrViewPercentageStatisticBinding binding;
    @Nullable
    private Function1<? super Double, String> percentFormat;

    @JvmOverloads
    public SLRStatsPercentageView(@NotNull Context object, @Nullable AttributeSet attributeSet, int n) {
        Context context = object;
        Context context2 = object;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        this._$_findViewCache = new LinkedHashMap<Integer, View>();
        SlrViewPercentageStatisticBinding slrViewPercentageStatisticBinding = SlrViewPercentageStatisticBinding.inflate(LayoutInflater.from((Context)object), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)slrViewPercentageStatisticBinding, (String)"inflate(LayoutInflater.from(context), this, true)");
        this.binding = slrViewPercentageStatisticBinding;
        object = R.styleable.SLRStatsPercentageView;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.SLRStatsPercentageView, (String)"SLRStatsPercentageView");
        object = context.obtainStyledAttributes(attributeSet, (int[])object, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"obtainStyledAttributes(s\u2026efStyleAttr, defStyleRes)");
        this.getBinding().slPercentageStatisticLabelTV.setText((CharSequence)object.getString(R.styleable.SLRStatsPercentageView_slrStatsPercentageLabel));
        object.recycle();
    }

    public /* synthetic */ SLRStatsPercentageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public static /* synthetic */ void setPercentage$default(SLRStatsPercentageView sLRStatsPercentageView, double d, double d2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        sLRStatsPercentageView.setPercentage(d, d2, bl);
    }

    public static /* synthetic */ void setPercentage$default(SLRStatsPercentageView sLRStatsPercentageView, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        sLRStatsPercentageView.setPercentage(n, n2, bl);
    }

    private final void setProgress(ProgressBar progressBar, int n, int n2, boolean bl) {
        ProgressBar progressBar2 = progressBar;
        progressBar2.setMax(n2 * 10);
        progressBar2.setProgress(0);
        int[] nArray = new int[2];
        Object object = nArray;
        object[0] = (SLRStatsPercentageView)false;
        nArray[1] = n * 10;
        object = ObjectAnimator.ofInt((Object)progressBar2, (String)"progress", (int[])object);
        long l = bl ? 2000L : 0L;
        Object object2 = object;
        object2.setDuration(l);
        object2.start();
    }

    static /* synthetic */ void setProgress$default(SLRStatsPercentageView sLRStatsPercentageView, ProgressBar progressBar, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl = true;
        }
        sLRStatsPercentageView.setProgress(progressBar, n, n2, bl);
    }

    private final String formatPercentage(double d) {
        Object object = String.format("%.3f", Arrays.copyOf(new Object[]{d}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(this, *args)");
        int n = d < 1.0 ? 1 : 0;
        return StringsKt.drop((String)object, (int)n);
    }

    @JvmOverloads
    public SLRStatsPercentageView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public SLRStatsPercentageView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @NotNull
    public final SlrViewPercentageStatisticBinding getBinding() {
        return this.binding;
    }

    @Nullable
    public final Function1<Double, String> getPercentFormat() {
        return this.percentFormat;
    }

    public final void setPercentFormat(@Nullable Function1<? super Double, String> function1) {
        this.percentFormat = function1;
    }

    public final void setLeftPercentColor(@ColorRes int n) {
        ProgressBar progressBar = this.binding.slPercentageStatisticLeftProgress;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.slPercentageStatisticLeftProgress");
        ViewExtensionsKt.setIndeterminateTintCompat(progressBar, ContextCompat.getColor((Context)this.getContext(), (int)n));
    }

    public final void setLeftPercentColor(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"res");
        ProgressBar progressBar = this.binding.slPercentageStatisticLeftProgress;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.slPercentageStatisticLeftProgress");
            ViewExtensionsKt.setIndeterminateTintCompat(progressBar, Color.parseColor((String)string2));
        }
        catch (Exception exception) {
            SLRLog.INSTANCE.e("SLRStatsPercentageView", Intrinsics.stringPlus((String)"Error parse color setLeftPercentColor ", (Object)string2), exception);
        }
    }

    public final void setRightPercentColor(@ColorRes int n) {
        ProgressBar progressBar = this.binding.slPercentageStatisticRightProgress;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.slPercentageStatisticRightProgress");
        ViewExtensionsKt.setIndeterminateTintCompat(progressBar, ContextCompat.getColor((Context)this.getContext(), (int)n));
    }

    public final void setRightPercentColor(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"res");
        ProgressBar progressBar = this.binding.slPercentageStatisticRightProgress;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.slPercentageStatisticRightProgress");
            ViewExtensionsKt.setIndeterminateTintCompat(progressBar, Color.parseColor((String)string2));
        }
        catch (Exception exception) {
            SLRLog.INSTANCE.e("SLRStatsPercentageView", Intrinsics.stringPlus((String)"Error parse color setRightPercentColor ", (Object)string2), exception);
        }
    }

    public final void setTitle(@Nullable String string2) {
        this.binding.slPercentageStatisticLabelTV.setText((CharSequence)string2);
    }

    public final void setPercentage(double d, double d2, boolean bl) {
        SLRStatsPercentageView sLRStatsPercentageView = this;
        SlrViewPercentageStatisticBinding slrViewPercentageStatisticBinding = sLRStatsPercentageView.binding;
        TextView textView = slrViewPercentageStatisticBinding.slPercentageStatisticLeftTV;
        Object object = sLRStatsPercentageView.getPercentFormat();
        object = object == null ? null : (String)object.invoke((Object)d2);
        if (object == null) {
            object = this.formatPercentage(d2);
        }
        textView.setText(object);
        textView = slrViewPercentageStatisticBinding.slPercentageStatisticRightTV;
        object = this.getPercentFormat();
        object = object == null ? null : (String)object.invoke((Object)d);
        if (object == null) {
            object = this.formatPercentage(d);
        }
        textView.setText(object);
        double d3 = 100;
        int n = (int)((d2 + d) * d3);
        ProgressBar progressBar = slrViewPercentageStatisticBinding.slPercentageStatisticLeftProgress;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"slPercentageStatisticLeftProgress");
        this.setProgress(progressBar, (int)(d2 * d3), n, bl);
        progressBar = slrViewPercentageStatisticBinding.slPercentageStatisticRightProgress;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"slPercentageStatisticRightProgress");
        this.setProgress(progressBar, (int)(d * d3), n, bl);
    }

    public final void setPercentage(int n, int n2, boolean bl) {
        SLRStatsPercentageView sLRStatsPercentageView = sLRStatsPercentageView3;
        SlrViewPercentageStatisticBinding slrViewPercentageStatisticBinding = sLRStatsPercentageView.binding;
        SLRStatsPercentageView sLRStatsPercentageView2 = sLRStatsPercentageView3;
        SlrViewPercentageStatisticBinding slrViewPercentageStatisticBinding2 = slrViewPercentageStatisticBinding;
        slrViewPercentageStatisticBinding2.slPercentageStatisticLeftTV.setText((CharSequence)String.valueOf(n2));
        slrViewPercentageStatisticBinding2.slPercentageStatisticRightTV.setText((CharSequence)String.valueOf(n));
        SLRStatsPercentageView sLRStatsPercentageView3 = slrViewPercentageStatisticBinding2.slPercentageStatisticLeftProgress;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sLRStatsPercentageView3), (String)"slPercentageStatisticLeftProgress");
        int n3 = n2 + n;
        sLRStatsPercentageView2.setProgress((ProgressBar)sLRStatsPercentageView3, n2, n3, bl);
        ProgressBar progressBar = slrViewPercentageStatisticBinding.slPercentageStatisticRightProgress;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"slPercentageStatisticRightProgress");
        sLRStatsPercentageView.setProgress(progressBar, n, n3, bl);
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int n) {
        Map<Integer, View> map2 = this._$_findViewCache;
        View view2 = map2.get(n);
        if (view2 == null) {
            view2 = this.findViewById(n);
            if (view2 == null) {
                view2 = null;
            } else {
                map2.put(n, view2);
            }
        }
        return view2;
    }
}

