/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views.alphavideoview;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.View;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.common.views.alphavideoview.ChromaKeyRenderer;
import io.streamlayer.common.views.alphavideoview.ChromaKeyVideoView;
import io.streamlayer.common.views.alphavideoview.GLTextureView;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ChromaKeyVideoView
extends GLTextureView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int GL_CONTEXT_VERSION = 2;
    private static final float DEFAULT_ASPECT_RATIO = 0.6666667f;
    private static final float DEFAULT_CENTER_VIDEO = 0.5f;
    @NotNull
    private static final String TAG = "ChromaKeyVideoView";
    @NotNull
    public Map<Integer, View> _$_findViewCache;
    private float videoAspectRatio;
    @Nullable
    private ChromaKeyRenderer renderer;
    @Nullable
    private MediaPlayer mediaPlayer;
    @Nullable
    private OnVideoStartedListener onVideoStartedListener;
    @Nullable
    private OnVideoEndedListener onVideoEndedListener;
    private boolean isSurfaceCreated;
    private boolean isDataSourceSet;
    @NotNull
    private PlayerState state;

    @JvmOverloads
    public ChromaKeyVideoView(int n, @NotNull Context object, @Nullable AttributeSet attributeSet) {
        ChromaKeyVideoView chromaKeyVideoView = this;
        Context context = object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet);
        chromaKeyVideoView._$_findViewCache = new LinkedHashMap<Integer, View>();
        chromaKeyVideoView.videoAspectRatio = 0.6666667f;
        chromaKeyVideoView.state = PlayerState.NOT_PREPARED;
        if (!chromaKeyVideoView.isInEditMode()) {
            Function1<SurfaceTexture, Unit> function1;
            ChromaKeyRenderer chromaKeyRenderer;
            ChromaKeyVideoView chromaKeyVideoView2 = this;
            chromaKeyVideoView2.setEGLContextClientVersion(2);
            chromaKeyVideoView2.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
            chromaKeyVideoView2.initMediaPlayer();
            chromaKeyVideoView2.setAlpha(0.0f);
            object = chromaKeyRenderer;
            new ChromaKeyRenderer().setBackgroundColor(n);
            Function1<SurfaceTexture, Unit> function12 = function1;
            function1 = new Function1<SurfaceTexture, Unit>(this){
                final /* synthetic */ ChromaKeyVideoView this$0;
                {
                    this.this$0 = chromaKeyVideoView;
                    super(1);
                }

                public final void invoke(@NotNull SurfaceTexture surfaceTexture) {
                    Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"it");
                    MediaPlayer mediaPlayer = this.this$0.getMediaPlayer();
                    if (mediaPlayer != null) {
                        Surface surface;
                        MediaPlayer mediaPlayer2 = mediaPlayer;
                        mediaPlayer = surface;
                        surface = new Surface(surfaceTexture);
                        mediaPlayer2.setSurface((Surface)mediaPlayer);
                    }
                    1.1 v2 = this;
                    ChromaKeyVideoView.access$setSurfaceCreated$p(v2.this$0, true);
                    if (ChromaKeyVideoView.access$isDataSourceSet$p(v2.this$0)) {
                        ChromaKeyVideoView.access$prepareAndStartMediaPlayer(this.this$0);
                    }
                }
            };
            object.setOnSurfacePrepareListener((Function1<? super SurfaceTexture, Unit>)function12);
            chromaKeyVideoView2.setRenderer((GLTextureView.Renderer)object);
            chromaKeyVideoView2.renderer = object;
            chromaKeyVideoView2.bringToFront();
            chromaKeyVideoView2.setRenderMode(1);
            chromaKeyVideoView2.setPreserveEGLContextOnPause(true);
            chromaKeyVideoView2.setOpaque(false);
            chromaKeyVideoView2.requestRender();
        }
    }

    public /* synthetic */ ChromaKeyVideoView(int n, Context context, AttributeSet attributeSet, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            attributeSet = null;
        }
        this(n, context, attributeSet);
    }

    private final void initMediaPlayer() {
        MediaPlayer mediaPlayer;
        MediaPlayer mediaPlayer2 = mediaPlayer;
        mediaPlayer2();
        this.mediaPlayer = mediaPlayer2;
        mediaPlayer.setScreenOnWhilePlaying(true);
        mediaPlayer2 = this.mediaPlayer;
        if (mediaPlayer2 != null) {
            mediaPlayer2.setOnCompletionListener(arg_0 -> ChromaKeyVideoView.initMediaPlayer$lambda-1(this, arg_0));
        }
    }

    private final void prepareAndStartMediaPlayer() {
        ChromaKeyVideoView chromaKeyVideoView = this;
        chromaKeyVideoView.prepareAsync(arg_0 -> ChromaKeyVideoView.prepareAndStartMediaPlayer$lambda-2(chromaKeyVideoView, arg_0));
    }

    private final void prepareAsync(MediaPlayer.OnPreparedListener onPreparedListener) {
        PlayerState playerState = chromaKeyVideoView.state;
        if (playerState == PlayerState.NOT_PREPARED || playerState == PlayerState.STOPPED) {
            playerState = chromaKeyVideoView.mediaPlayer;
            if (playerState != null) {
                playerState.setOnPreparedListener(arg_0 -> ChromaKeyVideoView.prepareAsync$lambda-3(chromaKeyVideoView, onPreparedListener, arg_0));
            }
            ChromaKeyVideoView chromaKeyVideoView = chromaKeyVideoView.mediaPlayer;
            if (chromaKeyVideoView != null) {
                chromaKeyVideoView.prepareAsync();
            }
        }
    }

    @JvmOverloads
    public ChromaKeyVideoView(int n, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(n, context, null, 4, null);
    }

    private static final void initMediaPlayer$lambda-1(ChromaKeyVideoView object, MediaPlayer mediaPlayer) {
        ChromaKeyVideoView chromaKeyVideoView = object;
        Intrinsics.checkNotNullParameter((Object)((Object)chromaKeyVideoView), (String)"this$0");
        chromaKeyVideoView.state = PlayerState.PAUSED;
        object = chromaKeyVideoView.onVideoEndedListener;
        if (object != null) {
            object.onVideoEnded();
        }
    }

    private static final void prepareAndStartMediaPlayer$lambda-2(ChromaKeyVideoView chromaKeyVideoView, MediaPlayer mediaPlayer) {
        ChromaKeyVideoView chromaKeyVideoView2 = chromaKeyVideoView;
        Intrinsics.checkNotNullParameter((Object)((Object)chromaKeyVideoView2), (String)"this$0");
        chromaKeyVideoView2.start();
    }

    private static final void prepareAsync$lambda-3(ChromaKeyVideoView chromaKeyVideoView, MediaPlayer.OnPreparedListener onPreparedListener, MediaPlayer mediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)((Object)chromaKeyVideoView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)onPreparedListener, (String)"$onPreparedListener");
        chromaKeyVideoView.state = PlayerState.PREPARED;
        onPreparedListener.onPrepared(mediaPlayer);
    }

    private static final void start$lambda-5$lambda-4(MediaPlayer object, ChromaKeyVideoView chromaKeyVideoView, MediaPlayer mediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)((Object)chromaKeyVideoView), (String)"this$0");
        object.start();
        chromaKeyVideoView.state = PlayerState.STARTED;
        object = chromaKeyVideoView.onVideoStartedListener;
        if (object != null) {
            object.onVideoStarted();
        }
    }

    public static final /* synthetic */ void access$setSurfaceCreated$p(ChromaKeyVideoView chromaKeyVideoView, boolean bl) {
        chromaKeyVideoView.isSurfaceCreated = bl;
    }

    public static final /* synthetic */ boolean access$isDataSourceSet$p(ChromaKeyVideoView chromaKeyVideoView) {
        return chromaKeyVideoView.isDataSourceSet;
    }

    public static final /* synthetic */ void access$prepareAndStartMediaPlayer(ChromaKeyVideoView chromaKeyVideoView) {
        chromaKeyVideoView.prepareAndStartMediaPlayer();
    }

    public final float getVideoAspectRatio() {
        return this.videoAspectRatio;
    }

    public final void setVideoAspectRatio(float f) {
        this.videoAspectRatio = f;
    }

    @Nullable
    public final MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    protected void onMeasure(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        n = View.MeasureSpec.getMode((int)n);
        n2 = View.MeasureSpec.getMode((int)n2);
        int n5 = View.MeasureSpec.getSize((int)n4);
        int n6 = View.MeasureSpec.getSize((int)n3);
        n2 = (int)((float)n6 * this.videoAspectRatio);
        this.setTranslationX((float)(n5 - n2) * 0.5f);
        int n7 = View.MeasureSpec.makeMeasureSpec((int)n2, (int)n);
        super.onMeasure(n7, View.MeasureSpec.makeMeasureSpec((int)n6, (int)n2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setVideoFromUri(@NotNull Uri uri) {
        ChromaKeyVideoView chromaKeyVideoView = this;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        chromaKeyVideoView.reset();
        try {
            MediaPlayer mediaPlayer = chromaKeyVideoView.mediaPlayer;
            if (mediaPlayer != null) {
                mediaPlayer.setDataSource(this.getContext(), uri);
            }
            this.isDataSourceSet = true;
            if (!this.isSurfaceCreated) return;
            this.prepareAndStartMediaPlayer();
            return;
        }
        catch (IOException iOException) {
            SLRLog.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"Video from uri ", (Object)uri.getPath()), iOException);
        }
    }

    @Override
    public void onPause() {
        ChromaKeyVideoView chromaKeyVideoView = this;
        super.onPause();
        chromaKeyVideoView.pause();
    }

    @Override
    protected void onDetachedFromWindow() {
        ChromaKeyVideoView chromaKeyVideoView = this;
        super.onDetachedFromWindow();
        chromaKeyVideoView.release();
    }

    public final void start() {
        MediaPlayer mediaPlayer = ((ChromaKeyVideoView)((Object)onVideoStartedListener)).mediaPlayer;
        if (mediaPlayer != null) {
            int n = WhenMappings.$EnumSwitchMapping$0[((ChromaKeyVideoView)((Object)onVideoStartedListener)).state.ordinal()];
            if (n != 1) {
                if (n != 2) {
                    if (n == 3) {
                        ((ChromaKeyVideoView)((Object)onVideoStartedListener)).prepareAsync(arg_0 -> ChromaKeyVideoView.start$lambda-5$lambda-4(mediaPlayer, (ChromaKeyVideoView)((Object)onVideoStartedListener), arg_0));
                    }
                } else {
                    ((ChromaKeyVideoView)((Object)onVideoStartedListener)).state = PlayerState.STARTED;
                    mediaPlayer.start();
                }
            } else {
                mediaPlayer.start();
                ((ChromaKeyVideoView)((Object)onVideoStartedListener)).state = PlayerState.STARTED;
                OnVideoStartedListener onVideoStartedListener = ((ChromaKeyVideoView)((Object)onVideoStartedListener)).onVideoStartedListener;
                if (onVideoStartedListener != null) {
                    onVideoStartedListener.onVideoStarted();
                }
            }
        }
    }

    public final void pause() {
        if (this.state == PlayerState.STARTED) {
            MediaPlayer mediaPlayer = this.mediaPlayer;
            if (mediaPlayer != null) {
                mediaPlayer.pause();
            }
            this.state = PlayerState.PAUSED;
        }
    }

    public final void stop() {
        PlayerState playerState = this.state;
        if (playerState == PlayerState.STARTED || playerState == PlayerState.PAUSED) {
            playerState = this.mediaPlayer;
            if (playerState != null) {
                playerState.stop();
            }
            this.state = PlayerState.STOPPED;
        }
    }

    public final void reset() {
        PlayerState playerState = this.state;
        if (playerState == PlayerState.STARTED || playerState == PlayerState.PAUSED || playerState == PlayerState.STOPPED) {
            playerState = this.mediaPlayer;
            if (playerState != null) {
                playerState.reset();
            }
            this.state = PlayerState.NOT_PREPARED;
        }
    }

    public final void release() {
        MediaPlayer mediaPlayer = this.mediaPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.release();
        }
        this.state = PlayerState.RELEASE;
    }

    public final void setOnVideoStartedListener(@Nullable OnVideoStartedListener onVideoStartedListener) {
        this.onVideoStartedListener = onVideoStartedListener;
    }

    public final void setOnVideoEndedListener(@Nullable OnVideoEndedListener onVideoEndedListener) {
        this.onVideoEndedListener = onVideoEndedListener;
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int n) {
        Map<Integer, View> map2 = this._$_findViewCache;
        View view2 = map2.get(n);
        if (view2 == null) {
            view2 = this.findViewById(n);
            if (view2 == null) {
                view2 = null;
            } else {
                map2.put(n, view2);
            }
        }
        return view2;
    }

    public static interface OnVideoStartedListener {
        public void onVideoStarted();
    }

    public static interface OnVideoEndedListener {
        public void onVideoEnded();
    }

    private static enum PlayerState {
        NOT_PREPARED,
        PREPARED,
        STARTED,
        PAUSED,
        STOPPED,
        RELEASE;

    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlayerState.values().length];
            nArray[PlayerState.PREPARED.ordinal()] = 1;
            nArray[PlayerState.PAUSED.ordinal()] = 2;
            nArray[PlayerState.STOPPED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

