/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views.tools;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.math.MathUtils;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;
import androidx.viewpager2.widget.ViewPager2;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.common.views.tools.SwipeSheetBehavior;
import io.streamlayer.sdk.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SwipeSheetBehavior<V extends View>
extends BottomSheetBehavior<V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "SheetBehavior";
    private static final float HIDE_THRESHOLD = 0.5f;
    private static final float HIDE_FRICTION = 0.1f;
    private float mMaximumVelocity;
    private int mPeekWidth;
    private int mMinOffset;
    private int mMaxOffset;
    private boolean mHideable;
    private boolean mSkipCollapsed;
    private int mState;
    private int oldState;
    @Nullable
    private ViewDragHelper mViewDragHelper;
    private boolean mIgnoreEvents;
    private int mLastNestedScrollDx;
    private boolean mNestedScrolled;
    private int mParentWidth;
    private int mParentHeight;
    @Nullable
    private WeakReference<View> mViewRef;
    @Nullable
    private WeakReference<View> mNestedScrollingChildRef;
    @NotNull
    private final List<BottomSheetBehavior.BottomSheetCallback> callbacks;
    @Nullable
    private VelocityTracker mVelocityTracker;
    private int mActivePointerId;
    private int mInitialX;
    private boolean mTouchingScrollingChild;
    private boolean isStartSide;
    private final int offSetDefault;
    @NotNull
    private final Set<Integer> idViewsIgnore;
    @NotNull
    private final ViewDragHelper.Callback mDragCallback;

    @JvmOverloads
    public SwipeSheetBehavior(@NotNull Context context, @Nullable AttributeSet object) {
        AttributeSet attributeSet = object;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, object);
        this.mState = 4;
        this.oldState = 4;
        this.callbacks = new ArrayList<BottomSheetBehavior.BottomSheetCallback>();
        this.offSetDefault = ViewExtensionsKt.getDp(20.0f);
        this.idViewsIgnore = new LinkedHashSet<Integer>();
        this.mDragCallback = new ViewDragHelper.Callback(this){
            final /* synthetic */ SwipeSheetBehavior<V> this$0;
            {
                this.this$0 = swipeSheetBehavior;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean tryCaptureView(@NotNull View view2, int n) {
                Intrinsics.checkNotNullParameter((Object)view2, (String)"child");
                if (SwipeSheetBehavior.access$getMState$p(this.this$0) == 1) {
                    return false;
                }
                if (SwipeSheetBehavior.access$getMTouchingScrollingChild$p(this.this$0)) {
                    return false;
                }
                if (SwipeSheetBehavior.access$getMState$p(this.this$0) == 3 && SwipeSheetBehavior.access$getMActivePointerId$p(this.this$0) == n) {
                    void var2_6;
                    WeakReference weakReference = SwipeSheetBehavior.access$getMNestedScrollingChildRef$p(this.this$0);
                    if (weakReference == null) {
                        Object var2_4 = null;
                    } else {
                        View view3 = (View)weakReference.get();
                    }
                    if (var2_6 != null && var2_6.canScrollHorizontally(-1)) {
                        return false;
                    }
                }
                if (SwipeSheetBehavior.access$getMViewRef$p(this.this$0) == null) return false;
                WeakReference weakReference = SwipeSheetBehavior.access$getMViewRef$p(this.this$0);
                Intrinsics.checkNotNull((Object)weakReference);
                if (weakReference.get() != view2) return false;
                return true;
            }

            public void onViewPositionChanged(@NotNull View view2, int n, int n2, int n3, int n4) {
                Intrinsics.checkNotNullParameter((Object)view2, (String)"changedView");
                SwipeSheetBehavior.access$dispatchOnSlide(this.this$0, n);
            }

            public void onViewDragStateChanged(int n) {
                if (n == 1) {
                    SwipeSheetBehavior.access$setStateInternal(this.this$0, 1);
                }
            }

            public void onViewReleased(@NotNull View view2, float f, float f2) {
                float f3;
                int n;
                Intrinsics.checkNotNullParameter((Object)view2, (String)"releasedChild");
                if (f > 0.0f && SwipeSheetBehavior.access$isStartSide$p(this.this$0)) {
                    n = SwipeSheetBehavior.access$getMMaxOffset$p(this.this$0);
                    f3 = 3;
                } else {
                    float f4 = f - 0.0f;
                    f3 = f4 == 0.0f ? 0 : (f4 < 0.0f ? -1 : 1);
                    if (f3 < 0 && !SwipeSheetBehavior.access$isStartSide$p(this.this$0)) {
                        f3 = 3;
                        n = 0;
                    } else if (SwipeSheetBehavior.access$getMHideable$p(this.this$0) && SwipeSheetBehavior.access$shouldHide(this.this$0, view2, f)) {
                        WeakReference weakReference = SwipeSheetBehavior.access$getMViewRef$p(this.this$0);
                        Intrinsics.checkNotNull((Object)weakReference);
                        T t = weakReference.get();
                        Intrinsics.checkNotNull(t);
                        n = -((View)t).getWidth();
                        f3 = 5;
                    } else if (f3 == false) {
                        n = view2.getLeft();
                        if (SwipeSheetBehavior.access$isStartSide$p(this.this$0) && Math.abs(n - SwipeSheetBehavior.access$getMMinOffset$p(this.this$0)) > Math.abs(n - SwipeSheetBehavior.access$getMMaxOffset$p(this.this$0)) || !SwipeSheetBehavior.access$isStartSide$p(this.this$0) && Math.abs(n - SwipeSheetBehavior.access$getMMinOffset$p(this.this$0)) < Math.abs(n - SwipeSheetBehavior.access$getMMaxOffset$p(this.this$0))) {
                            n = SwipeSheetBehavior.access$isStartSide$p(this.this$0) ? SwipeSheetBehavior.access$getMMaxOffset$p(this.this$0) : 0;
                            f3 = 3;
                        } else {
                            n = SwipeSheetBehavior.access$getMMinOffset$p(this.this$0);
                            f3 = 4;
                        }
                    } else {
                        n = SwipeSheetBehavior.access$isStartSide$p(this.this$0) ? SwipeSheetBehavior.access$getMMinOffset$p(this.this$0) : SwipeSheetBehavior.access$getMMaxOffset$p(this.this$0);
                        f3 = 4;
                    }
                }
                ViewDragHelper viewDragHelper = SwipeSheetBehavior.access$getMViewDragHelper$p(this.this$0);
                Intrinsics.checkNotNull((Object)viewDragHelper);
                if (viewDragHelper.settleCapturedViewAt(n, view2.getTop())) {
                    SwipeSheetBehavior.access$setStateInternal(this.this$0, 2);
                    ViewCompat.postOnAnimation((View)view2, (Runnable)this.this$0.new SettleRunnable(view2, (int)f3, false, 4, null));
                } else {
                    SwipeSheetBehavior.access$setStateInternal(this.this$0, (int)f3);
                }
            }

            public int clampViewPositionVertical(@NotNull View view2, int n, int n2) {
                View view3 = view2;
                Intrinsics.checkNotNullParameter((Object)view3, (String)"child");
                return view3.getTop();
            }

            public int clampViewPositionHorizontal(@NotNull View view2, int n, int n2) {
                int n3;
                Intrinsics.checkNotNullParameter((Object)view2, (String)"child");
                if (SwipeSheetBehavior.access$isStartSide$p(this.this$0)) {
                    int n4 = SwipeSheetBehavior.access$getMHideable$p(this.this$0) ? -view2.getWidth() : SwipeSheetBehavior.access$getMMinOffset$p(this.this$0);
                    n3 = MathUtils.clamp((int)n, (int)n4, (int)SwipeSheetBehavior.access$getMMaxOffset$p(this.this$0));
                } else {
                    mDragCallback.1 v1 = this;
                    int n5 = v1.this$0.getExpandedOffset();
                    int n6 = SwipeSheetBehavior.access$getMHideable$p(v1.this$0) ? SwipeSheetBehavior.access$getMParentWidth$p(this.this$0) : SwipeSheetBehavior.access$getMMaxOffset$p(this.this$0);
                    n3 = MathUtils.clamp((int)n, (int)n5, (int)n6);
                }
                return n3;
            }

            public int getViewHorizontalDragRange(@NotNull View view2) {
                Intrinsics.checkNotNullParameter((Object)view2, (String)"child");
                return SwipeSheetBehavior.access$getMHideable$p(this.this$0) ? view2.getWidth() : (SwipeSheetBehavior.access$isStartSide$p(this.this$0) ? SwipeSheetBehavior.access$getMMaxOffset$p(this.this$0) - SwipeSheetBehavior.access$getMMinOffset$p(this.this$0) : this.this$0.getExpandedOffset());
            }
        };
        object = R.styleable.BottomSheetBehavior_Layout;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.BottomSheetBehavior_Layout, (String)"BottomSheetBehavior_Layout");
        Object object2 = object = context.obtainStyledAttributes(attributeSet, (int[])object, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"obtainStyledAttributes(s\u2026efStyleAttr, defStyleRes)");
        this.setPeekWidth(object2.getDimensionPixelSize(R.styleable.BottomSheetBehavior_Layout_behavior_peekHeight, 0));
        this.setHideable(object.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_hideable, false));
        this.setSkipCollapsed(object.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_skipCollapsed, false));
        this.mMaximumVelocity = ViewConfiguration.get((Context)context).getScaledMaximumFlingVelocity();
        object.recycle();
    }

    public /* synthetic */ SwipeSheetBehavior(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    private static /* synthetic */ void getMState$annotations() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setStateInternal(int n) {
        if (n == 3 || n == 4) {
            this.oldState = n;
        }
        if (this.mState == n) {
            return;
        }
        this.mState = n;
        WeakReference<View> weakReference = this.mViewRef;
        Intrinsics.checkNotNull(weakReference);
        View view2 = (View)weakReference.get();
        if (view2 != null) {
            int n2 = 0;
            int n3 = this.callbacks.size();
            while (n2 < n3) {
                int n4;
                block7: {
                    n4 = n2 + 1;
                    try {
                        // empty try
                    }
                    catch (Throwable throwable) {
                        Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        break block7;
                    }
                    {
                        this.callbacks.get(n2).onStateChanged(view2, n);
                        Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                }
                n2 = n4;
            }
        }
    }

    private final void reset() {
        this.mActivePointerId = -1;
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
        }
        this.mVelocityTracker = null;
    }

    private final boolean shouldHide(View view2, float f) {
        if (view2.getLeft() > this.mMinOffset && this.isStartSide) {
            return false;
        }
        if (view2.getLeft() < this.mMinOffset && !this.isStartSide) {
            return false;
        }
        return Math.abs((float)view2.getLeft() + f * 0.1f - (float)this.mMinOffset) / (float)this.mPeekWidth > 0.5f;
    }

    private final View findScrollingChild(View view2) {
        if (view2 instanceof NestedScrollingChild) {
            return view2;
        }
        if (view2 instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view2;
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view3 = viewGroup.getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"group.getChildAt(i)");
                view3 = this.findScrollingChild(view3);
                if (view3 == null) continue;
                return view3;
            }
        }
        return null;
    }

    private final boolean hasViewPager(View view2) {
        if (view2 instanceof ViewPager2) {
            return true;
        }
        if (view2 instanceof ViewGroup) {
            int n = 0;
            ViewGroup viewGroup = (ViewGroup)view2;
            int n2 = viewGroup.getChildCount();
            while (n < n2) {
                View view3 = viewGroup.getChildAt(n++);
                Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"view.getChildAt(i)");
                if (!this.hasViewPager(view3)) continue;
                return true;
            }
        }
        return false;
    }

    private final float getXVelocity() {
        SwipeSheetBehavior swipeSheetBehavior = this;
        VelocityTracker velocityTracker = swipeSheetBehavior.mVelocityTracker;
        Intrinsics.checkNotNull((Object)velocityTracker);
        velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
        VelocityTracker velocityTracker2 = swipeSheetBehavior.mVelocityTracker;
        Intrinsics.checkNotNull((Object)velocityTracker2);
        return velocityTracker2.getXVelocity(this.mActivePointerId);
    }

    private final void dispatchOnSlide(int n) {
        Object object = this.mViewRef;
        object = object == null ? null : (View)object.get();
        if (object != null && this.callbacks.isEmpty() ^ true) {
            int n2 = 0;
            int n3 = this.callbacks.size();
            while (n2 < n3) {
                int n4 = n2 + 1;
                if (n < this.mMinOffset) {
                    this.callbacks.get(n2).onSlide(object, (float)(n - this.mMinOffset) / (float)this.mPeekWidth);
                } else {
                    n2 = this.mMinOffset;
                    this.callbacks.get(n2).onSlide(object, (float)(n - n2) / (float)(this.mMaxOffset - n2));
                }
                n2 = n4;
            }
        }
    }

    @JvmOverloads
    public SwipeSheetBehavior(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    public static final /* synthetic */ ViewDragHelper access$getMViewDragHelper$p(SwipeSheetBehavior swipeSheetBehavior) {
        return swipeSheetBehavior.mViewDragHelper;
    }

    public static final /* synthetic */ void access$setStateInternal(SwipeSheetBehavior swipeSheetBehavior, int n) {
        swipeSheetBehavior.setStateInternal(n);
    }

    public static final /* synthetic */ int access$getMState$p(SwipeSheetBehavior swipeSheetBehavior) {
        return swipeSheetBehavior.mState;
    }

    public static final /* synthetic */ boolean access$getMTouchingScrollingChild$p(SwipeSheetBehavior swipeSheetBehavior) {
        return swipeSheetBehavior.mTouchingScrollingChild;
    }

    public static final /* synthetic */ int access$getMActivePointerId$p(SwipeSheetBehavior swipeSheetBehavior) {
        return swipeSheetBehavior.mActivePointerId;
    }

    public static final /* synthetic */ WeakReference access$getMNestedScrollingChildRef$p(SwipeSheetBehavior swipeSheetBehavior) {
        return swipeSheetBehavior.mNestedScrollingChildRef;
    }

    public static final /* synthetic */ WeakReference access$getMViewRef$p(SwipeSheetBehavior swipeSheetBehavior) {
        return swipeSheetBehavior.mViewRef;
    }

    public static final /* synthetic */ void access$dispatchOnSlide(SwipeSheetBehavior swipeSheetBehavior, int n) {
        swipeSheetBehavior.dispatchOnSlide(n);
    }

    public static final /* synthetic */ boolean access$isStartSide$p(SwipeSheetBehavior swipeSheetBehavior) {
        return swipeSheetBehavior.isStartSide;
    }

    public static final /* synthetic */ int access$getMMaxOffset$p(SwipeSheetBehavior swipeSheetBehavior) {
        return swipeSheetBehavior.mMaxOffset;
    }

    public static final /* synthetic */ boolean access$getMHideable$p(SwipeSheetBehavior swipeSheetBehavior) {
        return swipeSheetBehavior.mHideable;
    }

    public static final /* synthetic */ boolean access$shouldHide(SwipeSheetBehavior swipeSheetBehavior, View view2, float f) {
        return swipeSheetBehavior.shouldHide(view2, f);
    }

    public static final /* synthetic */ int access$getMMinOffset$p(SwipeSheetBehavior swipeSheetBehavior) {
        return swipeSheetBehavior.mMinOffset;
    }

    public static final /* synthetic */ int access$getMParentWidth$p(SwipeSheetBehavior swipeSheetBehavior) {
        return swipeSheetBehavior.mParentWidth;
    }

    public final void addViewIdsIgnore(@NotNull List<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.idViewsIgnore.addAll(list);
    }

    public final void setSide(boolean bl) {
        this.isStartSide = bl;
    }

    public boolean onLayoutChild(@NotNull CoordinatorLayout object, V object2, int n) {
        CoordinatorLayout coordinatorLayout = object;
        Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"parent");
        if (ViewCompat.getFitsSystemWindows((View)coordinatorLayout)) {
            if (object2 != null) {
                if (!ViewCompat.getFitsSystemWindows(object2)) {
                    object2.setFitsSystemWindows(true);
                }
            } else {
                throw new NullPointerException("null cannot be cast to non-null type android.view.View");
            }
        }
        CoordinatorLayout coordinatorLayout2 = object;
        V v = object2;
        Intrinsics.checkNotNull(v);
        int n2 = v.getLeft();
        coordinatorLayout2.onLayoutChild(v, n);
        this.mParentWidth = coordinatorLayout2.getWidth();
        this.mParentHeight = object.getHeight();
        if (this.isStartSide) {
            SwipeSheetBehavior swipeSheetBehavior = this;
            swipeSheetBehavior.mMinOffset = Math.max(-object2.getWidth(), -(object2.getWidth() - this.mPeekWidth)) - this.offSetDefault;
            swipeSheetBehavior.mMaxOffset = 0;
        } else {
            n = this.mParentWidth;
            this.mMinOffset = n - this.mPeekWidth + this.offSetDefault;
            this.mMaxOffset = Math.max(n - this.getPeekWidth(), Math.max(0, this.mParentWidth - object2.getWidth())) + this.offSetDefault;
        }
        n = this.mState;
        if (n == 3) {
            n = this.isStartSide ? this.mMaxOffset : 0;
            ViewCompat.offsetLeftAndRight(object2, (int)n);
        } else if (this.mHideable && n == 5) {
            n = this.isStartSide ? -object2.getWidth() : this.mParentWidth;
            ViewCompat.offsetLeftAndRight(object2, (int)n);
        } else if (n == 4) {
            ViewCompat.offsetLeftAndRight(object2, (int)this.mMinOffset);
        } else if (n == 1 || n == 2) {
            ViewCompat.offsetLeftAndRight(object2, (int)(n2 - object2.getLeft()));
        }
        if (this.mViewDragHelper == null) {
            this.mViewDragHelper = ViewDragHelper.create((ViewGroup)object, (ViewDragHelper.Callback)this.mDragCallback);
        }
        this.mViewRef = new WeakReference<V>(object2);
        object2 = this.hasViewPager((View)object2) ? this.findScrollingChild((View)object2) : null;
        this.mNestedScrollingChildRef = object = new WeakReference(object2);
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onInterceptTouchEvent(@NotNull CoordinatorLayout coordinatorLayout, V object, @NotNull MotionEvent motionEvent) {
        void var3_8;
        Object object2 = object;
        Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)var3_8, (String)"event");
        Intrinsics.checkNotNull(object2);
        if (!object2.isShown()) {
            return false;
        }
        int n = var3_8.getActionMasked();
        if (n == 0) {
            this.reset();
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        if (object instanceof ViewGroup && this.idViewsIgnore.isEmpty() ^ true) {
            void v1 = var3_8;
            float f = v1.getX();
            float f2 = v1.getY();
            Iterator iterator = this.idViewsIgnore.iterator();
            while (iterator.hasNext()) {
                View view2 = coordinatorLayout.findViewById(((Number)iterator.next()).intValue());
                if (view2 == null) continue;
                int[] nArray = new int[2];
                view2.getLocationOnScreen(nArray);
                int n2 = nArray[0];
                int n3 = nArray[1];
                int n4 = n2;
                int n5 = n2 + view2.getWidth();
                n2 = n3 + view2.getHeight();
                if (f > (float)n4 && f < (float)n5 && f2 > (float)n3) {
                    if (f2 < (float)n2) return false;
                }
                if (var3_8.getAction() != 3) continue;
                return false;
            }
        }
        VelocityTracker velocityTracker = this.mVelocityTracker;
        Intrinsics.checkNotNull((Object)velocityTracker);
        velocityTracker.addMovement((MotionEvent)var3_8);
        if (n != 0) {
            if (n == 1 || n == 3) {
                this.mTouchingScrollingChild = false;
                this.mActivePointerId = -1;
                if (this.mIgnoreEvents) {
                    this.mIgnoreEvents = false;
                    return false;
                }
            }
        } else {
            void var2_6;
            void v5 = var3_8;
            int n6 = (int)v5.getY();
            this.mInitialX = (int)v5.getX();
            WeakReference<View> weakReference = this.mNestedScrollingChildRef;
            Intrinsics.checkNotNull(weakReference);
            View view3 = (View)weakReference.get();
            if (view3 != null && coordinatorLayout.isPointInChildBounds(view3, this.mInitialX, n6)) {
                SwipeSheetBehavior swipeSheetBehavior = this;
                void v8 = var3_8;
                swipeSheetBehavior.mActivePointerId = v8.getPointerId(v8.getActionIndex());
                swipeSheetBehavior.mTouchingScrollingChild = true;
            }
            if (this.mActivePointerId == -1 && !coordinatorLayout.isPointInChildBounds(object, this.mInitialX, n6)) {
                boolean bl = true;
            } else {
                boolean bl = false;
            }
            this.mIgnoreEvents = var2_6;
        }
        if (!this.mIgnoreEvents) {
            ViewDragHelper viewDragHelper = this.mViewDragHelper;
            Intrinsics.checkNotNull((Object)viewDragHelper);
            if (viewDragHelper.shouldInterceptTouchEvent((MotionEvent)var3_8)) {
                return true;
            }
        }
        WeakReference<View> weakReference = this.mNestedScrollingChildRef;
        Intrinsics.checkNotNull(weakReference);
        View view4 = (View)weakReference.get();
        if (n != 2) return false;
        if (view4 == null) return false;
        if (this.mIgnoreEvents) return false;
        if (this.mState == 1) return false;
        void v11 = var3_8;
        int n7 = (int)v11.getX();
        if (coordinatorLayout.isPointInChildBounds(view4, n7, (int)v11.getY())) return false;
        float f = Math.abs((float)this.mInitialX - var3_8.getX());
        ViewDragHelper viewDragHelper = this.mViewDragHelper;
        Intrinsics.checkNotNull((Object)viewDragHelper);
        if (!(f > (float)viewDragHelper.getTouchSlop())) return false;
        return true;
    }

    public boolean onTouchEvent(@NotNull CoordinatorLayout coordinatorLayout, V v, @NotNull MotionEvent motionEvent) {
        V v2 = v;
        Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)motionEvent, (String)"event");
        Intrinsics.checkNotNull(v2);
        if (!v2.isShown()) {
            return false;
        }
        int n = motionEvent.getActionMasked();
        if (this.mState == 1 && n == 0) {
            return true;
        }
        ViewDragHelper viewDragHelper = this.mViewDragHelper;
        if (viewDragHelper != null) {
            ViewDragHelper viewDragHelper2 = viewDragHelper;
            Intrinsics.checkNotNull((Object)viewDragHelper2);
            viewDragHelper2.processTouchEvent(motionEvent);
            if (n == 0) {
                this.reset();
            }
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            VelocityTracker velocityTracker = this.mVelocityTracker;
            Intrinsics.checkNotNull((Object)velocityTracker);
            velocityTracker.addMovement(motionEvent);
            if (n == 2 && !this.mIgnoreEvents) {
                float f = Math.abs((float)this.mInitialX - motionEvent.getX());
                ViewDragHelper viewDragHelper3 = this.mViewDragHelper;
                Intrinsics.checkNotNull((Object)viewDragHelper3);
                if (f > (float)viewDragHelper3.getTouchSlop()) {
                    ViewDragHelper viewDragHelper4 = this.mViewDragHelper;
                    MotionEvent motionEvent2 = motionEvent;
                    Intrinsics.checkNotNull((Object)viewDragHelper4);
                    viewDragHelper4.captureChildView(v, motionEvent2.getPointerId(motionEvent2.getActionIndex()));
                }
            }
        }
        return this.mIgnoreEvents ^ true;
    }

    public boolean onStartNestedScroll(@NotNull CoordinatorLayout coordinatorLayout, V v, @NotNull View view2, @NotNull View view3, int n) {
        SwipeSheetBehavior swipeSheetBehavior = this;
        Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"coordinatorLayout");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"directTargetChild");
        Intrinsics.checkNotNullParameter((Object)view3, (String)"target");
        swipeSheetBehavior.mLastNestedScrollDx = 0;
        swipeSheetBehavior.mNestedScrolled = false;
        return (n & 2) != 0;
    }

    public void onNestedPreScroll(@NotNull CoordinatorLayout coordinatorLayout, V v, @NotNull View view2, int n, int n2, @NotNull int[] nArray, int n3) {
        Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"coordinatorLayout");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"consumed");
        if (n3 == 1) {
            return;
        }
        WeakReference<View> weakReference = this.mNestedScrollingChildRef;
        Intrinsics.checkNotNull(weakReference);
        if (view2 != (View)weakReference.get()) {
            return;
        }
        V v2 = v;
        Intrinsics.checkNotNull(v2);
        int n4 = v2.getLeft();
        n2 = n4 - n;
        if (n > 0) {
            if (!view2.canScrollHorizontally(1)) {
                int n5 = this.mMinOffset;
                if (n2 < n5 && !this.mHideable) {
                    nArray[1] = n4 - n5;
                    ViewCompat.offsetLeftAndRight(v, (int)(-nArray[1]));
                    this.setStateInternal(4);
                } else {
                    nArray[1] = n;
                    ViewCompat.offsetLeftAndRight(v, (int)(-n));
                    this.setStateInternal(1);
                }
            }
        } else if (n < 0) {
            int n6 = this.mMaxOffset;
            if (n2 < n6) {
                nArray[1] = n;
                ViewCompat.offsetLeftAndRight(v, (int)(-n));
                this.setStateInternal(1);
            } else {
                nArray[1] = n4 - n6;
                ViewCompat.offsetLeftAndRight(v, (int)(-nArray[1]));
                this.setStateInternal(3);
            }
        }
        SwipeSheetBehavior swipeSheetBehavior = this;
        this.dispatchOnSlide(v.getLeft());
        swipeSheetBehavior.mLastNestedScrollDx = n;
        swipeSheetBehavior.mNestedScrolled = true;
    }

    public void onStopNestedScroll(@NotNull CoordinatorLayout coordinatorLayout, V v, @NotNull View view2, int n) {
        V v2 = v;
        Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"coordinatorLayout");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"target");
        Intrinsics.checkNotNull(v2);
        if (v2.getLeft() == this.mMaxOffset) {
            this.setStateInternal(3);
            return;
        }
        WeakReference<View> weakReference = this.mNestedScrollingChildRef;
        Intrinsics.checkNotNull(weakReference);
        if (view2 == weakReference.get() && this.mNestedScrolled) {
            int n2;
            int n3 = this.mLastNestedScrollDx;
            if (n3 > 0) {
                if (this.isFitToContents()) {
                    n3 = this.mMaxOffset;
                    n2 = 3;
                } else {
                    n3 = this.mMaxOffset;
                    if (v.getLeft() > n3) {
                        n2 = 6;
                    } else {
                        n3 = this.mMinOffset;
                        n2 = 3;
                    }
                }
            } else if (n3 < 0) {
                n3 = this.mMaxOffset;
                n2 = 3;
            } else if (this.mHideable && this.shouldHide((View)v, this.getXVelocity())) {
                n3 = -v.getWidth();
                n2 = 5;
            } else if (this.mLastNestedScrollDx == 0) {
                n3 = 0;
                n2 = 3;
            } else {
                n3 = this.mMinOffset;
                n2 = 4;
            }
            ViewDragHelper viewDragHelper = this.mViewDragHelper;
            V v3 = v;
            Intrinsics.checkNotNull((Object)viewDragHelper);
            if (viewDragHelper.smoothSlideViewTo(v3, n3, v3.getTop())) {
                SettleRunnable settleRunnable;
                this.setStateInternal(2);
                SettleRunnable settleRunnable2 = settleRunnable;
                settleRunnable = new SettleRunnable((View)v, n2, false, 4, null);
                ViewCompat.postOnAnimation(v, (Runnable)settleRunnable2);
            } else {
                this.setStateInternal(n2);
            }
            this.mNestedScrolled = false;
            return;
        }
    }

    public boolean onNestedPreFling(@NotNull CoordinatorLayout coordinatorLayout, V v, @NotNull View view2, float f, float f2) {
        Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"coordinatorLayout");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"target");
        WeakReference<View> weakReference = this.mNestedScrollingChildRef;
        Intrinsics.checkNotNull(weakReference);
        return view2 == weakReference.get() && (this.mState != 3 || super.onNestedPreFling(coordinatorLayout, v, view2, f, f2));
    }

    public final int getPeekWidth() {
        return this.mPeekWidth;
    }

    public final void setPeekWidth(int n) {
        this.mPeekWidth = Math.max(0, n);
        WeakReference<View> weakReference = this.mViewRef;
        if (weakReference != null && (weakReference == null ? null : (View)weakReference.get()) != null) {
            WeakReference<View> weakReference2 = this.mViewRef;
            Intrinsics.checkNotNull(weakReference2);
            Object t = weakReference2.get();
            Intrinsics.checkNotNull(t);
            int n2 = -((View)t).getWidth();
            WeakReference<View> weakReference3 = this.mViewRef;
            Intrinsics.checkNotNull(weakReference3);
            Object t2 = weakReference3.get();
            Intrinsics.checkNotNull(t2);
            this.mMinOffset = Math.max(n2, -(((View)t2).getWidth() - this.mPeekWidth));
        }
    }

    public boolean isHideable() {
        return this.mHideable;
    }

    public void setHideable(boolean bl) {
        this.mHideable = bl;
    }

    public boolean getSkipCollapsed() {
        return this.mSkipCollapsed;
    }

    public void setSkipCollapsed(boolean bl) {
        this.mSkipCollapsed = bl;
    }

    @Deprecated(message="use {@link #addBottomSheetCallback(BottomSheetCallback)} and {@link\n     * #removeBottomSheetCallback(BottomSheetCallback)} instead")
    public void setBottomSheetCallback(@Nullable BottomSheetBehavior.BottomSheetCallback bottomSheetCallback2) {
        SLRLog.INSTANCE.d(TAG, "BottomSheetBehavior now supports multiple callbacks. `setBottomSheetCallback()` removes all existing callbacks, including ones set internally by library authors, which may result in unintended behavior. This may change in the future. Please use `addBottomSheetCallback()` and `removeBottomSheetCallback()` instead to set your own callbacks.");
        this.callbacks.clear();
        if (bottomSheetCallback2 != null) {
            this.callbacks.add(bottomSheetCallback2);
        }
    }

    public void addBottomSheetCallback(@NotNull BottomSheetBehavior.BottomSheetCallback bottomSheetCallback2) {
        Intrinsics.checkNotNullParameter((Object)bottomSheetCallback2, (String)"callback");
        if (!this.callbacks.contains(bottomSheetCallback2)) {
            this.callbacks.add(bottomSheetCallback2);
        }
    }

    public void removeBottomSheetCallback(@NotNull BottomSheetBehavior.BottomSheetCallback bottomSheetCallback2) {
        Intrinsics.checkNotNullParameter((Object)bottomSheetCallback2, (String)"callback");
        this.callbacks.remove(bottomSheetCallback2);
    }

    public int getState() {
        return this.mState;
    }

    public void setState(int n) {
        block11: {
            int n2;
            Object object;
            block9: {
                block10: {
                    block8: {
                        SwipeSheetBehavior swipeSheetBehavior = this;
                        super.setState(n);
                        if (n == swipeSheetBehavior.mState) {
                            return;
                        }
                        object = this.mViewRef;
                        if (object == null) {
                            if (n == 4 || n == 3 || this.mHideable && n == 5) {
                                this.mState = n;
                            }
                            return;
                        }
                        if ((object = object == null ? null : (View)object.get()) == null) {
                            return;
                        }
                        if (n != 4) break block8;
                        n2 = this.mMinOffset;
                        break block9;
                    }
                    if (n != 3) break block10;
                    n2 = this.isStartSide ? this.mMaxOffset : 0;
                    break block9;
                }
                if (!this.mHideable || n != 5) break block11;
                n2 = this.isStartSide ? -object.getWidth() : this.mMaxOffset;
            }
            SwipeSheetBehavior swipeSheetBehavior = this;
            swipeSheetBehavior.setStateInternal(2);
            ViewDragHelper viewDragHelper = swipeSheetBehavior.mViewDragHelper;
            View view2 = object;
            Intrinsics.checkNotNull((Object)viewDragHelper);
            if (viewDragHelper.smoothSlideViewTo(view2, n2, view2.getTop())) {
                SettleRunnable settleRunnable;
                SettleRunnable settleRunnable2 = settleRunnable;
                settleRunnable = new SettleRunnable((View)object, n, false, 4, null);
                ViewCompat.postOnAnimation((View)object, (Runnable)settleRunnable2);
            }
            return;
        }
        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Illegal state argument: ", (Object)n));
    }

    private final class SettleRunnable
    implements Runnable {
        @NotNull
        private final View mView;
        private int mTargetState;
        private boolean isPosted;

        public SettleRunnable(View view2, int n, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)((Object)SwipeSheetBehavior.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"mView");
            this.mView = view2;
            this.mTargetState = n;
            this.isPosted = bl;
        }

        public /* synthetic */ SettleRunnable(View view2, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            this(view2, n, bl);
        }

        public final int getMTargetState() {
            return this.mTargetState;
        }

        public final void setMTargetState(int n) {
            this.mTargetState = n;
        }

        public final boolean isPosted() {
            return this.isPosted;
        }

        public final void setPosted(boolean bl) {
            this.isPosted = bl;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (SwipeSheetBehavior.access$getMViewDragHelper$p(SwipeSheetBehavior.this) == null) ** GOTO lbl-1000
            v0 = SwipeSheetBehavior.access$getMViewDragHelper$p(SwipeSheetBehavior.this);
            Intrinsics.checkNotNull((Object)v0);
            if (v0.continueSettling(true)) {
                ViewCompat.postOnAnimation((View)this.mView, (Runnable)this);
            } else lbl-1000:
            // 2 sources

            {
                SwipeSheetBehavior.access$setStateInternal(SwipeSheetBehavior.this, this.mTargetState);
            }
            this.isPosted = false;
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @NotNull
        public final <V extends View> SwipeSheetBehavior<V> from(@NotNull V v) {
            V v2 = v;
            Intrinsics.checkNotNullParameter(v2, (String)"view");
            Companion companion = v2.getLayoutParams();
            if (companion instanceof CoordinatorLayout.LayoutParams) {
                if ((companion = ((CoordinatorLayout.LayoutParams)companion).getBehavior()) instanceof SwipeSheetBehavior) {
                    if (companion != null) {
                        return (SwipeSheetBehavior)((Object)companion);
                    }
                    throw new NullPointerException("null cannot be cast to non-null type io.streamlayer.common.views.tools.SwipeSheetBehavior<V of io.streamlayer.common.views.tools.SwipeSheetBehavior.Companion.from>");
                }
                throw new IllegalArgumentException("The view is not associated with SwipeSheetBehavior".toString());
            }
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout".toString());
        }
    }
}

