/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views.tooltips;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.OneShotPreDrawListener;
import io.streamlayer.common.views.tooltips.BubbleView;
import io.streamlayer.common.views.tooltips.BubbleView$show$;
import io.streamlayer.sdk.R;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BubbleView
extends ConstraintLayout {
    @NotNull
    public Map<Integer, View> _$_findViewCache;
    private int arrowHeight;
    private int arrowWidth;
    private int arrowSourceMargin;
    private int arrowTargetMargin;
    private int color;
    @Nullable
    private Path bubblePath;
    @NotNull
    private Paint bubblePaint;
    @Nullable
    private Paint borderPaint;
    @NotNull
    private Position position;
    @NotNull
    private Animation tooltipAnimation;
    private int corner;
    @Nullable
    private Integer viewCenterX;
    @Nullable
    private Integer viewCenterY;
    private int arrowWidthPosition;
    private int arrowHeightPosition;
    @Nullable
    private View childView;

    @JvmOverloads
    public BubbleView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, n);
        this._$_findViewCache = new LinkedHashMap<Integer, View>();
        this.arrowHeight = 15;
        this.arrowWidth = 15;
        this.color = -1;
        this.position = Position.BOTTOM;
        this.tooltipAnimation = new FadeAnimation();
        this.corner = 30;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.SLRBubbleView, (String)"SLRBubbleView");
        context = context.obtainStyledAttributes(attributeSet, R.styleable.SLRBubbleView, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"obtainStyledAttributes(s\u2026efStyleAttr, defStyleRes)");
        this.setPosition(Position.Companion.parse(context.getInt(R.styleable.SLRBubbleView_slrBubblePosition, Position.NONE.ordinal())));
        this.setArrowWidthPosition(context.getDimensionPixelSize(R.styleable.SLRBubbleView_slrArrowWidthPosition, 0));
        this.setArrowHeightPosition(context.getDimensionPixelSize(R.styleable.SLRBubbleView_slrArrowHeightPosition, 0));
        attributeSet = context.getColorStateList(R.styleable.SLRBubbleView_slrBubbleColor);
        if (attributeSet != null) {
            this.setColor(attributeSet.getDefaultColor());
        }
        BubbleView bubbleView = this;
        this.corner = context.getDimensionPixelSize(R.styleable.SLRBubbleView_slrCornerRadius, 30);
        context.recycle();
        bubbleView.setWillNotDraw(false);
        Context context2 = context = paint;
        super(1);
        this.bubblePaint = context2;
        paint.setColor(this.color);
        bubbleView.bubblePaint.setStyle(Paint.Style.FILL);
        bubbleView.borderPaint = null;
        bubbleView.setLayerType(1, bubbleView.bubblePaint);
    }

    public /* synthetic */ BubbleView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final Path drawBubble(RectF rectF, float f) {
        Position position;
        Position position2;
        Path path;
        Path path2 = path;
        path = new Path();
        if (this.viewCenterX == null || this.viewCenterY == null) {
            BubbleView bubbleView = this;
            bubbleView.viewCenterX = (int)bubbleView.getX() + this.arrowWidthPosition;
            bubbleView.viewCenterY = (int)bubbleView.getY() + this.arrowHeightPosition;
        }
        BubbleView bubbleView = this;
        RectF rectF2 = rectF;
        int n = this.arrowHeight;
        float f2 = rectF2.left + (float)n;
        float f3 = rectF2.top + (float)n;
        float f4 = rectF2.right - (float)n;
        float f5 = rectF2.bottom - (float)n;
        Integer n2 = bubbleView.viewCenterX;
        Intrinsics.checkNotNull((Object)n2);
        float f6 = (float)n2.intValue() - this.getX();
        Integer n3 = bubbleView.viewCenterY;
        Intrinsics.checkNotNull((Object)n3);
        float f7 = (float)n3.intValue() - this.getY();
        Position position3 = Position.TOP;
        Position position4 = Position.BOTTOM;
        float f8 = CollectionsKt.listOf((Object[])new Position[]{position3, position4}).contains((Object)this.position) ? f6 + (float)this.arrowSourceMargin : f6;
        if (CollectionsKt.listOf((Object[])new Position[]{position3, position4}).contains((Object)this.position)) {
            f6 += (float)this.arrowTargetMargin;
        }
        float f9 = CollectionsKt.listOf((Object[])new Position[]{position2 = Position.RIGHT, position = Position.LEFT}).contains((Object)this.position) ? f7 - (float)this.arrowSourceMargin : f5 / 2.0f;
        f7 = CollectionsKt.listOf((Object[])new Position[]{position2, position}).contains((Object)this.position) ? (f7 -= (float)this.arrowTargetMargin) : f5 / 2.0f;
        float f10 = f2 + (f /= 2.0f);
        path2.moveTo(f10, f3);
        if (this.position == position4) {
            path2.lineTo(f8 - (float)this.arrowWidth, f3);
            path2.lineTo(f6, f3 - (float)this.arrowHeight);
            path2.lineTo(f8 + (float)this.arrowWidth, f3);
        }
        float f11 = f4 - f;
        path2.lineTo(f11, f3);
        float f12 = f3 + f;
        path2.quadTo(f4, f3, f4, f12);
        if (this.position == position) {
            path2.lineTo(f4, f9 - (float)this.arrowWidth + (float)this.arrowHeightPosition);
            float f13 = rectF.right;
            path2.lineTo(f13, f7 + (float)this.arrowHeightPosition);
            path2.lineTo(f4, f9 + (float)this.arrowWidth + (float)this.arrowHeightPosition);
        }
        f = f5 - f;
        path2.lineTo(f4, f);
        path2.quadTo(f4, f5, f11, f5);
        if (this.position == position3) {
            path2.lineTo(f8 + (float)this.arrowWidth, f5);
            path2.lineTo(f6, rectF.bottom);
            path2.lineTo(f8 - (float)this.arrowWidth, f5);
        }
        path2.lineTo(f10, f5);
        path2.quadTo(f2, f5, f2, f);
        if (this.position == position2) {
            path2.lineTo(f2, f9 + (float)this.arrowWidth + (float)this.arrowHeightPosition);
            float f14 = rectF.left;
            path2.lineTo(f14, f7 + (float)this.arrowHeightPosition);
            path2.lineTo(f2, f9 - (float)this.arrowWidth + (float)this.arrowHeightPosition);
        }
        Path path3 = path2;
        path3.lineTo(f2, f12);
        path3.quadTo(f2, f3, f10, f3);
        path3.close();
        return path3;
    }

    private final void proceedSetupTargetView(View view2) {
        BubbleView bubbleView = this;
        this.viewCenterX = (view2.getLeft() + view2.getRight()) / 2;
        bubbleView.viewCenterY = (view2.getTop() + view2.getBottom()) / 2;
        bubbleView.bubblePath = bubbleView.drawBubble(bubbleView.getRectFForBubble(), this.corner);
    }

    private final RectF getRectFForBubble() {
        BubbleView bubbleView = this;
        float f = bubbleView.getWidth();
        float f2 = bubbleView.getHeight();
        return new RectF(0.0f, 0.0f, f, f2);
    }

    public static /* synthetic */ void close$default(BubbleView bubbleView, Function0 function0, int n, Object object) {
        if (object == null) {
            if ((n & 1) != 0) {
                function0 = null;
            }
            bubbleView.close((Function0<Unit>)function0);
            return;
        }
        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: close");
    }

    private final void remove(Function0<Unit> function0) {
        Function0<Unit> function02;
        Function0<Unit> function03 = function02;
        function02 = new Function0<Unit>(this, function0){
            final /* synthetic */ BubbleView this$0;
            final /* synthetic */ Function0<Unit> $onAnimationEnd;
            {
                this.this$0 = bubbleView;
                this.$onAnimationEnd = function0;
                super(0);
            }

            public final void invoke() {
                remove.1 v0 = this;
                BubbleView.access$removeNow(v0.this$0);
                v0.$onAnimationEnd.invoke();
            }
        };
        this.startExitAnimation(function03);
    }

    private final void removeNow() {
        if (this.getParent() != null) {
            ViewParent viewParent = this.getParent();
            if (viewParent != null) {
                ((ViewGroup)viewParent).removeView((View)this);
            } else {
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
            }
        }
    }

    private final void startEnterAnimation() {
        this.tooltipAnimation.animateEnter(this);
    }

    private final void startExitAnimation(Function0<Unit> function0) {
        AnimatorListenerAdapter animatorListenerAdapter;
        BubbleView bubbleView = bubbleView2;
        BubbleView bubbleView2 = animatorListenerAdapter;
        animatorListenerAdapter = new AnimatorListenerAdapter(function0){
            final /* synthetic */ Function0<Unit> $onAnimEnd;
            {
                this.$onAnimEnd = function0;
            }

            public void onAnimationEnd(@Nullable Animator animator) {
                Function0<Unit> function0 = function02;
                super.onAnimationEnd(animator);
                Function0<Unit> function02 = function0.$onAnimEnd;
                if (function02 != null) {
                    function02.invoke();
                }
            }
        };
        bubbleView2.tooltipAnimation.animateExit(bubbleView, (Animator.AnimatorListener)bubbleView2);
    }

    public static /* synthetic */ void customView$default(BubbleView bubbleView, View view2, int n, int n2, int n3, Object object) {
        if (object == null) {
            if ((n3 & 2) != 0) {
                n = -2;
            }
            if ((n3 & 4) != 0) {
                n2 = -2;
            }
            bubbleView.customView(view2, n, n2);
            return;
        }
        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: customView");
    }

    public static /* synthetic */ void padding$default(BubbleView bubbleView, int n, int n2, int n3, int n4, int n5, Object object) {
        if (object == null) {
            if ((n5 & 1) != 0) {
                n = 0;
            }
            if ((n5 & 2) != 0) {
                n2 = 0;
            }
            if ((n5 & 4) != 0) {
                n3 = 0;
            }
            if ((n5 & 8) != 0) {
                n4 = 0;
            }
            bubbleView.padding(n, n2, n3, n4);
            return;
        }
        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: padding");
    }

    @JvmOverloads
    public BubbleView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public BubbleView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$removeNow(BubbleView bubbleView) {
        bubbleView.removeNow();
    }

    public static final /* synthetic */ void access$proceedSetupTargetView(BubbleView bubbleView, View view2) {
        bubbleView.proceedSetupTargetView(view2);
    }

    public static final /* synthetic */ void access$startEnterAnimation(BubbleView bubbleView) {
        bubbleView.startEnterAnimation();
    }

    protected final int getArrowHeight() {
        return this.arrowHeight;
    }

    protected final void setArrowHeight(int n) {
        this.arrowHeight = n;
    }

    protected final int getArrowWidth() {
        return this.arrowWidth;
    }

    protected final void setArrowWidth(int n) {
        this.arrowWidth = n;
    }

    protected final int getColor() {
        return this.color;
    }

    protected final void setColor(int n) {
        this.color = n;
    }

    @NotNull
    protected final Position getPosition() {
        return this.position;
    }

    protected final void setPosition(@NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"<set-?>");
        this.position = position;
    }

    @Nullable
    protected final Integer getViewCenterX() {
        return this.viewCenterX;
    }

    protected final void setViewCenterX(@Nullable Integer n) {
        this.viewCenterX = n;
    }

    @Nullable
    protected final Integer getViewCenterY() {
        return this.viewCenterY;
    }

    protected final void setViewCenterY(@Nullable Integer n) {
        this.viewCenterY = n;
    }

    public final int getArrowWidthPosition() {
        return this.arrowWidthPosition;
    }

    public final void setArrowWidthPosition(int n) {
        this.arrowWidthPosition = n;
    }

    public final int getArrowHeightPosition() {
        return this.arrowHeightPosition;
    }

    public final void setArrowHeightPosition(int n) {
        this.arrowHeightPosition = n;
    }

    @Nullable
    public final View getChildView() {
        return this.childView;
    }

    public final void setChildView(@Nullable View view2) {
        this.childView = view2;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        BubbleView bubbleView = this;
        super.onSizeChanged(n, n2, n3, n4);
        bubbleView.bubblePath = bubbleView.drawBubble(bubbleView.getRectFForBubble(), this.corner);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        BubbleView bubbleView = bubbleView2;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        Path path = bubbleView.bubblePath;
        if (path != null) {
            canvas.drawPath(path, bubbleView2.bubblePaint);
            BubbleView bubbleView2 = bubbleView2.borderPaint;
            if (bubbleView2 != null) {
                canvas.drawPath(path, (Paint)bubbleView2);
            }
        }
    }

    public final void show(@NotNull ViewGroup viewGroup, @NotNull View view2, @NotNull Function1<? super BubbleView, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"targetView");
        Intrinsics.checkNotNullParameter(function1, (String)"applyLayoutParams");
        viewGroup.addView((View)this, -2, -2);
        function1.invoke((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)OneShotPreDrawListener.add((View)this, (Runnable)new Runnable((View)this, function1, this, view2){
            final /* synthetic */ View $this_doOnPreDraw;
            final /* synthetic */ Function1 $applyLayoutParams$inlined;
            final /* synthetic */ BubbleView this$0;
            final /* synthetic */ View $targetView$inlined;
            {
                this.$this_doOnPreDraw = view2;
                this.$applyLayoutParams$inlined = function1;
                this.this$0 = bubbleView;
                this.$targetView$inlined = view3;
            }

            public final void run() {
                show$$inlined$doOnPreDraw$1 v0 = this;
                v0.$applyLayoutParams$inlined.invoke((Object)((Object)this.this$0));
                BubbleView.access$proceedSetupTargetView(v0.this$0, this.$targetView$inlined);
                BubbleView.access$startEnterAnimation(v0.this$0);
            }
        }), (String)"View.doOnPreDraw(\n    cr\u2026dd(this) { action(this) }");
    }

    public final void setTargetView(@NotNull View view2) {
        BubbleView bubbleView = this;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"targetView");
        bubbleView.proceedSetupTargetView(view2);
        bubbleView.invalidate();
    }

    public final void setTargetXView(int n) {
        this.viewCenterX = n;
        this.drawBubble();
    }

    public final void drawBubble() {
        BubbleView bubbleView = this;
        bubbleView.bubblePath = bubbleView.drawBubble(bubbleView.getRectFForBubble(), this.corner);
        bubbleView.invalidate();
    }

    public final void close(@Nullable Function0<Unit> function0) {
        Unit unit;
        if (function0 == null) {
            unit = null;
        } else {
            this.remove(function0);
            unit = Unit.INSTANCE;
        }
        if (unit == null) {
            this.removeNow();
        }
    }

    public final void customView(@NotNull View view2, int n, int n2) {
        BubbleView bubbleView = this;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"customView");
        bubbleView.removeView(bubbleView.childView);
        this.childView = view2;
        this.addView(view2, n, n2);
    }

    public final void updateCustomView(@NotNull Function1<? super View, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"update");
        BubbleView bubbleView = bubbleView.childView;
        if (bubbleView != null) {
            function1.invoke((Object)bubbleView);
        }
    }

    public final void color(int n) {
        BubbleView bubbleView = this;
        bubbleView.color = n;
        bubbleView.bubblePaint.setColor(n);
        bubbleView.postInvalidate();
    }

    public final void position(@NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        if (this.position == position) {
            return;
        }
        this.position = position;
        this.postInvalidate();
    }

    public final void padding(int n, int n2, int n3, int n4) {
        BubbleView bubbleView = this;
        bubbleView.setPadding(n, n2, n3, n4);
        bubbleView.postInvalidate();
    }

    public final void arrowHeight(int n) {
        this.arrowHeight = n;
        this.postInvalidate();
    }

    public final void arrowWidth(int n) {
        this.arrowWidth = n;
        this.postInvalidate();
    }

    public final void arrowSourceMargin(int n) {
        this.arrowSourceMargin = n;
        this.postInvalidate();
    }

    public final void arrowTargetMargin(int n) {
        this.arrowTargetMargin = n;
        this.postInvalidate();
    }

    public final void corner(int n) {
        if (n < 0) {
            n = 0;
        }
        this.corner = n;
        this.postInvalidate();
    }

    public final void tooltipAnimation(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"tooltipAnimation");
        this.tooltipAnimation = animation;
    }

    public final void border(int n, float f) {
        Paint paint;
        Paint paint2;
        BubbleView bubbleView = this;
        Paint paint3 = paint2 = paint;
        paint3(1);
        this.borderPaint = paint3;
        Intrinsics.checkNotNull((Object)paint2);
        paint.setColor(n);
        Paint paint4 = bubbleView.borderPaint;
        Intrinsics.checkNotNull((Object)paint4);
        paint4.setStyle(Paint.Style.STROKE);
        Paint paint5 = bubbleView.borderPaint;
        Intrinsics.checkNotNull((Object)paint5);
        paint5.setStrokeWidth(f);
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int n) {
        Map<Integer, View> map2 = this._$_findViewCache;
        View view2 = map2.get(n);
        if (view2 == null) {
            view2 = this.findViewById(n);
            if (view2 == null) {
                view2 = null;
            } else {
                map2.put(n, view2);
            }
        }
        return view2;
    }

    public static enum Position {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        NONE;

        @NotNull
        public static final Companion Companion = new Companion(null);

        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }

            @NotNull
            public final Position parse(int n) {
                Object object = LEFT;
                if (n != ((Enum)object).ordinal() && n != ((Enum)(object = RIGHT)).ordinal() && n != ((Enum)(object = TOP)).ordinal() && n != ((Enum)(object = BOTTOM)).ordinal()) {
                    object = NONE;
                }
                return object;
            }
        }
    }

    public static interface Animation {
        public void animateEnter(@NotNull BubbleView var1);

        public void animateExit(@NotNull BubbleView var1, @NotNull Animator.AnimatorListener var2);
    }

    public static final class FadeAnimation
    implements Animation {
        private long fadeDuration = 400L;

        @Override
        public void animateEnter(@NotNull BubbleView bubbleView) {
            BubbleView bubbleView2 = bubbleView;
            Intrinsics.checkNotNullParameter((Object)((Object)bubbleView2), (String)"view");
            bubbleView2.setAlpha(0.0f);
            bubbleView2.animate().alpha(1.0f).setDuration(this.fadeDuration);
        }

        @Override
        public void animateExit(@NotNull BubbleView bubbleView, @NotNull Animator.AnimatorListener animatorListener) {
            Intrinsics.checkNotNullParameter((Object)((Object)bubbleView), (String)"view");
            Intrinsics.checkNotNullParameter((Object)animatorListener, (String)"animatorListener");
            bubbleView.animate().alpha(0.0f).setDuration(this.fadeDuration).setListener(animatorListener);
        }
    }
}

