/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views.tooltips;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.airbnb.lottie.LottieAnimationView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.views.tooltips.BubbleView;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrTooltipProgressBinding;
import io.streamlayer.sdk.databinding.SlrTooltipViewBinding;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolTipView
extends ConstraintLayout {
    @NotNull
    public Map<Integer, View> _$_findViewCache;
    @NotNull
    private final SlrTooltipProgressBinding binding;
    @NotNull
    private final LottieAnimationView lottie;
    @NotNull
    private final AppCompatTextView title;
    @NotNull
    private final AppCompatButton okBtn;
    @NotNull
    private final BubbleView bubbleView;
    @NotNull
    private final ArrayList<ImageView> dots;
    private int dotsColor;
    private int selectedDotColor;
    private int dotsSize;
    private int dotsSpacing;
    private float dotsCornerRadius;
    private int currentItem;

    @JvmOverloads
    public ToolTipView(@NotNull Context object, @Nullable AttributeSet object2, int n) {
        Context context = object;
        AttributeSet attributeSet = object2;
        Context context2 = object;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, object2, n);
        this._$_findViewCache = new LinkedHashMap<Integer, View>();
        this.dots = new ArrayList();
        this.dotsColor = ContextCompat.getColor((Context)object, (int)R.color.slr_dot_progress);
        this.selectedDotColor = ContextCompat.getColor((Context)object, (int)R.color.slr_white);
        this.dotsSize = ViewExtensionsKt.getDp(8.0f);
        this.dotsSpacing = ViewExtensionsKt.getDp(2.0f);
        this.dotsCornerRadius = (float)this.dotsSize / 2.0f;
        ConstraintLayout.inflate((Context)object, (int)R.layout.slr_tooltip_progress, (ViewGroup)this);
        Object object3 = object2 = SlrTooltipProgressBinding.bind((View)this);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"bind(this)");
        this.binding = object3;
        Object object4 = object = SlrTooltipViewBinding.inflate(LayoutInflater.from((Context)object), (ViewGroup)this, false);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"inflate(LayoutInflater.from(context), this, false)");
        LottieAnimationView lottieAnimationView = ((SlrTooltipViewBinding)object4).slrLottieView;
        Intrinsics.checkNotNullExpressionValue((Object)lottieAnimationView, (String)"view.slrLottieView");
        this.lottie = lottieAnimationView;
        AppCompatTextView appCompatTextView = ((SlrTooltipViewBinding)object).titleTV;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"view.titleTV");
        this.title = appCompatTextView;
        AppCompatButton appCompatButton = ((SlrTooltipViewBinding)object).okBtn;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatButton, (String)"view.okBtn");
        this.okBtn = appCompatButton;
        BubbleView bubbleView = object2.slBubbleView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)bubbleView), (String)"binding.slBubbleView");
        this.bubbleView = bubbleView;
        BubbleView bubbleView2 = object2.slBubbleView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)bubbleView2), (String)"binding.slBubbleView");
        ConstraintLayout constraintLayout = ((SlrTooltipViewBinding)object).getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"view.root");
        BubbleView.customView$default(bubbleView2, (View)constraintLayout, 0, 0, 6, null);
        object2 = R.styleable.SLRToolTipView;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.SLRToolTipView, (String)"SLRToolTipView");
        object2 = context.obtainStyledAttributes(attributeSet, (int[])object2, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"obtainStyledAttributes(s\u2026efStyleAttr, defStyleRes)");
        String string2 = object2.getString(R.styleable.SLRToolTipView_slrAnimation);
        if (string2 != null) {
            ((SlrTooltipViewBinding)object).slrLottieView.setAnimation(string2);
        }
        string2 = object2.getString(R.styleable.SLRToolTipView_slrText);
        if (string2 != null) {
            ((SlrTooltipViewBinding)object).titleTV.setText((CharSequence)string2);
        }
        ToolTipView toolTipView = this;
        int n2 = object2.getResources().getDimensionPixelSize(R.dimen.slr_view_tooltip_arrow_height);
        toolTipView.getBinding().slBubbleView.arrowHeight(n2);
        toolTipView.getBinding().slBubbleView.arrowWidth(n2);
        toolTipView.getBinding().slBubbleView.position(BubbleView.Position.Companion.parse(object2.getInt(R.styleable.SLRToolTipView_slrToolTipPosition, BubbleView.Position.NONE.ordinal())));
        toolTipView.getBinding().slBubbleView.setArrowHeightPosition(object2.getDimensionPixelSize(R.styleable.SLRToolTipView_slrBubbleArrowHeightPosition, 0));
        this.setDots(object2.getInt(R.styleable.SLRToolTipView_slrDotsCount, 0));
        object2.recycle();
    }

    public /* synthetic */ ToolTipView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final void refreshDotsColors() {
        int n = 0;
        int n2 = this.dots.size();
        while (n < n2) {
            int n3 = n + 1;
            this.refreshDotColor(n);
            n = n3;
        }
    }

    @JvmOverloads
    public ToolTipView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public ToolTipView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @NotNull
    public final SlrTooltipProgressBinding getBinding() {
        return this.binding;
    }

    @NotNull
    public final LottieAnimationView getLottie() {
        return this.lottie;
    }

    @NotNull
    public final AppCompatTextView getTitle() {
        return this.title;
    }

    @NotNull
    public final AppCompatButton getOkBtn() {
        return this.okBtn;
    }

    @NotNull
    public final BubbleView getBubbleView() {
        return this.bubbleView;
    }

    @NotNull
    protected final ArrayList<ImageView> getDots() {
        return this.dots;
    }

    protected final int getDotsSize() {
        return this.dotsSize;
    }

    protected final void setDotsSize(int n) {
        this.dotsSize = n;
    }

    protected final int getDotsSpacing() {
        return this.dotsSpacing;
    }

    protected final void setDotsSpacing(int n) {
        this.dotsSpacing = n;
    }

    protected final float getDotsCornerRadius() {
        return this.dotsCornerRadius;
    }

    protected final void setDotsCornerRadius(float f) {
        this.dotsCornerRadius = f;
    }

    public final int getCurrentItem() {
        return this.currentItem;
    }

    public final void setCurrentItem(int n) {
        this.currentItem = n;
        this.refreshDotsColors();
    }

    public final void setDots(int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            this.addDot(n2);
            n2 = n3;
        }
    }

    public final void addDot(int n) {
        ImageView imageView;
        ImageView imageView2;
        RelativeLayout relativeLayout;
        RelativeLayout relativeLayout2 = relativeLayout;
        relativeLayout = new RelativeLayout(this.getContext());
        ImageView imageView3 = imageView2 = imageView;
        imageView3(this.getContext());
        relativeLayout2.addView((View)imageView3);
        ViewGroup.LayoutParams layoutParams = imageView.getLayoutParams();
        if (layoutParams != null) {
            DotsGradientDrawable dotsGradientDrawable;
            int n2;
            ((RelativeLayout.LayoutParams)layoutParams).height = n2 = this.dotsSize;
            ((RelativeLayout.LayoutParams)layoutParams).width = n2;
            int n3 = this.dotsSpacing;
            ((RelativeLayout.LayoutParams)layoutParams).setMargins(n3, 0, n3, 0);
            DotsGradientDrawable dotsGradientDrawable2 = dotsGradientDrawable;
            dotsGradientDrawable2();
            dotsGradientDrawable.setCornerRadius(this.dotsCornerRadius);
            n = this.currentItem == n ? this.selectedDotColor : this.dotsColor;
            ToolTipView toolTipView = this;
            DotsGradientDrawable dotsGradientDrawable3 = dotsGradientDrawable2;
            dotsGradientDrawable3.setColor(n);
            imageView2.setBackground((Drawable)dotsGradientDrawable3);
            toolTipView.dots.add(imageView2);
            toolTipView.binding.slDotContainer.addView((View)relativeLayout2);
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
    }

    public final void refreshDotColor(int n) {
        ImageView imageView = this.dots.get(n);
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"dots[index]");
        ImageView imageView2 = imageView;
        Drawable drawable2 = imageView.getBackground();
        if (drawable2 != null) {
            DotsGradientDrawable dotsGradientDrawable = (DotsGradientDrawable)drawable2;
            if (n == this.currentItem) {
                dotsGradientDrawable.setColor(this.selectedDotColor);
            } else {
                dotsGradientDrawable.setColor(this.dotsColor);
            }
            ImageView imageView3 = imageView2;
            imageView3.setBackground((Drawable)dotsGradientDrawable);
            imageView3.invalidate();
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type io.streamlayer.common.views.tooltips.ToolTipView.DotsGradientDrawable");
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int n) {
        Map<Integer, View> map2 = this._$_findViewCache;
        View view2 = map2.get(n);
        if (view2 == null) {
            view2 = this.findViewById(n);
            if (view2 == null) {
                view2 = null;
            } else {
                map2.put(n, view2);
            }
        }
        return view2;
    }

    private static final class DotsGradientDrawable
    extends GradientDrawable {
        private int currentColor;

        public final int getCurrentColor() {
            return this.currentColor;
        }

        public void setColor(int n) {
            super.setColor(n);
            this.currentColor = n;
        }
    }
}

