/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk;

import android.content.Context;
import android.content.Intent;
import androidx.emoji2.bundled.BundledEmojiCompatConfig;
import androidx.emoji2.text.EmojiCompat;
import androidx.fragment.app.FragmentActivity;
import io.streamlayer.common.data.notifications.NotificationChannelsHelper;
import io.streamlayer.common.data.notifications.PushNotificationsService;
import io.streamlayer.common.dispatcher.CoroutineDispatcherProviderImpl;
import io.streamlayer.common.media.MediaProvider;
import io.streamlayer.common.session.EventSessionProvider;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.common.session.WatchPartySessionProvider;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.common.utils.SLRLogKt;
import io.streamlayer.sdk.EventSession;
import io.streamlayer.sdk.StreamLayer;
import io.streamlayer.sdk.TimeCodeProvider;
import io.streamlayer.sdk.VideoPlayerProvider;
import io.streamlayer.sdk.WatchPartySession;
import io.streamlayer.sdk.deeplink.DeepLinkHandler;
import io.streamlayer.sdk.koin.KoinInjector;
import io.streamlayer.sdk.model.deeplink.InviteData;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;

public final class StreamLayer {
    @NotNull
    public static final StreamLayer INSTANCE = new StreamLayer();
    public static Koin koin;
    @Nullable
    private static AudioDuckingListener audioDuckingListener;
    @Nullable
    private static StreamEventChangeListener streamEventChangeListener;

    private StreamLayer() {
    }

    private final void assertComponent(Context object) {
        block5: {
            Unit unit;
            if (koin != null) break block5;
            Object object2 = assertComponent.throwNotInitialized.1.INSTANCE;
            if (object == null) {
                unit = null;
            } else {
                CoroutineDispatcherProviderImpl coroutineDispatcherProviderImpl;
                SessionPrefImpl sessionPrefImpl;
                SessionPrefImpl sessionPrefImpl2 = sessionPrefImpl;
                CoroutineDispatcherProviderImpl coroutineDispatcherProviderImpl2 = coroutineDispatcherProviderImpl;
                coroutineDispatcherProviderImpl = new CoroutineDispatcherProviderImpl(null, null, null, null, 15, null);
                if (new SessionPrefImpl((Context)object, coroutineDispatcherProviderImpl2).getSdkKey() == null) {
                    object2.invoke();
                    throw new KotlinNothingValueException();
                }
                Context context = object;
                object = sessionPrefImpl2.getSdkKey();
                Intrinsics.checkNotNull((Object)object);
                INSTANCE.initializeApp(context, (String)object);
                unit = Unit.INSTANCE;
            }
            if (unit == null) {
                object2.invoke();
                throw new KotlinNothingValueException();
            }
        }
    }

    static /* synthetic */ void assertComponent$default(StreamLayer streamLayer, Context context, int n, Object object) {
        if ((n & 1) != 0) {
            context = null;
        }
        streamLayer.assertComponent(context);
    }

    @NotNull
    public final Koin getKoin$sdk_originalRelease() {
        StreamLayer streamLayer = koin;
        if (streamLayer != null) {
            return streamLayer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"koin");
        return null;
    }

    public final void setKoin$sdk_originalRelease(@NotNull Koin koin) {
        Koin koin2 = koin;
        Intrinsics.checkNotNullParameter((Object)koin2, (String)"<set-?>");
        StreamLayer.koin = koin2;
    }

    public final void initializeApp(@NotNull Context context, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"sdkKey");
        if (koin != null && Intrinsics.areEqual((Object)((Session)this.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(Session.class), null, null)).getSdkKey(), (Object)string2)) {
            return;
        }
        StreamLayer streamLayer = this;
        streamLayer.setKoin$sdk_originalRelease(KoinInjector.INSTANCE.build(context, string2).getKoin());
        ((Session)streamLayer.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(Session.class), null, null)).setSdkKey(string2);
        EmojiCompat.init((EmojiCompat.Config)new BundledEmojiCompatConfig(context));
        NotificationChannelsHelper.INSTANCE.initChannels(context);
        SLRLogKt.initUncaughtLogger();
    }

    @NotNull
    public final EventSession createEventSession(@NotNull String string2, @Nullable TimeCodeProvider timeCodeProvider) {
        StreamLayer streamLayer = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"eventId");
        StreamLayer.assertComponent$default(streamLayer, null, 1, null);
        return ((EventSessionProvider)streamLayer.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(EventSessionProvider.class), null, null)).createEventSession(string2, timeCodeProvider);
    }

    @Nullable
    public final Object createWatchPartySession(@NotNull String string2, @NotNull Continuation<? super WatchPartySession> continuation) throws RuntimeException {
        StreamLayer streamLayer = this;
        StreamLayer.assertComponent$default(streamLayer, null, 1, null);
        return ((WatchPartySessionProvider)streamLayer.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(WatchPartySessionProvider.class), null, null)).createWatchPartySession(string2, continuation);
    }

    public final void setAudioDuckingListener(@Nullable AudioDuckingListener audioDuckingListener) {
        StreamLayer.audioDuckingListener = audioDuckingListener;
    }

    public final void setStreamEventChangeListener(@Nullable StreamEventChangeListener streamEventChangeListener) {
        StreamLayer.streamEventChangeListener = streamEventChangeListener;
    }

    public final void setVideoPlayerProvider(@NotNull VideoPlayerProvider videoPlayerProvider) {
        StreamLayer streamLayer = this;
        Intrinsics.checkNotNullParameter((Object)videoPlayerProvider, (String)"videoPlayerProvider");
        StreamLayer.assertComponent$default(streamLayer, null, 1, null);
        ((MediaProvider)streamLayer.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(MediaProvider.class), null, null)).setVideoPlayerProvider(videoPlayerProvider);
    }

    public final void setLogListener(@Nullable LogListener logListener) {
        SLRLog.INSTANCE.setListener(logListener);
    }

    public final void setLogcatLoggingEnabled(boolean bl) {
        SLRLog.INSTANCE.setLogcatLoggingEnabled(bl);
    }

    public final void notifyDuckingChange$sdk_originalRelease(boolean bl) {
        Object object;
        if (bl) {
            object = audioDuckingListener;
            if (object != null) {
                object.requestAudioDucking();
            }
        } else {
            object = audioDuckingListener;
            if (object != null) {
                object.disableAudioDucking();
            }
        }
    }

    public final void notifyStreamEventChange$sdk_originalRelease(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"id");
        StreamEventChangeListener streamEventChangeListener = StreamLayer.streamEventChangeListener;
        if (streamEventChangeListener != null) {
            streamEventChangeListener.onStreamChanged(string2);
        }
    }

    public final void uploadDeviceFCMToken(@NotNull Context context, @NotNull String string2) {
        StreamLayer streamLayer = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"token");
        streamLayer.assertComponent(context);
        ((Session)streamLayer.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(Session.class), null, null)).setFirebaseToken(string2);
        ((Session)streamLayer.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(Session.class), null, null)).setFirebaseTokenChanged(true);
        NotificationChannelsHelper.INSTANCE.initChannels((Context)this.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(Context.class), null, null));
    }

    public final boolean handlePush(@NotNull Context context, @NotNull Map<String, String> map2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(map2, (String)"data");
        if (PushNotificationsService.Companion.isStreamLayerPush(map2)) {
            StreamLayer streamLayer = this;
            streamLayer.assertComponent(context);
            ((PushNotificationsService)streamLayer.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(PushNotificationsService.class), null, null)).handlePushMessage(map2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean handleDeepLink(@NotNull Intent intent, @NotNull FragmentActivity fragmentActivity) {
        FragmentActivity fragmentActivity2 = fragmentActivity;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)fragmentActivity2, (String)"activity");
        this.assertComponent(fragmentActivity2.getApplicationContext());
        return DeepLinkHandler.INSTANCE.handleDeepLink(intent, fragmentActivity);
    }

    public final void handleInvite(@NotNull InviteData inviteData, @NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)inviteData, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.assertComponent(context2.getApplicationContext());
        DeepLinkHandler.INSTANCE.handleInvite(inviteData, context);
    }

    @Nullable
    public final InviteData getInvite(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"json");
        return DeepLinkHandler.INSTANCE.getInvite(string2);
    }

    public static enum LogLevel {
        VERBOSE,
        DEBUG,
        INFO,
        WARNING,
        ERROR;

    }

    public static interface LogListener {
        public void log(@NotNull LogLevel var1, @NotNull String var2);
    }

    public static interface AudioDuckingListener {
        public void requestAudioDucking();

        public void disableAudioDucking();
    }

    public static interface StreamEventChangeListener {
        public void onStreamChanged(@NotNull String var1);
    }
}

