/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk;

import androidx.fragment.app.FragmentActivity;
import java.util.Date;
import java.util.List;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface WatchPartySession {
    @NotNull
    public String getGroupId();

    @NotNull
    public Flow<Event> getEvents() throws RuntimeException;

    @NotNull
    public Flow<Message> getMessages() throws RuntimeException;

    @NotNull
    public List<Participant> getParticipants() throws RuntimeException;

    @NotNull
    public User getCurrentUser() throws RuntimeException;

    @Nullable
    public Object sendMessage(@NotNull String var1, @NotNull Continuation<? super Boolean> var2) throws RuntimeException;

    public void release();

    public boolean isReleased();

    public void show(@NotNull FragmentActivity var1) throws RuntimeException;

    public static final class User {
        @NotNull
        private final String id;
        @NotNull
        private final String bypassId;

        public User(@NotNull String string2, @NotNull String string3) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)string3, (String)"bypassId");
            this.id = string2;
            this.bypassId = string3;
        }

        public static /* synthetic */ User copy$default(User user2, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = user2.id;
            }
            if ((n & 2) != 0) {
                string3 = user2.bypassId;
            }
            return user2.copy(string2, string3);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getBypassId() {
            return this.bypassId;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.bypassId;
        }

        @NotNull
        public final User copy(@NotNull String string2, @NotNull String string3) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)string3, (String)"bypassId");
            return new User(string2, string3);
        }

        @NotNull
        public String toString() {
            return "User(id=" + this.id + ", bypassId=" + this.bypassId + ')';
        }

        public int hashCode() {
            return this.id.hashCode() * 31 + this.bypassId.hashCode();
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof User)) {
                return false;
            }
            object = (User)object;
            if (!Intrinsics.areEqual((Object)this.id, (Object)((User)object).id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.bypassId, (Object)((User)object).bypassId);
        }
    }

    public static final class Participant {
        @NotNull
        private final User user;
        @NotNull
        private final Status status;

        public Participant(@NotNull User user2, @NotNull Status status) {
            Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            this.user = user2;
            this.status = status;
        }

        public static /* synthetic */ Participant copy$default(Participant participant, User user2, Status status, int n, Object object) {
            if ((n & 1) != 0) {
                user2 = participant.user;
            }
            if ((n & 2) != 0) {
                status = participant.status;
            }
            return participant.copy(user2, status);
        }

        @NotNull
        public final User getUser() {
            return this.user;
        }

        @NotNull
        public final Status getStatus() {
            return this.status;
        }

        @NotNull
        public final User component1() {
            return this.user;
        }

        @NotNull
        public final Status component2() {
            return this.status;
        }

        @NotNull
        public final Participant copy(@NotNull User user2, @NotNull Status status) {
            Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            return new Participant(user2, status);
        }

        @NotNull
        public String toString() {
            return "Participant(user=" + this.user + ", status=" + (Object)((Object)this.status) + ')';
        }

        public int hashCode() {
            return this.user.hashCode() * 31 + this.status.hashCode();
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Participant)) {
                return false;
            }
            object = (Participant)object;
            if (!Intrinsics.areEqual((Object)this.user, (Object)((Participant)object).user)) {
                return false;
            }
            return this.status == ((Participant)object).status;
        }

        public static enum Status {
            PENDING,
            SUBSCRIBED,
            ON_CALL;

        }
    }

    public static final class Message {
        @NotNull
        private final User user;
        @NotNull
        private final String content;
        @NotNull
        private final Date date;

        public Message(@NotNull User user2, @NotNull String string2, @NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
            Intrinsics.checkNotNullParameter((Object)string2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            this.user = user2;
            this.content = string2;
            this.date = date;
        }

        public static /* synthetic */ Message copy$default(Message message, User user2, String string2, Date date, int n, Object object) {
            if ((n & 1) != 0) {
                user2 = message.user;
            }
            if ((n & 2) != 0) {
                string2 = message.content;
            }
            if ((n & 4) != 0) {
                date = message.date;
            }
            return message.copy(user2, string2, date);
        }

        @NotNull
        public final User getUser() {
            return this.user;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        @NotNull
        public final Date getDate() {
            return this.date;
        }

        @NotNull
        public final User component1() {
            return this.user;
        }

        @NotNull
        public final String component2() {
            return this.content;
        }

        @NotNull
        public final Date component3() {
            return this.date;
        }

        @NotNull
        public final Message copy(@NotNull User user2, @NotNull String string2, @NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
            Intrinsics.checkNotNullParameter((Object)string2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return new Message(user2, string2, date);
        }

        @NotNull
        public String toString() {
            return "Message(user=" + this.user + ", content=" + this.content + ", date=" + this.date + ')';
        }

        public int hashCode() {
            return (this.user.hashCode() * 31 + this.content.hashCode()) * 31 + this.date.hashCode();
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Message)) {
                return false;
            }
            object = (Message)object;
            if (!Intrinsics.areEqual((Object)this.user, (Object)((Message)object).user)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.content, (Object)((Message)object).content)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.date, (Object)((Message)object).date);
        }
    }

    public static abstract class Event {
        private Event() {
        }

        public /* synthetic */ Event(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public static final class ParticipantAdded
        extends Event {
            @NotNull
            private final Participant participant;

            public ParticipantAdded(@NotNull Participant participant) {
                Intrinsics.checkNotNullParameter((Object)participant, (String)"participant");
                super(null);
                this.participant = participant;
            }

            public static /* synthetic */ ParticipantAdded copy$default(ParticipantAdded participantAdded, Participant participant, int n, Object object) {
                if ((n & 1) != 0) {
                    participant = participantAdded.participant;
                }
                return participantAdded.copy(participant);
            }

            @NotNull
            public final Participant getParticipant() {
                return this.participant;
            }

            @NotNull
            public final Participant component1() {
                return this.participant;
            }

            @NotNull
            public final ParticipantAdded copy(@NotNull Participant participant) {
                Intrinsics.checkNotNullParameter((Object)participant, (String)"participant");
                return new ParticipantAdded(participant);
            }

            @NotNull
            public String toString() {
                return "ParticipantAdded(participant=" + this.participant + ')';
            }

            public int hashCode() {
                return this.participant.hashCode();
            }

            public boolean equals(@Nullable Object object) {
                if (participantAdded2 == object) {
                    return true;
                }
                if (!(object instanceof ParticipantAdded)) {
                    return false;
                }
                ParticipantAdded participantAdded = participantAdded2;
                ParticipantAdded participantAdded2 = (ParticipantAdded)object;
                return Intrinsics.areEqual((Object)participantAdded.participant, (Object)participantAdded2.participant);
            }
        }

        public static final class ParticipantUpdated
        extends Event {
            @NotNull
            private final Participant participant;

            public ParticipantUpdated(@NotNull Participant participant) {
                Intrinsics.checkNotNullParameter((Object)participant, (String)"participant");
                super(null);
                this.participant = participant;
            }

            public static /* synthetic */ ParticipantUpdated copy$default(ParticipantUpdated participantUpdated, Participant participant, int n, Object object) {
                if ((n & 1) != 0) {
                    participant = participantUpdated.participant;
                }
                return participantUpdated.copy(participant);
            }

            @NotNull
            public final Participant getParticipant() {
                return this.participant;
            }

            @NotNull
            public final Participant component1() {
                return this.participant;
            }

            @NotNull
            public final ParticipantUpdated copy(@NotNull Participant participant) {
                Intrinsics.checkNotNullParameter((Object)participant, (String)"participant");
                return new ParticipantUpdated(participant);
            }

            @NotNull
            public String toString() {
                return "ParticipantUpdated(participant=" + this.participant + ')';
            }

            public int hashCode() {
                return this.participant.hashCode();
            }

            public boolean equals(@Nullable Object object) {
                if (participantUpdated2 == object) {
                    return true;
                }
                if (!(object instanceof ParticipantUpdated)) {
                    return false;
                }
                ParticipantUpdated participantUpdated = participantUpdated2;
                ParticipantUpdated participantUpdated2 = (ParticipantUpdated)object;
                return Intrinsics.areEqual((Object)participantUpdated.participant, (Object)participantUpdated2.participant);
            }
        }

        public static final class ParticipantRemoved
        extends Event {
            @NotNull
            private final Participant participant;

            public ParticipantRemoved(@NotNull Participant participant) {
                Intrinsics.checkNotNullParameter((Object)participant, (String)"participant");
                super(null);
                this.participant = participant;
            }

            public static /* synthetic */ ParticipantRemoved copy$default(ParticipantRemoved participantRemoved, Participant participant, int n, Object object) {
                if ((n & 1) != 0) {
                    participant = participantRemoved.participant;
                }
                return participantRemoved.copy(participant);
            }

            @NotNull
            public final Participant getParticipant() {
                return this.participant;
            }

            @NotNull
            public final Participant component1() {
                return this.participant;
            }

            @NotNull
            public final ParticipantRemoved copy(@NotNull Participant participant) {
                Intrinsics.checkNotNullParameter((Object)participant, (String)"participant");
                return new ParticipantRemoved(participant);
            }

            @NotNull
            public String toString() {
                return "ParticipantRemoved(participant=" + this.participant + ')';
            }

            public int hashCode() {
                return this.participant.hashCode();
            }

            public boolean equals(@Nullable Object object) {
                if (participantRemoved2 == object) {
                    return true;
                }
                if (!(object instanceof ParticipantRemoved)) {
                    return false;
                }
                ParticipantRemoved participantRemoved = participantRemoved2;
                ParticipantRemoved participantRemoved2 = (ParticipantRemoved)object;
                return Intrinsics.areEqual((Object)participantRemoved.participant, (Object)participantRemoved2.participant);
            }
        }

        public static final class SessionReleased
        extends Event {
            @NotNull
            public static final SessionReleased INSTANCE = new SessionReleased();

            private SessionReleased() {
                super(null);
            }
        }
    }
}

