/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.auth.verifyphone;

import android.telephony.PhoneNumberUtils;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import com.google.i18n.phonenumbers.AsYouTypeFormatter;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import io.streamlayer.common.utils.SLRLog;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhoneNumberFormattingTextWatcher
implements TextWatcher {
    private boolean mSelfChange;
    private boolean mStopFormatting;
    @NotNull
    private final AsYouTypeFormatter mFormatter;
    @NotNull
    private final String countryCode;

    public PhoneNumberFormattingTextWatcher(@Nullable String string2) {
        if (string2 != null) {
            AsYouTypeFormatter asYouTypeFormatter = PhoneNumberUtil.getInstance().getAsYouTypeFormatter(string2);
            Intrinsics.checkNotNullExpressionValue((Object)asYouTypeFormatter, (String)"getInstance().getAsYouTypeFormatter(countryCode)");
            this.mFormatter = asYouTypeFormatter;
            this.countryCode = string2;
            return;
        }
        throw new IllegalArgumentException("Required value was null.".toString());
    }

    private final String reformat(CharSequence charSequence, int n) {
        --n;
        this.mFormatter.clear();
        char c = '\u0000';
        boolean bl = false;
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3;
            int n5 = n4 + 1;
            char c2 = charSequence.charAt(n4);
            if (PhoneNumberUtils.isNonSeparator((char)c2)) {
                if (c != '\u0000') {
                    this.getFormattedNumber(c, bl);
                    bl = false;
                }
                c = c2;
            }
            if (n3 == n) {
                bl = true;
                n3 = n5;
                continue;
            }
            n3 = n5;
        }
        SLRLog.INSTANCE.d("lastNonSeparator", Intrinsics.stringPlus((String)"", (Object)Character.valueOf(c)));
        String string2 = this.getFormattedNumber(c, bl);
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    private final String getFormattedNumber(char c, boolean bl) {
        Object object;
        if (bl) {
            object = ((PhoneNumberFormattingTextWatcher)object).mFormatter.inputDigitAndRememberPosition(c);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mFormatter.inputDigitAnd\u2026osition(lastNonSeparator)");
        } else {
            object = ((PhoneNumberFormattingTextWatcher)object).mFormatter.inputDigit(c);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mFormatter.inputDigit(\n \u2026astNonSeparator\n        )");
        }
        return object;
    }

    private final void stopFormatting() {
        this.mStopFormatting = true;
        this.mFormatter.clear();
    }

    private final boolean hasSeparator(CharSequence charSequence, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            if (PhoneNumberUtils.isNonSeparator((char)charSequence.charAt(n++))) continue;
            return true;
        }
        return false;
    }

    public void beforeTextChanged(@NotNull CharSequence charSequence, int n, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"s");
        if (!this.mSelfChange && !this.mStopFormatting) {
            if (n2 > 0 && this.hasSeparator(charSequence, n, n2)) {
                this.stopFormatting();
            }
            return;
        }
    }

    public void onTextChanged(@NotNull CharSequence charSequence, int n, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"s");
        if (!this.mSelfChange && !this.mStopFormatting) {
            if (n3 > 0 && this.hasSeparator(charSequence, n, n3)) {
                this.stopFormatting();
            }
            return;
        }
    }

    public synchronized void afterTextChanged(@NotNull Editable editable) {
        Intrinsics.checkNotNullParameter((Object)editable, (String)"s");
        if (this.mStopFormatting) {
            boolean bl = editable.length() != 0;
            this.mStopFormatting = bl;
            return;
        }
        if (this.mSelfChange) {
            return;
        }
        String string2 = this.reformat((CharSequence)editable, Selection.getSelectionEnd((CharSequence)editable));
        if (string2 != null) {
            Editable editable2 = editable;
            this.mSelfChange = true;
            int n = editable.length();
            int n2 = string2.length();
            editable2.replace(0, n, (CharSequence)string2, 0, n2);
            Selection.setSelection((Spannable)editable2, (int)Selection.getSelectionEnd((CharSequence)editable2));
            this.mSelfChange = false;
        }
    }
}

