/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.betting;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.betting.SelectionsAdapter;
import io.streamlayer.sdk.databinding.SlrBettingMarketItemBinding;
import io.streamlayer.sdk.model.analytics.InteractionActionType;
import io.streamlayer.sdk.model.betting.MarketUI;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MarketsAdapter
extends RecyclerView.Adapter<MarketsVH> {
    @NotNull
    private final Function1<InteractionActionType, Unit> interactionListener;
    @NotNull
    private final List<MarketUI> items;

    public MarketsAdapter(@NotNull Function1<? super InteractionActionType, Unit> function1) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(function1, (String)"interactionListener");
        object.interactionListener = function1;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.items = object;
    }

    private final void bind(SlrBettingMarketItemBinding slrBettingMarketItemBinding, MarketUI marketUI) {
        SlrBettingMarketItemBinding slrBettingMarketItemBinding2 = slrBettingMarketItemBinding;
        slrBettingMarketItemBinding2.slMarketNameTV.setText((CharSequence)marketUI.getMarket().getName());
        ImageView imageView = slrBettingMarketItemBinding2.slDropdownIV;
        float f = marketUI.isOpened() ? 180.0f : 360.0f;
        imageView.setRotation(f);
        RecyclerView recyclerView = slrBettingMarketItemBinding.slSelectionsRV;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"slSelectionsRV");
        ViewExtensionsKt.visibleIfElse((View)recyclerView, marketUI.isOpened(), 8);
        if (marketUI.isOpened()) {
            this.setSelectionAdapter(slrBettingMarketItemBinding, marketUI);
        }
        slrBettingMarketItemBinding.getRoot().setOnClickListener(arg_0 -> MarketsAdapter.bind$lambda-0(slrBettingMarketItemBinding, marketUI, this, arg_0));
    }

    private final void setSelectionAdapter(SlrBettingMarketItemBinding slrBettingMarketItemBinding, MarketUI marketUI) {
        RecyclerView.Adapter adapter2 = slrBettingMarketItemBinding.slSelectionsRV.getAdapter();
        if (adapter2 == null) {
            SelectionsAdapter selectionsAdapter;
            adapter2 = selectionsAdapter;
            selectionsAdapter = new SelectionsAdapter();
            slrBettingMarketItemBinding.slSelectionsRV.setAdapter(adapter2);
        }
        ((SelectionsAdapter)adapter2).setItems(marketUI.getMarket().getSelections());
        slrBettingMarketItemBinding.slSelectionsRV.setPadding(0, 32, 0, 0);
    }

    private static final void bind$lambda-0(SlrBettingMarketItemBinding slrBettingMarketItemBinding, MarketUI marketUI, MarketsAdapter marketsAdapter, View view2) {
        Intrinsics.checkNotNullParameter((Object)slrBettingMarketItemBinding, (String)"$this_bind");
        Intrinsics.checkNotNullParameter((Object)marketUI, (String)"$item");
        Intrinsics.checkNotNullParameter((Object)((Object)marketsAdapter), (String)"this$0");
        view2 = slrBettingMarketItemBinding.slDropdownIV.animate();
        float f = !marketUI.isOpened() ? 180.0f : 360.0f;
        view2.rotation(f).start();
        if (!marketUI.isOpened()) {
            marketsAdapter.setSelectionAdapter(slrBettingMarketItemBinding, marketUI);
        }
        MarketUI marketUI2 = marketUI;
        marketUI2.setOpened(marketUI2.isOpened() ^ true);
        RecyclerView recyclerView = slrBettingMarketItemBinding.slSelectionsRV;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"slSelectionsRV");
        ViewExtensionsKt.visibleIfElse((View)recyclerView, marketUI.isOpened(), 8);
        marketsAdapter.interactionListener.invoke((Object)InteractionActionType.TAP);
    }

    @NotNull
    public MarketsVH onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        MarketsAdapter marketsAdapter = object;
        Object object = SlrBettingMarketItemBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
        return marketsAdapter.new MarketsVH((SlrBettingMarketItemBinding)object);
    }

    public void onBindViewHolder(@NotNull MarketsVH marketsVH, int n) {
        MarketsVH marketsVH2 = marketsVH;
        Intrinsics.checkNotNullParameter((Object)((Object)marketsVH2), (String)"holder");
        this.bind(marketsVH2.getBinding(), this.items.get(n));
    }

    public int getItemCount() {
        return this.items.size();
    }

    public final void setItems(@NotNull List<MarketUI> list) {
        Intrinsics.checkNotNullParameter(list, (String)"markets");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new MarketDiffUtil(this.items, list));
        MarketsAdapter marketsAdapter = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(MarketDiffUtil(items, markets))");
        marketsAdapter.items.clear();
        marketsAdapter.items.addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)marketsAdapter);
    }

    public final class MarketsVH
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrBettingMarketItemBinding binding;

        public MarketsVH(SlrBettingMarketItemBinding slrBettingMarketItemBinding) {
            Intrinsics.checkNotNullParameter((Object)((Object)MarketsAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrBettingMarketItemBinding, (String)"binding");
            super((View)slrBettingMarketItemBinding.getRoot());
            this.binding = slrBettingMarketItemBinding;
        }

        @NotNull
        public final SlrBettingMarketItemBinding getBinding() {
            return this.binding;
        }
    }

    private static final class MarketDiffUtil
    extends DiffUtil.Callback {
        @NotNull
        private final List<MarketUI> oldList;
        @NotNull
        private final List<MarketUI> newList;

        public MarketDiffUtil(@NotNull List<MarketUI> list, @NotNull List<MarketUI> list2) {
            Intrinsics.checkNotNullParameter(list, (String)"oldList");
            Intrinsics.checkNotNullParameter(list2, (String)"newList");
            this.oldList = list;
            this.newList = list2;
        }

        @NotNull
        public final List<MarketUI> getOldList() {
            return this.oldList;
        }

        @NotNull
        public final List<MarketUI> getNewList() {
            return this.newList;
        }

        public int getOldListSize() {
            return this.oldList.size();
        }

        public int getNewListSize() {
            return this.newList.size();
        }

        public boolean areItemsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldList.get(n), (Object)this.newList.get(n));
        }

        public boolean areContentsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldList.get(n), (Object)this.newList.get(n));
        }
    }
}

