/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.betting;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.CoilExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.recyclerview.SelectableItemDiffUtils;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.betting.SportsAdapter;
import io.streamlayer.sdk.databinding.SlrSportTypeItemBinding;
import io.streamlayer.sdk.model.betting.SportType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class SportsAdapter
extends RecyclerView.Adapter<SportsVH> {
    @NotNull
    private final Function1<SportType, Unit> sportTypeClicked;
    @NotNull
    private final List<SportType> items;
    private int selectedPosition;

    public SportsAdapter(@NotNull Function1<? super SportType, Unit> function1) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(function1, (String)"sportTypeClicked");
        object.sportTypeClicked = function1;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.items = object;
    }

    @NotNull
    public SportsVH onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        SportsAdapter sportsAdapter2 = object;
        Object object = SlrSportTypeItemBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
        return sportsAdapter2.new SportsVH((SlrSportTypeItemBinding)object);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public long getItemId(int n) {
        return this.items.get(n).getId();
    }

    public void onBindViewHolder(@NotNull SportsVH sportsVH, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)sportsVH), (String)"holder");
        sportsVH.bind(this.items.get(sportsVH.getAbsoluteAdapterPosition()));
    }

    public final void setItems(@NotNull List<SportType> list) {
        Intrinsics.checkNotNullParameter(list, (String)"sportList");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new SelectableItemDiffUtils(list, this.items));
        SportsAdapter sportsAdapter2 = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(Selectable\u2026fUtils(sportList, items))");
        sportsAdapter2.items.clear();
        sportsAdapter2.items.addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)sportsAdapter2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class SportsVH
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrSportTypeItemBinding binding;

        public SportsVH(SlrSportTypeItemBinding slrSportTypeItemBinding) {
            Intrinsics.checkNotNullParameter((Object)((Object)SportsAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrSportTypeItemBinding, (String)"binding");
            super((View)slrSportTypeItemBinding.getRoot());
            this.binding = slrSportTypeItemBinding;
        }

        private static final void bind$lambda-1$lambda-0(SportsAdapter sportsAdapter2, SportsVH sportsVH, SlrSportTypeItemBinding slrSportTypeItemBinding, SportType sportType, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)sportsAdapter2), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)sportsVH), (String)"this$1");
            Intrinsics.checkNotNullParameter((Object)slrSportTypeItemBinding, (String)"$this_with");
            Intrinsics.checkNotNullParameter((Object)sportType, (String)"$item");
            int n = sportsAdapter2.selectedPosition;
            sportsAdapter2.selectedPosition = sportsVH.getAbsoluteAdapterPosition();
            SlrSportTypeItemBinding slrSportTypeItemBinding2 = slrSportTypeItemBinding = slrSportTypeItemBinding.slDivider;
            Intrinsics.checkNotNullExpressionValue((Object)slrSportTypeItemBinding2, (String)"slDivider");
            ViewExtensionsKt.visible((View)slrSportTypeItemBinding2);
            sportsAdapter2.sportTypeClicked.invoke((Object)sportType);
            sportsAdapter2.notifyItemChanged(n);
        }

        @NotNull
        public final SlrSportTypeItemBinding getBinding() {
            return this.binding;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final void bind(@NotNull SportType sportType) {
            SportsAdapter sportsAdapter2;
            SlrSportTypeItemBinding slrSportTypeItemBinding;
            block19: {
                Function1<ImageView, Unit> function1;
                int n;
                Object object;
                block20: {
                    block18: {
                        SportsVH sportsVH = this;
                        Intrinsics.checkNotNullParameter((Object)sportType, (String)"item");
                        slrSportTypeItemBinding = sportsVH.binding;
                        sportsAdapter2 = SportsAdapter.this;
                        slrSportTypeItemBinding.slTitleTV.setText((CharSequence)sportType.getName());
                        Object object2 = slrSportTypeItemBinding.slItemContainer;
                        object = sportsVH.itemView.getContext();
                        int n2 = sportType.isFavorite() ? R.color.slr_white : R.color.slr_gray700_a15;
                        object2.setCardBackgroundColor(ContextCompat.getColor((Context)object, (int)n2));
                        if (!sportType.isFavorite()) break block18;
                        object2 = sportType.getIconUrl();
                        boolean bl = object2 == null || object2.length() == 0;
                        if (bl) {
                            ImageView imageView = slrSportTypeItemBinding.slIconIV;
                            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slIconIV");
                            CoilExtensionsKt.clear(imageView, bind.1.1.INSTANCE);
                            break block19;
                        } else if (slrSportTypeItemBinding.slIconIV.getTag() == null || !Intrinsics.areEqual((Object)slrSportTypeItemBinding.slIconIV.getTag(), (Object)sportType.getIconUrl())) {
                            SlrSportTypeItemBinding slrSportTypeItemBinding2 = slrSportTypeItemBinding;
                            slrSportTypeItemBinding2.slIconIV.setTag((Object)sportType.getIconUrl());
                            ImageView imageView = slrSportTypeItemBinding2.slIconIV;
                            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slIconIV");
                            ViewExtensionsKt.loadUrl$default(imageView, sportType.getIconUrl(), false, null, null, 12, null);
                        }
                        break block19;
                    }
                    switch (sportType.getName()) {
                        default: {
                            break;
                        }
                        case "Football": {
                            n = R.drawable.slr_ic_football;
                            break block20;
                        }
                        case "Basketball": {
                            n = R.drawable.slr_ic_basketball;
                            break block20;
                        }
                        case "Baseball": {
                            n = R.drawable.slr_ic_baseball;
                            break block20;
                        }
                        case "Tennis": {
                            n = R.drawable.slr_ic_tennis;
                            break block20;
                        }
                        case "Soccer": {
                            n = R.drawable.slr_ic_soccer;
                            break block20;
                        }
                    }
                    n = R.drawable.slr_ic_betting_sport;
                }
                ImageView imageView = slrSportTypeItemBinding.slIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slIconIV");
                object = function1;
                function1 = new Function1<ImageView, Unit>(n){
                    final /* synthetic */ int $resId;
                    {
                        this.$resId = n;
                        super(1);
                    }

                    public final void invoke(@NotNull ImageView imageView) {
                        Intrinsics.checkNotNullParameter((Object)imageView, (String)"$this$clear");
                        imageView.setImageResource(this.$resId);
                    }
                };
                CoilExtensionsKt.clear(imageView, (Function1<? super ImageView, Unit>)object);
            }
            View view2 = slrSportTypeItemBinding.slDivider;
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"slDivider");
            ViewExtensionsKt.visibleIfElse$default(view2, sportType.isSelected(), 0, 2, null);
            if (sportType.isSelected()) {
                sportsAdapter2.selectedPosition = this.getAbsoluteAdapterPosition();
            }
            slrSportTypeItemBinding.getRoot().setOnClickListener(arg_0 -> SportsVH.bind$lambda-1$lambda-0(sportsAdapter2, this, slrSportTypeItemBinding, sportType, arg_0));
        }
    }
}

