/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.calls.call;

import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import io.streamlayer.common.data.notifications.NotificationChannelsHelper;
import io.streamlayer.common.utils.NavigationUtils;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.deeplink.DeepLinkHandler;
import io.streamlayer.sdk.deeplink.DeepLinkRoute;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WatchPartyService
extends Service {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String START_ACTION = "io.streamlayer.sdk.watch_party.service_start";
    @NotNull
    private static final String STOP_ACTION = "io.streamlayer.sdk.watch_party.service_stop";
    @NotNull
    private static final String CHAT_ID_EXTRA = "CHAT_ID_EXTRA";
    private static final int NOTIFICATION_ID = Integer.MAX_VALUE;

    private final Notification getWatchPartyNotification(Context context, String string2) {
        WatchPartyService watchPartyService = DeepLinkHandler.INSTANCE.buildDeepLinkIntent$sdk_originalRelease(context, DeepLinkRoute.MAIN, NavigationUtils.INSTANCE.buildWatchPartyDeepLink(string2), null);
        int n = Build.VERSION.SDK_INT >= 31 ? 0x14000000 : 0x10000000;
        Context context2 = context;
        watchPartyService = PendingIntent.getActivity((Context)context2, (int)0, (Intent)watchPartyService, (int)n);
        String string3 = ((Object)context2.getPackageManager().getApplicationLabel(context.getApplicationInfo())).toString();
        if (!(string3.length() > 0)) {
            string3 = context.getString(R.string.slr_streamlayer);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.slr_streamlayer)");
        }
        Notification notification = new NotificationCompat.Builder(context, NotificationChannelsHelper.Channel.streamlayer_low.name()).setSmallIcon(R.drawable.slr_ic_logo).setColor(ContextCompat.getColor((Context)context, (int)R.color.slr_primaryBlue)).setAutoCancel(false).setPriority(1).setCategory("call").setContentIntent((PendingIntent)watchPartyService).setContentTitle((CharSequence)string3).setContentText((CharSequence)context.getString(R.string.slr_watch_party_is_in_progress)).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"Builder(context, Notific\u2026ss))\n            .build()");
        return notification;
    }

    public int onStartCommand(@NotNull Intent intent, int n, int n2) {
        Intent intent2 = intent;
        Intrinsics.checkNotNullParameter((Object)intent2, (String)"intent");
        String string2 = intent2.getAction();
        if (string2 != null) {
            n2 = string2.hashCode();
            if (n2 != 789150471) {
                if (n2 == 2103666877 && string2.equals(STOP_ACTION)) {
                    watchPartyService2.stopSelf();
                }
            } else if (string2.equals(START_ACTION)) {
                WatchPartyService watchPartyService = watchPartyService2;
                WatchPartyService watchPartyService2 = watchPartyService2.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)watchPartyService2), (String)"applicationContext");
                watchPartyService.startForeground(Integer.MAX_VALUE, watchPartyService.getWatchPartyNotification((Context)watchPartyService2, intent.getStringExtra(CHAT_ID_EXTRA)));
            }
        }
        return 2;
    }

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return null;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final void start(@NotNull Context context, @NotNull String string2) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)string2, (String)"chatId");
            Intent intent2 = intent;
            intent = new Intent(context, WatchPartyService.class);
            Intent intent3 = intent;
            intent.setAction(WatchPartyService.START_ACTION);
            intent3.putExtra(WatchPartyService.CHAT_ID_EXTRA, string2);
            try {
                context.startService(intent2);
            }
            catch (IllegalStateException illegalStateException) {
                SLRLog.INSTANCE.e("WatchPartyService", Intrinsics.stringPlus((String)"Can not start service: ", (Object)illegalStateException.getMessage()));
            }
        }

        public final void stop(@NotNull Context context) {
            Context context2 = context;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intent intent = new Intent(context, WatchPartyService.class);
            Intent intent2 = intent;
            intent.setAction(WatchPartyService.STOP_ACTION);
            try {
                context2.startService(intent2);
            }
            catch (IllegalStateException illegalStateException) {
                SLRLog.INSTANCE.e("WatchPartyService", Intrinsics.stringPlus((String)"Can not stop service: ", (Object)illegalStateException.getMessage()));
            }
        }
    }
}

