/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.calls.recent;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.textview.MaterialTextView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.recyclerview.CategoryViewHolder;
import io.streamlayer.common.recyclerview.GenericAdapter;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.calls.recent.UserAvatarsAdapter;
import io.streamlayer.sdk.messaging.MessagingExtensionsKt;
import io.streamlayer.sdk.model.calls.ParticipantStatus;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus;
import io.streamlayer.sdk.model.invites.Action;
import io.streamlayer.sdk.model.invites.AnyListItem;
import io.streamlayer.sdk.model.invites.Category;
import io.streamlayer.sdk.model.invites.ShareInvite;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class WatchPartiesAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final Listener listener;
    @NotNull
    private final RecyclerView.RecycledViewPool avatarsRecyclerPool;
    @NotNull
    private final List<AnyListItem> listItems;

    public WatchPartiesAdapter(@NotNull Listener listener2) {
        ArrayList arrayList;
        RecyclerView.RecycledViewPool recycledViewPool;
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        object.listener = listener2;
        Object object = recycledViewPool;
        recycledViewPool = new RecyclerView.RecycledViewPool();
        v1.avatarsRecyclerPool = object;
        object = arrayList;
        arrayList = new ArrayList();
        v1.listItems = object;
    }

    public final void setData(@NotNull List<? extends AnyListItem> list) {
        Intrinsics.checkNotNullParameter(list, (String)"watchParties");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new WatchPartiesDiffUtil(this.listItems, list));
        WatchPartiesAdapter watchPartiesAdapter = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(WatchParti\u2026listItems, watchParties))");
        watchPartiesAdapter.listItems.clear();
        watchPartiesAdapter.listItems.addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)watchPartiesAdapter);
    }

    @NotNull
    public final AnyListItem getItem(int n) {
        return this.listItems.get(n);
    }

    public int getItemViewType(int n) {
        block5: {
            int n2;
            block3: {
                block4: {
                    block2: {
                        Object object = object.listItems.get(n);
                        if (!(object instanceof WatchParty)) break block2;
                        n2 = 0;
                        break block3;
                    }
                    if (!(object instanceof Category)) break block4;
                    n2 = 1;
                    break block3;
                }
                if (!(object instanceof Action)) break block5;
                n2 = -1;
            }
            return n2;
        }
        throw new Exception("Unsupported View type");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        void var0_4;
        void var2_6;
        void var1_5;
        Intrinsics.checkNotNullParameter((Object)var1_5, (String)"parent");
        if (var2_6 != -1) {
            if (var2_6 != false) {
                CategoryViewHolder categoryViewHolder;
                if (var2_6 != true) throw new Exception("Unsupported View type");
                CategoryViewHolder categoryViewHolder2 = categoryViewHolder;
                categoryViewHolder = new CategoryViewHolder(ViewExtensionsKt.inflate((ViewGroup)var1_5, R.layout.slr_item_category_view));
                return var0_4;
            } else {
                WatchPartyViewHolder watchPartyViewHolder;
                WatchPartyViewHolder watchPartyViewHolder2 = watchPartyViewHolder;
                watchPartyViewHolder = new WatchPartyViewHolder(this, ViewExtensionsKt.inflate((ViewGroup)var1_5, R.layout.slr_item_watch_party));
                WatchPartyViewHolder watchPartyViewHolder3 = watchPartyViewHolder2;
            }
            return var0_4;
        } else {
            ShowMoreViewHolder showMoreViewHolder;
            ShowMoreViewHolder showMoreViewHolder2 = showMoreViewHolder;
            showMoreViewHolder = new ShowMoreViewHolder(ViewExtensionsKt.inflate((ViewGroup)var1_5, R.layout.slr_item_watch_party_show_more));
            ShowMoreViewHolder showMoreViewHolder3 = showMoreViewHolder2;
        }
        return var0_4;
    }

    public int getItemCount() {
        return this.listItems.size();
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        RecyclerView.ViewHolder viewHolder2 = viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"holder");
        if (viewHolder2 instanceof WatchPartyViewHolder) {
            ((WatchPartyViewHolder)viewHolder).bind((WatchParty)this.getItem(n));
        } else if (viewHolder instanceof CategoryViewHolder) {
            ((CategoryViewHolder)viewHolder).bind((Category)this.getItem(n));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class ShowMoreViewHolder
    extends RecyclerView.ViewHolder {
        public ShowMoreViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)WatchPartiesAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
            ((MaterialTextView)view2.findViewById(R.id.slWatchPartyShowMoreTV)).setOnClickListener(arg_0 -> ShowMoreViewHolder._init_$lambda-0(WatchPartiesAdapter.this, arg_0));
        }

        private static final void _init_$lambda-0(WatchPartiesAdapter watchPartiesAdapter, View view2) {
            WatchPartiesAdapter watchPartiesAdapter2 = watchPartiesAdapter;
            Intrinsics.checkNotNullParameter((Object)((Object)watchPartiesAdapter2), (String)"this$0");
            int n = watchPartiesAdapter2.listItems.size() - 1;
            watchPartiesAdapter.listItems.remove(n);
            watchPartiesAdapter2.notifyItemRemoved(n);
            watchPartiesAdapter2.listener.showMore();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class WatchPartyViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final UserAvatarsAdapter participantsAdapter;
        final /* synthetic */ WatchPartiesAdapter this$0;

        public WatchPartyViewHolder(@NotNull WatchPartiesAdapter watchPartiesAdapter, View view2) {
            UserAvatarsAdapter userAvatarsAdapter;
            View view3 = view2;
            Intrinsics.checkNotNullParameter((Object)((Object)watchPartiesAdapter), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            object.this$0 = watchPartiesAdapter;
            super(view2);
            Object object = userAvatarsAdapter;
            v2.participantsAdapter = new UserAvatarsAdapter();
            ((RecyclerView)view3.findViewById(R.id.slWatchPartyParticipantsRV)).setAdapter((RecyclerView.Adapter)object);
            ((RecyclerView)view3.findViewById(R.id.slWatchPartyParticipantsRV)).setRecycledViewPool(watchPartiesAdapter.avatarsRecyclerPool);
        }

        private static final void bind$lambda-4(WatchParty watchParty, WatchPartiesAdapter watchPartiesAdapter, View view2) {
            Intrinsics.checkNotNullParameter((Object)watchParty, (String)"$watchParty");
            Intrinsics.checkNotNullParameter((Object)((Object)watchPartiesAdapter), (String)"this$0");
            if (watchParty.isActive()) {
                watchPartiesAdapter.listener.onWatchPartyJoinClick(watchParty.getData());
            } else {
                watchPartiesAdapter.listener.onWatchPartyStartClick(watchParty.getData());
            }
        }

        private static final void bind$lambda-14$lambda-6(WatchPartiesAdapter watchPartiesAdapter, WatchParty watchParty, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)watchPartiesAdapter), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)watchParty, (String)"$watchParty");
            watchPartiesAdapter.listener.onWatchPartyClick(watchParty.getData());
        }

        public final void bind(@NotNull WatchParty watchParty) {
            block20: {
                block17: {
                    Object object;
                    Object object2;
                    block18: {
                        block19: {
                            block15: {
                                block16: {
                                    ArrayList arrayList;
                                    Object object3;
                                    Object object422;
                                    WatchParty watchParty2 = watchParty;
                                    Intrinsics.checkNotNullParameter((Object)watchParty2, (String)"watchParty");
                                    object2 = watchParty2.getParticipantStatuses();
                                    if (object2 == null) {
                                        object2 = null;
                                    } else {
                                        ArrayList arrayList2;
                                        if (watchParty.isActive()) {
                                            ArrayList arrayList3;
                                            List list = object2;
                                            object2 = arrayList3;
                                            arrayList3 = new ArrayList();
                                            for (Object object422 : list) {
                                                if (!(((WatchPartyParticipantStatus)object422).getStatus() == ParticipantStatus.Active)) continue;
                                                object2.add(object422);
                                            }
                                        } else {
                                            ArrayList arrayList4;
                                            List list = object2;
                                            object2 = arrayList4;
                                            arrayList4 = new ArrayList();
                                            for (Object object422 : list) {
                                                if (!((WatchPartyParticipantStatus)object422).wasParticipant()) continue;
                                                object2.add(object422);
                                            }
                                        }
                                        object3 = arrayList2;
                                        arrayList2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
                                        object2 = object2.iterator();
                                        while (object2.hasNext()) {
                                            object3.add(((WatchPartyParticipantStatus)object2.next()).getUserId());
                                        }
                                        object2 = object3;
                                    }
                                    if (object2 == null) {
                                        object2 = CollectionsKt.emptyList();
                                    }
                                    WatchParty watchParty3 = watchParty;
                                    WatchPartyViewHolder watchPartyViewHolder = object;
                                    ((MaterialButton)watchPartyViewHolder.itemView.findViewById(R.id.slWatchPartyJoinBtn)).setOnClickListener(arg_0 -> WatchPartyViewHolder.bind$lambda-4(watchParty, ((WatchPartyViewHolder)((Object)object)).this$0, arg_0));
                                    object3 = watchPartyViewHolder.participantsAdapter;
                                    object422 = watchParty3.getData();
                                    Object object5 = watchParty3.getOwner();
                                    object5 = object5 == null ? null : ((TinodeContact)object5).getChatUserId();
                                    List<TinodeContact> list = MessagingExtensionsKt.participantsWithoutUser(object422, (String)object5);
                                    object422 = arrayList;
                                    arrayList = new ArrayList();
                                    for (Object t : list) {
                                        if (!object2.contains(((TinodeContact)t).getChatUserId())) continue;
                                        object422.add(t);
                                    }
                                    ((GenericAdapter)((Object)object3)).setItems(object422);
                                    object2 = ((RecyclerView.ViewHolder)object).itemView;
                                    object2.setOnClickListener(arg_0 -> WatchPartyViewHolder.bind$lambda-14$lambda-6(((WatchPartyViewHolder)((Object)object)).this$0, watchParty, arg_0));
                                    object = watchParty.getOwner();
                                    if (object != null) {
                                        AppCompatImageView appCompatImageView = (AppCompatImageView)object2.findViewById(R.id.slWatchPartyIV);
                                        object3 = appCompatImageView;
                                        Object object4 = object;
                                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"slWatchPartyIV");
                                        object = ((TinodeContact)object4).getChatName();
                                        object3 = ((TinodeContact)object4).getPhotoData();
                                        boolean bl = ((TinodeContact)object4).getOnline();
                                        ProfileExtensionsKt.loadContactAvatarWithStatus((ImageView)appCompatImageView, (String)object, (String)object3, bl);
                                    }
                                    object = (MaterialTextView)object2.findViewById(R.id.slWatchPartyNameTV);
                                    object3 = watchParty.getOwner();
                                    object3 = object3 == null ? null : ((TinodeContact)object3).getChatName();
                                    if (object3 == null) {
                                        object3 = watchParty.getData().getName();
                                    }
                                    Object object6 = object2;
                                    object.setText((CharSequence)object3);
                                    ((MaterialTextView)object6.findViewById(R.id.slWatchPartyGameTV)).setText((CharSequence)watchParty.getStreamTitle());
                                    MaterialTextView materialTextView = (MaterialTextView)object6.findViewById(R.id.slWatchPartyGameTV);
                                    Intrinsics.checkNotNullExpressionValue((Object)materialTextView, (String)"slWatchPartyGameTV");
                                    ViewExtensionsKt.visibleIf((View)materialTextView, watchParty.isActive());
                                    MaterialTextView materialTextView2 = (MaterialTextView)object6.findViewById(R.id.slWatchPartyDateTV);
                                    Intrinsics.checkNotNullExpressionValue((Object)materialTextView2, (String)"slWatchPartyDateTV");
                                    ViewExtensionsKt.visibleIf((View)materialTextView2, watchParty.isActive() ^ true);
                                    ((MaterialTextView)object6.findViewById(R.id.slWatchPartyDateTV)).setText((CharSequence)watchParty.dateWatchParty());
                                    if (!watchParty.isActive() || !watchParty.isFull()) break block15;
                                    object = (MaterialButton)object2.findViewById(R.id.slWatchPartyJoinBtn);
                                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
                                    watchParty = object.getLayoutParams();
                                    if (watchParty == null) break block16;
                                    Object object7 = object;
                                    ((ViewGroup.LayoutParams)watchParty).height = ViewExtensionsKt.getDp(32.0f);
                                    object7.setLayoutParams((ViewGroup.LayoutParams)watchParty);
                                    int n = ViewExtensionsKt.getDp(7.0f);
                                    object7.setPadding(n, n, n, n);
                                    object7.setText(R.string.slr_party_full);
                                    object7.setIconResource(R.drawable.slr_ic_watch_party_full);
                                    object7.setMinWidth(ViewExtensionsKt.getDp(92.0f));
                                    object7.setEnabled(false);
                                    break block17;
                                }
                                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
                            }
                            if (!watchParty.isActive()) break block18;
                            object = (MaterialButton)object2.findViewById(R.id.slWatchPartyJoinBtn);
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
                            watchParty = object.getLayoutParams();
                            if (watchParty == null) break block19;
                            Object object8 = object;
                            ((ViewGroup.LayoutParams)watchParty).height = ViewExtensionsKt.getDp(32.0f);
                            object8.setLayoutParams((ViewGroup.LayoutParams)watchParty);
                            int n = ViewExtensionsKt.getDp(7.0f);
                            object8.setPadding(n, n, n, n);
                            object8.setText(R.string.slr_join_party);
                            object8.setIconResource(R.drawable.slr_ic_watch_party);
                            object8.setMinWidth(ViewExtensionsKt.getDp(92.0f));
                            object8.setEnabled(true);
                            break block17;
                        }
                        throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
                    }
                    object = (MaterialButton)object2.findViewById(R.id.slWatchPartyJoinBtn);
                    object.setText(R.string.slr_start);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
                    int n = ViewExtensionsKt.getDp(0.0f);
                    object.setPadding(n, n, n, n);
                    watchParty = object.getLayoutParams();
                    if (watchParty == null) break block20;
                    Object object9 = object;
                    ((ViewGroup.LayoutParams)watchParty).height = -2;
                    object9.setLayoutParams((ViewGroup.LayoutParams)watchParty);
                    object9.setMinWidth(ViewExtensionsKt.getDp(82.0f));
                    object9.setIcon(null);
                    object9.setEnabled(true);
                }
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }
    }

    private static final class WatchPartiesDiffUtil
    extends DiffUtil.Callback {
        @NotNull
        private final List<AnyListItem> oldItems;
        @NotNull
        private final List<AnyListItem> newItems;

        public WatchPartiesDiffUtil(@NotNull List<? extends AnyListItem> list, @NotNull List<? extends AnyListItem> list2) {
            Intrinsics.checkNotNullParameter(list, (String)"oldItems");
            Intrinsics.checkNotNullParameter(list2, (String)"newItems");
            this.oldItems = list;
            this.newItems = list2;
        }

        public boolean areItemsTheSame(int n, int n2) {
            AnyListItem anyListItem = object.oldItems.get(n);
            Object object = object.newItems.get(n2);
            return anyListItem instanceof WatchParty && object instanceof WatchParty && Intrinsics.areEqual((Object)((WatchParty)anyListItem).getData().getChatId(), (Object)((WatchParty)object).getData().getChatId()) || anyListItem instanceof Category && object instanceof Category && Intrinsics.areEqual((Object)((Category)anyListItem).getTitle(), (Object)((Category)object).getTitle()) || anyListItem instanceof ShareInvite && object instanceof ShareInvite && Intrinsics.areEqual((Object)((ShareInvite)anyListItem).getTitle(), (Object)((ShareInvite)object).getTitle()) || anyListItem instanceof Action && object instanceof Action;
        }

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean areContentsTheSame(int n, int n2) {
            void var2_4;
            void var1_2;
            AnyListItem anyListItem = this.oldItems.get((int)var1_2);
            AnyListItem anyListItem2 = this.newItems.get((int)var2_4);
            if (anyListItem instanceof WatchParty && anyListItem2 instanceof WatchParty) {
                WatchParty watchParty = (WatchParty)anyListItem;
                WatchParty watchParty2 = (WatchParty)anyListItem2;
                if (Intrinsics.areEqual((Object)watchParty.getData().getUpdatedAt(), (Object)watchParty2.getData().getUpdatedAt()) && Intrinsics.areEqual(watchParty.getData().getParticipants(), watchParty2.getData().getParticipants()) && Intrinsics.areEqual((Object)watchParty.getOwner(), (Object)watchParty2.getOwner()) && watchParty.isActive() == watchParty2.isActive()) {
                    if (Intrinsics.areEqual(watchParty.getParticipantStatuses(), watchParty2.getParticipantStatuses())) return true;
                }
            }
            if (anyListItem instanceof Category && anyListItem2 instanceof Category) {
                if (Intrinsics.areEqual((Object)((Category)anyListItem).getTitle(), (Object)((Category)anyListItem2).getTitle())) return true;
            }
            if (anyListItem instanceof ShareInvite) {
                if (anyListItem2 instanceof ShareInvite) return true;
            }
            if (!(anyListItem instanceof Action)) return false;
            if (!(anyListItem2 instanceof Action)) return false;
            if (!Intrinsics.areEqual((Object)((Action)anyListItem).getTitle(), (Object)((Action)anyListItem2).getTitle())) return false;
            return true;
        }
    }

    public static interface Listener {
        public void onWatchPartyClick(@NotNull Topic var1);

        public void onWatchPartyStartClick(@NotNull Topic var1);

        public void onWatchPartyJoinClick(@NotNull Topic var1);

        public void showMore();

        public static final class DefaultImpls {
            public static void showMore(@NotNull Listener listener2) {
                Intrinsics.checkNotNullParameter((Object)listener2, (String)"this");
            }
        }
    }
}

