/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.deeplink;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import androidx.fragment.app.FragmentActivity;
import com.google.gson.JsonSyntaxException;
import io.streamlayer.common.utils.GsonUtil;
import io.streamlayer.common.utils.NavigationUtils;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.base.InterfacesKt;
import io.streamlayer.sdk.deeplink.DeepLinkRoute;
import io.streamlayer.sdk.deeplink.ReferralLink;
import io.streamlayer.sdk.model.deeplink.DeepLink;
import io.streamlayer.sdk.model.deeplink.InviteData;
import io.streamlayer.sdk.model.deeplink.Payload;
import java.io.Serializable;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeepLinkHandler {
    @NotNull
    public static final DeepLinkHandler INSTANCE = new DeepLinkHandler();
    @NotNull
    private static final String DEEP_LINK_NAV_GRAPH_DATA = "deep_link_graph_data";
    @NotNull
    private static final String DEEP_LINK_PAYLOAD_DATA = "deep_link_payload_data";

    private DeepLinkHandler() {
    }

    private final DeepLink getDeepLink(Intent intent) {
        Object object = (Uri)intent.getParcelableExtra(DEEP_LINK_NAV_GRAPH_DATA);
        if (object == null) {
            object = null;
        } else {
            DeepLink deepLink;
            DeepLink deepLink2 = deepLink;
            deepLink = new DeepLink((Uri)object, (Payload)intent.getSerializableExtra(DEEP_LINK_PAYLOAD_DATA));
            object = deepLink2;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean handleDeepLink(@NotNull Intent intent, @NotNull FragmentActivity object) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)object, (String)"activity");
        Object object2 = intent.getData();
        if (!Intrinsics.areEqual((Object)(object2 == null ? null : object2.getScheme()), (Object)"streamlayer")) return false;
        object2 = InterfacesKt.findSdkHost((FragmentActivity)object);
        if (object2 == null) {
            object2 = null;
        } else {
            boolean bl;
            object = INSTANCE.getDeepLink(intent);
            if (object == null) {
                bl = false;
            } else {
                SLRLog.INSTANCE.i("DeepLinkHandler", "processDeepLink " + ((DeepLink)object).getUri() + ' ' + ((DeepLink)object).getPayload());
                object2.processDeepLink((DeepLink)object);
                intent.setData(null);
                bl = true;
            }
            object2 = bl;
        }
        if (object2 == null) throw new IllegalStateException("StreamLayerFragment or StreamLayerLiteFragment are not found! Please add android:tag=\"StreamLayerFragment\" to your FragmentContainerView");
        boolean bl = (Boolean)object2;
        return bl;
    }

    @Nullable
    public final InviteData getInvite(@NotNull String string2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"json");
        try {
            object = ((ReferralLink)GsonUtil.INSTANCE.getDefaultGson().fromJson(string2, ReferralLink.class)).getData();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            object = null;
        }
        return object;
    }

    public final void handleInvite(@NotNull InviteData inviteData, @NotNull Context object) {
        Payload.Invite invite2;
        Context context = object;
        DeepLinkHandler deepLinkHandler = object2;
        Context context2 = object;
        Intrinsics.checkNotNullParameter((Object)inviteData, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SLRLog.INSTANCE.i("DeepLinkHandler", Intrinsics.stringPlus((String)"handleReferralLink link=", (Object)inviteData));
        Object object2 = DeepLinkRoute.INVITE;
        object = invite2;
        invite2 = new Payload.Invite(inviteData);
        context.startActivity(deepLinkHandler.buildDeepLinkIntent$sdk_originalRelease(context2, (DeepLinkRoute)((Object)object2), NavigationUtils.INSTANCE.buildInviteDeepLink(), (Payload)object));
    }

    @NotNull
    public final Intent buildDeepLinkIntent$sdk_originalRelease(@NotNull Context context, @NotNull DeepLinkRoute deepLinkRoute, @Nullable Uri uri, @Nullable Payload payload) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)deepLinkRoute), (String)"route");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("streamlayer://" + context.getPackageName() + deepLinkRoute.getValue())));
        intent.putExtra(DEEP_LINK_NAV_GRAPH_DATA, (Parcelable)uri);
        intent.putExtra(DEEP_LINK_PAYLOAD_DATA, (Serializable)payload);
        return intent;
    }
}

