/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.adv;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.Color;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.fragment.app.FragmentContainerView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.common.views.alphavideoview.ChromaKeyVideoView;
import io.streamlayer.sdk.databinding.SlrFragmentStreamLayerBinding;
import io.streamlayer.sdk.main.AdvVideo;
import io.streamlayer.sdk.main.StreamLayerOverlayNavigator;
import io.streamlayer.sdk.main.adv.StreamLayerAdvHelper;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StreamLayerAdvHelper {
    @NotNull
    private final SlrFragmentStreamLayerBinding binding;
    @Nullable
    private final StreamLayerOverlayNavigator streamLayerMainOverlayNavigator;
    @NotNull
    private final Function0<Unit> onHide;

    public StreamLayerAdvHelper(@NotNull SlrFragmentStreamLayerBinding slrFragmentStreamLayerBinding, @Nullable StreamLayerOverlayNavigator streamLayerOverlayNavigator, @NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter((Object)slrFragmentStreamLayerBinding, (String)"binding");
        Intrinsics.checkNotNullParameter(function0, (String)"onHide");
        this.binding = slrFragmentStreamLayerBinding;
        this.streamLayerMainOverlayNavigator = streamLayerOverlayNavigator;
        this.onHide = function0;
    }

    private final void show() {
        StreamLayerAdvHelper streamLayerAdvHelper = streamLayerOverlayNavigator;
        FrameLayout frameLayout = streamLayerAdvHelper.binding.slAdvertisingVideoViewHolder;
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.slAdvertisingVideoViewHolder");
        ViewExtensionsKt.visible((View)frameLayout);
        FragmentContainerView fragmentContainerView = streamLayerAdvHelper.binding.slHomeNavHostFragment;
        Intrinsics.checkNotNullExpressionValue((Object)fragmentContainerView, (String)"binding.slHomeNavHostFragment");
        ViewExtensionsKt.invisible((View)fragmentContainerView);
        StreamLayerOverlayNavigator streamLayerOverlayNavigator = streamLayerAdvHelper.streamLayerMainOverlayNavigator;
        if (streamLayerOverlayNavigator != null) {
            streamLayerOverlayNavigator.onAdvertisingStarted();
        }
    }

    private final void hide() {
        StreamLayerAdvHelper streamLayerAdvHelper = this;
        FragmentContainerView fragmentContainerView = streamLayerAdvHelper.binding.slHomeNavHostFragment;
        Intrinsics.checkNotNullExpressionValue((Object)fragmentContainerView, (String)"binding.slHomeNavHostFragment");
        ViewExtensionsKt.visible((View)fragmentContainerView);
        streamLayerAdvHelper.binding.slHomeNavHostFragment.animate().alpha(1.0f).setDuration(200L).start();
        StreamLayerOverlayNavigator streamLayerOverlayNavigator = streamLayerAdvHelper.streamLayerMainOverlayNavigator;
        if (streamLayerOverlayNavigator != null) {
            streamLayerOverlayNavigator.onAdvertisingFinished();
        }
        this.onHide.invoke();
    }

    private final void showAdv(FrameLayout frameLayout, AdvVideo advVideo, Function0<Unit> function0) {
        block3: {
            ChromaKeyVideoView.OnVideoEndedListener onVideoEndedListener;
            ChromaKeyVideoView chromaKeyVideoView;
            ChromaKeyVideoView chromaKeyVideoView2;
            frameLayout.removeAllViews();
            ChromaKeyVideoView chromaKeyVideoView3 = chromaKeyVideoView2 = chromaKeyVideoView;
            int n = this.getColor(advVideo);
            Context context = frameLayout.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"videoHolder.context");
            chromaKeyVideoView3(n, context, null, 4, null);
            frameLayout.addView((View)chromaKeyVideoView3, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            chromaKeyVideoView2.onResume();
            try {
                Uri uri = Uri.parse((String)advVideo.getUrl());
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(video.url)");
                chromaKeyVideoView.setVideoFromUri(uri);
                chromaKeyVideoView.setOnVideoStartedListener(new ChromaKeyVideoView.OnVideoStartedListener(chromaKeyVideoView2){
                    final /* synthetic */ ChromaKeyVideoView $newVideoView;
                    {
                        this.$newVideoView = chromaKeyVideoView;
                    }

                    private static final void onVideoStarted$lambda-0(ChromaKeyVideoView chromaKeyVideoView) {
                        ChromaKeyVideoView chromaKeyVideoView2 = chromaKeyVideoView;
                        Intrinsics.checkNotNullParameter((Object)((Object)chromaKeyVideoView2), (String)"$newVideoView");
                        chromaKeyVideoView2.animate().alpha(1.0f).setDuration(100L).start();
                    }

                    public void onVideoStarted() {
                        showAdv.1 v0 = this;
                        v0.$newVideoView.setOnVideoStartedListener(null);
                        ChromaKeyVideoView chromaKeyVideoView = v0.$newVideoView;
                        chromaKeyVideoView.postDelayed(() -> showAdv.1.onVideoStarted$lambda-0(chromaKeyVideoView), 200L);
                    }
                });
                chromaKeyVideoView.start();
                if (function0 == null) break block3;
            }
            catch (Exception exception) {
                SLRLog.INSTANCE.e("StreamLayerAdvHelper", Intrinsics.stringPlus((String)"Load adv uri ", (Object)advVideo.getUrl()), exception);
                frameLayout.removeView((View)chromaKeyVideoView2);
                if (function0 != null) {
                    function0.invoke();
                }
                return;
            }
            ChromaKeyVideoView.OnVideoEndedListener onVideoEndedListener2 = onVideoEndedListener;
            onVideoEndedListener = new ChromaKeyVideoView.OnVideoEndedListener(function0, chromaKeyVideoView2, frameLayout){
                final /* synthetic */ Function0<Unit> $listener;
                final /* synthetic */ ChromaKeyVideoView $newVideoView;
                final /* synthetic */ FrameLayout $videoHolder;
                {
                    this.$listener = function0;
                    this.$newVideoView = chromaKeyVideoView;
                    this.$videoHolder = frameLayout;
                }

                public void onVideoEnded() {
                    showAdv.2.1 v0 = object;
                    v0.$listener.invoke();
                    v0.$newVideoView.setOnVideoEndedListener(null);
                    v0.$newVideoView.onPause();
                    v0.$newVideoView.stop();
                    showAdv.2.1 v1 = object;
                    Object object = v1.$newVideoView;
                    v0.$newVideoView.animate().alpha(0.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter((ChromaKeyVideoView)((Object)object), v1.$videoHolder){
                        final /* synthetic */ ChromaKeyVideoView $newVideoView;
                        final /* synthetic */ FrameLayout $videoHolder;
                        {
                            this.$newVideoView = chromaKeyVideoView;
                            this.$videoHolder = frameLayout;
                        }

                        public void onAnimationEnd(@Nullable Animator animator) {
                            showAdv.2.onVideoEnded.1 v0 = this;
                            v0.$newVideoView.animate().setListener(null);
                            ViewExtensionsKt.invisible((View)v0.$newVideoView);
                            v0.$videoHolder.removeView((View)this.$newVideoView);
                            v0.$newVideoView.release();
                        }
                    });
                }
            };
            chromaKeyVideoView2.setOnVideoEndedListener(onVideoEndedListener2);
        }
    }

    static /* synthetic */ void showAdv$default(StreamLayerAdvHelper streamLayerAdvHelper, FrameLayout frameLayout, AdvVideo advVideo, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        streamLayerAdvHelper.showAdv(frameLayout, advVideo, (Function0<Unit>)function0);
    }

    private final void hideAdv(FrameLayout frameLayout) {
        if (frameLayout.getChildCount() > 0 && frameLayout.getChildAt(0) instanceof ChromaKeyVideoView) {
            StreamLayerAdvHelper streamLayerAdvHelper = frameLayout.getChildAt(0);
            if (streamLayerAdvHelper != null) {
                FrameLayout frameLayout2 = frameLayout;
                ((ChromaKeyVideoView)((Object)streamLayerAdvHelper)).stop();
                ViewExtensionsKt.invisible((View)frameLayout2);
                frameLayout2.removeAllViews();
            } else {
                throw new NullPointerException("null cannot be cast to non-null type io.streamlayer.common.views.alphavideoview.ChromaKeyVideoView");
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getColor(AdvVideo advVideo) {
        Object object;
        block5: {
            try {
                // empty try
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                break block5;
            }
            {
                object = Result.constructor-impl((Object)Color.parseColor((String)Intrinsics.stringPlus((String)"#", (Object)advVideo.getBackgroundColor())));
            }
        }
        if (Result.isFailure-impl((Object)object)) {
            object = null;
        }
        if ((object = (Integer)object) == null) {
            return -16711936;
        }
        int n = (Integer)object;
        return n;
    }

    public static final /* synthetic */ void access$hide(StreamLayerAdvHelper streamLayerAdvHelper) {
        streamLayerAdvHelper.hide();
    }

    public final void start(@NotNull AdvVideo advVideo) {
        Function0<Unit> function0;
        StreamLayerAdvHelper streamLayerAdvHelper = this;
        Intrinsics.checkNotNullParameter((Object)advVideo, (String)"adv");
        streamLayerAdvHelper.show();
        FrameLayout frameLayout = streamLayerAdvHelper.binding.slAdvertisingVideoViewHolder;
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.slAdvertisingVideoViewHolder");
        Function0<Unit> function02 = function0;
        function0 = new Function0<Unit>(this){
            final /* synthetic */ StreamLayerAdvHelper this$0;
            {
                this.this$0 = streamLayerAdvHelper;
                super(0);
            }

            public final void invoke() {
                StreamLayerAdvHelper.access$hide(this.this$0);
            }
        };
        streamLayerAdvHelper.showAdv(frameLayout, advVideo, function02);
    }

    public final void stop() {
        StreamLayerAdvHelper streamLayerAdvHelper = this;
        FrameLayout frameLayout = streamLayerAdvHelper.binding.slAdvertisingVideoViewHolder;
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.slAdvertisingVideoViewHolder");
        streamLayerAdvHelper.hideAdv(frameLayout);
        streamLayerAdvHelper.hide();
    }
}

