/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.notifications;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.text.Layout;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import androidx.savedstate.ViewKt;
import com.google.android.material.imageview.ShapeableImageView;
import io.streamlayer.common.extensions.CoilExtensionsKt;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.utils.OtherUtilsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemNotificationBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationCustomBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationFactoidBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationFactoidTweetBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationPredictionsBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationPredictionsResultBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationWatchPartyBinding;
import io.streamlayer.sdk.databinding.SlrPredictionsBannerBinding;
import io.streamlayer.sdk.main.notifications.NotificationViewsKt;
import io.streamlayer.sdk.main.notifications.NotificationViewsProvider;
import io.streamlayer.sdk.main.notifications.NotificationViewsProvider$BaseNotificationView$showAnimate$lambda-8$;
import io.streamlayer.sdk.main.notifications.NotificationsLayout;
import io.streamlayer.sdk.main.notifications.NotificationsLayoutKt;
import io.streamlayer.sdk.main.notifications.PredictionsResultState;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationBuilder;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.model.predictions.QuestionNotification;
import io.streamlayer.sdk.model.predictions.TweetOptions;
import io.streamlayer.sdk.predictions.view.ExtensionsKt;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.Iterator;
import java.util.LinkedList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationViewsProvider {
    @NotNull
    private final NotificationsLayout.NotificationViewAction listener;
    @NotNull
    private final Resources resources;
    @NotNull
    private final LinkedList<NotificationsLayout.BaseNotificationView> notificationViewsPool;
    private final int bottomMargin;
    private final int startMargin;
    private int overlayHeight;

    public NotificationViewsProvider(@NotNull NotificationsLayout.NotificationViewAction notificationViewAction2, @NotNull Resources resources) {
        NotificationViewsProvider notificationViewsProvider = this;
        Intrinsics.checkNotNullParameter((Object)notificationViewAction2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        this.listener = notificationViewAction2;
        notificationViewsProvider.resources = resources;
        notificationViewsProvider.notificationViewsPool = new LinkedList();
        this.bottomMargin = resources.getDimensionPixelSize(R.dimen.slr_activity_vertical_margin);
        this.startMargin = resources.getDimensionPixelSize(R.dimen.slr_activity_vertical_margin_small);
    }

    public static final /* synthetic */ int access$getStartMargin$p(NotificationViewsProvider notificationViewsProvider) {
        return notificationViewsProvider.startMargin;
    }

    public final int getOverlayHeight() {
        return this.overlayHeight;
    }

    public final void setOverlayHeight(int n) {
        this.overlayHeight = n;
    }

    @NotNull
    public final NotificationsLayout.BaseNotificationView getNotificationView(@NotNull ViewGroup object, @NotNull Notification notification) {
        Object object2;
        block11: {
            block10: {
                Notification notification2 = notification;
                Intrinsics.checkNotNullParameter((Object)object, (String)"parent");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                notification = LayoutInflater.from((Context)object.getContext());
                switch (WhenMappings.$EnumSwitchMapping$0[notification2.getType().ordinal()]) {
                    default: {
                        NotificationView notificationView;
                        if (!((NotificationViewsProvider)this).notificationViewsPool.isEmpty()) break;
                        object2 = notificationView;
                        object = SlrItemNotificationBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationView = (NotificationViewsProvider)this.new NotificationView((SlrItemNotificationBinding)object);
                        break block10;
                    }
                    case 8: {
                        NotificationCustomViewHolder notificationCustomViewHolder;
                        object2 = notificationCustomViewHolder;
                        object = SlrItemNotificationCustomBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(\n               \u2026  false\n                )");
                        notificationCustomViewHolder = (NotificationViewsProvider)this.new NotificationCustomViewHolder((SlrItemNotificationCustomBinding)object);
                        break block11;
                    }
                    case 7: {
                        NotificationFactoidTweetView notificationFactoidTweetView;
                        object2 = notificationFactoidTweetView;
                        object = SlrItemNotificationFactoidTweetBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationFactoidTweetView = (NotificationViewsProvider)this.new NotificationFactoidTweetView((SlrItemNotificationFactoidTweetBinding)object);
                        break block11;
                    }
                    case 6: {
                        NotificationFactoidView notificationFactoidView;
                        object2 = notificationFactoidView;
                        object = SlrItemNotificationFactoidBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationFactoidView = (NotificationViewsProvider)this.new NotificationFactoidView((SlrItemNotificationFactoidBinding)object);
                        break block11;
                    }
                    case 5: {
                        NotificationPredictionsBannerView notificationPredictionsBannerView;
                        object2 = notificationPredictionsBannerView;
                        object = SlrPredictionsBannerBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationPredictionsBannerView = (NotificationViewsProvider)this.new NotificationPredictionsBannerView((SlrPredictionsBannerBinding)object);
                        break block11;
                    }
                    case 4: {
                        NotificationPredictionsResultView notificationPredictionsResultView;
                        object2 = notificationPredictionsResultView;
                        object = SlrItemNotificationPredictionsResultBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationPredictionsResultView = (NotificationViewsProvider)this.new NotificationPredictionsResultView((SlrItemNotificationPredictionsResultBinding)object);
                        break block11;
                    }
                    case 3: {
                        NotificationPredictionsView notificationPredictionsView;
                        object2 = notificationPredictionsView;
                        object = SlrItemNotificationPredictionsBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationPredictionsView = (NotificationViewsProvider)this.new NotificationPredictionsView((SlrItemNotificationPredictionsBinding)object);
                        break block11;
                    }
                    case 2: {
                        NotificationWatchPartyView notificationWatchPartyView;
                        object2 = notificationWatchPartyView;
                        object = SlrItemNotificationWatchPartyBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationWatchPartyView = (NotificationViewsProvider)this.new NotificationWatchPartyView((SlrItemNotificationWatchPartyBinding)object);
                        break block11;
                    }
                    case 1: {
                        NotificationFriendJoinToChatView notificationFriendJoinToChatView;
                        object2 = notificationFriendJoinToChatView;
                        object = SlrItemNotificationBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(\n               \u2026  false\n                )");
                        notificationFriendJoinToChatView = (NotificationViewsProvider)this.new NotificationFriendJoinToChatView((SlrItemNotificationBinding)object);
                        break block11;
                    }
                }
                object2 = this = ((NotificationViewsProvider)this).notificationViewsPool.removeFirst();
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n                if (no\u2026moveFirst()\n            }");
        }
        return object2;
    }

    public final void addToPool(@NotNull NotificationsLayout.BaseNotificationView baseNotificationView) {
        Intrinsics.checkNotNullParameter((Object)baseNotificationView, (String)"view");
        if (!this.notificationViewsPool.contains(baseNotificationView)) {
            this.notificationViewsPool.addLast(baseNotificationView);
        }
    }

    public final void clearPool(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        Iterator iterator = this.notificationViewsPool.iterator();
        while (iterator.hasNext()) {
            viewGroup.removeView(((NotificationsLayout.BaseNotificationView)iterator.next()).getBinding().getRoot());
        }
        this.notificationViewsPool.clear();
    }

    public final class NotificationTouchListener
    implements View.OnTouchListener {
        @NotNull
        private final Notification notification;
        private float dY;
        private float y1;
        private float y2;
        private final float swipeThreshold;

        public NotificationTouchListener(Notification notification) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            this.notification = notification;
            this.swipeThreshold = 50.0f;
        }

        @NotNull
        public final Notification getNotification() {
            return this.notification;
        }

        public boolean onTouch(@NotNull View view2, @NotNull MotionEvent motionEvent) {
            MotionEvent motionEvent2 = motionEvent;
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
            Intrinsics.checkNotNullParameter((Object)motionEvent2, (String)"motionEvent");
            int n = motionEvent2.getAction();
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        view2.setY(motionEvent.getRawY() + this.dY);
                    }
                } else {
                    NotificationTouchListener notificationTouchListener;
                    this.y2 = view2.getY();
                    if (Math.abs(Math.abs(notificationTouchListener.y1) - Math.abs(this.y2)) < this.swipeThreshold) {
                        if (NotificationViewsKt.access$isClickable(this.notification)) {
                            NotificationViewsProvider.this.listener.onExpand(this.notification, view2);
                        }
                    } else {
                        float f;
                        float f2 = this.y2;
                        if (f < this.y1 && Math.abs(Math.abs(f2) - Math.abs(this.y1)) > this.swipeThreshold) {
                            NotificationViewsProvider.this.listener.onHide(this.notification, view2);
                        } else {
                            float f3;
                            float f4 = this.y1;
                            if (f3 < this.y2 && Math.abs(Math.abs(f4) - Math.abs(this.y2)) > this.swipeThreshold) {
                                NotificationViewsProvider.this.listener.hideAll();
                            }
                        }
                    }
                }
            } else {
                this.dY = view2.getY() - motionEvent.getRawY();
                this.y1 = view2.getY();
            }
            return true;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public abstract class BaseNotificationView
    implements NotificationsLayout.BaseNotificationView {
        @NotNull
        private final Lazy isPortrait$delegate;
        final /* synthetic */ NotificationViewsProvider this$0;

        public BaseNotificationView(NotificationViewsProvider notificationViewsProvider) {
            NotificationViewsProvider notificationViewsProvider2 = notificationViewsProvider;
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider2, (String)"this$0");
            this.this$0 = notificationViewsProvider2;
            this.isPortrait$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
                final /* synthetic */ BaseNotificationView this$0;
                {
                    this.this$0 = baseNotificationView;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    Context context = this.this$0.getBinding().getRoot().getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                    return OtherExtensionsKt.isScreenPortrait(context);
                }
            });
        }

        private static final void prepareView$lambda-1(BaseNotificationView baseNotificationView, ConstraintLayout constraintLayout, NotificationViewsProvider notificationViewsProvider) {
            BaseNotificationView baseNotificationView2 = baseNotificationView;
            Intrinsics.checkNotNullParameter((Object)baseNotificationView, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"$parent");
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider, (String)"this$1");
            View view2 = baseNotificationView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"binding.root");
            ViewExtensionsKt.invisible(view2);
            View view3 = baseNotificationView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"binding.root");
            ViewGroup.LayoutParams layoutParams = view3.getLayoutParams();
            if (layoutParams != null) {
                int n = baseNotificationView.isPortrait() ? constraintLayout.getWidth() - ViewExtensionsKt.getDp(16.0f) : notificationViewsProvider.resources.getDimensionPixelSize(R.dimen.slr_notification_landscape_width);
                layoutParams.width = n;
                view3.setLayoutParams(layoutParams);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        private static final void showAnimate$lambda-8$lambda-4(View view2, ValueAnimator object) {
            View view3 = view2;
            Intrinsics.checkNotNullParameter((Object)view3, (String)"$view");
            ViewGroup.LayoutParams layoutParams = view3.getLayoutParams();
            if (layoutParams != null) {
                if ((object = object.getAnimatedValue()) != null) {
                    layoutParams.width = (Integer)object;
                    view2.setLayoutParams(layoutParams);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        protected final boolean isPortrait() {
            return (Boolean)this.isPortrait$delegate.getValue();
        }

        @Override
        public void prepareView(@NotNull ConstraintLayout constraintLayout) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().post(() -> BaseNotificationView.prepareView$lambda-1(this, constraintLayout, this.this$0));
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintLayout constraintLayout, @NotNull ConstraintSet constraintSet) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            constraintSet.setTranslationZ(this.getBinding().getRoot().getId(), 20.0f);
            NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            int n = this.getBinding().getRoot().getId();
            NotificationsLayoutKt.setBottomSide(constraintSet, n, this.this$0.bottomMargin);
        }

        public int getLandscapeWidth() {
            return this.this$0.resources.getDimensionPixelSize(R.dimen.slr_notification_landscape_width);
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            BaseNotificationView baseNotificationView = notificationViewsProvider;
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            View view2 = baseNotificationView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"binding.root");
            int n = baseNotificationView.isPortrait() ? constraintLayout.getWidth() - ViewExtensionsKt.getDp(16.0f) : ((BaseNotificationView)((Object)notificationViewsProvider)).getLandscapeWidth();
            ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, n});
            NotificationViewsProvider notificationViewsProvider = ((BaseNotificationView)((Object)notificationViewsProvider)).this$0;
            valueAnimator.setDuration(400L);
            valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            valueAnimator.addUpdateListener(arg_0 -> BaseNotificationView.showAnimate$lambda-8$lambda-4(view2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"");
            valueAnimator.addListener(new Animator.AnimatorListener(view2){
                final /* synthetic */ View $view$inlined;
                {
                    this.$view$inlined = view2;
                }

                public void onAnimationRepeat(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationEnd(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationCancel(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    BaseNotificationView$showAnimate$lambda-8$$inlined$doOnStart$1 v0 = this;
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    ViewExtensionsKt.visible(v0.$view$inlined);
                    v0.$view$inlined.animate().alpha(1.0f).translationX(-20.0f).setStartDelay(200L).setDuration(200L).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).withEndAction(new Runnable(this.$view$inlined){
                        final /* synthetic */ View $view;
                        {
                            this.$view = view2;
                        }

                        public final void run() {
                            this.$view.animate().translationX(0.0f).setDuration(200L).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).start();
                        }
                    }).start();
                }
            });
            valueAnimator.addListener(new Animator.AnimatorListener(view2, function0, notificationViewsProvider){
                final /* synthetic */ View $view$inlined;
                final /* synthetic */ Function0 $onEnd$inlined;
                final /* synthetic */ NotificationViewsProvider this$0;
                {
                    this.$view$inlined = view2;
                    this.$onEnd$inlined = function0;
                    this.this$0 = notificationViewsProvider;
                }

                public void onAnimationRepeat(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationEnd(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    animator = this.$view$inlined;
                    ViewGroup.LayoutParams layoutParams = animator.getLayoutParams();
                    if (layoutParams != null) {
                        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
                        int n = NotificationViewsProvider.access$getStartMargin$p(this.this$0);
                        int n2 = marginLayoutParams.topMargin;
                        int n3 = NotificationViewsProvider.access$getStartMargin$p(this.this$0);
                        int n4 = marginLayoutParams.bottomMargin;
                        marginLayoutParams.setMargins(n, n2, n3, n4);
                        animator.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
                        Function0 function0 = this.$onEnd$inlined;
                        if (function0 != null) {
                            function0.invoke();
                        }
                        return;
                    }
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                }

                public void onAnimationCancel(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }
            });
            valueAnimator.start();
        }

        @Override
        public void clear() {
            NotificationsLayout.BaseNotificationView.DefaultImpls.clear(this);
        }
    }

    public final class NotificationWatchPartyView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationWatchPartyBinding binding;

        public NotificationWatchPartyView(SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationWatchPartyBinding, (String)"binding");
            super(NotificationViewsProvider.this);
            this.binding = slrItemNotificationWatchPartyBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationWatchPartyBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            NotificationWatchPartyView notificationWatchPartyView = this;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding = notificationWatchPartyView.getBinding();
            NotificationViewsProvider notificationViewsProvider = notificationWatchPartyView.NotificationViewsProvider.this;
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding2 = slrItemNotificationWatchPartyBinding;
            slrItemNotificationWatchPartyBinding2.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            slrItemNotificationWatchPartyBinding2.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            if (WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()] == 1) {
                slrItemNotificationWatchPartyBinding = slrItemNotificationWatchPartyBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationWatchPartyBinding, (String)"slNotifIconIV");
                Object object = notification.getNotificationIcon();
                object = object == null ? null : ((NotificationIcon)object).getAvatarUrl();
                Object object2 = notification.getNotificationIcon();
                object2 = object2 == null ? null : ((NotificationIcon)object2).getAvatarName();
                ProfileExtensionsKt.loadUserAvatar$default((ImageView)slrItemNotificationWatchPartyBinding, (String)object, (String)object2, null, 4, null);
            } else {
                AppCompatImageView appCompatImageView = slrItemNotificationWatchPartyBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                CoilExtensionsKt.clear((ImageView)appCompatImageView, bind.1.1.INSTANCE);
            }
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                nArray[NotificationType.WatchParty.ordinal()] = 1;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    public class NotificationView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationBinding binding;

        public NotificationView(SlrItemNotificationBinding slrItemNotificationBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationBinding, (String)"binding");
            super(NotificationViewsProvider.this);
            this.binding = slrItemNotificationBinding;
        }

        private final void setPadding(View view2, NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    n = 0;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n = ViewExtensionsKt.getDp(4.0f);
                }
            }
            int n2 = n;
            view2.setPadding(n2, n2, n2, n2);
        }

        @DrawableRes
        private final int getIcon(NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: {
                    n = 0;
                    break;
                }
                case 9: 
                case 15: {
                    n = R.drawable.slr_ic_watch_party_centered;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n = R.drawable.slr_ic_profile;
                    break;
                }
                case 5: {
                    n = R.drawable.slr_ic_betting;
                    break;
                }
                case 3: {
                    n = R.drawable.slr_ic_twitter;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n = R.drawable.slr_ic_chat;
                }
            }
            return n;
        }

        @ColorRes
        private final int getColor(NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 16: {
                    n = 0;
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    n = 17170445;
                    break;
                }
                case 9: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 5: {
                    n = R.color.slr_orange;
                    break;
                }
                case 4: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 3: {
                    n = R.color.slr_twitter;
                    break;
                }
                case 2: {
                    Context context = this.getBinding().getRoot().getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                    n = ViewExtensionsKt.resoleAttributeResId(context, R.attr.slrNotificationIconColor, R.color.slr_primaryBlue);
                    break;
                }
                case 1: {
                    n = R.color.slr_primaryBlue;
                }
            }
            return n;
        }

        public static final /* synthetic */ void access$setPadding(NotificationView notificationView, View view2, NotificationType notificationType) {
            notificationView.setPadding(view2, notificationType);
        }

        public static final /* synthetic */ int access$getIcon(NotificationView notificationView, NotificationType notificationType) {
            return notificationView.getIcon(notificationType);
        }

        @Override
        @NotNull
        public SlrItemNotificationBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationBinding slrItemNotificationBinding = this.getBinding();
            NotificationViewsProvider notificationViewsProvider = NotificationViewsProvider.this;
            slrItemNotificationBinding.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            Object object = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"slNotifTitleTV");
            String string2 = notification.getTitle();
            boolean bl = string2 == null || string2.length() == 0;
            ViewExtensionsKt.visibleIf((View)object, bl ^ true);
            slrItemNotificationBinding.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            object = notification.getDescription();
            boolean bl2 = object == null || object.length() == 0;
            bl2 ^= true;
            Object object2 = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifTitleTV");
            ViewGroup.LayoutParams layoutParams = object2.getLayoutParams();
            if (layoutParams != null) {
                Unit unit;
                layoutParams = (ConstraintLayout.LayoutParams)layoutParams;
                int n = bl2 ? 0 : slrItemNotificationBinding.slNotifIconIV.getId();
                layoutParams.topToTop = n;
                n = bl2 ? ViewExtensionsKt.getDp(4.0f) : 0;
                layoutParams.topMargin = n;
                n = bl2 ? -1 : slrItemNotificationBinding.slNotifIconIV.getId();
                layoutParams.bottomToBottom = n;
                object2.setLayoutParams(layoutParams);
                AppCompatTextView appCompatTextView = slrItemNotificationBinding.slNotifDescriptionTV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slNotifDescriptionTV");
                ViewExtensionsKt.visibleIf((View)appCompatTextView, bl2);
                Object object3 = notification.getNotificationIcon();
                if (object3 == null) {
                    unit = null;
                } else {
                    if (((NotificationIcon)object3).getAvatarName() != null) {
                        object2 = slrItemNotificationBinding.slNotifIconIV;
                        NotificationIcon notificationIcon = object3;
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifIconIV");
                        object3 = notificationIcon.getAvatarUrl();
                        ProfileExtensionsKt.loadUserAvatar$default((ImageView)object2, (String)object3, notificationIcon.getAvatarName(), null, 4, null);
                    } else if (((NotificationIcon)object3).getAvatarUrl() != null) {
                        Function1<Boolean, Unit> function1;
                        AppCompatImageView appCompatImageView = slrItemNotificationBinding.slNotifIconIV;
                        object2 = appCompatImageView;
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifIconIV");
                        object3 = ((NotificationIcon)object3).getAvatarUrl();
                        Intrinsics.checkNotNull((Object)object3);
                        object2 = this.getIcon(notification.getType());
                        Object object4 = object3;
                        object3 = function1;
                        function1 = new Function1<Boolean, Unit>(this, slrItemNotificationBinding, notification){
                            final /* synthetic */ NotificationView this$0;
                            final /* synthetic */ SlrItemNotificationBinding $this_with;
                            final /* synthetic */ Notification $data;
                            {
                                this.this$0 = notificationView;
                                this.$this_with = slrItemNotificationBinding;
                                this.$data = notification;
                                super(1);
                            }

                            public final void invoke(boolean bl) {
                                if (!bl) {
                                    AppCompatImageView appCompatImageView = this.$this_with.slNotifIconIV;
                                    Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                                    NotificationView.access$setPadding(this.this$0, (View)appCompatImageView, this.$data.getType());
                                }
                            }
                        };
                        ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)object4, false, (Integer)object2, (Function1)object3, 2, null);
                    }
                    slrItemNotificationBinding.slNotifIconIV.setBackgroundTintList(null);
                    unit = Unit.INSTANCE;
                }
                if (unit == null) {
                    SlrItemNotificationBinding slrItemNotificationBinding2 = slrItemNotificationBinding = slrItemNotificationBinding.slNotifIconIV;
                    Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationBinding2, (String)"");
                    CoilExtensionsKt.clear((ImageView)slrItemNotificationBinding2, (Function1<? super ImageView, Unit>)new Function1<ImageView, Unit>(this, notification){
                        final /* synthetic */ NotificationView this$0;
                        final /* synthetic */ Notification $data;
                        {
                            this.this$0 = notificationView;
                            this.$data = notification;
                            super(1);
                        }

                        public final void invoke(@NotNull ImageView imageView) {
                            Intrinsics.checkNotNullParameter((Object)imageView, (String)"$this$clear");
                            imageView.setImageResource(NotificationView.access$getIcon(this.this$0, this.$data.getType()));
                        }
                    });
                    this.setPadding((View)slrItemNotificationBinding, notification.getType());
                    slrItemNotificationBinding.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)slrItemNotificationBinding.getContext(), (int)this.getColor(notification.getType()))));
                    Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationBinding, (String)"run {\n                  \u2026      }\n                }");
                }
                this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }

        @Override
        public void clear() {
            SlrItemNotificationBinding slrItemNotificationBinding = this.getBinding();
            slrItemNotificationBinding.slNotifTitleTV.setText(null);
            AppCompatTextView appCompatTextView = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slNotifTitleTV");
            ViewExtensionsKt.gone((View)appCompatTextView);
            slrItemNotificationBinding.slNotifDescriptionTV.setText(null);
            AppCompatTextView appCompatTextView2 = slrItemNotificationBinding.slNotifDescriptionTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView2, (String)"slNotifDescriptionTV");
            ViewExtensionsKt.gone((View)appCompatTextView2);
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                nArray[NotificationType.Universal.ordinal()] = 1;
                nArray[NotificationType.Chat.ordinal()] = 2;
                nArray[NotificationType.Twitter.ordinal()] = 3;
                nArray[NotificationType.Alert.ordinal()] = 4;
                nArray[NotificationType.Inplay.ordinal()] = 5;
                nArray[NotificationType.ArrivingFriend.ordinal()] = 6;
                nArray[NotificationType.JoinToChat.ordinal()] = 7;
                nArray[NotificationType.WaveReply.ordinal()] = 8;
                nArray[NotificationType.CreateNewWatchParty.ordinal()] = 9;
                nArray[NotificationType.Prediction.ordinal()] = 10;
                nArray[NotificationType.PredictionResult.ordinal()] = 11;
                nArray[NotificationType.PredictionOnboarding.ordinal()] = 12;
                nArray[NotificationType.Factoid.ordinal()] = 13;
                nArray[NotificationType.FactoidTweet.ordinal()] = 14;
                nArray[NotificationType.WatchParty.ordinal()] = 15;
                nArray[NotificationType.Custom.ordinal()] = 16;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class NotificationFriendJoinToChatView
    extends NotificationView {
        public NotificationFriendJoinToChatView(SlrItemNotificationBinding slrItemNotificationBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationBinding, (String)"binding");
            super(slrItemNotificationBinding);
        }

        private static final void showAnimate$lambda-2(NotificationFriendJoinToChatView notificationFriendJoinToChatView) {
            NotificationFriendJoinToChatView notificationFriendJoinToChatView2 = notificationFriendJoinToChatView;
            Intrinsics.checkNotNullParameter((Object)notificationFriendJoinToChatView2, (String)"this$0");
            ConstraintLayout constraintLayout = notificationFriendJoinToChatView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            ViewExtensionsKt.visible((View)constraintLayout);
        }

        private static final void prepareView$lambda-5(NotificationFriendJoinToChatView notificationFriendJoinToChatView, NotificationViewsProvider notificationViewsProvider) {
            Intrinsics.checkNotNullParameter((Object)notificationFriendJoinToChatView, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider, (String)"this$1");
            notificationFriendJoinToChatView = notificationFriendJoinToChatView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)notificationFriendJoinToChatView, (String)"binding.root");
            ViewGroup.LayoutParams layoutParams = notificationFriendJoinToChatView.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.width = notificationViewsProvider.resources.getDimensionPixelSize(R.dimen.slr_overlay_content_landscape_width) - ViewExtensionsKt.getDp(12.0f);
                notificationFriendJoinToChatView.setLayoutParams(layoutParams);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        @Override
        public void bind(@NotNull Notification notification) {
            StyleSpan styleSpan;
            SpannableStringBuilder spannableStringBuilder;
            NotificationFriendJoinToChatView notificationFriendJoinToChatView = notificationFriendJoinToChatView3;
            Notification notification2 = notification;
            Intrinsics.checkNotNullParameter((Object)notification2, (String)"item");
            super.bind(notification2);
            SpannableStringBuilder spannableStringBuilder2 = spannableStringBuilder;
            NotificationFriendJoinToChatView notificationFriendJoinToChatView2 = notificationFriendJoinToChatView3;
            SpannableStringBuilder spannableStringBuilder3 = spannableStringBuilder2;
            SpannableStringBuilder spannableStringBuilder4 = spannableStringBuilder2;
            spannableStringBuilder4();
            NotificationFriendJoinToChatView notificationFriendJoinToChatView3 = styleSpan;
            styleSpan = new StyleSpan(1);
            int n = spannableStringBuilder4.length();
            spannableStringBuilder3.append((CharSequence)notification.getTitle());
            int n2 = spannableStringBuilder3.length();
            spannableStringBuilder3.setSpan((Object)notificationFriendJoinToChatView3, n, n2, 17);
            notificationFriendJoinToChatView3 = spannableStringBuilder.append((CharSequence)Intrinsics.stringPlus((String)" ", (Object)notificationFriendJoinToChatView2.NotificationViewsProvider.this.resources.getText(R.string.slr_messaging_chat_friend_joined_template)));
            SlrItemNotificationBinding slrItemNotificationBinding = notificationFriendJoinToChatView.getBinding();
            slrItemNotificationBinding.slNotifTitleTV.setText((CharSequence)((Object)notificationFriendJoinToChatView3));
            slrItemNotificationBinding.getRoot().setOnTouchListener(null);
            slrItemNotificationBinding.slNotification.setBackground(ContextCompat.getDrawable((Context)slrItemNotificationBinding.getRoot().getContext(), (int)R.drawable.slr_bg_notification_friend_arrived));
            slrItemNotificationBinding.slNotifIconIV.setBackground(null);
            slrItemNotificationBinding.slNotifTitleTV.setTextColor(ContextCompat.getColor((Context)slrItemNotificationBinding.getRoot().getContext(), (int)R.color.slr_white));
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().animate().translationX(0.0f).setDuration(400L).withStartAction(() -> NotificationFriendJoinToChatView.showAnimate$lambda-2(this)).start();
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintLayout constraintLayout, @NotNull ConstraintSet constraintSet) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            constraintSet.setTranslationZ(this.getBinding().getRoot().getId(), 20.0f);
            constraintSet.setTranslationX(this.getBinding().getRoot().getId(), (float)constraintLayout.getWidth());
            if (this.isPortrait()) {
                NotificationsLayoutKt.setTopSide(constraintSet, this.getBinding().getRoot().getId(), ViewExtensionsKt.getDp(75.0f));
                NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            } else {
                NotificationsLayoutKt.setTopSide(constraintSet, this.getBinding().getRoot().getId(), ViewExtensionsKt.getDp(60.0f));
            }
            NotificationsLayoutKt.setStartSide(constraintSet, this.getBinding().getRoot().getId(), 0);
        }

        @Override
        public void prepareView(@NotNull ConstraintLayout constraintLayout) {
            NotificationFriendJoinToChatView notificationFriendJoinToChatView = this;
            ConstraintLayout constraintLayout2 = constraintLayout;
            Intrinsics.checkNotNullParameter((Object)constraintLayout2, (String)"parent");
            super.prepareView(constraintLayout2);
            if (!notificationFriendJoinToChatView.isPortrait()) {
                NotificationFriendJoinToChatView notificationFriendJoinToChatView2 = this;
                this.getBinding().getRoot().post(() -> NotificationFriendJoinToChatView.prepareView$lambda-5(notificationFriendJoinToChatView2, notificationFriendJoinToChatView2.NotificationViewsProvider.this));
            }
        }
    }

    public abstract class BaseNotificationPredictionsView
    extends BaseNotificationView {
        @NotNull
        private final NotificationType type;

        public BaseNotificationPredictionsView(NotificationType notificationType) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)notificationType), (String)"type");
            super(NotificationViewsProvider.this);
            this.type = notificationType;
        }

        @NotNull
        public final NotificationType getType() {
            return this.type;
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintLayout constraintLayout, @NotNull ConstraintSet constraintSet) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            boolean bl = NotificationViewsKt.isLikePrediction(this.type);
            BaseNotificationPredictionsView baseNotificationPredictionsView = this;
            NotificationViewsProvider notificationViewsProvider = baseNotificationPredictionsView.NotificationViewsProvider.this;
            int n = baseNotificationPredictionsView.getBinding().getRoot().getId();
            float f = bl ? 30.0f : 20.0f;
            constraintSet.setTranslationZ(n, f);
            if (bl) {
                NotificationsLayoutKt.setStartSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            }
            if (bl && this.isPortrait() || !bl) {
                NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            }
            Context context = this.getBinding().getRoot().getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
            if (OtherExtensionsKt.isScreenPortrait(context) && bl && this.getType() != NotificationType.Factoid && this.getType() != NotificationType.FactoidTweet) {
                NotificationsLayoutKt.setTopSide(constraintSet, this.getBinding().getRoot().getId(), ViewExtensionsKt.getDp(22.0f));
            } else {
                int n2 = this.getBinding().getRoot().getId();
                NotificationsLayoutKt.setBottomSide(constraintSet, n2, notificationViewsProvider.bottomMargin);
            }
        }

        protected final void showAnimatePortrait() {
            View view2 = this.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"binding.root");
            ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
            if (layoutParams != null) {
                BaseNotificationPredictionsView baseNotificationPredictionsView = this;
                ((ViewGroup.MarginLayoutParams)layoutParams).height = -2;
                view2.setLayoutParams((ViewGroup.LayoutParams)((ViewGroup.MarginLayoutParams)layoutParams));
                baseNotificationPredictionsView.getBinding().getRoot().setAlpha(0.0f);
                baseNotificationPredictionsView.getBinding().getRoot().setTranslationX(-((float)this.getBinding().getRoot().getContext().getResources().getDisplayMetrics().widthPixels));
                View view3 = baseNotificationPredictionsView.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"binding.root");
                ViewExtensionsKt.visible(view3);
                baseNotificationPredictionsView.getBinding().getRoot().animate().setDuration(500L).alpha(1.0f).translationX(0.0f).start();
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class NotificationPredictionsView
    extends BaseNotificationPredictionsView {
        @NotNull
        private final SlrItemNotificationPredictionsBinding binding;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public NotificationPredictionsView(SlrItemNotificationPredictionsBinding slrItemNotificationPredictionsBinding) {
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsView.NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationPredictionsBinding, (String)"binding");
            super(NotificationType.Prediction);
            notificationPredictionsView.binding = slrItemNotificationPredictionsBinding;
            if (notificationPredictionsView.isPortrait()) return;
            notificationPredictionsView.NotificationViewsProvider.this = notificationPredictionsView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)notificationPredictionsView.NotificationViewsProvider.this, (String)"binding.root");
            slrItemNotificationPredictionsBinding = notificationPredictionsView.NotificationViewsProvider.this.getLayoutParams();
            if (slrItemNotificationPredictionsBinding == null) throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
            ((ViewGroup.LayoutParams)slrItemNotificationPredictionsBinding).width = notificationPredictionsView.getBinding().getRoot().getContext().getResources().getDimensionPixelSize(R.dimen.slr_predictions_notification_landscape_width);
            notificationPredictionsView.NotificationViewsProvider.this.setLayoutParams((ViewGroup.LayoutParams)slrItemNotificationPredictionsBinding);
            notificationPredictionsView.NotificationViewsProvider.this = notificationPredictionsView.getBinding().slNotification;
            Intrinsics.checkNotNullExpressionValue((Object)notificationPredictionsView.NotificationViewsProvider.this, (String)"binding.slNotification");
            slrItemNotificationPredictionsBinding = notificationPredictionsView.NotificationViewsProvider.this.getLayoutParams();
            if (slrItemNotificationPredictionsBinding == null) throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
            NotificationPredictionsView notificationPredictionsView = (ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding;
            ((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding).topToTop = -1;
            ((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding).bottomToBottom = 0;
            notificationPredictionsView.NotificationViewsProvider.this.setLayoutParams((ViewGroup.LayoutParams)notificationPredictionsView);
        }

        private static final void showAnimate$lambda-9$lambda-8$lambda-7(ValueAnimator object, NotificationPredictionsView notificationPredictionsView, ValueAnimator valueAnimator) {
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsView, (String)"this$0");
            object = object.getAnimatedValue();
            if (object != null) {
                int n = (Integer)object;
                valueAnimator = notificationPredictionsView.getBinding().slrNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"binding.slrNotificationIcon");
                boolean bl = n > ViewExtensionsKt.getDp(73.0f);
                ViewExtensionsKt.visibleIf((View)valueAnimator, bl);
                notificationPredictionsView = notificationPredictionsView.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)notificationPredictionsView, (String)"binding.root");
                valueAnimator = notificationPredictionsView.getLayoutParams();
                if (valueAnimator != null) {
                    valueAnimator.width = n;
                    notificationPredictionsView.setLayoutParams((ViewGroup.LayoutParams)valueAnimator);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }

        private static final void showAnimate$lambda-9(NotificationPredictionsView notificationPredictionsView) {
            NotificationPredictionsView notificationPredictionsView2 = notificationPredictionsView;
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsView2, (String)"this$0");
            if (!notificationPredictionsView2.isPortrait()) {
                NotificationPredictionsView notificationPredictionsView3 = notificationPredictionsView;
                ConstraintLayout constraintLayout = notificationPredictionsView3.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                ViewExtensionsKt.visible((View)constraintLayout);
                ConstraintLayout constraintLayout2 = notificationPredictionsView3.getBinding().slNotification;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"binding.slNotification");
                ViewExtensionsKt.invisible((View)constraintLayout2);
                ImageView imageView = notificationPredictionsView3.getBinding().slrNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slrNotificationIcon");
                ViewExtensionsKt.invisible((View)imageView);
                ImageView imageView2 = notificationPredictionsView3.getBinding().slrLeftSide;
                Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.slrLeftSide");
                ViewExtensionsKt.invisible((View)imageView2);
                int n = (int)notificationPredictionsView3.getBinding().getRoot().getContext().getResources().getDimension(R.dimen.slr_predictions_notification_landscape_width);
                ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, n});
                valueAnimator.setDuration(300L);
                valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(notificationPredictionsView){
                    final /* synthetic */ NotificationPredictionsView this$0;
                    {
                        this.this$0 = notificationPredictionsView;
                    }

                    public void onAnimationStart(@NotNull Animator animator) {
                        showAnimate.1.1.1 v0 = this;
                        Intrinsics.checkNotNullParameter((Object)animator, (String)"var1");
                        ConstraintLayout constraintLayout = v0.this$0.getBinding().slNotification;
                        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.slNotification");
                        ViewExtensionsKt.visible((View)constraintLayout);
                        ImageView imageView = v0.this$0.getBinding().slrLeftSide;
                        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slrLeftSide");
                        ViewExtensionsKt.visible((View)imageView);
                    }
                });
                valueAnimator.addUpdateListener(arg_0 -> NotificationPredictionsView.showAnimate$lambda-9$lambda-8$lambda-7(valueAnimator, notificationPredictionsView, arg_0));
                valueAnimator.start();
            } else {
                notificationPredictionsView.showAnimatePortrait();
            }
        }

        @Override
        @NotNull
        public SlrItemNotificationPredictionsBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            block10: {
                NotificationViewsProvider notificationViewsProvider;
                block9: {
                    NotificationPredictionsView notificationPredictionsView = slrItemNotificationPredictionsBinding;
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
                    SlrItemNotificationPredictionsBinding slrItemNotificationPredictionsBinding = notificationPredictionsView.getBinding();
                    notificationViewsProvider = notificationPredictionsView.NotificationViewsProvider.this;
                    slrItemNotificationPredictionsBinding.slrQuestionText.setText((CharSequence)notification.getTitle());
                    Object object = QuestionNotification.Companion.deserialize(notification.getDataJson());
                    String string2 = object == null ? null : ((QuestionNotification)object).getImage();
                    if (string2 != null) {
                        ImageView imageView = slrItemNotificationPredictionsBinding.slrNotificationIcon;
                        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slrNotificationIcon");
                        ExtensionsKt.load(imageView, string2);
                    } else {
                        slrItemNotificationPredictionsBinding.slrNotificationIcon.setImageResource(0);
                    }
                    if (object == null || (object = ((QuestionNotification)object).getIndicatorColor()) == null) break block9;
                    Object object2 = object;
                    try {
                        object = Result.constructor-impl((Object)Color.parseColor((String)object2));
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    if (Result.isFailure-impl((Object)object)) {
                        object = null;
                    }
                    if ((object = (Integer)object) == null) break block9;
                    int n = ((Number)object).intValue();
                    string2 = slrItemNotificationPredictionsBinding.slrLeftSide.getBackground();
                    if (string2 == null) break block10;
                    ((LayerDrawable)string2).getDrawable(0).setTint(n);
                }
                slrItemNotificationPredictionsBinding.getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().post(() -> NotificationPredictionsView.showAnimate$lambda-9(this));
        }
    }

    public final class NotificationPredictionsBannerView
    extends BaseNotificationView {
        @NotNull
        private final SlrPredictionsBannerBinding binding;

        public NotificationPredictionsBannerView(SlrPredictionsBannerBinding slrPredictionsBannerBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrPredictionsBannerBinding, (String)"binding");
            super(NotificationViewsProvider.this);
            this.binding = slrPredictionsBannerBinding;
        }

        @Override
        @NotNull
        public SlrPredictionsBannerBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)new NotificationTouchListener(notification));
        }

        @Override
        public int getLandscapeWidth() {
            return NotificationViewsProvider.this.resources.getDimensionPixelSize(R.dimen.slr_notification_onboarding_landscape_width);
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintLayout object, @NotNull ConstraintSet constraintSet) {
            NotificationPredictionsBannerView notificationPredictionsBannerView = this;
            NotificationPredictionsBannerView notificationPredictionsBannerView2 = this;
            Intrinsics.checkNotNullParameter((Object)object, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            object = notificationPredictionsBannerView2.NotificationViewsProvider.this;
            constraintSet.setTranslationZ(notificationPredictionsBannerView2.getBinding().getRoot().getId(), 30.0f);
            int n = notificationPredictionsBannerView.getBinding().getRoot().getId();
            int n2 = notificationPredictionsBannerView.isPortrait() ? 0 : ViewExtensionsKt.getDp(20.0f);
            NotificationsLayoutKt.setStartSide(constraintSet, n, n2);
            NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            int n3 = this.getBinding().getRoot().getId();
            NotificationsLayoutKt.setBottomSide(constraintSet, n3, ((NotificationViewsProvider)object).bottomMargin);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class NotificationPredictionsResultView
    extends BaseNotificationPredictionsView {
        @NotNull
        private final SlrItemNotificationPredictionsResultBinding binding;

        public NotificationPredictionsResultView(SlrItemNotificationPredictionsResultBinding slrItemNotificationPredictionsResultBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationPredictionsResultBinding, (String)"binding");
            super(NotificationType.PredictionResult);
            this.binding = slrItemNotificationPredictionsResultBinding;
        }

        private final void saveChangedState(PredictionsResultState predictionsResultState) {
            ConstraintLayout constraintLayout = notificationPredictionsResultView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            NotificationPredictionsResultView notificationPredictionsResultView = ViewKt.findViewTreeSavedStateRegistryOwner((View)constraintLayout);
            if (notificationPredictionsResultView != null && (notificationPredictionsResultView = notificationPredictionsResultView.getSavedStateRegistry()) != null) {
                notificationPredictionsResultView.registerSavedStateProvider("predictions_result_state", () -> NotificationPredictionsResultView.saveChangedState$lambda-1(predictionsResultState));
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final PredictionsResultState getState() {
            int n;
            ConstraintLayout constraintLayout = notificationPredictionsResultView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            NotificationPredictionsResultView notificationPredictionsResultView = ViewKt.findViewTreeSavedStateRegistryOwner((View)constraintLayout);
            if (notificationPredictionsResultView != null && (notificationPredictionsResultView = notificationPredictionsResultView.getSavedStateRegistry()) != null && (notificationPredictionsResultView = notificationPredictionsResultView.consumeRestoredStateForKey("predictions_result_state")) != null) {
                n = notificationPredictionsResultView.getInt("predictions_result_state");
                return PredictionsResultState.values()[n];
            }
            n = 0;
            return PredictionsResultState.values()[n];
        }

        private final void startStateController(PredictionsResultState predictionsResultState, boolean bl) {
            NotificationPredictionsResultView notificationPredictionsResultView = this;
            notificationPredictionsResultView.applyState(predictionsResultState);
            notificationPredictionsResultView.getBinding().getRoot().postDelayed(() -> NotificationPredictionsResultView.startStateController$lambda-8(predictionsResultState, bl, this), 5000L);
        }

        private final void applyState(PredictionsResultState predictionsResultState) {
            NotificationPredictionsResultView notificationPredictionsResultView = this;
            TextView textView = notificationPredictionsResultView.getBinding().slQuestionText;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slQuestionText");
            ViewExtensionsKt.invisible((View)textView);
            TextView textView2 = notificationPredictionsResultView.getBinding().slCongratulations;
            Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.slCongratulations");
            ViewExtensionsKt.invisible((View)textView2);
            TextView textView3 = notificationPredictionsResultView.getBinding().slCorrectAnswerTitle;
            Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"binding.slCorrectAnswerTitle");
            ViewExtensionsKt.invisible((View)textView3);
            TextView textView4 = notificationPredictionsResultView.getBinding().slCorrectAnswerText;
            Intrinsics.checkNotNullExpressionValue((Object)textView4, (String)"binding.slCorrectAnswerText");
            ViewExtensionsKt.invisible((View)textView4);
            TextView textView5 = notificationPredictionsResultView.getBinding().slLooseText1;
            Intrinsics.checkNotNullExpressionValue((Object)textView5, (String)"binding.slLooseText1");
            ViewExtensionsKt.invisible((View)textView5);
            TextView textView6 = notificationPredictionsResultView.getBinding().slLooseText2;
            Intrinsics.checkNotNullExpressionValue((Object)textView6, (String)"binding.slLooseText2");
            ViewExtensionsKt.invisible((View)textView6);
            ImageView imageView = notificationPredictionsResultView.getBinding().slRightIcon;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slRightIcon");
            ViewExtensionsKt.invisible((View)imageView);
            ImageView imageView2 = notificationPredictionsResultView.getBinding().slWrongIcon;
            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.slWrongIcon");
            ViewExtensionsKt.invisible((View)imageView2);
            switch (WhenMappings.$EnumSwitchMapping$0[predictionsResultState.ordinal()]) {
                default: {
                    break;
                }
                case 4: {
                    NotificationPredictionsResultView notificationPredictionsResultView2 = this;
                    TextView textView7 = notificationPredictionsResultView2.getBinding().slLooseText1;
                    Intrinsics.checkNotNullExpressionValue((Object)textView7, (String)"binding.slLooseText1");
                    ViewExtensionsKt.visible((View)textView7);
                    TextView textView8 = notificationPredictionsResultView2.getBinding().slLooseText2;
                    Intrinsics.checkNotNullExpressionValue((Object)textView8, (String)"binding.slLooseText2");
                    ViewExtensionsKt.visible((View)textView8);
                    ImageView imageView3 = notificationPredictionsResultView2.getBinding().slWrongIcon;
                    Intrinsics.checkNotNullExpressionValue((Object)imageView3, (String)"binding.slWrongIcon");
                    ViewExtensionsKt.visible((View)imageView3);
                    break;
                }
                case 3: {
                    NotificationPredictionsResultView notificationPredictionsResultView3 = this;
                    TextView textView9 = notificationPredictionsResultView3.getBinding().slCongratulations;
                    Intrinsics.checkNotNullExpressionValue((Object)textView9, (String)"binding.slCongratulations");
                    ViewExtensionsKt.visible((View)textView9);
                    ImageView imageView4 = notificationPredictionsResultView3.getBinding().slRightIcon;
                    Intrinsics.checkNotNullExpressionValue((Object)imageView4, (String)"binding.slRightIcon");
                    ViewExtensionsKt.visible((View)imageView4);
                    break;
                }
                case 2: {
                    NotificationPredictionsResultView notificationPredictionsResultView4 = this;
                    TextView textView10 = notificationPredictionsResultView4.getBinding().slCorrectAnswerTitle;
                    Intrinsics.checkNotNullExpressionValue((Object)textView10, (String)"binding.slCorrectAnswerTitle");
                    ViewExtensionsKt.visible((View)textView10);
                    TextView textView11 = notificationPredictionsResultView4.getBinding().slCorrectAnswerText;
                    Intrinsics.checkNotNullExpressionValue((Object)textView11, (String)"binding.slCorrectAnswerText");
                    ViewExtensionsKt.visible((View)textView11);
                    break;
                }
                case 1: {
                    TextView textView12 = this.getBinding().slQuestionText;
                    Intrinsics.checkNotNullExpressionValue((Object)textView12, (String)"binding.slQuestionText");
                    ViewExtensionsKt.visible((View)textView12);
                }
            }
            NotificationPredictionsResultView notificationPredictionsResultView5 = this;
            PredictionsResultState predictionsResultState2 = predictionsResultState;
            try {
                notificationPredictionsResultView5.saveChangedState(predictionsResultState2);
                Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }

        private static final Bundle saveChangedState$lambda-1(PredictionsResultState predictionsResultState) {
            Intrinsics.checkNotNullParameter((Object)((Object)predictionsResultState), (String)"$state");
            Bundle bundle = new Bundle();
            bundle.putInt("predictions_result_state", predictionsResultState.ordinal());
            return bundle;
        }

        private static final void startStateController$lambda-8(PredictionsResultState predictionsResultState, boolean bl, NotificationPredictionsResultView notificationPredictionsResultView) {
            Intrinsics.checkNotNullParameter((Object)((Object)predictionsResultState), (String)"$state");
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsResultView, (String)"this$0");
            predictionsResultState = predictionsResultState.next(bl);
            if (predictionsResultState != null) {
                notificationPredictionsResultView.startStateController(predictionsResultState, bl);
            }
        }

        private static final void showAnimate$lambda-13$lambda-12$lambda-11(ValueAnimator object, NotificationPredictionsResultView notificationPredictionsResultView, ValueAnimator valueAnimator) {
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsResultView, (String)"this$0");
            object = object.getAnimatedValue();
            if (object != null) {
                int n = (Integer)object;
                valueAnimator = notificationPredictionsResultView.getBinding().slWinNotification;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"binding.slWinNotification");
                boolean bl = n > ViewExtensionsKt.getDp(73.0f);
                ViewExtensionsKt.visibleIf((View)valueAnimator, bl);
                notificationPredictionsResultView = notificationPredictionsResultView.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)notificationPredictionsResultView, (String)"binding.root");
                valueAnimator = notificationPredictionsResultView.getLayoutParams();
                if (valueAnimator != null) {
                    valueAnimator.width = n;
                    notificationPredictionsResultView.setLayoutParams((ViewGroup.LayoutParams)valueAnimator);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }

        private static final void showAnimate$lambda-13(NotificationPredictionsResultView notificationPredictionsResultView) {
            NotificationPredictionsResultView notificationPredictionsResultView2 = notificationPredictionsResultView;
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsResultView2, (String)"this$0");
            if (!notificationPredictionsResultView2.isPortrait()) {
                NotificationPredictionsResultView notificationPredictionsResultView3 = notificationPredictionsResultView;
                ConstraintLayout constraintLayout = notificationPredictionsResultView3.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                ViewExtensionsKt.visible((View)constraintLayout);
                ConstraintLayout constraintLayout2 = notificationPredictionsResultView3.getBinding().slWinNotification;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"binding.slWinNotification");
                ViewExtensionsKt.invisible((View)constraintLayout2);
                int n = (int)notificationPredictionsResultView3.getBinding().getRoot().getContext().getResources().getDimension(R.dimen.slr_predictions_notification_landscape_width);
                ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, n});
                valueAnimator.setDuration(300L);
                valueAnimator.addUpdateListener(arg_0 -> NotificationPredictionsResultView.showAnimate$lambda-13$lambda-12$lambda-11(valueAnimator, notificationPredictionsResultView, arg_0));
                valueAnimator.start();
            } else {
                notificationPredictionsResultView.showAnimatePortrait();
            }
        }

        @Override
        @NotNull
        public SlrItemNotificationPredictionsResultBinding getBinding() {
            return this.binding;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void bind(@NotNull Notification notification) {
            String string2;
            Boolean bl;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            PredictionsResultState predictionsResultState = this.getState();
            Object object = QuestionNotification.Companion.deserialize(notification.getDataJson());
            boolean bl2 = object == null || (bl = ((QuestionNotification)object).isRight()) == null ? false : bl;
            if (object != null && (string2 = ((QuestionNotification)object).getImage()) != null) {
                NotificationPredictionsResultView notificationPredictionsResultView = this;
                ImageView imageView = notificationPredictionsResultView.getBinding().slrNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slrNotificationIcon");
                ExtensionsKt.load(imageView, string2);
                ImageView imageView2 = notificationPredictionsResultView.getBinding().slrNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.slrNotificationIcon");
                ViewExtensionsKt.visible((View)imageView2);
            }
            if (object != null && (string2 = ((QuestionNotification)object).getSmallImage()) != null) {
                NotificationPredictionsResultView notificationPredictionsResultView = this;
                ImageView imageView = notificationPredictionsResultView.getBinding().slrNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slrNotificationIcon");
                ExtensionsKt.load(imageView, string2);
                ImageView imageView3 = notificationPredictionsResultView.getBinding().slrNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView3, (String)"binding.slrNotificationIcon");
                ViewExtensionsKt.visible((View)imageView3);
            }
            NotificationPredictionsResultView notificationPredictionsResultView = this;
            notificationPredictionsResultView.getBinding().slCorrectAnswerText.setText((CharSequence)notification.getTitle());
            notificationPredictionsResultView.getBinding().slQuestionText.setText((CharSequence)notification.getDescription());
            if (object != null && (object = ((QuestionNotification)object).getIndicatorColor()) != null) {
                Object object2 = object;
                try {
                    object = Result.constructor-impl((Object)Color.parseColor((String)object2));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                if (Result.isFailure-impl((Object)object)) {
                    object = null;
                }
                if ((object = (Integer)object) != null) {
                    int n = ((Number)object).intValue();
                    string2 = this.getBinding().slrLeftSide.getBackground();
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
                    }
                    ((LayerDrawable)string2).getDrawable(0).setTint(n);
                    string2 = this.getBinding().slWrongIcon.getBackground();
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                    }
                    ((GradientDrawable)string2).setTint(n);
                    string2 = this.getBinding().slRightIcon.getBackground();
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                    }
                    ((GradientDrawable)string2).setTint(n);
                }
            }
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)new NotificationTouchListener(notification));
            this.startStateController(predictionsResultState, bl2);
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().post(() -> NotificationPredictionsResultView.showAnimate$lambda-13(this));
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PredictionsResultState.values().length];
                nArray[PredictionsResultState.QUESTION.ordinal()] = 1;
                nArray[PredictionsResultState.RIGHT_ANSWER.ordinal()] = 2;
                nArray[PredictionsResultState.WIN.ordinal()] = 3;
                nArray[PredictionsResultState.LOOSE.ordinal()] = 4;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class NotificationFactoidView
    extends BaseNotificationPredictionsView {
        @NotNull
        private final SlrItemNotificationFactoidBinding binding;

        public NotificationFactoidView(SlrItemNotificationFactoidBinding slrItemNotificationFactoidBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationFactoidBinding, (String)"binding");
            super(NotificationType.Factoid);
            this.binding = slrItemNotificationFactoidBinding;
            Context context = this.getBinding().getRoot().getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
            if (OtherExtensionsKt.isScreenPortrait(context)) {
                NotificationViewsProvider.this = this.getBinding().slNotification;
                Intrinsics.checkNotNullExpressionValue((Object)NotificationViewsProvider.this, (String)"binding.slNotification");
                slrItemNotificationFactoidBinding = NotificationViewsProvider.this.getLayoutParams();
                if (slrItemNotificationFactoidBinding != null) {
                    ((ViewGroup.LayoutParams)slrItemNotificationFactoidBinding).height = -2;
                    NotificationViewsProvider.this.setLayoutParams((ViewGroup.LayoutParams)slrItemNotificationFactoidBinding);
                } else {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
                }
            }
        }

        private final Integer getEllipsizedLength(TextView textView) {
            Object object;
            TextView textView2 = textView;
            int n = textView2.getText().length();
            Layout layout2 = textView.getLayout();
            int n2 = textView.getLayout().getLineCount();
            int n3 = n - layout2.getEllipsisCount(n2 - 1);
            try {
                object = Result.constructor-impl((Object)n3);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                object = null;
            }
            return (Integer)object;
        }

        private static final void bind$lambda-5(NotificationFactoidView object, Notification notification, String string2) {
            NotificationFactoidView notificationFactoidView = object;
            Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"$data");
            Intrinsics.checkNotNullParameter((Object)string2, (String)"$tapForMore");
            TextView textView = notificationFactoidView.getBinding().slText;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slText");
            Integer n = notificationFactoidView.getEllipsizedLength(textView);
            int n2 = n == null ? ((NotificationFactoidView)object).getBinding().slText.length() : n.intValue();
            if (n2 < ((NotificationFactoidView)object).getBinding().slText.getText().length()) {
                String string3;
                String string4 = notification.getTitle();
                if (string4 == null) {
                    string4 = "";
                }
                if ((string3 = notification.getDescription()) == null) {
                    string3 = "";
                }
                if (n2 - string2.length() > string4.length()) {
                    SpannableString spannableString;
                    NotificationFactoidView notificationFactoidView2 = object;
                    String string5 = string3.substring(0, n2 - string4.length() - 2 - string2.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    object = Intrinsics.stringPlus((String)string5, (Object)"\u2026");
                    CharSequence[] charSequenceArray = new CharSequence[3];
                    charSequenceArray[0] = OtherUtilsKt.bold(new SpannableString((CharSequence)Intrinsics.stringPlus((String)notification.getTitle(), (Object)" ")));
                    notification = spannableString;
                    spannableString = new SpannableString((CharSequence)object);
                    charSequenceArray[1] = notification;
                    charSequenceArray[2] = OtherUtilsKt.bold(new SpannableString((CharSequence)string2));
                    notificationFactoidView2.getBinding().slText.setText(TextUtils.concat((CharSequence[])charSequenceArray));
                } else {
                    NotificationFactoidView notificationFactoidView3 = object;
                    String string6 = string4.substring(0, n2 - 2 - string2.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    object = Intrinsics.stringPlus((String)string6, (Object)"\u2026");
                    notificationFactoidView3.getBinding().slText.setText(TextUtils.concat((CharSequence[])new CharSequence[]{OtherUtilsKt.bold(new SpannableString((CharSequence)object)), OtherUtilsKt.bold(new SpannableString((CharSequence)string2))}));
                }
            }
        }

        private static final void showAnimate$lambda-10$lambda-9$lambda-8(ValueAnimator object, NotificationFactoidView notificationFactoidView, ValueAnimator valueAnimator) {
            Intrinsics.checkNotNullParameter((Object)notificationFactoidView, (String)"this$0");
            object = object.getAnimatedValue();
            if (object != null) {
                NotificationFactoidView notificationFactoidView2 = notificationFactoidView;
                int n = (Integer)object;
                TextView textView = notificationFactoidView2.getBinding().slText;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slText");
                ViewExtensionsKt.visible((View)textView);
                notificationFactoidView = notificationFactoidView2.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)notificationFactoidView, (String)"binding.root");
                valueAnimator = notificationFactoidView.getLayoutParams();
                if (valueAnimator != null) {
                    valueAnimator.width = n;
                    notificationFactoidView.setLayoutParams((ViewGroup.LayoutParams)valueAnimator);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }

        private static final void showAnimate$lambda-10(NotificationFactoidView notificationFactoidView) {
            NotificationFactoidView notificationFactoidView2 = notificationFactoidView;
            Intrinsics.checkNotNullParameter((Object)notificationFactoidView2, (String)"this$0");
            if (!notificationFactoidView2.isPortrait()) {
                NotificationFactoidView notificationFactoidView3 = notificationFactoidView;
                ConstraintLayout constraintLayout = notificationFactoidView3.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                ViewExtensionsKt.visible((View)constraintLayout);
                TextView textView = notificationFactoidView3.getBinding().slText;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slText");
                ViewExtensionsKt.invisible((View)textView);
                ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, notificationFactoidView.getLandscapeWidth()});
                valueAnimator.setDuration(300L);
                valueAnimator.addUpdateListener(arg_0 -> NotificationFactoidView.showAnimate$lambda-10$lambda-9$lambda-8(valueAnimator, notificationFactoidView, arg_0));
                valueAnimator.start();
            } else {
                notificationFactoidView.showAnimatePortrait();
            }
        }

        @Override
        @NotNull
        public SlrItemNotificationFactoidBinding getBinding() {
            return this.binding;
        }

        @Override
        public int getLandscapeWidth() {
            return NotificationViewsProvider.this.resources.getDimensionPixelSize(R.dimen.slr_notification_factoid_landscape_width);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void bind(@NotNull Notification notification) {
            SpannableString spannableString;
            SpannableString spannableString2;
            TextView textView;
            Object object;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            QuestionNotification questionNotification = QuestionNotification.Companion.deserialize(notification.getDataJson());
            if (questionNotification != null && (object = questionNotification.getImage()) != null) {
                NotificationFactoidView notificationFactoidView = this;
                ImageView imageView = notificationFactoidView.getBinding().slrNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slrNotificationIcon");
                ExtensionsKt.load(imageView, (String)object);
                ImageView imageView2 = notificationFactoidView.getBinding().slrNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.slrNotificationIcon");
                ViewExtensionsKt.visible((View)imageView2);
            }
            if (questionNotification != null && (object = questionNotification.getIndicatorColor()) != null) {
                String string2 = object;
                try {
                    object = Result.constructor-impl((Object)Color.parseColor((String)string2));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                if (Result.isFailure-impl((Object)object)) {
                    object = null;
                }
                if ((object = (Integer)object) != null) {
                    int n = ((Number)object).intValue();
                    textView = this.getBinding().slrLeftSide.getBackground();
                    if (textView == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
                    }
                    ((LayerDrawable)textView).getDrawable(0).setTint(n);
                }
            }
            NotificationFactoidView notificationFactoidView = this;
            Object object2 = notificationFactoidView.getBinding().getRoot().getContext().getString(R.string.slr_factoid_tap_for_more);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"binding.root.context.get\u2026slr_factoid_tap_for_more)");
            textView = notificationFactoidView.getBinding().slText;
            CharSequence[] charSequenceArray = new CharSequence[3];
            CharSequence[] charSequenceArray2 = charSequenceArray;
            charSequenceArray[0] = OtherUtilsKt.bold(new SpannableString((CharSequence)Intrinsics.stringPlus((String)notification.getTitle(), (Object)" ")));
            SpannableString spannableString3 = spannableString2;
            spannableString2 = new SpannableString((CharSequence)notification.getDescription());
            charSequenceArray[1] = spannableString3;
            int n = 2;
            Object object3 = questionNotification != null && questionNotification.getClickable() ? object2 : "";
            SpannableString spannableString4 = spannableString;
            spannableString4((CharSequence)object3);
            charSequenceArray2[n] = OtherUtilsKt.bold(spannableString4);
            textView.setText(TextUtils.concat((CharSequence[])charSequenceArray2));
            if (questionNotification != null && questionNotification.getClickable()) {
                NotificationFactoidView notificationFactoidView2 = this;
                questionNotification = this.getBinding().slText;
                object2 = () -> NotificationFactoidView.bind$lambda-5(notificationFactoidView2, notification, (String)object2);
                Context context = notificationFactoidView2.getBinding().getRoot().getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                long l = OtherExtensionsKt.isScreenPortrait(context) ? 0L : 400L;
                questionNotification.postDelayed((Runnable)object2, l);
            }
            this.getBinding().slNotification.setOnTouchListener((View.OnTouchListener)new NotificationTouchListener(notification));
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().post(() -> NotificationFactoidView.showAnimate$lambda-10(this));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class NotificationFactoidTweetView
    extends BaseNotificationPredictionsView {
        @NotNull
        private final SlrItemNotificationFactoidTweetBinding binding;

        public NotificationFactoidTweetView(SlrItemNotificationFactoidTweetBinding slrItemNotificationFactoidTweetBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationFactoidTweetBinding, (String)"binding");
            super(NotificationType.FactoidTweet);
            this.binding = slrItemNotificationFactoidTweetBinding;
        }

        private static final void showAnimate$lambda-9$lambda-8$lambda-7(ValueAnimator object, NotificationFactoidTweetView notificationFactoidTweetView, ValueAnimator valueAnimator) {
            Intrinsics.checkNotNullParameter((Object)notificationFactoidTweetView, (String)"this$0");
            object = object.getAnimatedValue();
            if (object != null) {
                NotificationFactoidTweetView notificationFactoidTweetView2 = notificationFactoidTweetView;
                int n = (Integer)object;
                TextView textView = notificationFactoidTweetView2.getBinding().slText;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slText");
                ViewExtensionsKt.visible((View)textView);
                notificationFactoidTweetView = notificationFactoidTweetView2.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)notificationFactoidTweetView, (String)"binding.root");
                valueAnimator = notificationFactoidTweetView.getLayoutParams();
                if (valueAnimator != null) {
                    valueAnimator.width = n;
                    notificationFactoidTweetView.setLayoutParams((ViewGroup.LayoutParams)valueAnimator);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }

        private static final void showAnimate$lambda-9(NotificationFactoidTweetView notificationFactoidTweetView) {
            NotificationFactoidTweetView notificationFactoidTweetView2 = notificationFactoidTweetView;
            Intrinsics.checkNotNullParameter((Object)notificationFactoidTweetView2, (String)"this$0");
            if (!notificationFactoidTweetView2.isPortrait()) {
                NotificationFactoidTweetView notificationFactoidTweetView3 = notificationFactoidTweetView;
                ConstraintLayout constraintLayout = notificationFactoidTweetView3.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                ViewExtensionsKt.visible((View)constraintLayout);
                TextView textView = notificationFactoidTweetView3.getBinding().slText;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slText");
                ViewExtensionsKt.invisible((View)textView);
                int n = (int)notificationFactoidTweetView3.getBinding().getRoot().getContext().getResources().getDimension(R.dimen.slr_notification_factoid_landscape_width);
                ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, n});
                valueAnimator.setDuration(300L);
                valueAnimator.addUpdateListener(arg_0 -> NotificationFactoidTweetView.showAnimate$lambda-9$lambda-8$lambda-7(valueAnimator, notificationFactoidTweetView, arg_0));
                valueAnimator.start();
            } else {
                notificationFactoidTweetView.showAnimatePortrait();
            }
        }

        @Override
        @NotNull
        public SlrItemNotificationFactoidTweetBinding getBinding() {
            return this.binding;
        }

        @Override
        public int getLandscapeWidth() {
            return NotificationViewsProvider.this.resources.getDimensionPixelSize(R.dimen.slr_notification_factoid_landscape_width);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void bind(@NotNull Notification notification) {
            Drawable drawable2;
            void var6_18;
            TweetOptions tweetOptions;
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            Object object3 = QuestionNotification.Companion.deserialize(notification.getDataJson());
            if (object3 != null && (object2 = ((QuestionNotification)object3).getImage()) != null) {
                NotificationFactoidTweetView notificationFactoidTweetView = this;
                ShapeableImageView shapeableImageView = notificationFactoidTweetView.getBinding().slIcon;
                Intrinsics.checkNotNullExpressionValue((Object)shapeableImageView, (String)"binding.slIcon");
                ExtensionsKt.load((ImageView)shapeableImageView, (String)object2);
                ShapeableImageView shapeableImageView2 = notificationFactoidTweetView.getBinding().slIcon;
                Intrinsics.checkNotNullExpressionValue((Object)shapeableImageView2, (String)"binding.slIcon");
                ViewExtensionsKt.visible((View)shapeableImageView2);
            }
            if (object3 != null && (object2 = ((QuestionNotification)object3).getIndicatorColor()) != null) {
                String string2 = object2;
                try {
                    object2 = Result.constructor-impl((Object)Color.parseColor((String)string2));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                if (Result.isFailure-impl((Object)object2)) {
                    object2 = null;
                }
                if ((object2 = (Integer)object2) != null) {
                    int n = ((Number)object2).intValue();
                    object = this.getBinding().slrLeftSide.getBackground();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
                    }
                    ((LayerDrawable)object).getDrawable(0).setTint(n);
                }
            }
            boolean bl = object3 != null && (tweetOptions = ((QuestionNotification)object3).getTweetOptions()) != null && tweetOptions.getVerified();
            object = new CharSequence[2];
            int n = 0;
            String string3 = "@";
            object3 = object3 == null || (object3 = ((QuestionNotification)object3).getTweetOptions()) == null ? null : ((TweetOptions)object3).getAccount();
            object3 = Intrinsics.stringPlus((String)string3, (Object)object3);
            if (object3 == null) {
                object3 = "";
            }
            SpannableString spannableString = new SpannableString((CharSequence)object3);
            object[n] = spannableString;
            int n2 = 1;
            if (bl) {
                String string4 = "   \u00b7 ";
            } else {
                String string5 = " \u00b7 ";
            }
            SpannableString spannableString2 = new SpannableString((CharSequence)Intrinsics.stringPlus((String)var6_18, (Object)notification.getDescription()));
            if (bl && (drawable2 = ContextCompat.getDrawable((Context)this.getBinding().getRoot().getContext(), (int)R.drawable.slr_ic_twitter_verified)) != null) {
                ImageSpan imageSpan;
                int n3 = ViewExtensionsKt.getDp(12.0f);
                int n4 = ViewExtensionsKt.getDp(12.0f);
                drawable2.setBounds(0, 0, n3, n4);
                ImageSpan imageSpan2 = imageSpan;
                imageSpan = new ImageSpan(drawable2, 1);
                spannableString2.setSpan((Object)imageSpan2, 1, 2, 17);
            }
            Drawable drawable3 = object;
            drawable3[n2] = spannableString2;
            CharSequence charSequence = TextUtils.concat((CharSequence[])drawable3);
            if (this.isPortrait()) {
                this.getBinding().slText.setText(charSequence);
            } else {
                TextView textView = this.getBinding().slTitle;
                if (textView != null) {
                    textView.setText((CharSequence)notification.getTitle());
                }
                textView = this.getBinding().slTitle;
                if (textView != null) {
                    object = notification.getTitle();
                    boolean bl2 = object == null || object.length() == 0;
                    ViewExtensionsKt.visibleIf((View)textView, bl2 ^ true);
                }
                this.getBinding().slText.setText(charSequence);
            }
            this.getBinding().slNotification.setOnTouchListener((View.OnTouchListener)new NotificationTouchListener(notification));
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().post(() -> NotificationFactoidTweetView.showAnimate$lambda-9(this));
        }
    }

    public final class NotificationCustomViewHolder
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationCustomBinding binding;

        public NotificationCustomViewHolder(SlrItemNotificationCustomBinding slrItemNotificationCustomBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationCustomBinding, (String)"binding");
            super(NotificationViewsProvider.this);
            this.binding = slrItemNotificationCustomBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationCustomBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
                    Object object = notificationCustomViewHolder.getBinding().getRoot().getContext();
                    NotificationBuilder notificationBuilder = notification.getCustomBuilder();
                    if (notificationBuilder == null) break block7;
                    NotificationViewsProvider notificationViewsProvider = notificationCustomViewHolder.NotificationViewsProvider.this;
                    Object object2 = LayoutInflater.from((Context)object);
                    if (notificationBuilder.getLayoutId() != null) {
                        Integer n = notificationBuilder.getLayoutId();
                        Intrinsics.checkNotNull((Object)n);
                        object = object2.inflate(n.intValue(), (ViewGroup)notificationCustomViewHolder.getBinding().getRoot(), false);
                    } else {
                        object2 = SlrItemNotificationBinding.inflate(object2, (ViewGroup)notificationCustomViewHolder.getBinding().getRoot(), false);
                        object2.slNotifTitleTV.setText((CharSequence)notificationBuilder.getTitle());
                        object2.slNotifDescriptionTV.setText((CharSequence)notificationBuilder.getDescription());
                        Integer n = notificationBuilder.getIconBackgroundColor();
                        if (n != null) {
                            int n2 = n;
                            object2.slNotifIconIV.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)object, (int)n2)));
                        }
                        object = notificationBuilder.getIconUrl();
                        if (object != null) {
                            AppCompatImageView appCompatImageView = object2.slNotifIconIV;
                            Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                            ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)object, false, null, null, 14, null);
                        }
                        object = notificationCustomViewHolder.getBinding().getRoot();
                    }
                    Context context = object;
                    notificationCustomViewHolder.getBinding().getRoot().addView((View)object);
                    context.setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
                    NotificationCustomViewHolder notificationCustomViewHolder = context.getLayoutParams();
                    if (notificationCustomViewHolder == null) break block8;
                    Object object3 = object;
                    notificationCustomViewHolder = (FrameLayout.LayoutParams)notificationCustomViewHolder;
                    v4.gravity = 80;
                    object3.setLayoutParams((ViewGroup.LayoutParams)notificationCustomViewHolder);
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"view");
                    notificationBuilder.bindView((View)object);
                }
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            nArray[NotificationType.JoinToChat.ordinal()] = 1;
            nArray[NotificationType.WatchParty.ordinal()] = 2;
            nArray[NotificationType.Prediction.ordinal()] = 3;
            nArray[NotificationType.PredictionResult.ordinal()] = 4;
            nArray[NotificationType.PredictionOnboarding.ordinal()] = 5;
            nArray[NotificationType.Factoid.ordinal()] = 6;
            nArray[NotificationType.FactoidTweet.ordinal()] = 7;
            nArray[NotificationType.Custom.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

