/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.popup;

import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.main.popup.Popup;
import io.streamlayer.sdk.main.popup.PopupState;
import io.streamlayer.sdk.model.predictions.Factoid;
import io.streamlayer.sdk.predictions.factoid.FactoidMediaProvider;
import io.streamlayer.sdk.predictions.factoid.FactoidTweetView;
import io.streamlayer.sdk.predictions.factoid.FactoidView;
import io.streamlayer.sdk.twitter.TweetUI;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class PopupHelper {
    @NotNull
    private final Context context;
    @NotNull
    private final FrameLayout popupView;
    @NotNull
    private final FactoidMediaProvider factoidMediaProvider;
    @NotNull
    private final Function1<Boolean, Unit> showOverlaySheetContainer;

    public PopupHelper(@NotNull Context context, @NotNull FrameLayout frameLayout, @NotNull FactoidMediaProvider factoidMediaProvider2, @NotNull Function1<? super Boolean, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)frameLayout, (String)"popupView");
        Intrinsics.checkNotNullParameter((Object)factoidMediaProvider2, (String)"factoidMediaProvider");
        Intrinsics.checkNotNullParameter(function1, (String)"showOverlaySheetContainer");
        this.context = context;
        this.popupView = frameLayout;
        this.factoidMediaProvider = factoidMediaProvider2;
        this.showOverlaySheetContainer = function1;
    }

    public final void updatePopup(@NotNull PopupState object) {
        block8: {
            Object object2;
            block6: {
                FactoidTweetView factoidTweetView;
                block7: {
                    FactoidView factoidView;
                    block5: {
                        PopupState popupState = object;
                        Intrinsics.checkNotNullParameter((Object)popupState, (String)"popupState");
                        object2 = popupState.getPopup();
                        if (object2 != null) break block5;
                        object = null;
                        break block6;
                    }
                    if (!(object2 instanceof Popup.Factoid)) break block7;
                    object2 = factoidView;
                    ((FactoidView)((Object)object2))(function1.context, null, 0, 6, null);
                    object = ((Popup.Factoid)((PopupState)object).getPopup()).getFactoid();
                    object = factoidView.applyState((Factoid)object, function1.factoidMediaProvider);
                    break block6;
                }
                if (!(object2 instanceof Popup.Tweet)) break block8;
                object2 = factoidTweetView;
                PopupState popupState = object;
                ((FactoidTweetView)((Object)object2))(function1.context, null, 0, 6, null);
                object = ((Popup.Tweet)popupState.getPopup()).getTweetUI();
                object2 = ((Popup.Tweet)popupState.getPopup()).getTitle();
                FactoidMediaProvider factoidMediaProvider2 = function1.factoidMediaProvider;
                object = factoidTweetView.applyState((TweetUI)object, (String)object2, factoidMediaProvider2);
            }
            object2 = function1.popupView;
            object2.removeAllViews();
            if (object != null) {
                object2.addView((View)object);
            }
            boolean bl = object != null;
            ViewExtensionsKt.visibleIf((View)object2, bl);
            if (!OtherExtensionsKt.isScreenPortrait(function1.context)) {
                Function1<Boolean, Unit> function1 = function1.showOverlaySheetContainer;
                function1.invoke((Object)(object == null ? 1 : 0));
            }
            return;
        }
        throw new NoWhenBranchMatchedException();
    }
}

