/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.tooltips;

import android.animation.Animator;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.airbnb.lottie.LottieAnimationView;
import com.google.android.material.button.MaterialButton;
import io.streamlayer.common.session.PromoTooltipType;
import io.streamlayer.common.views.tooltips.BubbleView;
import io.streamlayer.common.views.tooltips.ViewTooltipHandler;
import io.streamlayer.common.views.tooltips.ViewTooltipHandlerKt;
import io.streamlayer.common.views.whoswatchingview.WhosWatchingView;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.main.tooltips.WhosWatchingButtonTooltip;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WhosWatchingButtonTooltip
implements ViewTooltipHandler {
    @NotNull
    private final WhosWatchingView view;
    @Nullable
    private BubbleView bubbleView;
    private boolean _isTooltipVisible;
    @Nullable
    private ShowToolTipRunnable showToolTipRunnable;
    @NotNull
    private final PromoTooltipType type;
    @Nullable
    private Function0<Unit> onTooltipCompleted;

    public WhosWatchingButtonTooltip(@NotNull WhosWatchingView whosWatchingView) {
        WhosWatchingButtonTooltip whosWatchingButtonTooltip = this;
        Intrinsics.checkNotNullParameter((Object)((Object)whosWatchingView), (String)"view");
        whosWatchingButtonTooltip.view = whosWatchingView;
        whosWatchingButtonTooltip.type = PromoTooltipType.WHOS_WATCHING;
    }

    private final void setBubbleView(ConstraintLayout constraintLayout) {
        Function1<BubbleView, Unit> function1;
        BubbleView bubbleView;
        WhosWatchingButtonTooltip whosWatchingButtonTooltip = this;
        whosWatchingButtonTooltip._isTooltipVisible = true;
        Context context = whosWatchingButtonTooltip.view.getContext();
        BubbleView bubbleView2 = bubbleView;
        ConstraintLayout constraintLayout2 = constraintLayout;
        BubbleView bubbleView3 = bubbleView2;
        BubbleView bubbleView4 = bubbleView2;
        Context context2 = context;
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        bubbleView4(context2, null, 0, 6, null);
        ViewTooltipHandlerKt.applyStyles(bubbleView4);
        View view2 = LayoutInflater.from((Context)context).inflate(R.layout.slr_whos_watching_tooltip, null);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"from(context).inflate(R.\u2026s_watching_tooltip, null)");
        BubbleView.customView$default(bubbleView2, view2, 0, 0, 6, null);
        bubbleView3.tooltipAnimation(this.buildTooltipAnimation());
        bubbleView3.position(BubbleView.Position.TOP);
        this.bubbleView = bubbleView3;
        Intrinsics.checkNotNull((Object)((Object)bubbleView2));
        constraintLayout = this.view;
        bubbleView2 = function1;
        function1 = new Function1<BubbleView, Unit>(context, this){
            final /* synthetic */ Context $context;
            final /* synthetic */ WhosWatchingButtonTooltip this$0;
            {
                this.$context = context;
                this.this$0 = whosWatchingButtonTooltip;
                super(1);
            }

            public final void invoke(@NotNull BubbleView object) {
                BubbleView bubbleView = object;
                Intrinsics.checkNotNullParameter((Object)((Object)bubbleView), (String)"it");
                ViewGroup.LayoutParams layoutParams = bubbleView.getLayoutParams();
                if (layoutParams != null) {
                    BubbleView bubbleView2 = object;
                    ConstraintLayout.LayoutParams layoutParams2 = (ConstraintLayout.LayoutParams)layoutParams;
                    setBubbleView.2 v3 = this_;
                    setBubbleView.2 this_ = v3.$context;
                    object = v3.this$0;
                    layoutParams2.bottomMargin = this_.getResources().getDimensionPixelSize(R.dimen.slr_view_tooltip_distance_between_view) + this_.getResources().getDimensionPixelSize(R.dimen.slr_whos_watching_btn_height);
                    layoutParams2.bottomToBottom = WhosWatchingButtonTooltip.access$getView$p((WhosWatchingButtonTooltip)object).getId();
                    bubbleView2.postInvalidate();
                    bubbleView2.requestLayout();
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
            }
        };
        bubbleView.show((ViewGroup)constraintLayout2, (View)constraintLayout, (Function1<? super BubbleView, Unit>)bubbleView2);
        whosWatchingButtonTooltip.view.setCountChanged((Function1<? super Integer, Unit>)new Function1<Integer, Unit>(this){
            final /* synthetic */ WhosWatchingButtonTooltip this$0;
            {
                this.this$0 = whosWatchingButtonTooltip;
                super(1);
            }

            public final void invoke(int n) {
                Object object = WhosWatchingButtonTooltip.access$getBubbleView$p(object.this$0);
                if (object != null) {
                    Function1<View, Unit> function1;
                    setBubbleView.3 v0 = object;
                    object = function1;
                    function1 = new Function1<View, Unit>(n){
                        final /* synthetic */ int $value;
                        {
                            this.$value = n;
                            super(1);
                        }

                        public final void invoke(@Nullable View object) {
                            if ((object = object == null ? null : (AppCompatTextView)object.findViewById(R.id.slrCountView)) != null) {
                                object.setText((CharSequence)String.valueOf(this.$value));
                            }
                        }
                    };
                    ((BubbleView)((Object)v0)).updateCustomView((Function1<? super View, Unit>)object);
                }
            }
        });
    }

    private final BubbleView.Animation buildTooltipAnimation() {
        return new BubbleView.Animation(this){
            final /* synthetic */ WhosWatchingButtonTooltip this$0;
            {
                this.this$0 = whosWatchingButtonTooltip;
            }

            private static final void animateEnter$lambda-0(WhosWatchingButtonTooltip function0, View view2) {
                Function0<Unit> function02 = function0;
                Intrinsics.checkNotNullParameter((Object)function02, (String)"this$0");
                function0 = function02.getOnTooltipCompleted();
                if (function0 != null) {
                    function0.invoke();
                }
            }

            public void animateEnter(@NotNull BubbleView bubbleView) {
                BubbleView bubbleView2 = bubbleView;
                Intrinsics.checkNotNullParameter((Object)((Object)bubbleView2), (String)"view");
                LottieAnimationView lottieAnimationView = (LottieAnimationView)bubbleView2.findViewById(R.id.slrLottieView);
                MaterialButton materialButton = (MaterialButton)bubbleView2.findViewById(R.id.slrGotItBtn);
                BubbleView bubbleView3 = bubbleView;
                ((AppCompatTextView)bubbleView3.findViewById(R.id.slrCountView)).setText((CharSequence)String.valueOf(WhosWatchingButtonTooltip.access$getView$p(this.this$0).getCount()));
                ViewTooltipHandlerKt.runEnterAnimation(bubbleView3, new Function0<Unit>(lottieAnimationView){
                    final /* synthetic */ LottieAnimationView $lottieView;
                    {
                        this.$lottieView = lottieAnimationView;
                        super(0);
                    }

                    public final void invoke() {
                        this.$lottieView.playAnimation();
                    }
                });
                materialButton.setOnClickListener(arg_0 -> buildTooltipAnimation.1.animateEnter$lambda-0(this.this$0, arg_0));
            }

            public void animateExit(@NotNull BubbleView bubbleView, @NotNull Animator.AnimatorListener animatorListener) {
                Intrinsics.checkNotNullParameter((Object)((Object)bubbleView), (String)"view");
                Intrinsics.checkNotNullParameter((Object)animatorListener, (String)"animatorListener");
                ((LottieAnimationView)bubbleView.findViewById(R.id.slrLottieView)).pauseAnimation();
                ViewTooltipHandlerKt.runExitAnimation(bubbleView, animatorListener);
            }
        };
    }

    public static final /* synthetic */ WhosWatchingView access$getView$p(WhosWatchingButtonTooltip whosWatchingButtonTooltip) {
        return whosWatchingButtonTooltip.view;
    }

    public static final /* synthetic */ BubbleView access$getBubbleView$p(WhosWatchingButtonTooltip whosWatchingButtonTooltip) {
        return whosWatchingButtonTooltip.bubbleView;
    }

    @Override
    @NotNull
    public PromoTooltipType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Function0<Unit> getOnTooltipCompleted() {
        return this.onTooltipCompleted;
    }

    @Override
    public void setOnTooltipCompleted(@Nullable Function0<Unit> function0) {
        this.onTooltipCompleted = function0;
    }

    @Override
    public boolean isTooltipVisible() {
        return this._isTooltipVisible;
    }

    @Override
    public void showTooltip(@NotNull ConstraintLayout constraintLayout) {
        ShowToolTipRunnable showToolTipRunnable;
        Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parentView");
        if (this.isTooltipVisible()) {
            return;
        }
        ShowToolTipRunnable showToolTipRunnable2 = this.showToolTipRunnable;
        if (showToolTipRunnable2 != null) {
            this.view.removeCallbacks(showToolTipRunnable2);
        }
        showToolTipRunnable2 = showToolTipRunnable;
        showToolTipRunnable2(constraintLayout);
        this.view.postDelayed(showToolTipRunnable2, 1500L);
        this.showToolTipRunnable = showToolTipRunnable;
    }

    @Override
    public void hideTooltip(@Nullable Function0<Unit> function0) {
        ShowToolTipRunnable showToolTipRunnable = ((WhosWatchingButtonTooltip)((Object)bubbleView)).showToolTipRunnable;
        if (showToolTipRunnable != null) {
            ((WhosWatchingButtonTooltip)((Object)bubbleView)).view.removeCallbacks(showToolTipRunnable);
        }
        if (!((WhosWatchingButtonTooltip)((Object)bubbleView)).isTooltipVisible()) {
            return;
        }
        WhosWatchingButtonTooltip whosWatchingButtonTooltip = bubbleView;
        whosWatchingButtonTooltip._isTooltipVisible = false;
        whosWatchingButtonTooltip.view.setCountChanged(null);
        BubbleView bubbleView = whosWatchingButtonTooltip.bubbleView;
        if (bubbleView != null) {
            bubbleView.close(function0);
        }
    }

    public final class ShowToolTipRunnable
    implements Runnable {
        @NotNull
        private final ConstraintLayout parentView;

        public ShowToolTipRunnable(ConstraintLayout constraintLayout) {
            Intrinsics.checkNotNullParameter((Object)WhosWatchingButtonTooltip.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parentView");
            this.parentView = constraintLayout;
        }

        @Override
        public void run() {
            WhosWatchingButtonTooltip.this.setBubbleView(this.parentView);
        }
    }
}

